/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.ps.PolynomialTaylorFunction;
import edu.jas.ps.StandardBaseSeq;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.Element;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class STDMultiPSTest
extends TestCase {
    BigRational cfac;
    MultiVarPowerSeriesRing<BigRational> fac;
    MultiVarPowerSeries<BigRational> a;
    MultiVarPowerSeries<BigRational> b;
    MultiVarPowerSeries<BigRational> c;
    MultiVarPowerSeries<BigRational> d;
    MultiVarPowerSeries<BigRational> e;
    MultiVarPowerSeries<BigRational> f;
    int rl = 3;
    int kl = 5;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)STDMultiPSTest.suite());
    }

    public STDMultiPSTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(STDMultiPSTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        String[] stringArray = new String[]{"x", "y", "z"};
        this.cfac = new BigRational(1L);
        this.fac = new MultiVarPowerSeriesRing<BigRational>(this.cfac, this.rl, stringArray);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testFixpoints() {
        int n = 0;
        UnivPowerSeriesRing univPowerSeriesRing = new UnivPowerSeriesRing(this.fac.coFac, this.fac.vars[n]);
        UnivPowerSeries univPowerSeries = univPowerSeriesRing.getEXP();
        this.a = this.fac.fromPowerSeries(univPowerSeries, 0);
        this.b = this.fac.fromPowerSeries(univPowerSeries, 1);
        this.c = this.fac.getEXP(0);
        this.d = this.fac.getEXP(1);
        STDMultiPSTest.assertEquals((String)"a == c ", this.a, this.c);
        STDMultiPSTest.assertEquals((String)"b == d ", this.b, this.d);
        this.e = this.d.differentiate(0);
        STDMultiPSTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.d.differentiate(1);
        STDMultiPSTest.assertEquals((String)"e == d ", this.d, this.e);
    }

    public void testGcd() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.gcd(this.b);
        this.d = this.a.divide(this.c);
        this.e = this.b.divide(this.c);
        this.f = this.d.gcd(this.e);
        STDMultiPSTest.assertTrue((String)"gcd(a/gcd(a,b),b/gcd(a,b)) == 1 ", (boolean)this.f.isONE());
    }

    public void testTaylor() {
        BigRational bigRational = new BigRational(5L);
        BigRational bigRational2 = new BigRational(0L);
        BigRational bigRational3 = new BigRational(-5L);
        ArrayList<BigRational> arrayList = new ArrayList<BigRational>(this.rl);
        ArrayList<BigRational> arrayList2 = new ArrayList<BigRational>(this.rl);
        ArrayList<BigRational> arrayList3 = new ArrayList<BigRational>(this.rl);
        for (int i = 0; i < this.rl; ++i) {
            arrayList.add(bigRational);
            arrayList2.add(bigRational2);
            arrayList3.add(bigRational3);
        }
        GenPolynomialRing<BigRational> genPolynomialRing = this.fac.polyRing();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, 3, 3, this.q + this.q);
        int n = (int)genPolynomial.degree();
        this.fac.setTruncate(n + 1);
        PolynomialTaylorFunction<BigRational> polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(genPolynomial);
        MultiVarPowerSeries<BigRational> multiVarPowerSeries = this.fac.fromPolynomial(genPolynomial);
        MultiVarPowerSeries<BigRational> multiVarPowerSeries2 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList2);
        STDMultiPSTest.assertEquals((String)"taylor(p) == p", multiVarPowerSeries2, multiVarPowerSeries);
        MultiVarPowerSeries<BigRational> multiVarPowerSeries3 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList);
        polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(multiVarPowerSeries3.asPolynomial());
        MultiVarPowerSeries<BigRational> multiVarPowerSeries4 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList3);
        STDMultiPSTest.assertEquals((String)"taylor(taylor(p,5),-5) == p", multiVarPowerSeries2, multiVarPowerSeries4);
        for (GenPolynomial<BigRational> genPolynomial2 : genPolynomialRing.generators()) {
            polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(genPolynomial2);
            multiVarPowerSeries2 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList2);
            multiVarPowerSeries = this.fac.fromPolynomial(genPolynomial2);
            STDMultiPSTest.assertEquals((String)"taylor(p) == p", multiVarPowerSeries2, multiVarPowerSeries);
            multiVarPowerSeries3 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList);
            polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(multiVarPowerSeries3.asPolynomial());
            multiVarPowerSeries4 = this.fac.seriesOfTaylor(polynomialTaylorFunction, arrayList3);
            STDMultiPSTest.assertEquals((String)"taylor(taylor(p,5),-5) == p", multiVarPowerSeries2, multiVarPowerSeries4);
        }
    }

    public void testEvaluation() {
        this.a = this.fac.random(this.kl, this.q);
        this.b = this.fac.random(this.kl, this.q);
        BigRational bigRational = new BigRational(0L);
        ArrayList<BigRational> arrayList = new ArrayList<BigRational>(this.rl);
        for (int i = 0; i < this.rl; ++i) {
            arrayList.add(bigRational.random(this.kl));
        }
        BigRational bigRational2 = this.a.evaluate(arrayList);
        BigRational bigRational3 = this.b.evaluate(arrayList);
        this.c = this.a.sum(this.b);
        BigRational bigRational4 = this.c.evaluate(arrayList);
        BigRational bigRational5 = bigRational2.sum(bigRational3);
        STDMultiPSTest.assertEquals((String)"a(v)+b(v) = (a+b)(v) ", (Object)bigRational4, (Object)bigRational5);
        this.c = this.fac.getZERO();
        bigRational4 = this.c.evaluate(arrayList);
        bigRational5 = bigRational.getZERO();
        STDMultiPSTest.assertEquals((String)"0(v) = 0 ", (Object)bigRational4, (Object)bigRational5);
        this.c = this.fac.getONE();
        bigRational4 = this.c.evaluate(arrayList);
        bigRational5 = bigRational.getONE();
        STDMultiPSTest.assertEquals((String)"1(v) = 1 ", (Object)bigRational4, (Object)bigRational5);
    }

    public void testSTD() {
        GenPolynomialRing<BigRational> genPolynomialRing = this.fac.polyRing();
        Element element = genPolynomialRing.parse("x**5 - x * y**6 - z**7");
        Element element2 = genPolynomialRing.parse("x * y + y**3 + z**3");
        Element element3 = genPolynomialRing.parse("x**2 + y**2 - z**2");
        this.a = this.fac.fromPolynomial((GenPolynomial<BigRational>)element);
        this.b = this.fac.fromPolynomial((GenPolynomial<BigRational>)element2);
        this.c = this.fac.fromPolynomial((GenPolynomial<BigRational>)element3);
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.a);
        arrayList.add(this.b);
        arrayList.add(this.c);
        StandardBaseSeq standardBaseSeq = new StandardBaseSeq();
        List list = standardBaseSeq.STD(arrayList);
        STDMultiPSTest.assertTrue((String)"isSTD(S): ", (boolean)standardBaseSeq.isSTD(list));
    }
}

