/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComplexAlgebraicRing<C extends GcdRingElem<C> & Rational>
implements RingFactory<ComplexAlgebraicNumber<C>> {
    private static final Logger logger = LogManager.getLogger(ComplexAlgebraicRing.class);
    public final AlgebraicNumberRing<Complex<C>> algebraic;
    Rectangle<C> root;
    protected BigRational eps;
    public static final int PRECISION = BigDecimal.DEFAULT_PRECISION;
    protected ComplexRootsSturm<C> engine = null;

    public ComplexAlgebraicRing(GenPolynomial<Complex<C>> genPolynomial, Rectangle<C> rectangle) {
        this.algebraic = new AlgebraicNumberRing<Complex<Complex<C>>>(genPolynomial);
        this.root = rectangle;
        if (genPolynomial.ring.characteristic().signum() > 0) {
            throw new IllegalArgumentException("characteristic not zero");
        }
        BigRational bigRational = new BigRational(10L);
        this.eps = bigRational = (BigRational)bigRational.power(-PRECISION / 2);
        this.ensureEngine();
    }

    public ComplexAlgebraicRing(GenPolynomial<Complex<C>> genPolynomial, Rectangle<C> rectangle, boolean bl) {
        this(genPolynomial, rectangle);
        this.setField(bl);
    }

    public synchronized void setRoot(Rectangle<C> rectangle) {
        assert (this.root.contains(rectangle)) : "root contains v";
        this.root = rectangle;
    }

    public synchronized Rectangle<C> getRoot() {
        return this.root;
    }

    public synchronized BigRational getEps() {
        return this.eps;
    }

    public synchronized void setEps(C c) {
        this.setEps(((Rational)c).getRational());
    }

    public synchronized void setEps(BigRational bigRational) {
        this.eps = bigRational;
    }

    public synchronized void refineRoot() {
        this.refineRoot(this.eps);
    }

    public synchronized void ensureEngine() {
        if (this.engine == null) {
            this.engine = new ComplexRootsSturm(this.algebraic.ring.coFac);
        }
    }

    public synchronized void refineRoot(BigRational bigRational) {
        this.ensureEngine();
        try {
            this.root = this.engine.complexRootRefinement(this.root, this.algebraic.modul, bigRational);
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            logger.warn("new eps not set: {}", (Object)bigRational);
            return;
        }
        this.eps = bigRational;
    }

    @Override
    public boolean isFinite() {
        return this.algebraic.isFinite();
    }

    @Override
    public ComplexAlgebraicNumber<C> copy(ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        return new ComplexAlgebraicNumber(this, complexAlgebraicNumber.number);
    }

    @Override
    public ComplexAlgebraicNumber<C> getZERO() {
        return new ComplexAlgebraicNumber(this, this.algebraic.getZERO());
    }

    @Override
    public ComplexAlgebraicNumber<C> getONE() {
        return new ComplexAlgebraicNumber(this, this.algebraic.getONE());
    }

    public ComplexAlgebraicNumber<C> getIMAG() {
        ComplexRing complexRing = (ComplexRing)this.algebraic.ring.coFac;
        Complex complex = complexRing.getIMAG();
        return new ComplexAlgebraicNumber(this, ((AlgebraicNumber)this.algebraic.getZERO()).sum(complex));
    }

    public ComplexAlgebraicNumber<C> getGenerator() {
        return new ComplexAlgebraicNumber<C>(this, this.algebraic.getGenerator());
    }

    @Override
    public List<ComplexAlgebraicNumber<C>> generators() {
        List<AlgebraicNumber<Complex<C>>> list = this.algebraic.generators();
        ArrayList<ComplexAlgebraicNumber<C>> arrayList = new ArrayList<ComplexAlgebraicNumber<C>>(list.size());
        for (AlgebraicNumber<Complex<C>> algebraicNumber : list) {
            arrayList.add(((ComplexAlgebraicNumber)this.getZERO()).sum(algebraicNumber.getVal()));
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.algebraic.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.algebraic.isAssociative();
    }

    @Override
    public boolean isField() {
        return this.algebraic.isField();
    }

    public void setField(boolean bl) {
        this.algebraic.setField(bl);
    }

    @Override
    public BigInteger characteristic() {
        return this.algebraic.characteristic();
    }

    @Override
    public ComplexAlgebraicNumber<C> fromInteger(BigInteger bigInteger) {
        return new ComplexAlgebraicNumber(this, this.algebraic.fromInteger(bigInteger));
    }

    @Override
    public ComplexAlgebraicNumber<C> fromInteger(long l) {
        return new ComplexAlgebraicNumber(this, this.algebraic.fromInteger(l));
    }

    public String toString() {
        return "ComplexAlgebraicRing[ " + this.algebraic.modul.toString() + " in " + this.root + " | isField=" + this.algebraic.isField() + " :: " + this.algebraic.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "ComplexN( " + this.algebraic.modul.toScript() + ", " + this.root.toScript() + " )";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ComplexAlgebraicRing)) {
            return false;
        }
        ComplexAlgebraicRing complexAlgebraicRing = (ComplexAlgebraicRing)object;
        return this.algebraic.equals(complexAlgebraicRing.algebraic) && this.root.equals(complexAlgebraicRing.root);
    }

    public int hashCode() {
        return 37 * this.algebraic.hashCode() + this.root.hashCode();
    }

    @Override
    public ComplexAlgebraicNumber<C> random(int n) {
        return new ComplexAlgebraicNumber(this, this.algebraic.random(n));
    }

    @Override
    public ComplexAlgebraicNumber<C> random(int n, Random random) {
        return new ComplexAlgebraicNumber(this, this.algebraic.random(n, random));
    }

    @Override
    public ComplexAlgebraicNumber<C> parse(String string) {
        return new ComplexAlgebraicNumber(this, this.algebraic.parse(string));
    }

    @Override
    public ComplexAlgebraicNumber<C> parse(Reader reader) {
        return new ComplexAlgebraicNumber(this, this.algebraic.parse(reader));
    }
}

