/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.ArithUtil;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.structure.MonoidElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealArithUtil {
    private static final Logger logger = LogManager.getLogger(RealArithUtil.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static List<BigInteger> continuedFraction(RealAlgebraicNumber<BigRational> realAlgebraicNumber, int n) {
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        if (realAlgebraicNumber == null) {
            return arrayList;
        }
        RealAlgebraicRing realAlgebraicRing = realAlgebraicNumber.ring;
        if (realAlgebraicNumber.isZERO()) {
            arrayList.add(BigInteger.ZERO);
            return arrayList;
        }
        if (realAlgebraicNumber.isONE()) {
            arrayList.add(BigInteger.ONE);
            return arrayList;
        }
        MonoidElem monoidElem = realAlgebraicNumber;
        BigInteger bigInteger = new BigInteger(((RealAlgebraicNumber)monoidElem).floor());
        arrayList.add(bigInteger);
        RealAlgebraicNumber<BigRational> realAlgebraicNumber2 = ((RealAlgebraicNumber)monoidElem).subtract((RealAlgebraicNumber<BigRational>)realAlgebraicRing.fromInteger(bigInteger.val));
        int n2 = 0;
        while (!realAlgebraicNumber2.isZERO() && n2++ < n) {
            monoidElem = realAlgebraicNumber2.inverse();
            bigInteger = new BigInteger(((RealAlgebraicNumber)monoidElem).floor());
            arrayList.add(bigInteger);
            realAlgebraicNumber2 = ((RealAlgebraicNumber)monoidElem).subtract(realAlgebraicRing.fromInteger(bigInteger.val));
        }
        if (debug) {
            logger.info("cf = {}", arrayList);
        }
        return arrayList;
    }

    public static BigRational continuedFractionApprox(List<BigInteger> list) {
        return ArithUtil.continuedFractionApprox(list);
    }
}

