/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInt;
import edu.jas.arith.ModIntRing;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFieldChar0Yun;
import edu.jas.ufd.SquarefreeFieldCharP;
import edu.jas.ufd.SquarefreeFiniteFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteAlgebraicFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import edu.jas.ufd.SquarefreeRingChar0;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SquarefreeFactory {
    private static final Logger logger = LogManager.getLogger(SquarefreeFactory.class);

    protected SquarefreeFactory() {
    }

    public static SquarefreeAbstract<ModInteger> getImplementation(ModIntegerRing modIntegerRing) {
        return new SquarefreeFiniteFieldCharP<ModInteger>(modIntegerRing);
    }

    public static SquarefreeAbstract<ModLong> getImplementation(ModLongRing modLongRing) {
        return new SquarefreeFiniteFieldCharP<ModLong>(modLongRing);
    }

    public static SquarefreeAbstract<ModInt> getImplementation(ModIntRing modIntRing) {
        return new SquarefreeFiniteFieldCharP<ModInt>(modIntRing);
    }

    public static SquarefreeAbstract<BigInteger> getImplementation(BigInteger bigInteger) {
        return new SquarefreeRingChar0<BigInteger>(bigInteger);
    }

    public static SquarefreeAbstract<BigRational> getImplementation(BigRational bigRational) {
        return new SquarefreeFieldChar0Yun<BigRational>(bigRational);
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<AlgebraicNumber<C>> getImplementation(AlgebraicNumberRing<C> algebraicNumberRing) {
        PolyUfdUtil.ensureFieldProperty(algebraicNumberRing);
        if (algebraicNumberRing.isField()) {
            if (algebraicNumberRing.characteristic().signum() == 0) {
                return new SquarefreeFieldChar0Yun<AlgebraicNumber<C>>(algebraicNumberRing);
            }
            if (algebraicNumberRing.isFinite()) {
                return new SquarefreeFiniteFieldCharP<AlgebraicNumber<C>>(algebraicNumberRing);
            }
            return new SquarefreeInfiniteAlgebraicFieldCharP(algebraicNumberRing);
        }
        throw new ArithmeticException("eventually no integral domain " + algebraicNumberRing.getClass().getName());
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing) {
        if (quotientRing.characteristic().signum() == 0) {
            return new SquarefreeFieldChar0Yun<Quotient<C>>(quotientRing);
        }
        return new SquarefreeInfiniteFieldCharP(quotientRing);
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<C> getImplementation(GenPolynomialRing<C> genPolynomialRing) {
        return SquarefreeFactory.getImplementationPoly(genPolynomialRing);
    }

    protected static <C extends GcdRingElem<C>> SquarefreeAbstract<C> getImplementationPoly(GenPolynomialRing<C> genPolynomialRing) {
        RingFactory ringFactory;
        if (genPolynomialRing.characteristic().signum() == 0) {
            if (genPolynomialRing.coFac.isField()) {
                return new SquarefreeFieldChar0Yun(genPolynomialRing.coFac);
            }
            return new SquarefreeRingChar0(genPolynomialRing.coFac);
        }
        if (genPolynomialRing.coFac.isFinite()) {
            return new SquarefreeFiniteFieldCharP(genPolynomialRing.coFac);
        }
        RingFactory ringFactory2 = genPolynomialRing.coFac;
        SquarefreeFieldCharP squarefreeFieldCharP = null;
        if (ringFactory2 instanceof QuotientRing) {
            ringFactory = (QuotientRing)ringFactory2;
            squarefreeFieldCharP = new SquarefreeInfiniteFieldCharP(ringFactory);
        } else if (ringFactory2 instanceof AlgebraicNumberRing) {
            ringFactory = (AlgebraicNumberRing)ringFactory2;
            squarefreeFieldCharP = new SquarefreeInfiniteAlgebraicFieldCharP(ringFactory);
        }
        if (squarefreeFieldCharP == null) {
            throw new IllegalArgumentException("no squarefree factorization " + genPolynomialRing.coFac);
        }
        ringFactory = squarefreeFieldCharP;
        return ringFactory;
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<C> getImplementation(RingFactory<C> ringFactory) {
        SquarefreeAbstract squarefreeAbstract = null;
        AlgebraicNumberRing algebraicNumberRing = null;
        QuotientRing quotientRing = null;
        GenPolynomialRing genPolynomialRing = null;
        RingFactory ringFactory2 = ringFactory;
        if (ringFactory2 instanceof BigInteger) {
            squarefreeAbstract = new SquarefreeRingChar0<C>(ringFactory);
        } else if (ringFactory2 instanceof BigRational) {
            squarefreeAbstract = new SquarefreeFieldChar0Yun<C>(ringFactory);
        } else if (ringFactory2 instanceof ModIntegerRing) {
            squarefreeAbstract = new SquarefreeFiniteFieldCharP<C>(ringFactory);
        } else if (ringFactory2 instanceof ModLongRing) {
            squarefreeAbstract = new SquarefreeFiniteFieldCharP<C>(ringFactory);
        } else if (ringFactory2 instanceof ModIntRing) {
            squarefreeAbstract = new SquarefreeFiniteFieldCharP<C>(ringFactory);
        } else if (ringFactory2 instanceof AlgebraicNumberRing) {
            algebraicNumberRing = (AlgebraicNumberRing)ringFactory2;
            squarefreeAbstract = SquarefreeFactory.getImplementation(algebraicNumberRing);
        } else if (ringFactory2 instanceof QuotientRing) {
            quotientRing = (QuotientRing)ringFactory2;
            squarefreeAbstract = SquarefreeFactory.getImplementation(quotientRing);
        } else if (ringFactory2 instanceof GenPolynomialRing) {
            genPolynomialRing = (GenPolynomialRing)ringFactory2;
            squarefreeAbstract = SquarefreeFactory.getImplementationPoly(genPolynomialRing);
        } else if (ringFactory.isField()) {
            squarefreeAbstract = ringFactory.characteristic().signum() == 0 ? new SquarefreeFieldChar0Yun<C>(ringFactory) : (ringFactory.isFinite() ? new SquarefreeFiniteFieldCharP<C>(ringFactory) : new SquarefreeInfiniteFieldCharP(ringFactory));
        } else if (ringFactory.characteristic().signum() == 0) {
            squarefreeAbstract = new SquarefreeRingChar0<C>(ringFactory);
        } else {
            throw new IllegalArgumentException("no squarefree factorization implementation for " + ringFactory.getClass().getName());
        }
        logger.debug("ufd = {}", squarefreeAbstract);
        return squarefreeAbstract;
    }
}

