/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.PolynomialTaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.QuotientTaylorFunction;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class UnivPowerSeriesTaylorTest
extends TestCase {
    BigRational cfac;
    UnivPowerSeriesRing<BigRational> fac;
    UnivPowerSeries<BigRational> a;
    UnivPowerSeries<BigRational> b;
    UnivPowerSeries<BigRational> c;
    UnivPowerSeries<BigRational> d;
    UnivPowerSeries<BigRational> e;
    int kl = 10;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)UnivPowerSeriesTaylorTest.suite());
    }

    public UnivPowerSeriesTaylorTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(UnivPowerSeriesTaylorTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new BigRational(1L);
        this.fac = new UnivPowerSeriesRing<BigRational>(this.cfac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.cfac = null;
        ComputerThreads.terminate();
    }

    public void testTaylor() {
        BigRational bigRational = new BigRational(0L);
        GenPolynomialRing<BigRational> genPolynomialRing = this.fac.polyRing();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, 3, 3, this.q + this.q);
        PolynomialTaylorFunction<BigRational> polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(genPolynomial);
        UnivPowerSeries<BigRational> univPowerSeries = this.fac.seriesOfTaylor(polynomialTaylorFunction, bigRational);
        UnivPowerSeries<BigRational> univPowerSeries2 = this.fac.fromPolynomial(genPolynomial);
        UnivPowerSeriesTaylorTest.assertEquals((String)"taylor(p) == p", univPowerSeries, univPowerSeries2);
        for (GenPolynomial<BigRational> genPolynomial2 : genPolynomialRing.generators()) {
            polynomialTaylorFunction = new PolynomialTaylorFunction<BigRational>(genPolynomial2);
            univPowerSeries = this.fac.seriesOfTaylor(polynomialTaylorFunction, bigRational);
            univPowerSeries2 = this.fac.fromPolynomial(genPolynomial2);
            UnivPowerSeriesTaylorTest.assertEquals((String)"taylor(p) == p", univPowerSeries, univPowerSeries2);
        }
    }

    public void testQuotientTaylor() {
        BigRational bigRational = new BigRational(0L);
        GenPolynomialRing<BigRational> genPolynomialRing = this.fac.polyRing();
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        Quotient<BigRational> quotient = quotientRing.random(this.kl, 3, 3, this.q + this.q);
        if (((BigRational)quotient.den.trailingBaseCoefficient()).isZERO()) {
            return;
        }
        QuotientTaylorFunction<BigRational> quotientTaylorFunction = new QuotientTaylorFunction<BigRational>(quotient);
        UnivPowerSeries<BigRational> univPowerSeries = this.fac.seriesOfTaylor(quotientTaylorFunction, bigRational);
        UnivPowerSeries<BigRational> univPowerSeries2 = this.fac.fromPolynomial(quotient.num).divide(this.fac.fromPolynomial(quotient.den));
        UnivPowerSeriesTaylorTest.assertEquals((String)"taylor(p) == p", univPowerSeries, univPowerSeries2);
        for (Quotient<BigRational> quotient2 : quotientRing.generators()) {
            quotientTaylorFunction = new QuotientTaylorFunction<BigRational>(quotient2);
            univPowerSeries = this.fac.seriesOfTaylor(quotientTaylorFunction, bigRational);
            univPowerSeries2 = this.fac.fromPolynomial(quotient2.num).divide(this.fac.fromPolynomial(quotient2.den));
            UnivPowerSeriesTaylorTest.assertEquals((String)"taylor(p) == p", univPowerSeries, univPowerSeries2);
        }
    }

    public void testQuotientPade() {
        BigRational bigRational = new BigRational(0L);
        GenPolynomialRing<BigRational> genPolynomialRing = this.fac.polyRing();
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        Quotient<GcdRingElem<BigRational>> quotient = quotientRing.random(this.kl, 3, 4, this.q + this.q);
        Quotient<BigRational> quotient2 = quotientRing.generators().get(1);
        while (((BigRational)quotient.den.trailingBaseCoefficient()).isZERO()) {
            quotient = quotient.multiply((GcdRingElem<BigRational>)quotient2);
        }
        while (((BigRational)quotient.num.trailingBaseCoefficient()).isZERO()) {
            quotient = quotient.divide(quotient2);
        }
        QuotientTaylorFunction<GcdRingElem<BigRational>> quotientTaylorFunction = new QuotientTaylorFunction<GcdRingElem<BigRational>>(quotient);
        int n = (int)quotient.num.degree() + 1;
        int n2 = (int)quotient.den.degree() + 1;
        Quotient<BigRational> quotient3 = null;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                quotient3 = PolyUfdUtil.approximantOfPade(this.fac, quotientTaylorFunction, bigRational, i, j);
                UnivPowerSeriesTaylorTest.assertTrue((String)"deg(num) <= m", (quotient3.num.degree() <= (long)i ? 1 : 0) != 0);
                UnivPowerSeriesTaylorTest.assertTrue((String)"deg(den) <= n", (quotient3.den.degree() <= (long)j ? 1 : 0) != 0);
            }
        }
        UnivPowerSeriesTaylorTest.assertEquals((String)"p == pa: ", quotient, quotient3);
    }
}

