/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.FactorRealReal;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorAlgebraic;
import edu.jas.ufd.FactorComplex;
import edu.jas.ufd.FactorQuotient;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufdroot.FactorRealAlgebraic;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactorFactory
extends edu.jas.ufd.FactorFactory {
    private static final Logger logger = LogManager.getLogger(FactorFactory.class);

    protected FactorFactory() {
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<AlgebraicNumber<C>> getImplementation(AlgebraicNumberRing<C> algebraicNumberRing) {
        return new FactorAlgebraic<C>(algebraicNumberRing, FactorFactory.getImplementation(algebraicNumberRing.ring.coFac));
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Complex<C>> getImplementation(ComplexRing<C> complexRing) {
        return new FactorComplex<C>(complexRing);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Quotient<C>> getImplementation(QuotientRing<C> quotientRing) {
        return new FactorQuotient<C>(quotientRing, FactorFactory.getImplementation(quotientRing.ring.coFac));
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(GenPolynomialRing<C> genPolynomialRing) {
        return FactorFactory.getImplementation(genPolynomialRing.coFac);
    }

    public static <C extends GcdRingElem<C> & Rational> FactorAbstract<edu.jas.root.RealAlgebraicNumber<C>> getImplementation(edu.jas.root.RealAlgebraicRing<C> realAlgebraicRing) {
        return new FactorRealAlgebraic<C>(realAlgebraicRing, FactorFactory.getImplementation(realAlgebraicRing.algebraic));
    }

    public static <C extends GcdRingElem<C> & Rational> FactorAbstract<RealAlgebraicNumber<C>> getImplementation(RealAlgebraicRing<C> realAlgebraicRing) {
        edu.jas.root.RealAlgebraicRing realAlgebraicRing2 = realAlgebraicRing.realRing;
        return new FactorRealReal<C>(realAlgebraicRing, FactorFactory.getImplementation(realAlgebraicRing2));
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(RingFactory<C> ringFactory) {
        logger.info("app factor factory = {}", (Object)ringFactory.getClass().getName());
        FactorAbstract factorAbstract = null;
        RealAlgebraicRing realAlgebraicRing = null;
        edu.jas.root.RealAlgebraicRing realAlgebraicRing2 = null;
        AlgebraicNumberRing algebraicNumberRing = null;
        ComplexRing complexRing = null;
        QuotientRing quotientRing = null;
        GenPolynomialRing genPolynomialRing = null;
        RingFactory<C> ringFactory2 = ringFactory;
        if (ringFactory2 instanceof RealAlgebraicRing) {
            realAlgebraicRing = (RealAlgebraicRing)ringFactory2;
            factorAbstract = new FactorRealReal(realAlgebraicRing, FactorFactory.getImplementation(realAlgebraicRing.realRing));
        } else if (ringFactory2 instanceof edu.jas.root.RealAlgebraicRing) {
            realAlgebraicRing2 = (edu.jas.root.RealAlgebraicRing)ringFactory2;
            factorAbstract = new FactorRealAlgebraic(realAlgebraicRing2, FactorFactory.getImplementation(realAlgebraicRing2.algebraic));
        } else if (ringFactory2 instanceof ComplexRing) {
            complexRing = (ComplexRing)ringFactory2;
            algebraicNumberRing = complexRing.algebraicRing();
            factorAbstract = new FactorComplex<C>(complexRing, FactorFactory.getImplementation(algebraicNumberRing));
        } else if (ringFactory2 instanceof AlgebraicNumberRing) {
            algebraicNumberRing = (AlgebraicNumberRing)ringFactory2;
            factorAbstract = new FactorAlgebraic(algebraicNumberRing, FactorFactory.getImplementation(algebraicNumberRing.ring.coFac));
        } else if (ringFactory2 instanceof QuotientRing) {
            quotientRing = (QuotientRing)ringFactory2;
            factorAbstract = new FactorQuotient(quotientRing, FactorFactory.getImplementation(quotientRing.ring.coFac));
        } else if (ringFactory2 instanceof GenPolynomialRing) {
            genPolynomialRing = (GenPolynomialRing)ringFactory2;
            factorAbstract = FactorFactory.getImplementation(genPolynomialRing.coFac);
        } else {
            factorAbstract = edu.jas.ufd.FactorFactory.getImplementation(ringFactory);
        }
        return factorAbstract;
    }
}

