/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.arith.BigInteger;
import edu.jas.poly.ExpVector;
import edu.jas.poly.ExpVectorLong;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegerProgram
implements Serializable {
    private static final Logger logger = LogManager.getLogger(IntegerProgram.class);
    private static boolean debug = logger.isDebugEnabled();
    private boolean negVars;
    private boolean success;
    int n;
    int m;
    long[] C;
    long[] B;
    long[][] A;
    long[] D;
    long[][] Aa;
    Ideal<BigInteger> I;
    Ideal<BigInteger> GB;
    TermOrder to;
    PolynomialList<BigInteger> F;
    GenPolynomial<BigInteger> S;

    public void setDebug(boolean bl) {
        debug = bl;
    }

    private void createIdeal() {
        Object object;
        int n;
        this.Aa = (long[][])this.A.clone();
        this.negVars = this.negVarTest();
        String[] stringArray = new String[this.n];
        String[] stringArray2 = new String[this.n];
        String[] stringArray3 = new String[this.m];
        String[] stringArray4 = new String[this.n];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Int(");
        if (this.negVars) {
            for (n = 1; n <= this.n; ++n) {
                stringArray[n - 1] = "w" + n;
            }
            for (n = 1; n <= this.m; ++n) {
                stringArray3[n - 1] = "z" + n;
            }
            for (n = 0; n < this.n; ++n) {
                int n2;
                object = new StringBuffer("");
                long l = 0L;
                for (n2 = 0; n2 < this.m; ++n2) {
                    if (this.A[n2][n] >= l) continue;
                    l = this.A[n2][n];
                }
                if (l < 0L) {
                    long l2 = -l;
                    ((StringBuffer)object).append("t^" + l2 + " * ");
                    for (int i = 0; i < this.m; ++i) {
                        this.Aa[i][n] = this.A[i][n] + l2;
                        ((StringBuffer)object).append(stringArray3[i] + "^" + this.Aa[i][n] + " * ");
                    }
                } else {
                    for (n2 = 0; n2 < this.m; ++n2) {
                        if (this.A[n2][n] == 0L) continue;
                        ((StringBuffer)object).append(stringArray3[n2] + "^" + this.A[n2][n] + " * ");
                    }
                }
                stringArray2[n] = ((StringBuffer)object).substring(0, ((StringBuffer)object).length() - 3).toString();
            }
            this.setDeg();
            this.setTO();
            for (n = 0; n < this.n; ++n) {
                stringArray4[n] = stringArray2[n] + " - " + stringArray[n];
            }
            stringBuilder.append("t");
            for (n = 0; n < this.m; ++n) {
                stringBuilder.append(",").append(stringArray3[n]);
            }
            for (n = 0; n < this.n; ++n) {
                stringBuilder.append(",").append(stringArray[n]);
            }
            stringBuilder.append(") W ");
            stringBuilder.append(this.to.weightToString());
            stringBuilder.append(" ( ( t");
            for (n = 0; n < this.m; ++n) {
                stringBuilder.append(" * ").append(stringArray3[n]);
            }
            stringBuilder.append(" - 1 )");
            for (n = 0; n < this.n; ++n) {
                stringBuilder.append(", (").append(stringArray4[n]).append(" )");
            }
            stringBuilder.append(") ");
        } else {
            for (n = 1; n <= this.n; ++n) {
                stringArray[n - 1] = "w" + n;
            }
            for (n = 1; n <= this.m; ++n) {
                stringArray3[n - 1] = "z" + n;
            }
            for (n = 0; n < this.n; ++n) {
                object = new StringBuffer("");
                for (int i = 0; i < this.m; ++i) {
                    if (this.A[i][n] == 0L) continue;
                    ((StringBuffer)object).append(stringArray3[i] + "^" + this.A[i][n] + " * ");
                }
                stringArray2[n] = ((StringBuffer)object).substring(0, ((StringBuffer)object).length() - 3).toString();
            }
            this.setDeg();
            this.setTO();
            for (n = 0; n < this.n; ++n) {
                stringArray4[n] = stringArray2[n] + " - " + stringArray[n];
            }
            stringBuilder.append(stringArray3[0]);
            for (n = 1; n < this.m; ++n) {
                stringBuilder.append(",").append(stringArray3[n]);
            }
            for (n = 0; n < this.n; ++n) {
                stringBuilder.append(",").append(stringArray[n]);
            }
            stringBuilder.append(") W ");
            stringBuilder.append(this.to.weightToString());
            stringBuilder.append(" ( (").append(stringArray4[0]).append(")");
            for (n = 1; n < this.n; ++n) {
                stringBuilder.append(", (").append(stringArray4[n]).append(" )");
            }
            stringBuilder.append(") ");
        }
        if (debug) {
            logger.debug("list = {}", (Object)stringBuilder);
        }
        StringReader stringReader = new StringReader(stringBuilder.toString());
        object = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = ((GenPolynomialTokenizer)object).nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (debug) {
            logger.debug("F = {}", (Object)polynomialList);
        }
        this.I = new Ideal(polynomialList);
    }

    public boolean getSuccess() {
        return this.success;
    }

    public long[] solve(long[][] lArray, long[] lArray2, long[] lArray3) {
        this.A = (long[][])Arrays.copyOf(lArray, lArray.length);
        this.B = Arrays.copyOf(lArray2, lArray2.length);
        this.C = Arrays.copyOf(lArray3, lArray3.length);
        this.n = lArray[0].length;
        this.m = lArray.length;
        this.D = new long[this.n];
        this.createIdeal();
        this.GB = this.I.GB();
        return this.solve(lArray2);
    }

    public long[] solve(long[] lArray) {
        int n;
        long[] lArray2;
        long[] lArray3 = new long[this.n];
        if (lArray.length != this.m) {
            System.out.println("ERROR: Dimensions don't match: " + lArray.length + " != " + this.m);
            return lArray3;
        }
        this.B = Arrays.copyOf(lArray, lArray.length);
        if (debug) {
            logger.debug("GB = {}", this.GB);
        }
        if (this.negVars) {
            lArray2 = new long[this.m + this.n + 1];
            long l = this.findMin(lArray);
            if (l < 0L) {
                long l2;
                lArray2[this.m + this.n] = l2 = -l;
                for (int i = 0; i < this.m; ++i) {
                    lArray2[this.m + this.n - 1 - i] = lArray[i] + l2;
                }
            } else {
                for (int i = 0; i < this.m; ++i) {
                    lArray2[this.m + this.n - 1 - i] = lArray[i];
                }
            }
        } else {
            lArray2 = new long[this.m + this.n];
            for (int i = 0; i < this.m; ++i) {
                lArray2[this.m + this.n - 1 - i] = lArray[i];
            }
        }
        ExpVectorLong expVectorLong = new ExpVectorLong(lArray2);
        this.S = new GenPolynomial<BigInteger>(this.I.getRing(), expVectorLong);
        this.S = this.GB.normalform(this.S);
        ExpVector expVector = this.S.exponentIterator().next();
        for (n = 0; n < this.n; ++n) {
            lArray3[this.n - 1 - n] = expVector.getVal(n);
        }
        this.success = true;
        for (n = this.n; n < this.n + this.m; ++n) {
            if (expVector.getVal(n) == 0L) continue;
            this.success = false;
            break;
        }
        if (this.success) {
            if (debug) {
                logger.debug("The solution is: {}", (Object)Arrays.toString(lArray3));
            }
        } else {
            logger.warn("The Problem does not have a feasible solution.");
            lArray3 = null;
        }
        return lArray3;
    }

    private void setDeg() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.m; ++j) {
                int n = i;
                this.D[n] = this.D[n] + this.Aa[j][i];
            }
        }
    }

    private void setTO() {
        int n;
        int n2 = this.negVars ? this.m + this.n + 1 : this.m + this.n;
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n2];
        for (int i = 0; i < n2 - this.n; ++i) {
            lArray[n2 - 1 - i] = 1L;
        }
        long[] lArray3 = new long[n2];
        long[] lArray4 = new long[n2];
        for (int i = n2 - this.n; i < n2; ++i) {
            lArray3[i] = this.C[i - (n2 - this.n)];
            lArray4[i] = this.D[i - (n2 - this.n)];
        }
        long l = lArray3[0];
        for (n = 0; n < n2; ++n) {
            lArray2[n2 - 1 - n] = lArray3[n] + lArray4[n];
            if (lArray2[n2 - 1 - n] >= l) continue;
            l = lArray2[n2 - 1 - n];
        }
        while (l < 0L) {
            l = lArray2[0];
            for (n = 0; n < n2; ++n) {
                int n3 = n2 - 1 - n;
                lArray2[n3] = lArray2[n3] + lArray4[n];
                if (lArray2[n2 - 1 - n] >= l) continue;
                l = lArray2[n2 - 1 - n];
            }
        }
        long[][] lArrayArray = new long[][]{lArray, lArray2};
        this.to = new TermOrder(lArrayArray);
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Function to minimize:\n");
        char c = 'A';
        boolean bl = false;
        for (n = 0; n < this.n; ++n) {
            if (this.C[n] != 0L) {
                if (this.C[n] < 0L) {
                    stringBuilder.append("(").append(this.C[n]).append(")");
                    stringBuilder.append("*");
                } else if (this.C[n] != 1L) {
                    stringBuilder.append(this.C[n]);
                    stringBuilder.append("*");
                }
                stringBuilder.append(c);
                stringBuilder.append(" + ");
                bl = true;
            }
            c = (char)(c + 1);
        }
        if (bl) {
            stringBuilder.delete(stringBuilder.lastIndexOf("+"), stringBuilder.length());
        }
        stringBuilder.append("\nunder the Restrictions:\n");
        for (n = 0; n < this.m; ++n) {
            c = 'A';
            bl = false;
            for (int i = 0; i < this.n; ++i) {
                if (this.A[n][i] != 0L) {
                    if (this.A[n][i] < 0L) {
                        stringBuilder.append("(").append(this.A[n][i]).append(")");
                        stringBuilder.append("*");
                    } else if (this.A[n][i] != 1L) {
                        stringBuilder.append(this.A[n][i]);
                        stringBuilder.append("*");
                    }
                    stringBuilder.append(c);
                    stringBuilder.append(" + ");
                    bl = true;
                }
                c = (char)(c + '\u0001');
            }
            if (bl) {
                stringBuilder.delete(stringBuilder.lastIndexOf("+"), stringBuilder.length());
            } else {
                stringBuilder.append("0 ");
            }
            stringBuilder.append("= ").append(this.B[n]).append("\n");
        }
        return stringBuilder.toString();
    }

    private boolean negVarTest() {
        for (int i = 0; i < this.m; ++i) {
            if (this.B[i] < 0L) {
                return true;
            }
            for (int j = 0; j < this.n; ++j) {
                if (this.A[i][j] >= 0L) continue;
                return true;
            }
        }
        return false;
    }

    private long findMin(long[] lArray) {
        long l = lArray[0];
        for (int i = 1; i < lArray.length; ++i) {
            if (lArray[i] >= l) continue;
            l = lArray[i];
        }
        return l;
    }
}

