/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.LocalSolvablePolynomial;
import edu.jas.application.SolvableLocal;
import edu.jas.application.SolvableLocalRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalSolvablePolynomialRing<C extends GcdRingElem<C>>
extends GenSolvablePolynomialRing<SolvableLocal<C>> {
    public final RecSolvablePolynomialRing<C> polCoeff;
    public final LocalSolvablePolynomial<C> ZERO;
    public final LocalSolvablePolynomial<C> ONE;
    private static final Logger logger = LogManager.getLogger(LocalSolvablePolynomialRing.class);

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, int n) {
        this(ringFactory, n, new TermOrder(), (String[])null, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, int n, RelationTable<SolvableLocal<C>> relationTable) {
        this(ringFactory, n, new TermOrder(), (String[])null, relationTable);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, int n, TermOrder termOrder) {
        this(ringFactory, n, termOrder, (String[])null, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, int n, TermOrder termOrder, RelationTable<SolvableLocal<C>> relationTable) {
        this(ringFactory, n, termOrder, (String[])null, relationTable);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, n, termOrder, stringArray, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, stringArray.length, termOrder, stringArray, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, new TermOrder(), stringArray, (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray, RelationTable<SolvableLocal<C>> relationTable) {
        super(ringFactory, n, termOrder, stringArray, relationTable);
        ArrayList arrayList;
        SolvableLocalRing solvableLocalRing = (SolvableLocalRing)ringFactory;
        this.polCoeff = new RecSolvablePolynomialRing(solvableLocalRing.ring, n, termOrder, stringArray);
        if (this.table.size() > 0) {
            arrayList = new ArrayList();
            for (GenSolvablePolynomial<SolvableLocal<C>> genSolvablePolynomial : this.table.relationList()) {
                arrayList.add(this.toPolyCoefficients(genSolvablePolynomial));
            }
            this.polCoeff.table.addSolvRelations(arrayList);
        }
        this.ZERO = new LocalSolvablePolynomial(this);
        arrayList = (SolvableLocal)this.coFac.getONE();
        this.ONE = new LocalSolvablePolynomial(this, arrayList, this.evzero);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, GenSolvablePolynomialRing genSolvablePolynomialRing) {
        this(ringFactory, genSolvablePolynomialRing.nvar, genSolvablePolynomialRing.tord, genSolvablePolynomialRing.getVars(), (RelationTable<SolvableLocal<C>>)null);
    }

    public LocalSolvablePolynomialRing(RingFactory<SolvableLocal<C>> ringFactory, LocalSolvablePolynomialRing localSolvablePolynomialRing) {
        this(ringFactory, (GenSolvablePolynomialRing)localSolvablePolynomialRing);
    }

    @Override
    public String toString() {
        Object object = super.toString();
        object = PrettyPrint.isTrue() ? (String)object + "\n" + this.polCoeff.coeffTable.toString(this.vars) : (String)object + ", #rel = " + this.table.size() + " + " + this.polCoeff.coeffTable.size();
        return object;
    }

    @Override
    public String toScript() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("SolvPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",\"" + this.varsToString() + "\",");
        String string2 = this.tord.toScript();
        stringBuffer.append(string2);
        if (this.table.size() > 0) {
            string = this.table.toScript();
            stringBuffer.append(",rel=");
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        string = this.polCoeff.toScript();
        stringBuffer.append("\n  # ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LocalSolvablePolynomialRing)) {
            return false;
        }
        LocalSolvablePolynomialRing localSolvablePolynomialRing = null;
        try {
            localSolvablePolynomialRing = (LocalSolvablePolynomialRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (localSolvablePolynomialRing == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        return this.polCoeff.coeffTable.equals(localSolvablePolynomialRing.polCoeff.coeffTable);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.table.hashCode();
        n = 37 * n + this.polCoeff.coeffTable.hashCode();
        return n;
    }

    @Override
    public LocalSolvablePolynomial<C> getZERO() {
        if (this.ZERO == null || !this.ZERO.isZERO()) {
            throw new RuntimeException("zero not 0: " + this.ZERO);
        }
        return this.ZERO;
    }

    @Override
    public LocalSolvablePolynomial<C> getONE() {
        if (this.ONE == null || !this.ONE.isONE()) {
            throw new RuntimeException("one not 1: " + this.ONE);
        }
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.polCoeff.coeffTable.size() == 0) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        List list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            LocalSolvablePolynomial localSolvablePolynomial = (LocalSolvablePolynomial)list.get(i);
            for (int j = i + 1; j < n; ++j) {
                LocalSolvablePolynomial localSolvablePolynomial2 = (LocalSolvablePolynomial)list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    LocalSolvablePolynomial localSolvablePolynomial3;
                    LocalSolvablePolynomial localSolvablePolynomial4;
                    LocalSolvablePolynomial localSolvablePolynomial5 = (LocalSolvablePolynomial)list.get(k);
                    try {
                        localSolvablePolynomial4 = localSolvablePolynomial5.multiply(localSolvablePolynomial2).multiply(localSolvablePolynomial);
                        localSolvablePolynomial3 = localSolvablePolynomial5.multiply(localSolvablePolynomial2.multiply(localSolvablePolynomial));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    if (localSolvablePolynomial4.compareTo(localSolvablePolynomial3) == 0) continue;
                    logger.info("Xk = {}, Xj = {}, Xi = {}", (Object)localSolvablePolynomial5, (Object)localSolvablePolynomial2, (Object)localSolvablePolynomial);
                    logger.info("p = ( Xk * Xj ) * Xi = {}", localSolvablePolynomial4);
                    logger.info("q = Xk * ( Xj * Xi ) = {}", localSolvablePolynomial3);
                    logger.info("q-p = {}", localSolvablePolynomial4.subtract(localSolvablePolynomial3));
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public LocalSolvablePolynomial<C> fromInteger(long l) {
        return new LocalSolvablePolynomial(this, (SolvableLocal)this.coFac.fromInteger(l), this.evzero);
    }

    @Override
    public LocalSolvablePolynomial<C> fromInteger(BigInteger bigInteger) {
        return new LocalSolvablePolynomial(this, (SolvableLocal)this.coFac.fromInteger(bigInteger), this.evzero);
    }

    @Override
    public LocalSolvablePolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public LocalSolvablePolynomial<C> random(int n, Random random) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, random);
        }
        return this.random(5, n, 3, 0.3f, random);
    }

    @Override
    public LocalSolvablePolynomial<C> random(int n, int n2, int n3, float f) {
        return this.random(n, n2, n3, f, random);
    }

    @Override
    public LocalSolvablePolynomial<C> random(int n, int n2, int n3, float f, Random random) {
        GenSolvablePolynomial genSolvablePolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            ExpVector expVector = ExpVector.random(this.nvar, n3, f, random);
            SolvableLocal solvableLocal = (SolvableLocal)this.coFac.random(n, random);
            genSolvablePolynomial = (LocalSolvablePolynomial)genSolvablePolynomial.sum(solvableLocal, expVector);
        }
        return genSolvablePolynomial;
    }

    @Override
    public LocalSolvablePolynomial<C> copy(LocalSolvablePolynomial<C> localSolvablePolynomial) {
        return new LocalSolvablePolynomial(this, localSolvablePolynomial.getMap());
    }

    @Override
    public LocalSolvablePolynomial<C> parse(String string) {
        return this.parse(new StringReader(string));
    }

    @Override
    public LocalSolvablePolynomial<C> parse(Reader reader) {
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this, reader);
        LocalSolvablePolynomial localSolvablePolynomial = null;
        try {
            GenSolvablePolynomial genSolvablePolynomial = genPolynomialTokenizer.nextSolvablePolynomial();
            localSolvablePolynomial = new LocalSolvablePolynomial(this, genSolvablePolynomial);
        }
        catch (IOException iOException) {
            logger.error("{} parse {}", (Object)iOException, (Object)this);
            localSolvablePolynomial = this.ZERO;
        }
        return localSolvablePolynomial;
    }

    @Override
    public LocalSolvablePolynomial<C> univariate(int n) {
        return (LocalSolvablePolynomial)super.univariate(n);
    }

    @Override
    public LocalSolvablePolynomial<C> univariate(int n, long l) {
        return (LocalSolvablePolynomial)super.univariate(n, l);
    }

    @Override
    public LocalSolvablePolynomial<C> univariate(int n, int n2, long l) {
        return (LocalSolvablePolynomial)super.univariate(n, n2, l);
    }

    @Override
    public List<LocalSolvablePolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    @Override
    public List<LocalSolvablePolynomial<C>> univariateList(int n) {
        return this.univariateList(n, 1L);
    }

    @Override
    public List<LocalSolvablePolynomial<C>> univariateList(int n, long l) {
        ArrayList<LocalSolvablePolynomial<C>> arrayList = new ArrayList<LocalSolvablePolynomial<C>>(this.nvar);
        int n2 = this.nvar - n;
        for (int i = 0; i < n2; ++i) {
            GenSolvablePolynomial genSolvablePolynomial = this.univariate(n, n2 - 1 - i, l);
            arrayList.add((LocalSolvablePolynomial<C>)genSolvablePolynomial);
        }
        return arrayList;
    }

    @Override
    public LocalSolvablePolynomialRing<C> extend(int n) {
        return this.extend(n, false);
    }

    @Override
    public LocalSolvablePolynomialRing<C> extend(int n, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(n, bl);
        LocalSolvablePolynomialRing<C> localSolvablePolynomialRing = new LocalSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        localSolvablePolynomialRing.table.extend(this.table);
        localSolvablePolynomialRing.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return localSolvablePolynomialRing;
    }

    @Override
    public LocalSolvablePolynomialRing<C> extend(String[] stringArray) {
        return this.extend(stringArray, false);
    }

    @Override
    public LocalSolvablePolynomialRing<C> extend(String[] stringArray, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(stringArray, bl);
        LocalSolvablePolynomialRing<C> localSolvablePolynomialRing = new LocalSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        localSolvablePolynomialRing.table.extend(this.table);
        localSolvablePolynomialRing.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return localSolvablePolynomialRing;
    }

    @Override
    public LocalSolvablePolynomialRing<C> contract(int n) {
        GenPolynomialRing genPolynomialRing = super.contract(n);
        LocalSolvablePolynomialRing<C> localSolvablePolynomialRing = new LocalSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        localSolvablePolynomialRing.table.contract(this.table);
        localSolvablePolynomialRing.polCoeff.coeffTable.contract(this.polCoeff.coeffTable);
        return localSolvablePolynomialRing;
    }

    @Override
    public LocalSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public LocalSolvablePolynomialRing<C> reverse(boolean bl) {
        GenPolynomialRing genPolynomialRing = super.reverse(bl);
        LocalSolvablePolynomialRing<C> localSolvablePolynomialRing = new LocalSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        localSolvablePolynomialRing.partial = bl;
        localSolvablePolynomialRing.table.reverse(this.table);
        localSolvablePolynomialRing.polCoeff.coeffTable.reverse(this.polCoeff.coeffTable);
        return localSolvablePolynomialRing;
    }

    public LocalSolvablePolynomial<C> fromPolyCoefficients(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        GenSolvablePolynomial genSolvablePolynomial2 = ((LocalSolvablePolynomial)this.getZERO()).copy();
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        RingFactory ringFactory = this.coFac;
        SolvableLocalRing solvableLocalRing = (SolvableLocalRing)ringFactory;
        for (Map.Entry entry : genSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)entry.getValue();
            SolvableLocal solvableLocal = new SolvableLocal(solvableLocalRing, genSolvablePolynomial3);
            if (solvableLocal.isZERO()) continue;
            genSolvablePolynomial2.doPutToMap(expVector, solvableLocal);
        }
        return genSolvablePolynomial2;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(LocalSolvablePolynomial<C> localSolvablePolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (localSolvablePolynomial == null || localSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry entry : localSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            SolvableLocal solvableLocal = (SolvableLocal)entry.getValue();
            if (!solvableLocal.den.isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + solvableLocal);
            }
            GenSolvablePolynomial genSolvablePolynomial2 = solvableLocal.num;
            if (genSolvablePolynomial2.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genSolvablePolynomial2);
        }
        return genSolvablePolynomial;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(GenPolynomial<SolvableLocal<C>> genPolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry<ExpVector, SolvableLocal<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            SolvableLocal<C> solvableLocal = entry.getValue();
            if (!solvableLocal.den.isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + solvableLocal);
            }
            GenSolvablePolynomial genSolvablePolynomial2 = solvableLocal.num;
            if (genSolvablePolynomial2.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genSolvablePolynomial2);
        }
        return genSolvablePolynomial;
    }
}

