/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.root.RealRootTuple;
import edu.jas.structure.Element;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.Power;
import edu.jas.structure.StarRingElem;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RealAlgebraicTest
extends TestCase {
    RealAlgebraicRing<BigRational> fac;
    GenPolynomialRing<BigRational> mfac;
    RealAlgebraicNumber<BigRational> a;
    RealAlgebraicNumber<BigRational> b;
    RealAlgebraicNumber<BigRational> c;
    RealAlgebraicNumber<BigRational> d;
    RealAlgebraicNumber<BigRational> e;
    int rl = 2;
    int kl = 10;
    int ll;
    int el = this.ll = 10;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RealAlgebraicTest.suite());
    }

    public RealAlgebraicTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RealAlgebraicTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        BigRational bigRational = new BigRational();
        String[] stringArray = new String[]{"x", "y"};
        this.rl = stringArray.length;
        TermOrder termOrder = new TermOrder(2);
        this.mfac = new GenPolynomialRing<BigRational>(bigRational, termOrder, stringArray);
        Element element = this.mfac.parse("y**3 - 3 * x**2 * y  - 2");
        Element element2 = this.mfac.parse("-3 * x * y**2 + x**3");
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(element);
        arrayList.add(element2);
        Ideal<BigRational> ideal = new Ideal<BigRational>(this.mfac, arrayList);
        List<IdealWithUniv<BigRational>> list = ideal.zeroDimRootDecomposition();
        IdealWithUniv<BigRational> idealWithUniv = list.get(0);
        GenPolynomial genPolynomial = idealWithUniv.ideal.list.list.remove(1);
        genPolynomial = genPolynomial.multiply(genPolynomial).subtract((GenPolynomial<Element>)this.mfac.fromInteger(3L));
        idealWithUniv.ideal.list.list.add(genPolynomial);
        IdealWithRealAlgebraicRoots idealWithRealAlgebraicRoots = PolyUtilApp.realAlgebraicRoots(idealWithUniv.ideal).get(0);
        List list2 = idealWithRealAlgebraicRoots.ran;
        RealRootTuple realRootTuple = new RealRootTuple(list2.get(0));
        if (list2.size() > 1) {
            realRootTuple = new RealRootTuple(list2.get(1));
        }
        this.fac = new RealAlgebraicRing<BigRational>(idealWithUniv, realRootTuple);
    }

    protected void tearDown() {
        ComputerThreads.terminate();
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        RealAlgebraicTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        RealAlgebraicTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        RealAlgebraicTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        String string = this.fac.toScript();
        RealAlgebraicTest.assertTrue((String)"RealN in toScript", (string.indexOf("RealN") >= 0 ? 1 : 0) != 0);
        string = this.fac.getRoot().toScript();
        RealAlgebraicTest.assertTrue((String)"ts = [x,y]", (string.indexOf("[x,y]") >= 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"#rat(root) = 2", (this.fac.getRoot().getRational().size() == this.rl ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"#dec(root) = 2", (this.fac.getRoot().decimalMagnitude().size() == this.rl ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.el);
            if (this.a.isZERO() || this.a.isONE()) continue;
            RealAlgebraicTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            RealAlgebraicTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testReIm() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(this.fac);
        Complex<RealAlgebraicNumber<BigRational>> complex = new Complex<RealAlgebraicNumber<BigRational>>(complexRing, this.a, this.b);
        RealAlgebraicTest.assertEquals((String)"a == re(c)", this.a, complex.getRe());
        RealAlgebraicTest.assertEquals((String)"b == im(c)", this.b, complex.getIm());
        StarRingElem starRingElem = complex.conjugate();
        StarRingElem starRingElem2 = ((Complex)starRingElem).conjugate();
        RealAlgebraicTest.assertEquals((String)"con(con(c)) = c", complex, (Object)starRingElem2);
        Complex<RealAlgebraicNumber<BigRational>> complex2 = complex.multiply((Complex<RealAlgebraicNumber<BigRational>>)starRingElem);
        starRingElem2 = complex.norm();
        this.c = complex2.getRe();
        this.e = (RealAlgebraicNumber)((Complex)starRingElem2).getRe();
        RealAlgebraicTest.assertEquals((String)"c*con(c) = norm(c)", this.c, this.e);
        this.c = complex2.getIm();
        this.e = (RealAlgebraicNumber)((Complex)starRingElem2).getIm();
        RealAlgebraicTest.assertEquals((String)"c*con(c) = norm(c)", this.c, this.e);
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        RealAlgebraicTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        RealAlgebraicTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        RealAlgebraicTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((RealAlgebraicNumber<BigRational>)this.fac.getZERO());
        this.d = this.a.subtract((RealAlgebraicNumber<BigRational>)this.fac.getZERO());
        RealAlgebraicTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((RealAlgebraicNumber)this.fac.getZERO()).sum(this.a);
        this.d = ((RealAlgebraicNumber)this.fac.getZERO()).subtract(this.a.negate());
        RealAlgebraicTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        RealAlgebraicTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        RealAlgebraicTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        RealAlgebraicTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        RealAlgebraicTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        RealAlgebraicTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        RealAlgebraicTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        RealAlgebraicTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        RealAlgebraicTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((RealAlgebraicNumber<BigRational>)this.fac.getONE());
        this.d = ((RealAlgebraicNumber)this.fac.getONE()).multiply(this.a);
        RealAlgebraicTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.a.inverse();
        this.d = this.c.multiply(this.a);
        RealAlgebraicTest.assertEquals((String)"a*1/a = 1", (Object)this.fac.getONE(), this.d);
        try {
            this.a = ((RealAlgebraicNumber)this.fac.getZERO()).inverse();
            RealAlgebraicTest.fail((String)"0 invertible");
        }
        catch (NotInvertibleException notInvertibleException) {
            // empty catch block
        }
    }

    public void testDistributive() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        RealAlgebraicTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testSignum() {
        this.a = this.fac.random(this.ll);
        int n = this.a.signum();
        RealAlgebraicTest.assertTrue((String)"isZERO( c )", (this.a.isZERO() && n == 0 || !this.a.isZERO() && n != 0 ? 1 : 0) != 0);
        BigDecimal bigDecimal = this.a.decimalMagnitude();
        this.b = this.a.multiply(this.a);
        BigDecimal bigDecimal2 = this.b.decimalMagnitude();
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal);
        BigDecimal bigDecimal4 = Power.positivePower(new BigDecimal(0.1), BigDecimal.DEFAULT_PRECISION - 8);
        BigDecimal bigDecimal5 = bigDecimal3.subtract(bigDecimal2).abs().divide(bigDecimal3.abs().sum(bigDecimal2.abs()));
        RealAlgebraicTest.assertTrue((String)("magnitude(a)*magnitude(a) == magnitude(a*a): " + bigDecimal5 + " <= " + bigDecimal4), (bigDecimal5.compareTo(bigDecimal4) <= 0 ? 1 : 0) != 0);
    }

    public void testCompare() {
        this.a = ((RealAlgebraicNumber)this.fac.random(this.ll)).abs();
        this.b = this.a.sum((RealAlgebraicNumber<BigRational>)this.fac.getONE());
        this.c = this.b.sum((RealAlgebraicNumber<BigRational>)this.fac.getONE());
        int n = this.a.compareTo(this.b);
        int n2 = this.b.compareTo(this.c);
        int n3 = this.a.compareTo(this.c);
        RealAlgebraicTest.assertTrue((String)"a < a+1 ", (n < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a+1 < a+2 ", (n2 < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a < a+2 ", (n3 < 0 ? 1 : 0) != 0);
        this.a = this.a.negate();
        this.b = this.a.sum((RealAlgebraicNumber<BigRational>)this.fac.getONE());
        this.c = this.b.sum((RealAlgebraicNumber<BigRational>)this.fac.getONE());
        n = this.a.compareTo(this.b);
        n2 = this.b.compareTo(this.c);
        n3 = this.a.compareTo(this.c);
        RealAlgebraicTest.assertTrue((String)"a < a+1 ", (n < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a+1 < a+2 ", (n2 < 0 ? 1 : 0) != 0);
        RealAlgebraicTest.assertTrue((String)"a < a+2 ", (n3 < 0 ? 1 : 0) != 0);
    }
}

