/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ResidueSolvablePolynomial;
import edu.jas.application.ResidueSolvablePolynomialRing;
import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableResidue;
import edu.jas.application.SolvableResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ResidueSolvablePolynomialTest
extends TestCase {
    ResidueSolvablePolynomial<BigRational> a;
    ResidueSolvablePolynomial<BigRational> b;
    ResidueSolvablePolynomial<BigRational> c;
    ResidueSolvablePolynomial<BigRational> d;
    ResidueSolvablePolynomial<BigRational> e;
    ResidueSolvablePolynomial<BigRational> f;
    ResidueSolvablePolynomial<BigRational> x1;
    ResidueSolvablePolynomial<BigRational> x2;
    int rl = 4;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.3f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    SolvableResidueRing<BigRational> rring;
    SolvableIdeal<BigRational> sideal;
    ResidueSolvablePolynomialRing<BigRational> ring;
    BigRational cfac;
    GenSolvablePolynomialRing<BigRational> sring;
    GenPolynomialRing<BigRational> cring;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ResidueSolvablePolynomialTest.suite());
    }

    public ResidueSolvablePolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ResidueSolvablePolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.sring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = this.sring.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(this.sring, arrayList);
        this.sideal = this.sideal.twosidedGB();
        if (this.sideal.isONE()) {
            System.out.println("twosided sideal = " + this.sideal.toScript());
            throw new IllegalArgumentException("ideal is one");
        }
        this.rring = new SolvableResidueRing<BigRational>(this.sideal);
        this.ring = new ResidueSolvablePolynomialRing(this.rring, this.tord, this.vars);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        List list = this.ring.table.relationList();
        ArrayList arrayList2 = new ArrayList();
        for (GenSolvablePolynomial genSolvablePolynomial : list) {
            RecSolvablePolynomial<BigRational> recSolvablePolynomial = this.ring.toPolyCoefficients(genSolvablePolynomial);
            arrayList2.add(recSolvablePolynomial);
        }
        this.ring.polCoeff.table.addSolvRelations(arrayList2);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        this.a = this.ring.getZERO();
        ResidueSolvablePolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        ResidueSolvablePolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        ResidueSolvablePolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        ResidueSolvablePolynomialTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        ResidueSolvablePolynomialTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new ResidueSolvablePolynomial<BigRational>(this.ring);
        ResidueSolvablePolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        ResidueSolvablePolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        ResidueSolvablePolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        ResidueSolvablePolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        ResidueSolvablePolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ResidueSolvablePolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            ResidueSolvablePolynomialTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.ring.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            ResidueSolvablePolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            ResidueSolvablePolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ResidueSolvablePolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (ResidueSolvablePolynomial)this.a.subtract((BigRational)((Object)this.a));
        ResidueSolvablePolynomialTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (ResidueSolvablePolynomial)this.a.sum((BigRational)((Object)this.a));
        this.c = (ResidueSolvablePolynomial)this.b.subtract((BigRational)((Object)this.a));
        ResidueSolvablePolynomialTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (ResidueSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (ResidueSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        ResidueSolvablePolynomialTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (ResidueSolvablePolynomial)this.a.sum((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = (ResidueSolvablePolynomial)this.a.sum((BigRational)((Object)this.b)).sum(this.c);
        ResidueSolvablePolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        Element element = this.rring.random(this.kl);
        this.b = ((ResidueSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (ResidueSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        this.d = (ResidueSolvablePolynomial)this.a.sum((BigRational)element, expVector);
        ResidueSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (ResidueSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (ResidueSolvablePolynomial)this.a.subtract((BigRational)element, expVector);
        ResidueSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((ResidueSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (ResidueSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (ResidueSolvablePolynomial)this.a.sum((BigRational)element, expVector);
        ResidueSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (ResidueSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (ResidueSolvablePolynomial)this.a.subtract((BigRational)element, expVector);
        ResidueSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        ResidueSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        ResidueSolvablePolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        this.d = (ResidueSolvablePolynomial)this.a.monic();
        ResidueSolvablePolynomialTest.assertTrue((String)("a.monic(): " + this.d), (((SolvableResidue)this.d.leadingBaseCoefficient()).isONE() || ((SolvableResidue)this.d.leadingBaseCoefficient()).equals(this.a.leadingBaseCoefficient()) ? 1 : 0) != 0);
    }

    public void testPartCommutative() {
        ResidueSolvablePolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        this.ring = new ResidueSolvablePolynomialRing(this.rring, this.ring);
        ResidueSolvablePolynomialTest.assertTrue((String)"isCommutative()", (this.ring.isCommutative() || !this.rring.isCommutative() ? 1 : 0) != 0);
        ResidueSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        ResidueSolvablePolynomialTest.assertEquals((String)"ba == ab: ", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((ResidueSolvablePolynomial)this.b.sum((BigRational)((Object)this.c)));
        this.e = (ResidueSolvablePolynomial)this.a.multiply(this.b).sum((BigRational)((Object)this.a.multiply(this.c)));
        ResidueSolvablePolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testSolvableCoeffsRelations() {
        ResidueSolvablePolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        ResidueSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        ResidueSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = this.sring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        RecSolvablePolynomial<BigRational> recSolvablePolynomial = this.ring.toPolyCoefficients((ResidueSolvablePolynomial<BigRational>)genSolvablePolynomial2);
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), (GenSolvablePolynomial<GenPolynomial<BigRational>>)recSolvablePolynomial);
        ResidueSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        ResidueSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial2 : list) {
            RecSolvablePolynomial<BigRational> recSolvablePolynomial2;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial2;
            try {
                recSolvablePolynomial2 = this.ring.toPolyCoefficients(genSolvablePolynomial3);
                this.c = this.ring.fromPolyCoefficients(recSolvablePolynomial2);
                ResidueSolvablePolynomialTest.assertEquals((String)"from(to(xx)) == xx", (Object)genSolvablePolynomial3, this.c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.a = new ResidueSolvablePolynomial<BigRational>(this.ring, genSolvablePolynomial3);
            try {
                recSolvablePolynomial2 = this.ring.toPolyCoefficients(this.a);
                this.c = this.ring.fromPolyCoefficients(recSolvablePolynomial2);
                ResidueSolvablePolynomialTest.assertEquals((String)"from(to(a)) == a", this.a, this.c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            for (GenPolynomial genPolynomial3 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial3;
                this.b = new ResidueSolvablePolynomial<BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply(this.b);
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                ResidueSolvablePolynomialTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
                expVector = ((SolvableResidue)this.a.leadingBaseCoefficient()).val.leadingExpVector().sum(((SolvableResidue)this.b.leadingBaseCoefficient()).val.leadingExpVector());
                ResidueSolvablePolynomialTest.assertTrue((String)"LT(lc(a))*LT(lc(b)) == LT(lc(c))", (boolean)((SolvableResidue)this.c.leadingBaseCoefficient()).val.leadingExpVector().equals(expVector));
            }
        }
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        ResidueSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
    }

    public void testExtendContractWeyl() {
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = this.sring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), (GenSolvablePolynomial<GenPolynomial<BigRational>>)this.ring.toPolyCoefficients((ResidueSolvablePolynomial<BigRational>)genSolvablePolynomial2));
        int n = this.rl;
        GenSolvablePolynomialRing genSolvablePolynomialRing = this.ring.extend(n);
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = ((ResidueSolvablePolynomialRing)genSolvablePolynomialRing).contract(n);
        ResidueSolvablePolynomialTest.assertEquals((String)"ring == pfec", this.ring, (Object)genSolvablePolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        ResidueSolvablePolynomial residueSolvablePolynomial = (ResidueSolvablePolynomial)genSolvablePolynomial3.extend(genSolvablePolynomialRing, 0, 0L);
        Map map = residueSolvablePolynomial.contract(genSolvablePolynomialRing2);
        ArrayList arrayList = new ArrayList(map.values());
        GenPolynomial genPolynomial2 = (GenPolynomial)arrayList.get(0);
        ResidueSolvablePolynomialTest.assertEquals((String)"a == aec", (Object)genSolvablePolynomial3, (Object)genPolynomial2);
    }

    public void testReverseWeyl() {
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = this.sring.parse("a");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("a x + b");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), (GenSolvablePolynomial<GenPolynomial<BigRational>>)this.ring.toPolyCoefficients((ResidueSolvablePolynomial<BigRational>)genSolvablePolynomial2));
        GenSolvablePolynomialRing genSolvablePolynomialRing = this.ring.reverse();
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = ((ResidueSolvablePolynomialRing)genSolvablePolynomialRing).reverse();
        ResidueSolvablePolynomialTest.assertEquals((String)"pf == pfrr", this.ring, (Object)genSolvablePolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        ResidueSolvablePolynomial residueSolvablePolynomial = (ResidueSolvablePolynomial)genSolvablePolynomial3.reverse(genSolvablePolynomialRing);
        ResidueSolvablePolynomial residueSolvablePolynomial2 = (ResidueSolvablePolynomial)residueSolvablePolynomial.reverse(genSolvablePolynomialRing2);
        ResidueSolvablePolynomialTest.assertEquals((String)"a == arr", (Object)genSolvablePolynomial3, (Object)residueSolvablePolynomial2);
    }

    public void testRecursiveWeyl() {
        GenPolynomialRing genPolynomialRing = this.ring.recursive(2);
        GenSolvablePolynomial genSolvablePolynomial = this.ring.random(this.kl, this.ll, this.el, this.q);
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.random(this.kl, this.ll, this.el, this.q);
        GenSolvablePolynomial<GenSolvablePolynomial> genSolvablePolynomial3 = genSolvablePolynomial.multiply(genSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial3 = recSolvablePolynomial.multiply(recSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial4 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial3);
        ResidueSolvablePolynomialTest.assertEquals((String)"dr.ring == cr.ring", recSolvablePolynomial4.ring, recSolvablePolynomial3.ring);
        ResidueSolvablePolynomialTest.assertEquals((String)"dr == cr", (Object)recSolvablePolynomial4, recSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)PolyUtil.distribute(this.ring, recSolvablePolynomial3);
        ResidueSolvablePolynomialTest.assertEquals((String)"dd == cd", (Object)genSolvablePolynomial4, genSolvablePolynomial3);
    }
}

