/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.SolvableIdeal;
import edu.jas.arith.BigRational;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.poly.WeylRelations;
import edu.jas.poly.WeylRelationsIterated;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolvableIdealTest
extends TestCase {
    TermOrder to;
    GenSolvablePolynomialRing<BigRational> fac;
    List<GenSolvablePolynomial<BigRational>> L;
    List<GenSolvablePolynomial<BigRational>> M;
    PolynomialList<BigRational> F;
    List<GenSolvablePolynomial<BigRational>> G;
    SolvableGroebnerBase<BigRational> bb;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    int rl = 4;
    int kl = 2;
    int ll = 3;
    int el = 3;
    float q = 0.15f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SolvableIdealTest.suite());
    }

    public SolvableIdealTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableIdealTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.fac = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.fac);
        this.bb = new SolvableGroebnerBaseSeq<BigRational>();
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
        ComputerThreads.terminate();
    }

    public void testLeftIdealSum() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L = PolynomialList.castToSolvableList(this.fac.generators());
        int n = this.L.size() - this.rl;
        if (this.a.isZERO()) {
            this.a = this.L.get(n++);
        }
        if (this.b.isZERO()) {
            this.b = this.L.get(n++);
        }
        if (this.c.isZERO()) {
            this.c = this.L.get(n++);
        }
        if (this.d.isZERO()) {
            this.d = this.L.get(n++);
            this.e = this.d;
        }
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)("isGB( I ): " + solvableIdeal.toScript()), (boolean)solvableIdeal.isGB());
        this.L = this.bb.leftGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        String string = solvableIdeal.toScript() + "\n" + solvableIdeal.toString();
        SolvableIdealTest.assertTrue((String)"#s >= 260: ", (string.length() >= 260 ? 1 : 0) != 0);
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.getZERO();
        SolvableIdealTest.assertTrue((String)("K == 0: " + solvableIdeal2), (boolean)solvableIdeal2.isZERO());
        solvableIdeal2 = solvableIdeal.getONE();
        SolvableIdealTest.assertTrue((String)("K == 1: " + solvableIdeal2), (boolean)solvableIdeal2.isONE());
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        this.L = this.bb.leftGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal;
        solvableIdeal2 = solvableIdeal3.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"equals( K, I )", (boolean)solvableIdeal2.equals(solvableIdeal));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        SolvableIdealTest.assertTrue((String)"isGB( { c } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        solvableIdeal2 = solvableIdeal3.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"K contains(I)", (boolean)solvableIdeal2.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"K contains(J)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        SolvableIdealTest.assertTrue((String)"isGB( { d } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        solvableIdeal = solvableIdeal2;
        solvableIdeal2 = solvableIdeal3.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"K contains(I)", (boolean)solvableIdeal2.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"K contains(J)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        SolvableIdealTest.assertTrue((String)"isGB( { e } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        solvableIdeal = solvableIdeal2;
        solvableIdeal2 = solvableIdeal3.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"equals( K, I )", (boolean)solvableIdeal2.equals(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"K contains(J)", (boolean)solvableIdeal2.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"I contains(K)", (boolean)solvableIdeal.contains(solvableIdeal2));
        this.L = solvableIdeal2.normalform(solvableIdeal.getList());
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)("I mod K == 0: " + solvableIdeal), (boolean)solvableIdeal.isZERO());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L.add(this.b);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        solvableIdeal.doGB();
        solvableIdeal3 = solvableIdeal.power(3);
        solvableIdeal3 = solvableIdeal3.power(2);
        solvableIdeal2 = solvableIdeal.power(6);
        SolvableIdealTest.assertEquals((String)"equals( (I**3)**2, I**6 )", solvableIdeal2, solvableIdeal3);
        if (solvableIdeal.isUnit(this.c)) {
            this.d = solvableIdeal.inverse(this.c);
            this.e = solvableIdeal.normalform(this.d.multiply((BigRational)((Object)this.c)));
            SolvableIdealTest.assertTrue((String)("inv(c) * c mod I == 1: " + this.e), (boolean)this.e.isONE());
        }
    }

    public void testRightIdealSum() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L = PolynomialList.castToSolvableList(this.fac.generators());
        int n = this.L.size() - this.rl;
        if (this.a.isZERO()) {
            this.a = this.L.get(n++);
        }
        if (this.b.isZERO()) {
            this.b = this.L.get(n++);
        }
        if (this.c.isZERO()) {
            this.c = this.L.get(n++);
        }
        if (this.d.isZERO()) {
            this.d = this.L.get(n++);
            this.e = this.d;
        }
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.right);
        SolvableIdealTest.assertTrue((String)"not isZERO( Ir )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Ir )", (boolean)solvableIdeal.isGB());
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false, SolvableIdeal.Side.right);
        SolvableIdealTest.assertTrue((String)"not isZERO( Ir )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)("isGB( Ir ): " + solvableIdeal.toScript()), (boolean)solvableIdeal.isGB());
        SolvableIdealTest.assertTrue((String)"isGB( Ir )", (boolean)solvableIdeal.isRightGB());
        this.L = this.bb.rightGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isRightGB(this.L));
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.right);
        SolvableIdealTest.assertTrue((String)"not isZERO( Ir )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Ir )", (boolean)solvableIdeal.isGB());
        SolvableIdealTest.assertTrue((String)"isGB( Ir )", (boolean)solvableIdeal.isRightGB());
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false, SolvableIdeal.Side.right);
        SolvableIdealTest.assertTrue((String)"not isZERO( Ir )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Ir )", (boolean)solvableIdeal.isGB());
        SolvableIdealTest.assertTrue((String)"isGB( Ir )", (boolean)solvableIdeal.isRightGB());
        String string = solvableIdeal.toScript() + "\n" + solvableIdeal.toString();
        SolvableIdealTest.assertTrue((String)"#s >= 260: ", (string.length() >= 260 ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false, SolvableIdeal.Side.right);
        SolvableIdealTest.assertTrue((String)"not isZERO( Ir )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        this.L = this.bb.rightGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isRightGB(this.L));
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.right);
        SolvableIdealTest.assertTrue((String)"not isZERO( Ir )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Ir )", (boolean)solvableIdeal.isRightGB());
        SolvableIdealTest.assertTrue((String)"isGB( Ir )", (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.rightGB();
        SolvableIdealTest.assertTrue((String)"isGB( Jr )", (boolean)solvableIdeal2.isRightGB());
        solvableIdeal2 = solvableIdeal;
        SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( Kr )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Kr )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"isGB( Kr )", (boolean)solvableIdeal3.isRightGB());
        SolvableIdealTest.assertTrue((String)"equals( Kr, Ir )", (boolean)solvableIdeal3.equals(solvableIdeal));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        SolvableIdealTest.assertTrue((String)"isGB( { c } )", (boolean)this.bb.isRightGB(this.L));
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.right);
        solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( Kr )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Kr )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"isGB( Kr )", (boolean)solvableIdeal3.isRightGB());
        SolvableIdealTest.assertTrue((String)"Kr contains(Ir)", (boolean)solvableIdeal3.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"Kr contains(Jr)", (boolean)solvableIdeal3.contains(solvableIdeal2));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        SolvableIdealTest.assertTrue((String)"isGB( { d } )", (boolean)this.bb.isRightGB(this.L));
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.right);
        solvableIdeal = solvableIdeal3;
        solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( Kr )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Kr )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"isGB( Kr )", (boolean)solvableIdeal3.isRightGB());
        SolvableIdealTest.assertTrue((String)"Kr contains(Ir)", (boolean)solvableIdeal3.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"Kr contains(Jr)", (boolean)solvableIdeal3.contains(solvableIdeal2));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        SolvableIdealTest.assertTrue((String)"isGB( { e } )", (boolean)this.bb.isRightGB(this.L));
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.right);
        solvableIdeal = solvableIdeal3;
        solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( Kr )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Kr )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"isGB( Kr )", (boolean)solvableIdeal3.isRightGB());
        SolvableIdealTest.assertTrue((String)"equals( Kr, Ir )", (boolean)solvableIdeal3.equals(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"Kr contains(Jr)", (boolean)solvableIdeal3.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"Ir contains(Kr)", (boolean)solvableIdeal.contains(solvableIdeal3));
    }

    public void testTwosideIdealSum() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L = PolynomialList.castToSolvableList(this.fac.generators());
        int n = this.L.size() - this.rl;
        if (this.a.isZERO()) {
            this.a = this.L.get(n++);
        }
        if (this.b.isZERO()) {
            this.b = this.L.get(n++);
        }
        if (this.c.isZERO()) {
            this.c = this.L.get(n++);
        }
        if (this.d.isZERO()) {
            this.d = this.L.get(n++);
            this.e = this.d;
        }
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.twosided);
        SolvableIdealTest.assertTrue((String)"not isZERO( It )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( It )", (boolean)solvableIdeal.isGB());
        this.L = this.bb.twosidedGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isTwosidedGB(this.L));
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false, SolvableIdeal.Side.twosided);
        SolvableIdealTest.assertTrue((String)"not isZERO( It )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)("isGB( It ): " + solvableIdeal.toScript()), (boolean)solvableIdeal.isGB());
        SolvableIdealTest.assertTrue((String)("is2sGB( It ): " + solvableIdeal.toScript()), (boolean)solvableIdeal.isTwosidedGB());
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.twosided);
        SolvableIdealTest.assertTrue((String)"not isZERO( It )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( It )", (boolean)solvableIdeal.isGB());
        String string = solvableIdeal.toScript() + "\n" + solvableIdeal.toString();
        SolvableIdealTest.assertTrue((String)"#s >= 260: ", (string.length() >= 260 ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false, SolvableIdeal.Side.twosided);
        SolvableIdealTest.assertTrue((String)"not isZERO( It )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        this.L = this.bb.twosidedGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isTwosidedGB(this.L));
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.twosided);
        SolvableIdealTest.assertTrue((String)"not isZERO( It )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( It )", (boolean)solvableIdeal.isGB());
        SolvableIdealTest.assertTrue((String)("is2sGB( It ): " + solvableIdeal.toScript()), (boolean)solvableIdeal.isTwosidedGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal;
        SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( Kt )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Kt )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"equals( Kt, It )", (boolean)solvableIdeal3.equals(solvableIdeal));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.twosidedGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { c } )", (boolean)this.bb.isTwosidedGB(this.L));
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.twosided);
        solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( Kt )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Kt )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"Kt equals(It)", (boolean)solvableIdeal3.equals(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"Kt equals(Jt)", (boolean)solvableIdeal3.equals(solvableIdeal2));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.twosidedGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { d } )", (boolean)this.bb.isTwosidedGB(this.L));
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.twosided);
        SolvableIdealTest.assertTrue((String)("is2sGB( Jt ): " + solvableIdeal2.toScript()), (boolean)solvableIdeal2.isTwosidedGB());
        solvableIdeal = solvableIdeal3;
        solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( Kt )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Kt )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"Kt equals(It)", (boolean)solvableIdeal3.equals(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"Kt equals(Jt)", (boolean)solvableIdeal3.equals(solvableIdeal2));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        SolvableIdealTest.assertTrue((String)"isGB( { e } )", (boolean)this.bb.isRightGB(this.L));
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true, SolvableIdeal.Side.twosided);
        solvableIdeal = solvableIdeal3;
        solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( Kt )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( Kt )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"equals( Kt, It )", (boolean)solvableIdeal3.equals(solvableIdeal));
    }

    public void testSolvableIdealProduct() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el - 1, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el - 1, this.q);
        this.d = this.c;
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isONE( I )", (!solvableIdeal.isONE() || this.a.isConstant() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)("isGB( I ): " + solvableIdeal.toScript()), (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.leftProduct(this.b);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"I contains(H)", (boolean)solvableIdeal.contains(solvableIdeal2));
        solvableIdeal2 = solvableIdeal.product(this.b);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal2.isGB());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        SolvableIdeal<BigRational> solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( J )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isONE( J )", (!solvableIdeal3.isONE() || this.a.isConstant() || this.b.isConstant() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)("isGB( J ): " + solvableIdeal3.toScript()), (boolean)solvableIdeal3.isGB());
        SolvableIdeal<BigRational> solvableIdeal4 = solvableIdeal.product(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal4.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal3.contains(solvableIdeal4));
        SolvableIdealTest.assertEquals((String)"H == K: ", solvableIdeal2, solvableIdeal4);
        solvableIdeal2 = solvableIdeal.intersect(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"I contains(H)", (boolean)solvableIdeal.contains(solvableIdeal2));
        SolvableIdealTest.assertTrue((String)"J contains(H)", (boolean)solvableIdeal3.contains(solvableIdeal2));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal4 = solvableIdeal.product(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal4.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal3.contains(solvableIdeal4));
        solvableIdeal2 = solvableIdeal.intersect(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"I contains(H)", (boolean)solvableIdeal.contains(solvableIdeal2));
        SolvableIdealTest.assertTrue((String)"J contains(H)", (boolean)solvableIdeal3.contains(solvableIdeal2));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( J )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal3.isGB());
        solvableIdeal4 = solvableIdeal.product(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal4.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal3.contains(solvableIdeal4));
        solvableIdeal2 = solvableIdeal.intersect(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"I contains(H)", (boolean)solvableIdeal.contains(solvableIdeal2));
        SolvableIdealTest.assertTrue((String)"J contains(H)", (boolean)solvableIdeal3.contains(solvableIdeal2));
        ArrayList arrayList = new ArrayList();
        arrayList.add(solvableIdeal4);
        arrayList.add(solvableIdeal3);
        solvableIdeal2 = solvableIdeal.intersect(arrayList);
        SolvableIdealTest.assertEquals((String)"H == K: ", solvableIdeal2, solvableIdeal4);
    }

    public void testSolvableIdealQuotient() {
        this.a = this.fac.random(this.kl, this.ll - 2, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q / 2.0f);
        this.c = this.fac.random(this.kl, this.ll, this.el - 1, this.q);
        this.d = this.c;
        this.e = this.d;
        this.L = PolynomialList.castToSolvableList(this.fac.generators());
        int n = this.L.size() - this.rl;
        if (this.a.isZERO()) {
            this.a = this.L.get(n++);
        }
        if (this.b.isZERO()) {
            this.b = this.L.get(n++);
        }
        if (this.c.isZERO()) {
            this.c = this.L.get(n++);
        }
        if (this.d.isZERO()) {
            this.d = this.L.get(n++);
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( J )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal.product(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        SolvableIdeal<BigRational> solvableIdeal4 = solvableIdeal3.quotient(solvableIdeal2.getList().get(0));
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
        solvableIdeal4 = solvableIdeal3.quotient(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( J )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        solvableIdeal3 = solvableIdeal.product(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        solvableIdeal4 = solvableIdeal3.quotient(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal3 = solvableIdeal.product(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        solvableIdeal4 = solvableIdeal3.quotient(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
    }

    public void testSolvableIdealInfiniteQuotient() {
        this.a = this.fac.random(this.kl, this.ll - 2, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.c = this.fac.random(this.kl, this.ll / 2, this.el - 1, this.q / 2.0f);
        this.d = this.c;
        this.e = this.d;
        this.L = PolynomialList.castToSolvableList(this.fac.generators());
        int n = this.L.size() - this.rl;
        if (this.a.isZERO()) {
            this.a = this.L.get(n++);
        }
        if (this.b.isZERO()) {
            this.b = this.L.get(n++);
        }
        if (this.c.isZERO()) {
            this.c = this.L.get(n++);
        }
        if (this.d.isZERO()) {
            this.d = this.L.get(n++);
            this.e = this.d;
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.infiniteQuotient(this.a);
        int n2 = solvableIdeal.infiniteQuotientExponent(this.a, solvableIdeal2);
        SolvableIdealTest.assertTrue((String)("x >= 0: " + n2), (n2 >= 0 ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)("contains(J,I): " + solvableIdeal2.toScript() + ", " + solvableIdeal.toScript()), (boolean)solvableIdeal2.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"contains(J,I)", (boolean)solvableIdeal2.contains(solvableIdeal));
        this.G = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.G.add(this.a);
        this.G = this.bb.leftGB(this.G);
        SolvableIdeal<BigRational> solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.G, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotient(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"contains(J,I)", (boolean)solvableIdeal2.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"not isZERO( e ): + e", (!this.e.isZERO() ? 1 : 0) != 0);
        this.G.add(this.e);
        this.G = this.bb.leftGB(this.G);
        solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.G, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotient(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"contains(J,I)", (boolean)solvableIdeal2.contains(solvableIdeal));
    }

    public void testSolvableIdealInfiniteQuotientRab() {
        this.fac = new GenSolvablePolynomialRing(this.fac.coFac, this.rl, this.fac.tord, this.fac.getVars());
        this.a = this.fac.random(this.kl - 1, this.ll - 1, this.el - 1, this.q / 2.0f);
        this.b = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.c = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.d = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.e = this.a;
        this.L = PolynomialList.castToSolvableList(this.fac.generators());
        int n = this.L.size() - this.rl;
        if (this.a.isZERO()) {
            this.a = this.L.get(n++);
        }
        if (this.b.isZERO()) {
            this.b = this.L.get(n++);
        }
        if (this.c.isZERO()) {
            this.c = this.L.get(n++);
        }
        if (this.d.isZERO()) {
            this.d = this.L.get(n++);
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.infiniteQuotientRab(this.a);
        SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"equals(J,JJ)", (boolean)solvableIdeal2.equals(solvableIdeal3));
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotientRab(this.a);
        SolvableIdealTest.assertTrue((String)("contains(J,I): " + solvableIdeal2 + ", " + solvableIdeal), (boolean)solvableIdeal2.contains(solvableIdeal));
        solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)("contains(J,JJ): " + solvableIdeal2 + ", " + solvableIdeal3), (boolean)solvableIdeal2.contains(solvableIdeal3));
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotientRab(this.a);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"contains(J,I)", (boolean)solvableIdeal2.contains(solvableIdeal));
        solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"contains(J,JJ)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        this.G = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.G.add(this.a);
        this.G = this.bb.leftGB(this.G);
        SolvableIdeal<BigRational> solvableIdeal4 = new SolvableIdeal<BigRational>(this.fac, this.G, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal4.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotientRab(solvableIdeal4);
        SolvableIdealTest.assertTrue((String)"contains(J,I)", (boolean)solvableIdeal2.contains(solvableIdeal));
        solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"contains(J,JJ)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        SolvableIdealTest.assertTrue((String)("not isZERO( e ): " + this.e), (!this.e.isZERO() ? 1 : 0) != 0);
        this.G.add(this.e);
        this.G = this.bb.leftGB(this.G);
        solvableIdeal4 = new SolvableIdeal<BigRational>(this.fac, this.G, true);
        SolvableIdealTest.assertTrue((String)("not isZERO( K ): " + solvableIdeal4), (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal4.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotientRab(solvableIdeal4);
        SolvableIdealTest.assertTrue((String)"contains(J,I)", (boolean)solvableIdeal2.contains(solvableIdeal));
        solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"contains(J,JJ)", (boolean)solvableIdeal2.contains(solvableIdeal3));
    }

    public void testSolvableIdealRadicalMember() {
        this.fac = new GenSolvablePolynomialRing(this.fac.coFac, this.rl, this.fac.tord, this.fac.getVars());
        this.a = this.fac.random(this.kl - 1, this.ll, this.el - 1, this.q);
        this.b = this.fac.random(this.kl - 1, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.L = PolynomialList.castToSolvableList(this.fac.generators());
        int n = this.L.size() - this.rl;
        if (this.a.isZERO()) {
            this.a = this.L.get(n++);
        }
        if (this.b.isZERO()) {
            this.b = this.L.get(n++);
        }
        if (this.c.isZERO()) {
            this.c = this.L.get(n++);
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        if (!solvableIdeal.isONE() && !this.a.equals(this.b)) {
            SolvableIdealTest.assertFalse((String)("a in radical(b): " + this.a + ", " + this.b), (boolean)solvableIdeal.isRadicalMember(this.a));
            SolvableIdealTest.assertTrue((String)("b in radical(b): " + this.a + ", " + this.b), (boolean)solvableIdeal.isRadicalMember(this.b));
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.b.multiply((BigRational)((Object)this.b)));
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        if (!solvableIdeal.isONE() && !this.a.equals(this.b)) {
            SolvableIdealTest.assertFalse((String)"a in radical(b*b)", (boolean)solvableIdeal.isRadicalMember(this.a));
            SolvableIdealTest.assertTrue((String)"b in radical(b*b)", (boolean)solvableIdeal.isRadicalMember(this.b));
        }
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        if (!solvableIdeal.isONE() && !this.a.equals(this.b)) {
            SolvableIdealTest.assertFalse((String)"a in radical(b*b,c)", (boolean)solvableIdeal.isRadicalMember(this.a));
            SolvableIdealTest.assertTrue((String)"b in radical(b*b,c)", (boolean)solvableIdeal.isRadicalMember(this.b));
        }
    }

    public void testSolvableIdealCommonZeros() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)1);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)1);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)-1);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
            SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)1);
        }
        this.L = this.fac.univariateList();
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)0);
        this.L.remove(0);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)1);
    }

    public void testSolvableIdealDimension() {
        Dimension dimension;
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"dimension( I )", (int)this.rl, (int)solvableIdeal.dimension().d);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"dimension( I )", (int)this.rl, (int)solvableIdeal.dimension().d);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"dimension( I )", (int)-1, (int)solvableIdeal.dimension().d);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
            dimension = solvableIdeal.dimension();
            SolvableIdealTest.assertTrue((String)"dimension( I )", (dimension.d >= 1 ? 1 : 0) != 0);
        }
        this.L = this.fac.univariateList();
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        dimension = solvableIdeal.dimension();
        SolvableIdealTest.assertEquals((String)"dimension( I )", (int)0, (int)dimension.d);
        while (this.L.size() > 0) {
            this.L.remove(0);
            solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
            dimension = solvableIdeal.dimension();
            SolvableIdealTest.assertEquals((String)"dimension( I )", (int)(this.rl - this.L.size()), (int)dimension.d);
        }
        this.L = this.fac.univariateList();
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        solvableIdeal = solvableIdeal.product(solvableIdeal);
        dimension = solvableIdeal.dimension();
        SolvableIdealTest.assertTrue((String)"dimension( I )", (0 >= dimension.d ? 1 : 0) != 0);
        this.L = solvableIdeal.getList();
        while (this.L.size() > 0) {
            this.L.remove(0);
            solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
            dimension = solvableIdeal.dimension();
            SolvableIdealTest.assertTrue((String)"dimension( I )", (dimension.d > 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testElimSolvableIdeal() {
        int n;
        BigRational bigRational = new BigRational(17L, 1L);
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.fac = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        WeylRelationsIterated<BigRational> weylRelationsIterated = new WeylRelationsIterated<BigRational>();
        weylRelationsIterated.generate(this.fac);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.univariate(0, 3L);
        this.b = this.fac.univariate(1, 2L);
        this.c = this.fac.univariate(0, 1L);
        this.L.add(this.a);
        this.L.add(this.c);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L);
        solvableIdeal.doGB();
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 2; n <= stringArray.length; n += 2) {
            KsubSet ksubSet = new KsubSet(arrayList, n);
            for (List list : ksubSet) {
                void var15_23;
                Object object;
                Object object2;
                int n2 = Collections.indexOfSubList(arrayList, list);
                if (n2 < 0 || n2 % 2 != 0) continue;
                ArrayList arrayList2 = new ArrayList(stringArray.length);
                SolvableIdeal solvableIdeal2 = null;
                if (n2 != 0) {
                    void var15_19;
                    arrayList2.addAll(list);
                    for (String i : arrayList) {
                        if (arrayList2.contains(i)) continue;
                        arrayList2.add(i);
                    }
                    object2 = new String[arrayList2.size()];
                    boolean bl = false;
                    while (var15_19 < arrayList2.size()) {
                        object2[var15_19] = (String)arrayList2.get((int)var15_19);
                        ++var15_19;
                    }
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>(arrayList.size());
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        int n3 = arrayList.indexOf(object2[i]);
                        arrayList3.add(n3);
                    }
                    object = (GenSolvablePolynomialRing)this.fac.permutation(arrayList3);
                    List list2 = TermOrderOptimization.permutation(arrayList3, object, solvableIdeal.list.castToSolvableList());
                    solvableIdeal2 = new SolvableIdeal(object, list2);
                }
                object2 = new String[list.size()];
                boolean bl = false;
                while (var15_23 < list.size()) {
                    object2[var15_23] = (String)list.get((int)var15_23);
                    ++var15_23;
                }
                GenSolvablePolynomialRing object32 = new GenSolvablePolynomialRing(this.fac.coFac, ((Object)object2).length, this.fac.tord, (String[])object2);
                object = new WeylRelationsIterated();
                object.generate(object32);
                SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal2 == null ? solvableIdeal.eliminate(object32) : solvableIdeal2.eliminate(object32);
                SolvableIdealTest.assertTrue((String)("isGB( J ): " + solvableIdeal3.toScript()), (boolean)solvableIdeal3.isGB());
                SolvableIdealTest.assertTrue((String)"size( J ) <=  |ev|", (solvableIdeal3.getList().size() <= list.size() ? 1 : 0) != 0);
            }
        }
    }

    public void testUnivPoly() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.fac = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        SolvableIdealTest.assertTrue((String)"vars.length == 4 ", (stringArray.length == 4 ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 + 34/55 x^2 + 1/9 x + 99 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^3 - x y )");
        this.d = this.fac.parse("( w^2 + 3 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        this.L.add(this.d);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        for (int i = 0; i < this.rl; ++i) {
            GenSolvablePolynomial<BigRational> genSolvablePolynomial = solvableIdeal.constructUnivariate(this.rl - 1 - i);
            GenPolynomial genPolynomial = this.fac.parse(genSolvablePolynomial.toString());
            SolvableIdealTest.assertTrue((String)"I.contains(U) ", (boolean)solvableIdeal.contains((GenSolvablePolynomial<BigRational>)genPolynomial));
        }
        List<GenSolvablePolynomial<BigRational>> list = solvableIdeal.constructUnivariate();
        for (GenSolvablePolynomial genSolvablePolynomial : list) {
            GenPolynomial genPolynomial = this.fac.parse(genSolvablePolynomial.toString());
            SolvableIdealTest.assertTrue((String)"I.contains(U) ", (boolean)solvableIdeal.contains((GenSolvablePolynomial<BigRational>)genPolynomial));
        }
    }

    public void testAnnihilator() {
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.a.isConstant());
        this.b = this.fac.univariate(1);
        this.c = this.fac.univariate(this.rl - 1);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.annihilator(this.c);
        solvableIdeal2.doGB();
        SolvableIdealTest.assertTrue((String)"isAnnihilator(c,J)", (boolean)solvableIdeal.isAnnihilator(this.c, solvableIdeal2));
        this.d = this.fac.univariate(this.rl - 2);
        this.M = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.M.add(this.c);
        this.M.add(this.d);
        SolvableIdeal<BigRational> solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.M);
        solvableIdeal2 = solvableIdeal.annihilator(solvableIdeal3);
        solvableIdeal2.doGB();
        SolvableIdealTest.assertTrue((String)"isAnnihilator(M,J)", (boolean)solvableIdeal.isAnnihilator(solvableIdeal3, solvableIdeal2));
    }
}

