/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class BigDecimal
implements GcdRingElem<BigDecimal>,
RingFactory<BigDecimal>,
Rational {
    public final java.math.BigDecimal val;
    public final MathContext context;
    public static final MathContext DEFAULT_CONTEXT = MathContext.DECIMAL64;
    public static final int DEFAULT_PRECISION = DEFAULT_CONTEXT.getPrecision();
    private static final Random random = new Random();
    public static final boolean EXACT_EQUAL = true;
    public static final BigDecimal ZERO = new BigDecimal(java.math.BigDecimal.ZERO);
    public static final BigDecimal ONE = new BigDecimal(java.math.BigDecimal.ONE);

    public BigDecimal(java.math.BigDecimal bigDecimal) {
        this(bigDecimal, DEFAULT_CONTEXT);
    }

    public BigDecimal(java.math.BigDecimal bigDecimal, MathContext mathContext) {
        this.val = bigDecimal;
        this.context = mathContext;
    }

    public BigDecimal(long l) {
        this(l, DEFAULT_CONTEXT);
    }

    public BigDecimal(long l, MathContext mathContext) {
        this(new java.math.BigDecimal(String.valueOf(l)), mathContext);
    }

    public BigDecimal(double d) {
        this(d, DEFAULT_CONTEXT);
    }

    public BigDecimal(double d, MathContext mathContext) {
        this(new java.math.BigDecimal(d, mathContext), mathContext);
    }

    public BigDecimal(java.math.BigInteger bigInteger) {
        this(bigInteger, DEFAULT_CONTEXT);
    }

    public BigDecimal(java.math.BigInteger bigInteger, MathContext mathContext) {
        this(new java.math.BigDecimal(bigInteger), mathContext);
    }

    public BigDecimal(BigRational bigRational) {
        this(bigRational, DEFAULT_CONTEXT);
    }

    public BigDecimal(BigRational bigRational, MathContext mathContext) {
        this(new java.math.BigDecimal(bigRational.num, mathContext).divide(new java.math.BigDecimal(bigRational.den, mathContext), mathContext), mathContext);
    }

    public BigDecimal(String string) {
        this(string, DEFAULT_CONTEXT);
    }

    public BigDecimal(String string, MathContext mathContext) {
        this(new java.math.BigDecimal(string.trim()), mathContext);
    }

    public BigDecimal() {
        this(java.math.BigDecimal.ZERO, DEFAULT_CONTEXT);
    }

    public BigDecimal factory() {
        return this;
    }

    @Override
    public List<BigDecimal> generators() {
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>(1);
        arrayList.add(this.getONE());
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigDecimal copy() {
        return new BigDecimal(this.val, this.context);
    }

    @Override
    public BigDecimal copy(BigDecimal bigDecimal) {
        return new BigDecimal(bigDecimal.val, bigDecimal.context);
    }

    @Override
    public BigDecimal getZERO() {
        return ZERO;
    }

    @Override
    public BigDecimal getONE() {
        return ONE;
    }

    public BigDecimal getDecimal() {
        return this;
    }

    @Override
    public BigRational getRational() {
        return new BigRational(this.toString());
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return java.math.BigInteger.ZERO;
    }

    @Override
    public BigDecimal fromInteger(java.math.BigInteger bigInteger) {
        return new BigDecimal(new java.math.BigDecimal(bigInteger), this.context);
    }

    public static BigDecimal valueOf(java.math.BigDecimal bigDecimal) {
        return new BigDecimal(bigDecimal, DEFAULT_CONTEXT);
    }

    @Override
    public BigDecimal fromInteger(long l) {
        return new BigDecimal(l, this.context);
    }

    public static BigDecimal valueOf(long l) {
        return new BigDecimal(l, DEFAULT_CONTEXT);
    }

    @Override
    public boolean isZERO() {
        return this.val.compareTo(java.math.BigDecimal.ZERO) == 0;
    }

    @Override
    public boolean isONE() {
        return this.val.compareTo(java.math.BigDecimal.ONE) == 0;
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    public String toString() {
        return this.val.toString();
    }

    public double doubleValue() {
        return this.val.doubleValue();
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        return "DD()";
    }

    @Override
    public int compareTo(BigDecimal bigDecimal) {
        return this.val.compareTo(bigDecimal.val);
    }

    public int compareToAbsolute(BigDecimal bigDecimal) {
        java.math.BigDecimal bigDecimal2 = this.val.subtract(bigDecimal.val, this.context);
        java.math.BigDecimal bigDecimal3 = this.val.ulp();
        java.math.BigDecimal bigDecimal4 = bigDecimal.val.ulp();
        int n = Math.min(bigDecimal3.scale(), bigDecimal4.scale());
        java.math.BigDecimal bigDecimal5 = n <= 0 ? bigDecimal3.max(bigDecimal4) : bigDecimal3.min(bigDecimal4);
        int n2 = bigDecimal2.abs().compareTo(bigDecimal5);
        if (n2 < 1) {
            return 0;
        }
        return bigDecimal2.signum();
    }

    public int compareToRelative(BigDecimal bigDecimal) {
        java.math.BigDecimal bigDecimal2 = this.val.subtract(bigDecimal.val, this.context);
        java.math.BigDecimal bigDecimal3 = this.val.ulp();
        java.math.BigDecimal bigDecimal4 = bigDecimal.val.ulp();
        int n = Math.min(bigDecimal3.scale(), bigDecimal4.scale());
        java.math.BigDecimal bigDecimal5 = n <= 0 ? bigDecimal3.max(bigDecimal4) : bigDecimal3.min(bigDecimal4);
        bigDecimal5 = bigDecimal5.movePointRight(1);
        java.math.BigDecimal bigDecimal6 = this.val.abs().max(bigDecimal.val.abs());
        int n2 = bigDecimal6.compareTo(java.math.BigDecimal.ONE) <= 1 ? bigDecimal2.abs().compareTo(bigDecimal5) : bigDecimal2.abs().divide(bigDecimal6, this.context).compareTo(bigDecimal5);
        if (n2 < 1) {
            return 0;
        }
        return bigDecimal2.signum();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        return this.val.equals(bigDecimal.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public BigDecimal abs() {
        return new BigDecimal(this.val.abs(), this.context);
    }

    @Override
    public BigDecimal negate() {
        return new BigDecimal(this.val.negate(), this.context);
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public BigDecimal subtract(BigDecimal bigDecimal) {
        return new BigDecimal(this.val.subtract(bigDecimal.val, this.context), this.context);
    }

    @Override
    public BigDecimal divide(BigDecimal bigDecimal) {
        return new BigDecimal(this.val.divide(bigDecimal.val, this.context), this.context);
    }

    @Override
    public BigDecimal inverse() {
        return ONE.divide(this);
    }

    @Override
    public BigDecimal remainder(BigDecimal bigDecimal) {
        return new BigDecimal(this.val.remainder(bigDecimal.val, this.context), this.context);
    }

    public BigDecimal[] quotientRemainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = new BigDecimal[2];
        java.math.BigDecimal[] bigDecimalArray2 = this.val.divideAndRemainder(bigDecimal.val, this.context);
        bigDecimalArray[0] = new BigDecimal(bigDecimalArray2[0], this.context);
        bigDecimalArray[1] = new BigDecimal(bigDecimalArray2[1], this.context);
        return bigDecimalArray;
    }

    @Override
    public BigDecimal gcd(BigDecimal bigDecimal) {
        throw new UnsupportedOperationException("BigDecimal.gcd() not implemented");
    }

    public BigDecimal[] egcd(BigDecimal bigDecimal) {
        throw new UnsupportedOperationException("BigDecimal.egcd() not implemented");
    }

    @Override
    public BigDecimal random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigDecimal random(int n, Random random) {
        return this.random(n, 10, random);
    }

    public BigDecimal random(int n, int n2) {
        return this.random(n, n2, random);
    }

    public BigDecimal random(int n, int n2, Random random) {
        java.math.BigInteger bigInteger = new java.math.BigInteger(n, random);
        if (random.nextBoolean()) {
            bigInteger = bigInteger.negate();
        }
        int n3 = random.nextInt(n2);
        java.math.BigDecimal bigDecimal = new java.math.BigDecimal(bigInteger, n3, this.context);
        return new BigDecimal(bigDecimal, this.context);
    }

    @Override
    public BigDecimal multiply(BigDecimal bigDecimal) {
        return new BigDecimal(this.val.multiply(bigDecimal.val, this.context), this.context);
    }

    @Override
    public BigDecimal sum(BigDecimal bigDecimal) {
        return new BigDecimal(this.val.add(bigDecimal.val, this.context), this.context);
    }

    @Override
    public BigDecimal parse(String string) {
        int n = string.indexOf("/");
        if (n < 0) {
            return new BigDecimal(string, this.context);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        BigDecimal bigDecimal = new BigDecimal(string2, this.context);
        BigDecimal bigDecimal2 = new BigDecimal(string3, this.context);
        return bigDecimal.divide(bigDecimal2);
    }

    @Override
    public BigDecimal parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    public long bitLength() {
        long l = this.val.unscaledValue().bitLength();
        if (this.val.signum() < 0) {
            ++l;
        }
        ++l;
        return l += BigInteger.bitLength(this.val.scale());
    }
}

