/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigQuaternionInteger;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import edu.jas.arith.Roots;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.StarRingElem;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BigQuaternion
implements StarRingElem<BigQuaternion>,
GcdRingElem<BigQuaternion> {
    public final BigRational re;
    public final BigRational im;
    public final BigRational jm;
    public final BigRational km;
    public final BigQuaternionRing ring;
    protected static final Random random = new Random();
    private static final Logger logger = LogManager.getLogger(BigQuaternion.class);
    private static final boolean debug = logger.isDebugEnabled();

    public BigQuaternion(BigQuaternionRing bigQuaternionRing, BigRational bigRational, BigRational bigRational2, BigRational bigRational3, BigRational bigRational4) {
        this.ring = bigQuaternionRing;
        this.re = bigRational;
        this.im = bigRational2;
        this.jm = bigRational3;
        this.km = bigRational4;
    }

    public BigQuaternion(BigQuaternionRing bigQuaternionRing, BigRational bigRational, BigRational bigRational2, BigRational bigRational3) {
        this(bigQuaternionRing, bigRational, bigRational2, bigRational3, BigRational.ZERO);
    }

    public BigQuaternion(BigQuaternionRing bigQuaternionRing, BigRational bigRational, BigRational bigRational2) {
        this(bigQuaternionRing, bigRational, bigRational2, BigRational.ZERO);
    }

    public BigQuaternion(BigQuaternionRing bigQuaternionRing, BigRational bigRational) {
        this(bigQuaternionRing, bigRational, BigRational.ZERO);
    }

    public BigQuaternion(BigQuaternionRing bigQuaternionRing, BigComplex bigComplex) {
        this(bigQuaternionRing, bigComplex.re, bigComplex.im);
    }

    public BigQuaternion(BigQuaternionRing bigQuaternionRing, long l) {
        this(bigQuaternionRing, new BigRational(l), BigRational.ZERO);
    }

    public BigQuaternion(BigQuaternionRing bigQuaternionRing) {
        this(bigQuaternionRing, BigRational.ZERO);
    }

    public BigQuaternion(BigQuaternionRing bigQuaternionRing, String string) throws NumberFormatException {
        int n;
        int n2;
        this.ring = bigQuaternionRing;
        if (string == null || string.length() == 0) {
            this.re = BigRational.ZERO;
            this.im = BigRational.ZERO;
            this.jm = BigRational.ZERO;
            this.km = BigRational.ZERO;
            return;
        }
        int n3 = (string = string.trim()).indexOf("i") + string.indexOf("j") + string.indexOf("k");
        if (n3 == -3) {
            this.re = new BigRational(string);
            this.im = BigRational.ZERO;
            this.jm = BigRational.ZERO;
            this.km = BigRational.ZERO;
            return;
        }
        string = string.replaceAll("~", "-");
        int n4 = string.indexOf("i");
        String string2 = "";
        if (n4 > 0) {
            string2 = string.substring(0, n4);
        } else if (n4 < 0) {
            throw new NumberFormatException("BigQuaternion missing i: " + string);
        }
        String string3 = "";
        if (n4 < string.length()) {
            string = string.substring(n4 + 1, string.length());
        }
        if ((n2 = string.indexOf("j")) > 0) {
            string3 = string.substring(0, n2);
        } else if (n2 < 0) {
            throw new NumberFormatException("BigQuaternion missing j: " + string);
        }
        String string4 = "";
        if (n2 < string.length()) {
            string = string.substring(n2 + 1, string.length());
        }
        if ((n = string.indexOf("k")) > 0) {
            string4 = string.substring(0, n);
        } else if (n < 0) {
            throw new NumberFormatException("BigQuaternion missing k: " + string);
        }
        String string5 = "";
        if (n < string.length()) {
            string = string.substring(n + 1, string.length());
        }
        string5 = string;
        this.re = new BigRational(string2.trim());
        this.im = new BigRational(string3.trim());
        this.jm = new BigRational(string4.trim());
        this.km = new BigRational(string5.trim());
    }

    public BigQuaternionRing factory() {
        return this.ring;
    }

    @Override
    public BigQuaternion copy() {
        return new BigQuaternion(this.ring, this.re, this.im, this.jm, this.km);
    }

    public BigRational getRe() {
        return this.re;
    }

    public BigRational getIm() {
        return this.im;
    }

    public BigRational getJm() {
        return this.jm;
    }

    public BigRational getKm() {
        return this.km;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.re.compareTo(BigRational.ZERO);
        if (n != 0) {
            stringBuffer.append(this.re.toString());
        }
        int n2 = this.im.compareTo(BigRational.ZERO);
        int n3 = this.jm.compareTo(BigRational.ZERO);
        int n4 = this.km.compareTo(BigRational.ZERO);
        if (debug) {
            logger.debug("compareTo {} ? 0 = {}", (Object)this.im, (Object)n2);
            logger.debug("compareTo {} ? 0 = {}", (Object)this.jm, (Object)n3);
            logger.debug("compareTo {} ? 0 = {}", (Object)this.km, (Object)n4);
        }
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            if (n == 0) {
                stringBuffer.append(this.re.toString());
            }
            return stringBuffer.toString();
        }
        if (n2 != 0) {
            stringBuffer.append("i" + this.im);
        }
        if (n3 != 0) {
            stringBuffer.append("j" + this.jm);
        }
        if (n4 != 0) {
            stringBuffer.append("k" + this.km);
        }
        String string = stringBuffer.toString();
        return string;
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.im.isZERO();
        boolean bl2 = this.jm.isZERO();
        boolean bl3 = this.km.isZERO();
        if (bl && bl2 && bl3) {
            if (this.re.isZERO()) {
                return "0 ";
            }
            if (!this.re.isONE()) {
                stringBuffer.append(this.re.toScript() + "*");
            }
            stringBuffer.append("oneQ ");
            return stringBuffer.toString();
        }
        if (!this.re.isZERO()) {
            if (!this.re.isONE()) {
                stringBuffer.append(this.re.toScript() + "*");
            }
            stringBuffer.append("oneQ ");
        }
        if (!bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+ ");
            }
            if (!this.im.isONE()) {
                stringBuffer.append(this.im.toScript() + "*");
            }
            stringBuffer.append("IQ ");
        }
        if (!bl2) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+ ");
            }
            if (!this.jm.isONE()) {
                stringBuffer.append(this.jm.toScript() + "*");
            }
            stringBuffer.append("JQ ");
        }
        if (!bl3) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+ ");
            }
            if (!this.km.isONE()) {
                stringBuffer.append(this.km.toScript() + "*");
            }
            stringBuffer.append("KQ ");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return this.ring.toScript();
    }

    public static boolean isQZERO(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return false;
        }
        return bigQuaternion.isZERO();
    }

    @Override
    public boolean isZERO() {
        return this.re.isZERO() && this.im.isZERO() && this.jm.isZERO() && this.km.isZERO();
    }

    public static boolean isQONE(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return false;
        }
        return bigQuaternion.isONE();
    }

    @Override
    public boolean isONE() {
        return this.re.isONE() && this.im.isZERO() && this.jm.isZERO() && this.km.isZERO();
    }

    public boolean isIMAG() {
        return this.re.isZERO() && this.im.isONE() && this.jm.isZERO() && this.km.isZERO();
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    public boolean isEntier() {
        if (this.re.isEntier() && this.im.isEntier() && this.jm.isEntier() && this.km.isEntier()) {
            return true;
        }
        java.math.BigInteger bigInteger = BigInteger.TWO.val;
        return this.re.den.equals(bigInteger) && this.im.den.equals(bigInteger) && this.jm.den.equals(bigInteger) && this.km.den.equals(bigInteger);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BigQuaternion)) {
            return false;
        }
        BigQuaternion bigQuaternion = (BigQuaternion)object;
        return this.re.equals(bigQuaternion.re) && this.im.equals(bigQuaternion.im) && this.jm.equals(bigQuaternion.jm) && this.km.equals(bigQuaternion.km);
    }

    @Override
    public int hashCode() {
        int n = this.re.hashCode();
        n += n * 37 + this.im.hashCode();
        n += n * 37 + this.jm.hashCode();
        n += n * 37 + this.km.hashCode();
        return n;
    }

    @Override
    public int compareTo(BigQuaternion bigQuaternion) {
        int n = this.re.compareTo(bigQuaternion.re);
        if (n != 0) {
            return n;
        }
        n = this.im.compareTo(bigQuaternion.im);
        if (n != 0) {
            return n;
        }
        n = this.jm.compareTo(bigQuaternion.jm);
        if (n != 0) {
            return n;
        }
        return this.km.compareTo(bigQuaternion.km);
    }

    @Override
    public int signum() {
        int n = this.re.signum();
        if (n != 0) {
            return n;
        }
        n = this.im.signum();
        if (n != 0) {
            return n;
        }
        n = this.jm.signum();
        if (n != 0) {
            return n;
        }
        return this.km.signum();
    }

    @Override
    public BigQuaternion sum(BigQuaternion bigQuaternion) {
        return new BigQuaternion(this.ring, this.re.sum(bigQuaternion.re), this.im.sum(bigQuaternion.im), this.jm.sum(bigQuaternion.jm), this.km.sum(bigQuaternion.km));
    }

    public static BigQuaternion QSUM(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.sum(bigQuaternion2);
    }

    public static BigQuaternion QDIF(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.subtract(bigQuaternion2);
    }

    @Override
    public BigQuaternion subtract(BigQuaternion bigQuaternion) {
        return new BigQuaternion(this.ring, this.re.subtract(bigQuaternion.re), this.im.subtract(bigQuaternion.im), this.jm.subtract(bigQuaternion.jm), this.km.subtract(bigQuaternion.km));
    }

    public static BigQuaternion QNEG(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.negate();
    }

    @Override
    public BigQuaternion negate() {
        return new BigQuaternion(this.ring, this.re.negate(), this.im.negate(), this.jm.negate(), this.km.negate());
    }

    public static BigQuaternion QCON(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.conjugate();
    }

    @Override
    public BigQuaternion conjugate() {
        return new BigQuaternion(this.ring, this.re, this.im.negate(), this.jm.negate(), this.km.negate());
    }

    @Override
    public BigQuaternion norm() {
        BigRational bigRational = this.re.multiply(this.re);
        bigRational = bigRational.sum(this.im.multiply(this.im));
        bigRational = bigRational.sum(this.jm.multiply(this.jm));
        bigRational = bigRational.sum(this.km.multiply(this.km));
        return new BigQuaternion(this.ring, bigRational);
    }

    @Override
    public BigQuaternion abs() {
        BigQuaternion bigQuaternion = this.norm();
        BigRational bigRational = Roots.sqrt(bigQuaternion.re);
        return new BigQuaternion(this.ring, bigRational);
    }

    public static BigRational QABS(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.abs().re;
    }

    public static BigQuaternion QPROD(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.multiply(bigQuaternion2);
    }

    @Override
    public BigQuaternion multiply(BigRational bigRational) {
        BigRational bigRational2 = this.re.multiply(bigRational);
        BigRational bigRational3 = this.im.multiply(bigRational);
        BigRational bigRational4 = this.jm.multiply(bigRational);
        BigRational bigRational5 = this.km.multiply(bigRational);
        return new BigQuaternion(this.ring, bigRational2, bigRational3, bigRational4, bigRational5);
    }

    @Override
    public BigQuaternion multiply(BigQuaternion bigQuaternion) {
        BigRational bigRational = this.re.multiply(bigQuaternion.re);
        bigRational = bigRational.subtract(this.im.multiply(bigQuaternion.im));
        bigRational = bigRational.subtract(this.jm.multiply(bigQuaternion.jm));
        bigRational = bigRational.subtract(this.km.multiply(bigQuaternion.km));
        BigRational bigRational2 = this.re.multiply(bigQuaternion.im);
        bigRational2 = bigRational2.sum(this.im.multiply(bigQuaternion.re));
        bigRational2 = bigRational2.sum(this.jm.multiply(bigQuaternion.km));
        bigRational2 = bigRational2.subtract(this.km.multiply(bigQuaternion.jm));
        BigRational bigRational3 = this.re.multiply(bigQuaternion.jm);
        bigRational3 = bigRational3.subtract(this.im.multiply(bigQuaternion.km));
        bigRational3 = bigRational3.sum(this.jm.multiply(bigQuaternion.re));
        bigRational3 = bigRational3.sum(this.km.multiply(bigQuaternion.im));
        BigRational bigRational4 = this.re.multiply(bigQuaternion.km);
        bigRational4 = bigRational4.sum(this.im.multiply(bigQuaternion.jm));
        bigRational4 = bigRational4.subtract(this.jm.multiply(bigQuaternion.im));
        bigRational4 = bigRational4.sum(this.km.multiply(bigQuaternion.re));
        return new BigQuaternion(this.ring, bigRational, bigRational2, bigRational3, bigRational4);
    }

    public BigQuaternion multiplyLeft(BigQuaternion bigQuaternion) {
        return bigQuaternion.multiply(this);
    }

    public static BigQuaternion QINV(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.inverse();
    }

    @Override
    public BigQuaternion inverse() {
        BigRational bigRational = this.norm().re.inverse();
        return new BigQuaternion(this.ring, this.re.multiply(bigRational), this.im.negate().multiply(bigRational), this.jm.negate().multiply(bigRational), this.km.negate().multiply(bigRational));
    }

    @Override
    public BigQuaternion remainder(BigQuaternion bigQuaternion) {
        if (bigQuaternion.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (this.ring.integral) {
            BigQuaternionInteger bigQuaternionInteger = new BigQuaternionInteger(this.ring, this);
            BigQuaternionInteger bigQuaternionInteger2 = new BigQuaternionInteger(this.ring, bigQuaternion);
            return bigQuaternionInteger.rightRemainder(bigQuaternionInteger2);
        }
        return this.ring.getZERO();
    }

    public static BigQuaternion QQ(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        if (bigQuaternion == null) {
            return null;
        }
        return bigQuaternion.divide(bigQuaternion2);
    }

    @Override
    public BigQuaternion divide(BigQuaternion bigQuaternion) {
        return this.rightDivide(bigQuaternion);
    }

    @Override
    public BigQuaternion rightDivide(BigQuaternion bigQuaternion) {
        if (this.ring.integral) {
            BigQuaternionInteger bigQuaternionInteger = new BigQuaternionInteger(this.ring, this);
            BigQuaternionInteger bigQuaternionInteger2 = new BigQuaternionInteger(this.ring, bigQuaternion);
            return bigQuaternionInteger.rightDivide(bigQuaternionInteger2);
        }
        return this.multiply(bigQuaternion.inverse());
    }

    @Override
    public BigQuaternion leftDivide(BigQuaternion bigQuaternion) {
        if (this.ring.integral) {
            BigQuaternionInteger bigQuaternionInteger = new BigQuaternionInteger(this.ring, this);
            BigQuaternionInteger bigQuaternionInteger2 = new BigQuaternionInteger(this.ring, bigQuaternion);
            return bigQuaternionInteger.leftDivide(bigQuaternionInteger2);
        }
        return bigQuaternion.inverse().multiply(this);
    }

    @Override
    public BigQuaternion divide(BigRational bigRational) {
        BigRational bigRational2 = bigRational.inverse();
        return new BigQuaternion(this.ring, this.re.multiply(bigRational2), this.im.multiply(bigRational2), this.jm.multiply(bigRational2), this.km.multiply(bigRational2));
    }

    public BigQuaternion[] quotientRemainder(BigQuaternion bigQuaternion) {
        if (this.ring.integral) {
            BigQuaternionInteger bigQuaternionInteger = new BigQuaternionInteger(this.ring, this);
            BigQuaternionInteger bigQuaternionInteger2 = new BigQuaternionInteger(this.ring, bigQuaternion);
            return bigQuaternionInteger.rightQuotientAndRemainder(bigQuaternionInteger2);
        }
        return new BigQuaternion[]{this.divide(bigQuaternion), this.ring.getZERO()};
    }

    @Override
    public BigQuaternion gcd(BigQuaternion bigQuaternion) {
        return this.leftGcd(bigQuaternion);
    }

    @Override
    public BigQuaternion leftGcd(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null || bigQuaternion.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return bigQuaternion;
        }
        if (this.ring.integral) {
            BigQuaternionInteger bigQuaternionInteger = new BigQuaternionInteger(this.ring, this);
            BigQuaternionInteger bigQuaternionInteger2 = new BigQuaternionInteger(this.ring, bigQuaternion);
            return bigQuaternionInteger.leftGcd(bigQuaternionInteger2);
        }
        return this.ring.getONE();
    }

    @Override
    public BigQuaternion rightGcd(BigQuaternion bigQuaternion) {
        if (bigQuaternion == null || bigQuaternion.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return bigQuaternion;
        }
        if (this.ring.integral) {
            BigQuaternionInteger bigQuaternionInteger = new BigQuaternionInteger(this.ring, this);
            BigQuaternionInteger bigQuaternionInteger2 = new BigQuaternionInteger(this.ring, bigQuaternion);
            return bigQuaternionInteger.rightGcd(bigQuaternionInteger2);
        }
        return this.ring.getONE();
    }

    public BigQuaternion[] egcd(BigQuaternion bigQuaternion) {
        if (this.ring.integral) {
            System.out.println("*** entier egcd case not implemented ***");
        }
        BigQuaternion[] bigQuaternionArray = new BigQuaternion[]{null, null, null};
        if (bigQuaternion == null || bigQuaternion.isZERO()) {
            bigQuaternionArray[0] = this;
            return bigQuaternionArray;
        }
        if (this.isZERO()) {
            bigQuaternionArray[0] = bigQuaternion;
            return bigQuaternionArray;
        }
        BigQuaternion bigQuaternion2 = new BigQuaternion(this.ring, new BigRational(1L, 2L));
        bigQuaternionArray[0] = this.ring.getONE();
        bigQuaternionArray[1] = this.inverse().multiply(bigQuaternion2);
        bigQuaternionArray[2] = bigQuaternion.inverse().multiply(bigQuaternion2);
        return bigQuaternionArray;
    }

    public long bitLength() {
        return this.re.bitLength() + this.im.bitLength() + this.jm.bitLength() + this.km.bitLength();
    }

    public BigQuaternion ceil() {
        BigRational bigRational = new BigRational(this.re.ceil());
        BigRational bigRational2 = new BigRational(this.im.ceil());
        BigRational bigRational3 = new BigRational(this.jm.ceil());
        BigRational bigRational4 = new BigRational(this.km.ceil());
        return new BigQuaternion(this.ring, bigRational, bigRational2, bigRational3, bigRational4);
    }

    public BigQuaternion floor() {
        BigRational bigRational = new BigRational(this.re.floor());
        BigRational bigRational2 = new BigRational(this.im.floor());
        BigRational bigRational3 = new BigRational(this.jm.floor());
        BigRational bigRational4 = new BigRational(this.km.floor());
        return new BigQuaternion(this.ring, bigRational, bigRational2, bigRational3, bigRational4);
    }

    public BigQuaternionInteger roundToLipschitzian() {
        BigRational bigRational = BigRational.HALF;
        BigRational bigRational2 = new BigRational(this.re.sum(bigRational).floor());
        BigRational bigRational3 = new BigRational(this.im.sum(bigRational).floor());
        BigRational bigRational4 = new BigRational(this.jm.sum(bigRational).floor());
        BigRational bigRational5 = new BigRational(this.km.sum(bigRational).floor());
        return new BigQuaternionInteger(this.ring, bigRational2, bigRational3, bigRational4, bigRational5);
    }

    public BigQuaternionInteger roundToHurwitzian() {
        if (this.isEntier()) {
            return new BigQuaternionInteger(this.ring, this);
        }
        BigQuaternionInteger bigQuaternionInteger = this.roundToLipschitzian();
        BigQuaternion bigQuaternion = this.ring.getZERO();
        BigQuaternion bigQuaternion2 = this.subtract(bigQuaternionInteger).norm();
        List<BigQuaternion> list = this.ring.unitsOfHurwitzian();
        BigQuaternion bigQuaternion3 = null;
        for (BigQuaternion bigQuaternion4 : list) {
            bigQuaternion3 = this.subtract(bigQuaternionInteger.sum(bigQuaternion4)).norm();
            if (bigQuaternion3.re.compareTo(bigQuaternion2.re) >= 0) continue;
            bigQuaternion2 = bigQuaternion3;
            bigQuaternion = bigQuaternion4;
        }
        bigQuaternionInteger = new BigQuaternionInteger(this.ring, bigQuaternionInteger.sum(bigQuaternion));
        return bigQuaternionInteger;
    }
}

