/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.fd.FDUtil;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelationsIterated;
import edu.jas.structure.RingElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FDUtilQuatTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    BigQuaternionRing cfi;
    BigQuaternionRing cfr;
    GenSolvablePolynomialRing<BigQuaternion> dfac;
    GenSolvablePolynomialRing<BigQuaternion> rdfac;
    GenSolvablePolynomialRing<GenPolynomial<BigQuaternion>> rfac;
    GenSolvablePolynomialRing<GenPolynomial<BigQuaternion>> rrfac;
    RecSolvablePolynomialRing<BigQuaternion> rsfac;
    GenSolvablePolynomial<BigQuaternion> a;
    GenSolvablePolynomial<BigQuaternion> b;
    GenSolvablePolynomial<BigQuaternion> c;
    GenSolvablePolynomial<BigQuaternion> d;
    GenSolvablePolynomial<BigQuaternion> e;
    GenSolvablePolynomial<BigQuaternion> f;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> ar;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> br;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> cr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> dr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> er;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> fr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> arr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> brr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> abrr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> barr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> crr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> drr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> err;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> frr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> x1;
    RecSolvablePolynomial<BigQuaternion> as;
    RecSolvablePolynomial<BigQuaternion> bs;
    RecSolvablePolynomial<BigQuaternion> cs;
    RecSolvablePolynomial<BigQuaternion> ds;
    RecSolvablePolynomial<BigQuaternion> es;
    RecSolvablePolynomial<BigQuaternion> fs;
    int rl = 4;
    int kl = 2;
    int ll = 4;
    int el = 3;
    float q = 0.35f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FDUtilQuatTest.suite());
        ComputerThreads.terminate();
    }

    public FDUtilQuatTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FDUtilQuatTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.rl = stringArray.length;
        this.cfi = new BigQuaternionRing(true);
        this.cfr = new BigQuaternionRing();
        this.dfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfi, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = this.dfac.recursive(1);
        this.rdfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfr, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated2 = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated2);
        this.rrfac = this.rdfac.recursive(1);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.rfac = null;
    }

    public void testBasePseudoDivisionExact() {
        do {
            this.a = ((GenSolvablePolynomial)this.dfac.random(this.kl, this.ll + 1, this.el, this.q)).monic();
        } while (this.a.isZERO());
        do {
            this.b = ((GenSolvablePolynomial)this.dfac.random(this.kl, this.ll + 1, this.el, this.q)).monic();
        } while (this.b.isZERO());
        this.c = this.b.multiply((BigQuaternion)((Object)this.a));
        this.d = this.a.multiply((BigQuaternion)((Object)this.b));
        FDUtilQuatTest.assertTrue((String)"c != 0: ", (!this.c.isZERO() ? 1 : 0) != 0);
        FDUtilQuatTest.assertTrue((String)"d != 0: ", (!this.d.isZERO() ? 1 : 0) != 0);
        FDUtilQuatTest.assertTrue((String)"a*b != b*a", (!this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.e = FDUtil.leftBasePseudoQuotient(this.c, this.a);
        FDUtilQuatTest.assertEquals((String)"b == b*a/a: ", this.b, this.e);
        this.f = FDUtil.rightBasePseudoQuotient(this.c, this.b);
        FDUtilQuatTest.assertEquals((String)"a == b*a/b: ", this.a, this.f);
        this.e = FDUtil.rightBasePseudoQuotient(this.d, this.a);
        FDUtilQuatTest.assertEquals((String)"b == a*b/a: ", this.b, this.e);
        this.f = FDUtil.leftBasePseudoQuotient(this.d, this.b);
        FDUtilQuatTest.assertEquals((String)"a == a*b/b: ", this.a, this.f);
    }

    public void testBasePseudoQuotientRemainderExact() {
        do {
            this.a = ((GenSolvablePolynomial)this.dfac.random(this.kl, this.ll + 1, this.el, this.q)).monic();
        } while (this.a.isZERO());
        do {
            this.b = ((GenSolvablePolynomial)this.dfac.random(this.kl, this.ll + 1, this.el, this.q)).monic();
        } while (this.b.isZERO());
        this.c = this.b.multiply((BigQuaternion)((Object)this.a));
        this.d = this.a.multiply((BigQuaternion)((Object)this.b));
        FDUtilQuatTest.assertTrue((String)"c != 0: ", (!this.c.isZERO() ? 1 : 0) != 0);
        FDUtilQuatTest.assertTrue((String)"d != 0: ", (!this.d.isZERO() ? 1 : 0) != 0);
        FDUtilQuatTest.assertTrue((String)"a*b != b*a", (!this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.d, this.a);
        FDUtilQuatTest.assertTrue((String)"ab = a*x + 0: ", (boolean)this.e.isZERO());
        this.f = FDUtil.leftBaseSparsePseudoRemainder(this.d, this.b);
        FDUtilQuatTest.assertTrue((String)"ab = y*b + 0: ", (boolean)this.f.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.c, this.a);
        FDUtilQuatTest.assertTrue((String)"ba = x*a + 0: ", (boolean)this.e.isZERO());
        this.f = FDUtil.rightBaseSparsePseudoRemainder(this.c, this.b);
        FDUtilQuatTest.assertTrue((String)"ba = b*y + 0: ", (boolean)this.f.isZERO());
    }

    public void testBasePseudoDivisionRemainder() {
        String[] stringArray = new String[]{"x"};
        GenSolvablePolynomialRing<BigQuaternion> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigQuaternion>(this.cfi, this.to, stringArray);
        GenSolvablePolynomialRing<BigQuaternion> genSolvablePolynomialRing2 = new GenSolvablePolynomialRing<BigQuaternion>(this.cfr, genSolvablePolynomialRing);
        do {
            this.a = genSolvablePolynomialRing.random(this.kl, this.ll * 1, this.el + 0, this.q);
        } while (this.a.isZERO());
        do {
            this.b = genSolvablePolynomialRing.random(this.kl, this.ll * 2, this.el + 1, this.q);
        } while (this.b.isZERO());
        GenSolvablePolynomial<BigQuaternion>[] genSolvablePolynomialArray = FDUtil.leftBasePseudoQuotientRemainder(this.a, this.b);
        this.c = genSolvablePolynomialArray[0];
        this.d = genSolvablePolynomialArray[1];
        boolean bl = FDUtil.isLeftBasePseudoQuotientRemainder(this.a, this.b, this.c, this.d);
        FDUtilQuatTest.assertTrue((String)("lc^n c = e b + f: " + this.f), (boolean)bl);
        genSolvablePolynomialArray = FDUtil.rightBasePseudoQuotientRemainder(this.a, this.b);
        this.e = genSolvablePolynomialArray[0];
        this.f = genSolvablePolynomialArray[1];
        bl = FDUtil.isRightBasePseudoQuotientRemainder(this.a, this.b, this.e, this.f);
        FDUtilQuatTest.assertTrue((String)("ore(lc^n) c = e b + f: " + this.f), (boolean)bl);
    }

    public void testRecursivePseudoDivision() {
        String[] stringArray = new String[]{"t", "x", "y", "z"};
        this.rdfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfr, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rrfac = (RecSolvablePolynomialRing)this.rdfac.recursive(1);
        this.q = 0.27f;
        this.kl = 1;
        this.ll = 3;
        this.arr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        this.brr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        if (this.brr.isZERO()) {
            this.brr = this.rrfac.parse(" ( x - 2 ) z - ( t - y^2 + y ) ");
        }
        this.drr = FDUtil.recursivePseudoQuotient(this.arr, this.brr);
        this.crr = FDUtil.recursiveSparsePseudoRemainder(this.arr, this.brr);
        GenSolvablePolynomial<GenPolynomial<C>>[] genSolvablePolynomialArray = FDUtil.recursivePseudoQuotientRemainder(this.arr, this.brr);
        boolean bl = FDUtil.isRecursivePseudoQuotientRemainder(this.arr, this.brr, this.drr, this.crr);
        FDUtilQuatTest.assertTrue((String)("ore(lc^n) a = q b + r: " + this.crr), (boolean)bl);
    }

    public void xtestLeftAndRightRecursiveDivision() {
        String[] stringArray = new String[]{"y", "z"};
        this.rdfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfr, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rrfac = this.rdfac.recursive(1);
        this.kl = 2;
        this.ll = 4;
        this.el = 5;
        this.arr = this.rrfac.random(this.kl, this.ll, this.el + 1, this.q);
        this.brr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        this.abrr = this.arr.multiply((GenPolynomial<BigQuaternion>)this.brr);
        this.drr = FDUtil.recursivePseudoQuotient(this.abrr, this.brr);
        this.crr = FDUtil.recursiveSparsePseudoRemainder(this.abrr, this.brr);
        GenSolvablePolynomial<GenPolynomial<C>>[] genSolvablePolynomialArray = FDUtil.recursivePseudoQuotientRemainder(this.abrr, this.brr);
        FDUtilQuatTest.assertEquals((String)"drr == QR[0]: ", this.drr, genSolvablePolynomialArray[0]);
        FDUtilQuatTest.assertEquals((String)"crr == QR[1]: ", this.crr, genSolvablePolynomialArray[1]);
        boolean bl = FDUtil.isRecursivePseudoQuotientRemainder(this.abrr, this.brr, this.drr, this.crr);
        FDUtilQuatTest.assertTrue((String)("ore(lc^n) a = q b + r: " + this.crr), (boolean)bl);
        this.barr = this.brr.multiply((GenPolynomial<BigQuaternion>)this.arr);
        genSolvablePolynomialArray = FDUtil.recursiveRightPseudoQuotientRemainder(this.barr, this.brr);
        this.drr = genSolvablePolynomialArray[0];
        this.crr = genSolvablePolynomialArray[1];
        bl = FDUtil.isRecursiveRightPseudoQuotientRemainder(this.barr, this.brr, this.drr, this.crr);
        FDUtilQuatTest.assertTrue((String)("a ore(lc^n) = q b + r: " + this.crr), (boolean)bl);
        genSolvablePolynomialArray = FDUtil.recursivePseudoQuotientRemainder(this.arr, this.brr);
        this.drr = genSolvablePolynomialArray[0];
        this.crr = genSolvablePolynomialArray[1];
        bl = FDUtil.isRecursivePseudoQuotientRemainder(this.arr, this.brr, this.drr, this.crr);
        FDUtilQuatTest.assertTrue((String)("ore(lc^n) a = b q + r: " + this.crr), (boolean)bl);
        genSolvablePolynomialArray = FDUtil.recursiveRightPseudoQuotientRemainder(this.arr, this.brr);
        this.drr = genSolvablePolynomialArray[0];
        this.crr = genSolvablePolynomialArray[1];
        bl = FDUtil.isRecursiveRightPseudoQuotientRemainder(this.arr, this.brr, this.drr, this.crr);
        FDUtilQuatTest.assertTrue((String)("ore(lc^n) a = q p + r: " + this.crr), (boolean)bl);
    }

    public void xtestRightRecursivePolynomial() {
        String[] stringArray = new String[]{"y", "z"};
        this.rdfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfr, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rrfac = this.rdfac.recursive(1);
        this.kl = 3;
        this.ll = 4;
        this.el = 5;
        this.arr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        System.out.println("arr  = " + this.arr);
        this.brr = this.arr.rightRecursivePolynomial();
        System.out.println("brr  = " + this.brr);
        boolean bl = this.arr.isRightRecursivePolynomial(this.brr);
        FDUtilQuatTest.assertTrue((String)"arr == eval(brr): ", (boolean)bl);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.rrfac.random(this.kl, this.ll, this.el, this.q).leadingBaseCoefficient();
        System.out.println("c  = " + genSolvablePolynomial);
        this.drr = this.arr.multiply((RingElem)genSolvablePolynomial);
        System.out.println("drr  = " + this.drr);
        this.err = FDUtil.recursiveLeftDivide(this.drr, genSolvablePolynomial);
        System.out.println("err  = " + this.err);
        FDUtilQuatTest.assertEquals((String)"arr == err: ", this.arr, this.err);
        this.drr = this.arr.multiplyLeft((RingElem)genSolvablePolynomial);
        System.out.println("drr  = " + this.drr);
        this.err = FDUtil.recursiveRightDivide(this.drr, genSolvablePolynomial);
        System.out.println("err  = " + this.err);
        FDUtilQuatTest.assertEquals((String)"arr == err: ", this.arr, this.err);
    }

    public void testRecursiveDivide() {
        this.rdfac = new GenSolvablePolynomialRing<BigQuaternion>(this.cfr, this.dfac);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rsfac = (RecSolvablePolynomialRing)this.rdfac.recursive(1);
        FDUtilQuatTest.assertFalse((String)"isCommutative()", (boolean)this.rsfac.isCommutative());
        FDUtilQuatTest.assertTrue((String)"isAssociative()", (boolean)this.rsfac.isAssociative());
        do {
            this.as = this.rsfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.as.isZERO());
        do {
            this.bs = this.rsfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.bs.isZERO());
        this.cs = this.bs.multiply(this.as);
        this.ds = this.as.multiply(this.bs);
        FDUtilQuatTest.assertTrue((String)"cs != 0: ", (!this.cs.isZERO() ? 1 : 0) != 0);
        FDUtilQuatTest.assertTrue((String)"ds != 0: ", (!this.ds.isZERO() ? 1 : 0) != 0);
        FDUtilQuatTest.assertTrue((String)"as*bs != bs*as", (!this.cs.equals(this.ds) || this.cs.leadingExpVector().equals(this.ds.leadingExpVector()) ? 1 : 0) != 0);
        this.es = (RecSolvablePolynomial)FDUtil.recursivePseudoQuotient(this.cs, this.as);
        int n = 0;
        do {
            this.x1 = this.bs.multiplyLeft((GenPolynomial)((GenPolynomial)this.as.leadingBaseCoefficient()).power(n));
            if (this.es.equals(this.x1)) {
                FDUtilQuatTest.assertEquals((String)"b == b*a/a: ", this.es, this.x1);
                break;
            }
            if (!((GenPolynomial)this.es.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: b == b*a/a: lc(e)==lc(x1)");
            if (!((GenPolynomial)this.es.abs()).equals(this.bs.abs())) break;
            System.out.println("success via pseudo: b == b*a/a: ");
            break;
        } while (n++ < 4);
        this.fs = (RecSolvablePolynomial)FDUtil.recursivePseudoQuotient(this.ds, this.bs);
        n = 0;
        do {
            this.x1 = this.as.multiplyLeft((GenPolynomial)((GenPolynomial)this.bs.leadingBaseCoefficient()).power(n));
            if (this.fs.equals(this.x1)) {
                FDUtilQuatTest.assertEquals((String)"a == a*b/b: ", this.fs, this.x1);
                break;
            }
            if (!((GenPolynomial)this.fs.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: a == a*b/b: lc(f)==lc(x1)");
            if (!((GenPolynomial)this.fs.abs()).equals(this.as.abs())) break;
            System.out.println("success via pseudo: a == a*b/b: ");
            break;
        } while (n++ < 4);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.bs.leadingBaseCoefficient();
        this.ds = (RecSolvablePolynomial)this.as.multiply((RingElem)genSolvablePolynomial);
        this.fs = (RecSolvablePolynomial)FDUtil.recursiveDivide(this.ds, genSolvablePolynomial);
        n = 0;
        do {
            this.x1 = (RecSolvablePolynomial)this.as.multiply((RingElem)((GenPolynomial)genSolvablePolynomial.power(n)));
            if (this.fs.equals(this.x1)) {
                FDUtilQuatTest.assertEquals((String)"a == a*b/b: ", this.fs, this.x1);
                break;
            }
            if (!((GenPolynomial)this.fs.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: a == a*b/b: lc(f)==lc(x1)");
            if (!((GenPolynomial)this.fs.abs()).equals(this.as.abs())) break;
            System.out.println("success via pseudo: a == a*b/b: ");
            break;
        } while (n++ < 4);
        genSolvablePolynomial = (GenSolvablePolynomial)this.bs.leadingBaseCoefficient();
        this.ds = (RecSolvablePolynomial)this.as.multiply((RingElem)genSolvablePolynomial);
        this.fs = (RecSolvablePolynomial)FDUtil.recursiveLeftDivide(this.ds, genSolvablePolynomial);
        n = 0;
        do {
            this.x1 = (RecSolvablePolynomial)this.as.multiply((RingElem)((GenPolynomial)genSolvablePolynomial.power(n)));
            if (this.fs.equals(this.x1)) {
                FDUtilQuatTest.assertEquals((String)"a == a*b/b: ", this.fs, this.x1);
                break;
            }
            if (!((GenPolynomial)this.fs.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: a == a*b/b: lc(f)==lc(x1)");
            if (!((GenPolynomial)this.fs.abs()).equals(this.as.abs())) break;
            System.out.println("success via pseudo: a == a*b/b: ");
            break;
        } while (n++ < 4);
    }
}

