/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.fd.FDUtil;
import edu.jas.fd.SolvableQuotientRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelationsIterated;
import edu.jas.structure.RingElem;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FDUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenSolvablePolynomialRing<BigInteger> dfac;
    GenSolvablePolynomialRing<BigRational> rdfac;
    GenSolvablePolynomialRing<GenPolynomial<BigInteger>> rfac;
    GenSolvablePolynomialRing<GenPolynomial<BigRational>> rrfac;
    RecSolvablePolynomialRing<BigRational> rsfac;
    GenSolvablePolynomial<BigInteger> a;
    GenSolvablePolynomial<BigInteger> b;
    GenSolvablePolynomial<BigInteger> c;
    GenSolvablePolynomial<BigInteger> d;
    GenSolvablePolynomial<BigInteger> e;
    GenSolvablePolynomial<BigInteger> f;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> ar;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> br;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> cr;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> dr;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> er;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> fr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> arr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> brr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> abrr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> barr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> crr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> drr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> err;
    GenSolvablePolynomial<GenPolynomial<BigRational>> frr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> x1;
    RecSolvablePolynomial<BigRational> as;
    RecSolvablePolynomial<BigRational> bs;
    RecSolvablePolynomial<BigRational> cs;
    RecSolvablePolynomial<BigRational> ds;
    RecSolvablePolynomial<BigRational> es;
    RecSolvablePolynomial<BigRational> fs;
    int rl = 4;
    int kl = 2;
    int ll = 4;
    int el = 3;
    float q = 0.35f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FDUtilTest.suite());
        ComputerThreads.terminate();
    }

    public FDUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FDUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.rl = stringArray.length;
        this.dfac = new GenSolvablePolynomialRing<BigInteger>(new BigInteger(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = this.dfac.recursive(1);
        this.rdfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated2 = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated2);
        this.rrfac = this.rdfac.recursive(1);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.rfac = null;
    }

    public void testBasePseudoDivisionExact() {
        do {
            this.a = this.dfac.random(this.kl, this.ll + 1, this.el, this.q);
        } while (this.a.isZERO());
        do {
            this.b = this.dfac.random(this.kl, this.ll + 1, this.el, this.q);
        } while (this.b.isZERO());
        this.c = this.b.multiply((BigInteger)((Object)this.a));
        this.d = this.a.multiply((BigInteger)((Object)this.b));
        FDUtilTest.assertTrue((String)"c != 0: ", (!this.c.isZERO() ? 1 : 0) != 0);
        FDUtilTest.assertTrue((String)"d != 0: ", (!this.d.isZERO() ? 1 : 0) != 0);
        FDUtilTest.assertTrue((String)"a*b != b*a", (!this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.e = FDUtil.leftBasePseudoQuotient(this.c, this.a);
        FDUtilTest.assertEquals((String)"b == b*a/a: ", this.b, this.e);
        this.f = FDUtil.rightBasePseudoQuotient(this.c, this.b);
        FDUtilTest.assertEquals((String)"a == b*a/b: ", this.a, this.f);
        this.e = FDUtil.rightBasePseudoQuotient(this.d, this.a);
        FDUtilTest.assertEquals((String)"b == a*b/a: ", this.b, this.e);
        this.f = FDUtil.leftBasePseudoQuotient(this.d, this.b);
        FDUtilTest.assertEquals((String)"a == a*b/b: ", this.a, this.f);
    }

    public void testBasePseudoDivision() {
        String[] stringArray = new String[]{"x"};
        GenSolvablePolynomialRing<BigInteger> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigInteger>(new BigInteger(1L), this.to, stringArray);
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing2 = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), genSolvablePolynomialRing);
        do {
            this.a = genSolvablePolynomialRing.random(this.kl, this.ll * 1, this.el + 0, this.q);
        } while (this.a.isZERO());
        this.a = genSolvablePolynomialRing.parse("3 x**5 + 44");
        do {
            this.b = genSolvablePolynomialRing.random(this.kl, this.ll * 2, this.el + 1, this.q);
        } while (this.b.isZERO());
        this.b = genSolvablePolynomialRing.parse("2 x**2 + 40");
        GenPolynomial<BigInteger>[] genPolynomialArray = PolyUtil.basePseudoQuotientRemainder(this.a, this.b);
        this.c = (GenSolvablePolynomial)genPolynomialArray[0];
        this.d = (GenSolvablePolynomial)genPolynomialArray[1];
        boolean bl = PolyUtil.isBasePseudoQuotientRemainder(this.a, this.b, this.c, this.d);
        FDUtilTest.assertTrue((String)("lc^n c = e b + f: " + this.f), (boolean)bl);
        GenSolvablePolynomial<BigInteger>[] genSolvablePolynomialArray = FDUtil.leftBasePseudoQuotientRemainder(this.a, this.b);
        this.e = genSolvablePolynomialArray[0];
        this.f = genSolvablePolynomialArray[1];
        bl = PolyUtil.isBasePseudoQuotientRemainder(this.a, this.b, this.e, this.f);
        FDUtilTest.assertTrue((String)("ore(lc^n) c = e b + f: " + this.f), (boolean)bl);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing2, this.a);
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing2, this.b);
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing2, this.c);
        GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing2, this.d);
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing2, this.e);
        GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)PolyUtil.fromIntegerCoefficients(genSolvablePolynomialRing2, this.f);
        GenSolvablePolynomial<GenSolvablePolynomial> genSolvablePolynomial7 = genSolvablePolynomial.divide(genSolvablePolynomial2);
        GenSolvablePolynomial genSolvablePolynomial8 = genSolvablePolynomial.remainder(genSolvablePolynomial2);
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = genSolvablePolynomial.quotientRemainder(genSolvablePolynomial2);
        FDUtilTest.assertEquals((String)"qp == QRr[0]: ", genSolvablePolynomial7, genSolvablePolynomialArray2[0]);
        FDUtilTest.assertEquals((String)"rp == QRr[1]: ", genSolvablePolynomial8, genSolvablePolynomialArray2[1]);
        GenSolvablePolynomial genSolvablePolynomial9 = (GenSolvablePolynomial)genSolvablePolynomial7.multiply(genSolvablePolynomial2).sum(genSolvablePolynomial8);
        FDUtilTest.assertEquals((String)"ap == qp bp + rp: ", (Object)genSolvablePolynomial, (Object)genSolvablePolynomial9);
        FDUtilTest.assertEquals((String)"cp == qp: ", (Object)genSolvablePolynomial7.monic(), (Object)genSolvablePolynomial3.monic());
        FDUtilTest.assertEquals((String)"dp == rp: ", (Object)genSolvablePolynomial8.monic(), (Object)genSolvablePolynomial4.monic());
        FDUtilTest.assertEquals((String)"ep == qp: ", (Object)genSolvablePolynomial5.monic(), (Object)genSolvablePolynomial3.monic());
        FDUtilTest.assertEquals((String)"fp == rp: ", (Object)genSolvablePolynomial6.monic(), (Object)genSolvablePolynomial4.monic());
    }

    public void testRecursivePseudoDivision() {
        String[] stringArray = new String[]{"t", "x", "y", "z"};
        this.rdfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rsfac = (RecSolvablePolynomialRing)this.rdfac.recursive(1);
        this.q = 0.27f;
        this.kl = 1;
        this.ll = 3;
        this.arr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        this.brr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        if (this.brr.isZERO()) {
            this.brr = this.rrfac.parse(" ( x - 2 ) z - ( t - y^2 + y ) ");
        }
        this.drr = FDUtil.recursivePseudoQuotient(this.arr, this.brr);
        this.crr = FDUtil.recursiveSparsePseudoRemainder(this.arr, this.brr);
        GenSolvablePolynomial<GenPolynomial<C>>[] genSolvablePolynomialArray = FDUtil.recursivePseudoQuotientRemainder(this.arr, this.brr);
        FDUtilTest.assertEquals((String)"drr == QR[0]: ", this.drr, genSolvablePolynomialArray[0]);
        FDUtilTest.assertEquals((String)"crr == QR[1]: ", this.crr, genSolvablePolynomialArray[1]);
        boolean bl = FDUtil.isRecursivePseudoQuotientRemainder(this.arr, this.brr, this.drr, this.crr);
        FDUtilTest.assertTrue((String)("ore(lc^n) a = q b + r: " + this.crr), (boolean)bl);
    }

    public void testLeftAndRightRecursiveDivision() {
        String[] stringArray = new String[]{"y", "z"};
        this.rdfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rrfac = this.rdfac.recursive(1);
        this.kl = 2;
        this.ll = 4;
        this.el = 5;
        this.arr = this.rrfac.random(this.kl, this.ll, this.el + 1, this.q);
        this.brr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        this.abrr = this.arr.multiply((GenPolynomial<BigRational>)this.brr);
        this.drr = FDUtil.recursivePseudoQuotient(this.abrr, this.brr);
        this.crr = FDUtil.recursiveSparsePseudoRemainder(this.abrr, this.brr);
        GenSolvablePolynomial<GenPolynomial<C>>[] genSolvablePolynomialArray = FDUtil.recursivePseudoQuotientRemainder(this.abrr, this.brr);
        FDUtilTest.assertEquals((String)"drr == QR[0]: ", this.drr, genSolvablePolynomialArray[0]);
        FDUtilTest.assertEquals((String)"crr == QR[1]: ", this.crr, genSolvablePolynomialArray[1]);
        boolean bl = FDUtil.isRecursivePseudoQuotientRemainder(this.abrr, this.brr, this.drr, this.crr);
        FDUtilTest.assertTrue((String)("ore(lc^n) a = q b + r: " + this.crr), (boolean)bl);
        this.barr = this.brr.multiply((GenPolynomial<BigRational>)this.arr);
        genSolvablePolynomialArray = FDUtil.recursiveRightPseudoQuotientRemainder(this.barr, this.brr);
        this.drr = genSolvablePolynomialArray[0];
        this.crr = genSolvablePolynomialArray[1];
        bl = FDUtil.isRecursiveRightPseudoQuotientRemainder(this.barr, this.brr, this.drr, this.crr);
        FDUtilTest.assertTrue((String)("a ore(lc^n) = q b + r: " + this.crr), (boolean)bl);
        genSolvablePolynomialArray = FDUtil.recursivePseudoQuotientRemainder(this.arr, this.brr);
        this.drr = genSolvablePolynomialArray[0];
        this.crr = genSolvablePolynomialArray[1];
        bl = FDUtil.isRecursivePseudoQuotientRemainder(this.arr, this.brr, this.drr, this.crr);
        FDUtilTest.assertTrue((String)("ore(lc^n) a = b q + r: " + this.crr), (boolean)bl);
        genSolvablePolynomialArray = FDUtil.recursiveRightPseudoQuotientRemainder(this.arr, this.brr);
        this.drr = genSolvablePolynomialArray[0];
        this.crr = genSolvablePolynomialArray[1];
        bl = FDUtil.isRecursiveRightPseudoQuotientRemainder(this.arr, this.brr, this.drr, this.crr);
        FDUtilTest.assertTrue((String)("ore(lc^n) a = q p + r: " + this.crr), (boolean)bl);
    }

    public void testRightRecursivePolynomial() {
        String[] stringArray = new String[]{"y", "z"};
        this.rdfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rrfac = this.rdfac.recursive(1);
        this.kl = 3;
        this.ll = 4;
        this.el = 5;
        this.arr = this.rrfac.random(this.kl, this.ll, this.el, this.q);
        this.brr = this.arr.rightRecursivePolynomial();
        boolean bl = this.arr.isRightRecursivePolynomial(this.brr);
        FDUtilTest.assertTrue((String)"arr == eval(brr): ", (boolean)bl);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.rrfac.random(this.kl, this.ll, this.el, this.q).leadingBaseCoefficient();
        this.drr = this.arr.multiply((RingElem)genSolvablePolynomial);
        this.err = FDUtil.recursiveLeftDivide(this.drr, genSolvablePolynomial);
        FDUtilTest.assertEquals((String)"arr == err: ", this.arr, this.err);
        this.drr = this.arr.multiplyLeft((RingElem)genSolvablePolynomial);
        this.err = FDUtil.recursiveRightDivide(this.drr, genSolvablePolynomial);
        FDUtilTest.assertEquals((String)"arr == err: ", this.arr, this.err);
    }

    public void testRecursiveDivide() {
        this.rdfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.dfac);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.rdfac.addRelations(weylRelationsIterated);
        this.rsfac = (RecSolvablePolynomialRing)this.rdfac.recursive(1);
        FDUtilTest.assertFalse((String)"isCommutative()", (boolean)this.rsfac.isCommutative());
        FDUtilTest.assertTrue((String)"isAssociative()", (boolean)this.rsfac.isAssociative());
        do {
            this.as = this.rsfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.as.isZERO());
        do {
            this.bs = this.rsfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.bs.isZERO());
        this.cs = this.bs.multiply(this.as);
        this.ds = this.as.multiply(this.bs);
        FDUtilTest.assertTrue((String)"cs != 0: ", (!this.cs.isZERO() ? 1 : 0) != 0);
        FDUtilTest.assertTrue((String)"ds != 0: ", (!this.ds.isZERO() ? 1 : 0) != 0);
        FDUtilTest.assertTrue((String)"as*bs != bs*as", (!this.cs.equals(this.ds) || this.cs.leadingExpVector().equals(this.ds.leadingExpVector()) ? 1 : 0) != 0);
        this.es = (RecSolvablePolynomial)FDUtil.recursivePseudoQuotient(this.cs, this.as);
        int n = 0;
        do {
            this.x1 = this.bs.multiplyLeft((GenPolynomial)((GenPolynomial)this.as.leadingBaseCoefficient()).power(n));
            if (this.es.equals(this.x1)) {
                FDUtilTest.assertEquals((String)"b == b*a/a: ", this.es, this.x1);
                break;
            }
            if (!((GenPolynomial)this.es.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: b == b*a/a: lc(e)==lc(x1)");
            if (!((GenPolynomial)this.es.abs()).equals(this.bs.abs())) break;
            System.out.println("success via pseudo: b == b*a/a: ");
            break;
        } while (n++ < 4);
        this.fs = (RecSolvablePolynomial)FDUtil.recursiveRightPseudoQuotient(this.cs, this.bs);
        n = 0;
        do {
            this.x1 = (RecSolvablePolynomial)this.as.multiply((RingElem)((GenPolynomial)((GenPolynomial)this.bs.leadingBaseCoefficient()).power(n)));
            if (this.fs.equals(this.x1)) {
                FDUtilTest.assertEquals((String)"a == b*a/b: ", this.fs, this.x1);
                break;
            }
            if (!((GenPolynomial)this.fs.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: a == b*a/b: lc(f)==lc(x1)");
            if (!((GenPolynomial)this.fs.abs()).equals(this.as.abs())) break;
            System.out.println("success via pseudo: a == b*a/b: ");
            break;
        } while (n++ < 4);
        this.es = (RecSolvablePolynomial)FDUtil.recursiveRightPseudoQuotient(this.ds, this.as);
        n = 0;
        do {
            this.x1 = (RecSolvablePolynomial)this.bs.multiply((RingElem)((GenPolynomial)((GenPolynomial)this.as.leadingBaseCoefficient()).power(n)));
            if (this.es.equals(this.x1)) {
                FDUtilTest.assertEquals((String)"b == a*b/a: ", this.es, this.x1);
                break;
            }
            if (!((GenPolynomial)this.es.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: b == a*b/a: lc(e) == lc(x1)");
            if (!((GenPolynomial)this.es.abs()).equals(this.bs.abs())) break;
            break;
        } while (n++ < 4);
        this.fs = (RecSolvablePolynomial)FDUtil.recursivePseudoQuotient(this.ds, this.bs);
        n = 0;
        do {
            this.x1 = this.as.multiplyLeft((GenPolynomial)((GenPolynomial)this.bs.leadingBaseCoefficient()).power(n));
            if (this.fs.equals(this.x1)) {
                FDUtilTest.assertEquals((String)"a == a*b/b: ", this.fs, this.x1);
                break;
            }
            if (!((GenPolynomial)this.fs.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: a == a*b/b: lc(f)==lc(x1)");
            if (!((GenPolynomial)this.fs.abs()).equals(this.as.abs())) break;
            System.out.println("success via pseudo: a == a*b/b: ");
            break;
        } while (n++ < 4);
        GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this.bs.leadingBaseCoefficient();
        this.ds = (RecSolvablePolynomial)this.as.multiply((RingElem)genSolvablePolynomial);
        this.fs = (RecSolvablePolynomial)FDUtil.recursiveDivide(this.ds, genSolvablePolynomial);
        n = 0;
        do {
            this.x1 = (RecSolvablePolynomial)this.as.multiply((RingElem)((GenPolynomial)genSolvablePolynomial.power(n)));
            if (this.fs.equals(this.x1)) {
                FDUtilTest.assertEquals((String)"a == a*b/b: ", this.fs, this.x1);
                break;
            }
            if (!((GenPolynomial)this.fs.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: a == a*b/b: lc(f)==lc(x1)");
            if (!((GenPolynomial)this.fs.abs()).equals(this.as.abs())) break;
            System.out.println("success via pseudo: a == a*b/b: ");
            break;
        } while (n++ < 4);
        genSolvablePolynomial = (GenSolvablePolynomial)this.bs.leadingBaseCoefficient();
        this.ds = (RecSolvablePolynomial)this.as.multiply((RingElem)genSolvablePolynomial);
        this.fs = (RecSolvablePolynomial)FDUtil.recursiveLeftDivide(this.ds, genSolvablePolynomial);
        n = 0;
        do {
            this.x1 = (RecSolvablePolynomial)this.as.multiply((RingElem)((GenPolynomial)genSolvablePolynomial.power(n)));
            if (this.fs.equals(this.x1)) {
                FDUtilTest.assertEquals((String)"a == a*b/b: ", this.fs, this.x1);
                break;
            }
            if (!((GenPolynomial)this.fs.leadingBaseCoefficient()).equals(this.x1.leadingBaseCoefficient())) continue;
            System.out.println("fail: a == a*b/b: lc(f)==lc(x1)");
            if (!((GenPolynomial)this.fs.abs()).equals(this.as.abs())) break;
            System.out.println("success via pseudo: a == a*b/b: ");
            break;
        } while (n++ < 4);
    }

    public void testIntConversion() {
        this.rfac = this.dfac.recursive(2);
        FDUtilTest.assertFalse((String)"isCommutative()", (boolean)this.rfac.isCommutative());
        FDUtilTest.assertTrue((String)"isAssociative()", (boolean)this.rfac.isAssociative());
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = new GenSolvablePolynomialRing(solvableQuotientRing, this.rfac);
        List list = this.rfac.table.relationList();
        List list2 = FDUtil.quotientFromIntegralCoefficients(genSolvablePolynomialRing2, list);
        FDUtilTest.assertEquals((String)"#irel == #qrel: ", (int)list.size(), (int)list2.size());
        genSolvablePolynomialRing2.table.addSolvRelations(list2);
        FDUtilTest.assertFalse((String)"isCommutative()", (boolean)genSolvablePolynomialRing2.isCommutative());
        List list3 = FDUtil.integralFromQuotientCoefficients(this.rfac, list2);
        FDUtilTest.assertEquals((String)"#qrel == #iqrel: ", (int)list2.size(), (int)list3.size());
        FDUtilTest.assertEquals((String)"irel == iqrel: ", list, list3);
    }

    public void testRatConversion() {
        GenPolynomial genPolynomial;
        GenPolynomial genPolynomial2;
        this.rrfac = this.rdfac.recursive(2);
        FDUtilTest.assertFalse((String)"isCommutative()", (boolean)this.rrfac.isCommutative());
        FDUtilTest.assertTrue((String)"isAssociative()", (boolean)this.rrfac.isAssociative());
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rrfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = new GenSolvablePolynomialRing(solvableQuotientRing, this.rrfac);
        List list = this.rrfac.table.relationList();
        List list2 = FDUtil.quotientFromIntegralCoefficients(genSolvablePolynomialRing2, list);
        FDUtilTest.assertEquals((String)"#rrel == #qrel: ", (int)list.size(), (int)list2.size());
        genSolvablePolynomialRing2.table.addSolvRelations(list2);
        FDUtilTest.assertFalse((String)"isCommutative()", (boolean)genSolvablePolynomialRing2.isCommutative());
        FDUtilTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing2.isAssociative());
        List list3 = FDUtil.integralFromQuotientCoefficients(this.rrfac, list2);
        FDUtilTest.assertEquals((String)"#rrel == #rqrel: ", (int)list.size(), (int)list3.size());
        FDUtilTest.assertEquals((String)"rrel == rqrel: ", list, list3);
        this.kl = 1;
        this.q = 0.3f;
        while ((genPolynomial2 = genSolvablePolynomialRing2.random(this.kl, this.ll, this.el, this.q)).isZERO()) {
        }
        while ((genPolynomial = genSolvablePolynomialRing2.random(this.kl, this.ll, this.el, this.q / 2.0f)).isZERO()) {
        }
        GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(genPolynomial2);
        GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial2 = ((GenSolvablePolynomial)genPolynomial2).multiply(genPolynomial);
        FDUtilTest.assertTrue((String)"cq != 0: ", (!genSolvablePolynomial.isZERO() ? 1 : 0) != 0);
        FDUtilTest.assertTrue((String)"dq != 0: ", (!genSolvablePolynomial2.isZERO() ? 1 : 0) != 0);
        FDUtilTest.assertTrue((String)"aq*bq != bq*aq", (!genSolvablePolynomial.equals(genSolvablePolynomial2) || genSolvablePolynomial.leadingExpVector().equals(genSolvablePolynomial2.leadingExpVector()) ? 1 : 0) != 0);
    }
}

