/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.poly.WeylRelationsIterated;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDSimpleQuatTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigQuaternion> fd;
    TermOrder to = TermOrderByName.INVLEX;
    GenSolvablePolynomialRing<BigQuaternion> qfac;
    RecSolvablePolynomialRing<BigQuaternion> rfac;
    GenSolvablePolynomial<BigQuaternion> a;
    GenSolvablePolynomial<BigQuaternion> b;
    GenSolvablePolynomial<BigQuaternion> a0;
    GenSolvablePolynomial<BigQuaternion> b0;
    GenSolvablePolynomial<BigQuaternion> c;
    GenSolvablePolynomial<BigQuaternion> d;
    GenSolvablePolynomial<BigQuaternion> e;
    GenSolvablePolynomial<BigQuaternion> f;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> ar;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> br;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> cr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> dr;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> er;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> ar0;
    GenSolvablePolynomial<GenPolynomial<BigQuaternion>> br0;
    int rl = 4;
    int kl = 2;
    int ll = 2;
    int el = 3;
    float q = 0.25f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GCDSimpleQuatTest.suite());
        ComputerThreads.terminate();
    }

    public GCDSimpleQuatTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDSimpleQuatTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        this.fd = new GreatestCommonDivisorSimple<BigQuaternion>(bigQuaternionRing);
        this.qfac = new GenSolvablePolynomialRing<BigQuaternion>(bigQuaternionRing, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.qfac.addRelations(weylRelationsIterated);
        this.rfac = (RecSolvablePolynomialRing)this.qfac.recursive(1);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.fd = null;
        this.qfac = null;
        this.rfac = null;
    }

    public void testQuatBaseGcdSimple() {
        String[] stringArray = new String[]{"x"};
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        this.qfac = new GenSolvablePolynomialRing<BigQuaternion>(bigQuaternionRing, 1, this.to, stringArray);
        for (int i = 0; i < 3; ++i) {
            this.a = this.qfac.random(this.kl + i, this.ll + 2 * i, this.el + 2, this.q);
            this.a = (GenSolvablePolynomial)this.a.sum((BigQuaternion)((Object)((GenPolynomial)this.qfac.univariate(0).power(2L))));
            this.b = this.qfac.random(this.kl + (i + 1), this.ll + i, this.el + 2, this.q);
            this.b = (GenSolvablePolynomial)this.b.sum((BigQuaternion)((Object)this.qfac.univariate(0)));
            this.c = this.qfac.random(this.kl + (i + 1), this.ll + 1, this.el + 1, this.q);
            this.c = this.c.multiply((BigQuaternion)((Object)this.qfac.univariate(0)));
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            this.a = this.a.monic();
            this.b = this.b.monic();
            this.c = this.c.monic();
            this.a = this.c.multiply((BigQuaternion)((Object)this.a));
            this.b = this.c.multiply((BigQuaternion)((Object)this.b));
            this.d = this.fd.leftBaseGcd(this.a, this.b);
            this.e = FDUtil.leftBaseSparsePseudoRemainder(this.a, this.d);
            GCDSimpleQuatTest.assertTrue((String)("gcd(ca,cb) | ca " + this.e), (boolean)this.e.isZERO());
            this.e = FDUtil.leftBaseSparsePseudoRemainder(this.b, this.d);
            GCDSimpleQuatTest.assertTrue((String)("gcd(ca,cb) | cb " + this.e), (boolean)this.e.isZERO());
        }
    }
}

