/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisor;
import edu.jas.gbufd.SolvableSyzygyAbstract;
import edu.jas.gbufd.SolvableSyzygySeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import edu.jas.ufd.GCDFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GreatestCommonDivisorAbstract<C extends GcdRingElem<C>>
implements GreatestCommonDivisor<C> {
    private static final Logger logger = LogManager.getLogger(GreatestCommonDivisorAbstract.class);
    private static final boolean debug = logger.isDebugEnabled();
    final SolvableSyzygyAbstract<C> syz;
    final RingFactory<C> coFac;

    public GreatestCommonDivisorAbstract(RingFactory<C> ringFactory) {
        this(ringFactory, new SolvableSyzygySeq<C>(ringFactory));
    }

    public GreatestCommonDivisorAbstract(RingFactory<C> ringFactory, SolvableSyzygyAbstract<C> solvableSyzygyAbstract) {
        this.coFac = ringFactory;
        this.syz = solvableSyzygyAbstract;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public C leftBaseContent(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return (C)((GcdRingElem)genSolvablePolynomial.ring.getZEROCoefficient());
        }
        if (genSolvablePolynomial.ring.coFac.isField()) {
            return (C)((GcdRingElem)genSolvablePolynomial.leadingBaseCoefficient());
        }
        AbelianGroupElem abelianGroupElem = null;
        for (GcdRingElem gcdRingElem : genSolvablePolynomial.getMap().values()) {
            if (!(abelianGroupElem = abelianGroupElem == null ? gcdRingElem : abelianGroupElem.leftGcd(gcdRingElem)).isONE()) continue;
            return (C)abelianGroupElem;
        }
        if (abelianGroupElem.signum() < 0) {
            abelianGroupElem = (GcdRingElem)abelianGroupElem.negate();
        }
        return (C)abelianGroupElem;
    }

    public C rightBaseContent(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return (C)((GcdRingElem)genSolvablePolynomial.ring.getZEROCoefficient());
        }
        if (genSolvablePolynomial.ring.coFac.isField()) {
            return (C)((GcdRingElem)genSolvablePolynomial.leadingBaseCoefficient());
        }
        AbelianGroupElem abelianGroupElem = null;
        for (GcdRingElem gcdRingElem : genSolvablePolynomial.getMap().values()) {
            if (!(abelianGroupElem = abelianGroupElem == null ? gcdRingElem : abelianGroupElem.rightGcd(gcdRingElem)).isONE()) continue;
            return (C)abelianGroupElem;
        }
        if (abelianGroupElem.signum() < 0) {
            abelianGroupElem = (GcdRingElem)abelianGroupElem.negate();
        }
        return (C)abelianGroupElem;
    }

    public GenSolvablePolynomial<C> leftBasePrimitivePart(GenSolvablePolynomial<C> genSolvablePolynomial) {
        GenPolynomial genPolynomial;
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        C c = this.leftBaseContent(genSolvablePolynomial);
        if (c.isONE()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial.ring.coFac.isField()) {
            return genSolvablePolynomial.multiplyLeft((GcdRingElem)c.inverse());
        }
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.leftDivideCoeff(c);
        if (debug && !((GenSolvablePolynomial)(genPolynomial = genSolvablePolynomial2.multiplyLeft((RingElem)c))).equals(genSolvablePolynomial)) {
            throw new ArithmeticException("pp(p)*cont(p) != p: ");
        }
        return genSolvablePolynomial2;
    }

    public GenSolvablePolynomial<C> rightBasePrimitivePart(GenSolvablePolynomial<C> genSolvablePolynomial) {
        GenPolynomial genPolynomial;
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        C c = this.rightBaseContent(genSolvablePolynomial);
        if (c.isONE()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial.ring.coFac.isField()) {
            return genSolvablePolynomial.multiplyLeft((GcdRingElem)c.inverse());
        }
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.leftDivideCoeff(c);
        if (debug && !((GenSolvablePolynomial)(genPolynomial = genSolvablePolynomial2.multiplyLeft((RingElem)c))).equals(genSolvablePolynomial)) {
            throw new ArithmeticException("pp(p)*cont(p) != p: ");
        }
        return genSolvablePolynomial2;
    }

    public abstract GenSolvablePolynomial<C> leftBaseGcd(GenSolvablePolynomial<C> var1, GenSolvablePolynomial<C> var2);

    public abstract GenSolvablePolynomial<C> rightBaseGcd(GenSolvablePolynomial<C> var1, GenSolvablePolynomial<C> var2);

    public GenSolvablePolynomial<C> recursiveContent(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        Iterable iterable;
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial instanceof RecSolvablePolynomial) {
            iterable = (RecSolvablePolynomialRing)genSolvablePolynomial.ring;
            if (!((RecSolvablePolynomialRing)iterable).coeffTable.isEmpty()) {
                throw new IllegalArgumentException("P is a RecSolvablePolynomial, use recursiveContent()");
            }
        }
        if (genSolvablePolynomial.isZERO()) {
            return (GenSolvablePolynomial)genSolvablePolynomial.ring.getZEROCoefficient();
        }
        if (genSolvablePolynomial.isONE()) {
            return (GenSolvablePolynomial)genSolvablePolynomial.ring.getONECoefficient();
        }
        if (((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).isONE()) {
            return (GenSolvablePolynomial)genSolvablePolynomial.ring.getONECoefficient();
        }
        iterable = null;
        for (GenPolynomial genPolynomial : genSolvablePolynomial.getMap().values()) {
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genPolynomial;
            if (!((GenPolynomial)(iterable = iterable == null ? genSolvablePolynomial2 : this.rightGcd((GenSolvablePolynomial<C>)iterable, genSolvablePolynomial2))).isONE()) continue;
            return iterable;
        }
        return (GenSolvablePolynomial)((GenPolynomial)iterable).abs();
    }

    public GenSolvablePolynomial<C> rightRecursiveContent(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P != null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return (GenSolvablePolynomial)genSolvablePolynomial.ring.getZEROCoefficient();
        }
        if (((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).isONE()) {
            return (GenSolvablePolynomial)genSolvablePolynomial.ring.getONECoefficient();
        }
        GenSolvablePolynomial<C> genSolvablePolynomial2 = null;
        GenSolvablePolynomial genSolvablePolynomial3 = null;
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4 = genSolvablePolynomial.rightRecursivePolynomial();
        logger.info("RI-recCont: P = {}, right(P) = {}", genSolvablePolynomial, genSolvablePolynomial4);
        for (GenPolynomial genPolynomial : genSolvablePolynomial4.getMap().values()) {
            genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial;
            if (genSolvablePolynomial2 == null) {
                genSolvablePolynomial2 = genSolvablePolynomial3;
            } else {
                GenSolvablePolynomial<C> genSolvablePolynomial5 = genSolvablePolynomial2;
                genSolvablePolynomial2 = this.leftGcd(genSolvablePolynomial2, genSolvablePolynomial3);
                logger.info("RI-recCont: d = {}, cs = {}, d = {}", genSolvablePolynomial5, (Object)genSolvablePolynomial3, genSolvablePolynomial2);
            }
            if (!genSolvablePolynomial2.isONE()) continue;
            return genSolvablePolynomial2;
        }
        return (GenSolvablePolynomial)genSolvablePolynomial2.abs();
    }

    public GenSolvablePolynomial<GenPolynomial<C>> rightRecursivePrimitivePart(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomial<C> genSolvablePolynomial2 = this.rightRecursiveContent(genSolvablePolynomial);
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3 = FDUtil.recursiveLeftDivide(genSolvablePolynomial, genSolvablePolynomial2);
        if (debug && !genSolvablePolynomial.equals(genSolvablePolynomial3.multiply((RingElem)genSolvablePolynomial2))) {
            System.out.println("RI-ppart, P         = " + genSolvablePolynomial);
            System.out.println("RI-ppart, cont(P)   = " + genSolvablePolynomial2);
            System.out.println("RI-ppart, pp(P)     = " + genSolvablePolynomial3);
            System.out.println("RI-ppart, pp(P)c(P) = " + (GenSolvablePolynomial)genSolvablePolynomial3.multiply((RingElem)genSolvablePolynomial2));
            throw new RuntimeException("RI-primitivePart: P != pp(P)*cont(P)");
        }
        return genSolvablePolynomial3;
    }

    public GenSolvablePolynomial<C> leftRecursiveContent(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P != null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return (GenSolvablePolynomial)genSolvablePolynomial.ring.getZEROCoefficient();
        }
        if (((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).isONE()) {
            return (GenSolvablePolynomial)genSolvablePolynomial.ring.getONECoefficient();
        }
        GenSolvablePolynomial<C> genSolvablePolynomial2 = null;
        GenSolvablePolynomial genSolvablePolynomial3 = null;
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4 = genSolvablePolynomial;
        logger.info("recCont: P = {}, right(P) = {}", genSolvablePolynomial, genSolvablePolynomial4);
        for (GenPolynomial genPolynomial : genSolvablePolynomial4.getMap().values()) {
            genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial;
            if (genSolvablePolynomial2 == null) {
                genSolvablePolynomial2 = genSolvablePolynomial3;
            } else {
                genSolvablePolynomial2 = this.rightGcd(genSolvablePolynomial2, genSolvablePolynomial3);
                logger.info("recCont: cs = {}, d = {}", (Object)genSolvablePolynomial3, genSolvablePolynomial2);
            }
            if (!genSolvablePolynomial2.isONE()) continue;
            return genSolvablePolynomial2;
        }
        return (GenSolvablePolynomial)genSolvablePolynomial2.abs();
    }

    public GenSolvablePolynomial<GenPolynomial<C>> leftRecursivePrimitivePart(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomial<C> genSolvablePolynomial2 = this.leftRecursiveContent(genSolvablePolynomial);
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3 = FDUtil.recursiveRightDivide(genSolvablePolynomial, genSolvablePolynomial2);
        if (debug && !genSolvablePolynomial.equals(genSolvablePolynomial3.multiplyLeft((RingElem)genSolvablePolynomial2))) {
            System.out.println("ppart, P         = " + genSolvablePolynomial);
            System.out.println("ppart, cont(P)   = " + genSolvablePolynomial2);
            System.out.println("ppart, pp(P)     = " + genSolvablePolynomial3);
            System.out.println("ppart, pp(P)c(P) = " + (GenSolvablePolynomial)genSolvablePolynomial3.multiplyLeft((RingElem)genSolvablePolynomial2));
            throw new RuntimeException("primitivePart: P != cont(P)*pp(P)");
        }
        return genSolvablePolynomial3;
    }

    public C baseRecursiveContent(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)genSolvablePolynomial.ring.coFac;
            return (C)((GcdRingElem)genSolvablePolynomialRing.coFac.getZERO());
        }
        AbelianGroupElem abelianGroupElem = null;
        for (GenPolynomial genPolynomial : genSolvablePolynomial.getMap().values()) {
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genPolynomial;
            C c = this.leftBaseContent(genSolvablePolynomial2);
            if (!(abelianGroupElem = abelianGroupElem == null ? c : this.gcd(abelianGroupElem, c)).isONE()) continue;
            return (C)abelianGroupElem;
        }
        return (C)((GcdRingElem)abelianGroupElem.abs());
    }

    public GenSolvablePolynomial<GenPolynomial<C>> baseRecursivePrimitivePart(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        C c = this.baseRecursiveContent(genSolvablePolynomial);
        if (c.isONE()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)PolyUtil.baseRecursiveDivide(genSolvablePolynomial, c);
        return genSolvablePolynomial2;
    }

    public GenSolvablePolynomial<GenPolynomial<C>> leftRecursiveGcd(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        GenSolvablePolynomialRing genSolvablePolynomialRing;
        Iterable iterable;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.ring.nvar == 1) {
            return this.leftRecursiveUnivariateGcd(genSolvablePolynomial, genSolvablePolynomial2);
        }
        RecSolvablePolynomialRing recSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (recSolvablePolynomialRing instanceof RecSolvablePolynomialRing) {
            iterable = recSolvablePolynomialRing;
            genSolvablePolynomialRing = RecSolvablePolynomialRing.distribute(iterable);
        } else {
            iterable = recSolvablePolynomialRing;
            genSolvablePolynomialRing = iterable.distribute();
        }
        iterable = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, genSolvablePolynomial);
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, genSolvablePolynomial2);
        GenSolvablePolynomial<C> genSolvablePolynomial4 = this.leftGcd((GenSolvablePolynomial<C>)iterable, genSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)PolyUtil.recursive(recSolvablePolynomialRing, genSolvablePolynomial4);
        return genSolvablePolynomial5;
    }

    public GenSolvablePolynomial<GenPolynomial<C>> rightRecursiveGcd(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        GenSolvablePolynomialRing genSolvablePolynomialRing;
        Iterable iterable;
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.ring.nvar == 1) {
            return this.rightRecursiveUnivariateGcd(genSolvablePolynomial, genSolvablePolynomial2);
        }
        RecSolvablePolynomialRing recSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (recSolvablePolynomialRing instanceof RecSolvablePolynomialRing) {
            iterable = recSolvablePolynomialRing;
            genSolvablePolynomialRing = RecSolvablePolynomialRing.distribute(iterable);
        } else {
            iterable = recSolvablePolynomialRing;
            genSolvablePolynomialRing = iterable.distribute();
        }
        iterable = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, genSolvablePolynomial);
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, genSolvablePolynomial2);
        GenSolvablePolynomial<C> genSolvablePolynomial4 = this.rightGcd((GenSolvablePolynomial<C>)iterable, genSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)PolyUtil.recursive(recSolvablePolynomialRing, genSolvablePolynomial4);
        return genSolvablePolynomial5;
    }

    public abstract GenSolvablePolynomial<GenPolynomial<C>> leftRecursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> var1, GenSolvablePolynomial<GenPolynomial<C>> var2);

    public abstract GenSolvablePolynomial<GenPolynomial<C>> rightRecursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> var1, GenSolvablePolynomial<GenPolynomial<C>> var2);

    @Override
    public GenSolvablePolynomial<C> rightContent(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (genSolvablePolynomialRing.nvar <= 1) {
            throw new IllegalArgumentException("use baseContent() for univariate polynomials");
        }
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(1);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        GenSolvablePolynomial<C> genSolvablePolynomial2 = this.rightRecursiveContent(recSolvablePolynomial);
        return genSolvablePolynomial2;
    }

    @Override
    public GenSolvablePolynomial<C> rightPrimitivePart(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (genSolvablePolynomialRing.nvar <= 1) {
            return this.rightBasePrimitivePart(genSolvablePolynomial);
        }
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(1);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2 = this.rightRecursivePrimitivePart(recSolvablePolynomial);
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, genSolvablePolynomial2);
        return genSolvablePolynomial3;
    }

    @Override
    public GenSolvablePolynomial<C> leftContent(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (genSolvablePolynomialRing.nvar <= 1) {
            throw new IllegalArgumentException("use baseContent() for univariate polynomials");
        }
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(1);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        GenSolvablePolynomial<C> genSolvablePolynomial2 = this.leftRecursiveContent(recSolvablePolynomial);
        return genSolvablePolynomial2;
    }

    @Override
    public GenSolvablePolynomial<C> leftPrimitivePart(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (genSolvablePolynomialRing.nvar <= 1) {
            return this.leftBasePrimitivePart(genSolvablePolynomial);
        }
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(1);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2 = this.leftRecursivePrimitivePart(recSolvablePolynomial);
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, genSolvablePolynomial2);
        return genSolvablePolynomial3;
    }

    public GenSolvablePolynomial<C> divide(GenSolvablePolynomial<C> genSolvablePolynomial, C c) {
        if (c == null || c.isZERO()) {
            throw new IllegalArgumentException("division by zero");
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        return (GenSolvablePolynomial)genSolvablePolynomial.divide(c);
    }

    public C gcd(C c, C c2) {
        if (c2 == null || c2.isZERO()) {
            return c;
        }
        if (c == null || c.isZERO()) {
            return c2;
        }
        return (C)((GcdRingElem)c.gcd(c2));
    }

    @Override
    public GenSolvablePolynomial<C> leftGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.isONE()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (genSolvablePolynomialRing.nvar <= 1) {
            GenSolvablePolynomial<C> genSolvablePolynomial3 = this.leftBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
            return genSolvablePolynomial3;
        }
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(1);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial2);
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4 = this.leftRecursiveUnivariateGcd(recSolvablePolynomial, recSolvablePolynomial2);
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, genSolvablePolynomial4);
        if (debug) {
            GenSolvablePolynomial<C> genSolvablePolynomial6 = FDUtil.rightBaseSparsePseudoRemainder(genSolvablePolynomial, genSolvablePolynomial5);
            GenSolvablePolynomial<C> genSolvablePolynomial7 = FDUtil.rightBaseSparsePseudoRemainder(genSolvablePolynomial2, genSolvablePolynomial5);
            if (!genSolvablePolynomial6.isZERO() || !genSolvablePolynomial7.isZERO()) {
                System.out.println("fullGcd, D  = " + genSolvablePolynomial5);
                System.out.println("fullGcd, P  = " + genSolvablePolynomial);
                System.out.println("fullGcd, S  = " + genSolvablePolynomial2);
                System.out.println("fullGcd, ps = " + genSolvablePolynomial6);
                System.out.println("fullGcd, ss = " + genSolvablePolynomial7);
                throw new RuntimeException("fullGcd: not divisible");
            }
            logger.info("fullGcd(P,S) okay: D = {}, P = {}, S = {}", (Object)genSolvablePolynomial5, genSolvablePolynomial, genSolvablePolynomial2);
        }
        return genSolvablePolynomial5;
    }

    @Override
    public GenSolvablePolynomial<C> leftLcm(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.leftOreCond(genSolvablePolynomial, genSolvablePolynomial2);
        return genSolvablePolynomialArray[0].multiply(genSolvablePolynomial);
    }

    @Override
    public GenSolvablePolynomial<C> rightGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.isONE()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (genSolvablePolynomialRing.nvar <= 1) {
            GenSolvablePolynomial<C> genSolvablePolynomial3 = this.rightBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
            return genSolvablePolynomial3;
        }
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(1);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial2);
        GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4 = this.rightRecursiveUnivariateGcd(recSolvablePolynomial, recSolvablePolynomial2);
        GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, genSolvablePolynomial4);
        if (debug) {
            GenSolvablePolynomial<C> genSolvablePolynomial6 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial, genSolvablePolynomial5);
            GenSolvablePolynomial<C> genSolvablePolynomial7 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial2, genSolvablePolynomial5);
            if (!genSolvablePolynomial6.isZERO() || !genSolvablePolynomial7.isZERO()) {
                System.out.println("RI-fullGcd, D  = " + genSolvablePolynomial5);
                System.out.println("RI-fullGcd, P  = " + genSolvablePolynomial);
                System.out.println("RI-fullGcd, S  = " + genSolvablePolynomial2);
                System.out.println("RI-fullGcd, ps = " + genSolvablePolynomial6);
                System.out.println("RI-fullGcd, ss = " + genSolvablePolynomial7);
                throw new RuntimeException("RI-fullGcd: not divisible");
            }
            logger.info("RI-fullGcd(P,S) okay: D = {}", (Object)genSolvablePolynomial5);
        }
        return genSolvablePolynomial5;
    }

    @Override
    public GenSolvablePolynomial<C> rightLcm(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.rightOreCond(genSolvablePolynomial, genSolvablePolynomial2);
        return genSolvablePolynomial.multiply(genSolvablePolynomialArray[0]);
    }

    public GenSolvablePolynomial<C> leftGcd(List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("A may not be empty");
        }
        GenSolvablePolynomial<C> genSolvablePolynomial = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            GenSolvablePolynomial<C> genSolvablePolynomial2 = list.get(i);
            genSolvablePolynomial = this.leftGcd(genSolvablePolynomial, genSolvablePolynomial2);
        }
        return genSolvablePolynomial;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftCoPrime(List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        List<GenSolvablePolynomial<C>> list2 = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        GenSolvablePolynomial<C> genSolvablePolynomial = list.get(0);
        if (!genSolvablePolynomial.isZERO() && !genSolvablePolynomial.isConstant()) {
            for (int i = 1; i < list.size(); ++i) {
                GenSolvablePolynomial<C> genSolvablePolynomial2 = list.get(i);
                GenSolvablePolynomial<C> genSolvablePolynomial3 = this.leftGcd(genSolvablePolynomial, genSolvablePolynomial2);
                if (!genSolvablePolynomial3.isONE()) {
                    genSolvablePolynomial = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial, genSolvablePolynomial3);
                    genSolvablePolynomial2 = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial2, genSolvablePolynomial3);
                    GenSolvablePolynomial<C> genSolvablePolynomial4 = this.leftGcd(genSolvablePolynomial, genSolvablePolynomial3);
                    while (!genSolvablePolynomial4.isONE()) {
                        genSolvablePolynomial = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial, genSolvablePolynomial4);
                        genSolvablePolynomial3 = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial3, genSolvablePolynomial4);
                        list2.add(genSolvablePolynomial3);
                        genSolvablePolynomial3 = genSolvablePolynomial4;
                        genSolvablePolynomial4 = this.leftGcd(genSolvablePolynomial, genSolvablePolynomial4);
                    }
                    if (!genSolvablePolynomial3.isZERO() && !genSolvablePolynomial3.isConstant()) {
                        list2.add(genSolvablePolynomial3);
                    }
                }
                if (genSolvablePolynomial2.isZERO() || genSolvablePolynomial2.isConstant()) continue;
                list2.add(genSolvablePolynomial2);
            }
        } else {
            list2.addAll(list.subList(1, list.size()));
        }
        list2 = this.leftCoPrime(list2);
        if (!genSolvablePolynomial.isZERO() && !genSolvablePolynomial.isConstant()) {
            genSolvablePolynomial = (GenSolvablePolynomial<C>)genSolvablePolynomial.abs();
            list2.add(genSolvablePolynomial);
        }
        return list2;
    }

    public List<GenSolvablePolynomial<C>> leftCoPrimeRec(List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        List<GenSolvablePolynomial<C>> list2 = new ArrayList<GenSolvablePolynomial<C>>();
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list) {
            list2 = this.leftCoPrime(genSolvablePolynomial, list2);
        }
        return list2;
    }

    public List<GenSolvablePolynomial<C>> leftCoPrime(GenSolvablePolynomial<C> genSolvablePolynomial, List<GenSolvablePolynomial<C>> list) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO() || genSolvablePolynomial.isConstant()) {
            return list;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list.size() + 1);
        for (int i = 0; i < list.size(); ++i) {
            GenSolvablePolynomial<C> genSolvablePolynomial2 = list.get(i);
            GenSolvablePolynomial<C> genSolvablePolynomial3 = this.leftGcd(genSolvablePolynomial, genSolvablePolynomial2);
            if (!genSolvablePolynomial3.isONE()) {
                genSolvablePolynomial = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial, genSolvablePolynomial3);
                genSolvablePolynomial2 = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial2, genSolvablePolynomial3);
                GenSolvablePolynomial<C> genSolvablePolynomial4 = this.leftGcd(genSolvablePolynomial, genSolvablePolynomial3);
                while (!genSolvablePolynomial4.isONE()) {
                    genSolvablePolynomial = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial, genSolvablePolynomial4);
                    if (!(genSolvablePolynomial3 = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial3, genSolvablePolynomial4)).isZERO() && !genSolvablePolynomial3.isConstant()) {
                        arrayList.add(genSolvablePolynomial3);
                    }
                    genSolvablePolynomial3 = genSolvablePolynomial4;
                    genSolvablePolynomial4 = this.leftGcd(genSolvablePolynomial, genSolvablePolynomial4);
                }
                genSolvablePolynomial4 = this.leftGcd(genSolvablePolynomial2, genSolvablePolynomial3);
                while (!genSolvablePolynomial4.isONE()) {
                    genSolvablePolynomial2 = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial2, genSolvablePolynomial4);
                    if (!(genSolvablePolynomial3 = FDUtil.leftBasePseudoQuotient(genSolvablePolynomial3, genSolvablePolynomial4)).isZERO() && !genSolvablePolynomial3.isConstant()) {
                        arrayList.add(genSolvablePolynomial3);
                    }
                    genSolvablePolynomial3 = genSolvablePolynomial4;
                    genSolvablePolynomial4 = this.leftGcd(genSolvablePolynomial2, genSolvablePolynomial4);
                }
                if (!genSolvablePolynomial3.isZERO() && !genSolvablePolynomial3.isConstant()) {
                    arrayList.add(genSolvablePolynomial3);
                }
            }
            if (genSolvablePolynomial2.isZERO() || genSolvablePolynomial2.isConstant()) continue;
            arrayList.add(genSolvablePolynomial2);
        }
        if (!genSolvablePolynomial.isZERO() && !genSolvablePolynomial.isConstant()) {
            arrayList.add(genSolvablePolynomial);
        }
        return arrayList;
    }

    @Override
    public boolean isLeftCoPrime(List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        if (list.size() == 1) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            GenSolvablePolynomial<C> genSolvablePolynomial = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenSolvablePolynomial<C> genSolvablePolynomial2 = list.get(j);
                GenSolvablePolynomial<C> genSolvablePolynomial3 = this.leftGcd(genSolvablePolynomial, genSolvablePolynomial2);
                if (genSolvablePolynomial3.isONE()) continue;
                System.out.println("not co-prime, a: " + genSolvablePolynomial);
                System.out.println("not co-prime, b: " + genSolvablePolynomial2);
                System.out.println("not co-prime, g: " + genSolvablePolynomial3);
                return false;
            }
        }
        return true;
    }

    public boolean isLeftCoPrime(List<GenSolvablePolynomial<C>> list, List<GenSolvablePolynomial<C>> list2) {
        if (!this.isLeftCoPrime(list)) {
            return false;
        }
        if (list2 == null || list2.isEmpty()) {
            return true;
        }
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list2) {
            if (genSolvablePolynomial.isZERO() || genSolvablePolynomial.isConstant()) continue;
            boolean bl = false;
            for (GenSolvablePolynomial<C> genSolvablePolynomial2 : list) {
                GenSolvablePolynomial<C> genSolvablePolynomial3 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial, genSolvablePolynomial2);
                if (!genSolvablePolynomial3.isZERO()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            System.out.println("no divisor for: " + genSolvablePolynomial);
            return false;
        }
        return true;
    }

    public GenSolvablePolynomial<C>[] baseExtendedGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.baseHalfExtendedGcd(genSolvablePolynomial, genSolvablePolynomial2);
        GenSolvablePolynomial[] genSolvablePolynomialArray2 = new GenSolvablePolynomial[3];
        genSolvablePolynomialArray2[0] = genSolvablePolynomialArray[0];
        genSolvablePolynomialArray2[1] = genSolvablePolynomialArray[1];
        if (genSolvablePolynomialArray2[0].isZERO()) {
            genSolvablePolynomialArray2[1] = genSolvablePolynomial.ring.getZERO();
            genSolvablePolynomialArray2[2] = genSolvablePolynomial.ring.getZERO();
            return genSolvablePolynomialArray2;
        }
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomialArray[0].subtract(genSolvablePolynomialArray[1].multiply(genSolvablePolynomial));
        Object[] objectArray = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial3, genSolvablePolynomial2);
        if (!objectArray[1].isZERO()) {
            throw new RuntimeException("qr[1] != 0: " + Arrays.toString(objectArray));
        }
        genSolvablePolynomialArray2[2] = objectArray[0];
        return genSolvablePolynomialArray2;
    }

    public GenSolvablePolynomial<C>[] baseHalfExtendedGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        RingElem ringElem;
        Object object;
        if (genSolvablePolynomial == null || genSolvablePolynomial2 == null) {
            throw new IllegalArgumentException("null P or S not allowed");
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[]{null, null};
        if (genSolvablePolynomial2.isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial.ring.getONE();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial.isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial2;
            genSolvablePolynomialArray[1] = genSolvablePolynomial2.ring.getZERO();
            return genSolvablePolynomialArray;
        }
        if (genSolvablePolynomial.ring.nvar != 1) {
            throw new IllegalArgumentException("for univariate polynomials only " + genSolvablePolynomial.ring);
        }
        GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial3 = genSolvablePolynomial;
        Object object2 = genSolvablePolynomial2;
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)genSolvablePolynomial.ring.getONE()).copy();
        RingElem ringElem2 = ((GenSolvablePolynomial)genSolvablePolynomial.ring.getZERO()).copy();
        while (!((GenPolynomial)object2).isZERO()) {
            object = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial3, object2);
            genSolvablePolynomial3 = object[0];
            ringElem = (GenSolvablePolynomial)genPolynomial.subtract(genSolvablePolynomial3.multiply((GenPolynomial)ringElem2));
            genPolynomial = ringElem2;
            ringElem2 = ringElem;
            genSolvablePolynomial3 = object2;
            object2 = object[1];
        }
        object = (GcdRingElem)genSolvablePolynomial3.leadingBaseCoefficient();
        if (object.isUnit()) {
            ringElem = (GcdRingElem)object.inverse();
            genSolvablePolynomial3 = genSolvablePolynomial3.multiply(ringElem);
            genPolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(ringElem);
        }
        genSolvablePolynomialArray[0] = genSolvablePolynomial3;
        genSolvablePolynomialArray[1] = genPolynomial;
        return genSolvablePolynomialArray;
    }

    public GenSolvablePolynomial<C>[] baseGcdDiophant(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2, GenSolvablePolynomial<C> genSolvablePolynomial3) {
        GenSolvablePolynomial genSolvablePolynomial4;
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.baseExtendedGcd(genSolvablePolynomial, genSolvablePolynomial2);
        GenSolvablePolynomial<C> genSolvablePolynomial5 = genSolvablePolynomialArray[0];
        GenSolvablePolynomial<Object>[] genSolvablePolynomialArray2 = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial3, genSolvablePolynomial5);
        if (!genSolvablePolynomialArray2[1].isZERO()) {
            throw new ArithmeticException("not solvable, r = " + genSolvablePolynomialArray2[1] + ", c = " + genSolvablePolynomial3 + ", g = " + genSolvablePolynomial5);
        }
        GenSolvablePolynomial<C> genSolvablePolynomial6 = genSolvablePolynomialArray2[0];
        GenSolvablePolynomial<Object> genSolvablePolynomial7 = genSolvablePolynomialArray[1].multiply(genSolvablePolynomial6);
        GenSolvablePolynomial genSolvablePolynomial8 = genSolvablePolynomialArray[2].multiply(genSolvablePolynomial6);
        if (!genSolvablePolynomial7.isZERO() && genSolvablePolynomial7.degree(0) >= genSolvablePolynomial2.degree(0)) {
            genSolvablePolynomialArray2 = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial7, genSolvablePolynomial2);
            genSolvablePolynomial7 = genSolvablePolynomialArray2[1];
            genSolvablePolynomial8 = (GenSolvablePolynomial)genSolvablePolynomial8.sum(genSolvablePolynomial.multiply(genSolvablePolynomialArray2[0]));
        }
        GenSolvablePolynomial[] genSolvablePolynomialArray3 = new GenSolvablePolynomial[]{genSolvablePolynomial7, genSolvablePolynomial8};
        if (debug && !(genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomialArray3[0].multiply(genSolvablePolynomial).sum(genSolvablePolynomialArray3[1].multiply(genSolvablePolynomial2))).equals(genSolvablePolynomial3)) {
            System.out.println("P  = " + genSolvablePolynomial);
            System.out.println("S  = " + genSolvablePolynomial2);
            System.out.println("c  = " + genSolvablePolynomial3);
            System.out.println("a  = " + genSolvablePolynomial7);
            System.out.println("b  = " + genSolvablePolynomial8);
            System.out.println("y  = " + genSolvablePolynomial4);
            throw new ArithmeticException("not diophant, x = " + genSolvablePolynomial4.subtract(genSolvablePolynomial3));
        }
        return genSolvablePolynomialArray3;
    }

    public C[] leftOreCond(C gcdRingElem, C c) {
        if (gcdRingElem == null || gcdRingElem.isZERO() || c == null || c.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        Object[] objectArray = new GcdRingElem[2];
        if (gcdRingElem instanceof GenSolvablePolynomial && c instanceof GenSolvablePolynomial) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)((Object)gcdRingElem);
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)c;
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.leftOreCond(genSolvablePolynomial, genSolvablePolynomial2);
            objectArray[0] = (GcdRingElem)((Object)genSolvablePolynomialArray[0]);
            objectArray[1] = (GcdRingElem)((Object)genSolvablePolynomialArray[1]);
            return objectArray;
        }
        RingFactory<C> ringFactory = this.coFac;
        if (gcdRingElem.equals(c)) {
            objectArray[0] = (GcdRingElem)ringFactory.getONE();
            objectArray[1] = (GcdRingElem)ringFactory.getONE();
            logger.info("Ore multiple ==: {}", (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        if (gcdRingElem.equals(c.negate())) {
            objectArray[0] = (GcdRingElem)ringFactory.getONE();
            objectArray[1] = (GcdRingElem)((GcdRingElem)ringFactory.getONE()).negate();
            logger.info("Ore multiple ==-: {}", (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        if (ringFactory.isCommutative()) {
            GcdRingElem gcdRingElem2;
            if (debug) {
                logger.info("left Ore condition on coefficients, commutative case: {}, {}", gcdRingElem, c);
            }
            if ((gcdRingElem2 = (GcdRingElem)gcdRingElem.gcd(c)).isONE()) {
                objectArray[0] = c;
                objectArray[1] = gcdRingElem;
                if (objectArray[0].compareTo((GcdRingElem)ringFactory.getZERO()) < 0 && objectArray[1].compareTo((GcdRingElem)ringFactory.getZERO()) < 0) {
                    objectArray[0] = (GcdRingElem)objectArray[0].negate();
                    objectArray[1] = (GcdRingElem)objectArray[1].negate();
                }
                logger.info("Ore multiple: {}", (Object)Arrays.toString(objectArray));
                return objectArray;
            }
            GcdRingElem gcdRingElem3 = (GcdRingElem)gcdRingElem.multiply(c);
            GcdRingElem gcdRingElem4 = (GcdRingElem)gcdRingElem3.divide(gcdRingElem2).abs();
            objectArray[0] = (GcdRingElem)gcdRingElem4.divide(gcdRingElem);
            objectArray[1] = (GcdRingElem)gcdRingElem4.divide(c);
            if (objectArray[0].compareTo((GcdRingElem)ringFactory.getZERO()) < 0 && objectArray[1].compareTo((GcdRingElem)ringFactory.getZERO()) < 0) {
                objectArray[0] = (GcdRingElem)objectArray[0].negate();
                objectArray[1] = (GcdRingElem)objectArray[1].negate();
            }
            logger.info("Ore multiple: lcm={}, gcd={}, {}", (Object)gcdRingElem4, (Object)gcdRingElem2, (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        if (ringFactory.isField()) {
            logger.info("left Ore condition on coefficients, skew field {} case: {}, {}", ringFactory, gcdRingElem, c);
            objectArray[0] = (GcdRingElem)gcdRingElem.inverse();
            objectArray[1] = (GcdRingElem)c.inverse();
            logger.info("Ore multiple: {}", (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        if (c instanceof StarRingElem) {
            logger.info("left Ore condition on coefficients, StarRing case: {}, {}", gcdRingElem, c);
            GcdRingElem gcdRingElem5 = (GcdRingElem)((StarRingElem)c).conjugate();
            objectArray[0] = (GcdRingElem)gcdRingElem5.multiply(c);
            objectArray[1] = gcdRingElem.multiply((GcdRingElem)gcdRingElem5);
            logger.info("Ore multiple: {}", (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        throw new UnsupportedOperationException("leftOreCond not implemented for " + ringFactory.getClass() + ", rf = " + ringFactory.toScript());
    }

    public GenSolvablePolynomial<C>[] leftOreCond(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO() || genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        Object[] objectArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial.equals(genSolvablePolynomial2)) {
            objectArray[0] = genSolvablePolynomialRing.getONE();
            objectArray[1] = genSolvablePolynomialRing.getONE();
            return objectArray;
        }
        if (genSolvablePolynomial.equals(genSolvablePolynomial2.negate())) {
            objectArray[0] = genSolvablePolynomialRing.getONE();
            objectArray[1] = (GenSolvablePolynomial)genSolvablePolynomialRing.getONE().negate();
            return objectArray;
        }
        if (genSolvablePolynomialRing.isCommutative()) {
            logger.info("left Ore condition, polynomial commutative case: {}, {}", genSolvablePolynomial, genSolvablePolynomial2);
            edu.jas.ufd.GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract = GCDFactory.getImplementation(genSolvablePolynomialRing.coFac);
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)greatestCommonDivisorAbstract.lcm(genSolvablePolynomial, genSolvablePolynomial2);
            objectArray[0] = (GenSolvablePolynomial)PolyUtil.basePseudoDivide(genSolvablePolynomial3, genSolvablePolynomial);
            objectArray[1] = (GenSolvablePolynomial)PolyUtil.basePseudoDivide(genSolvablePolynomial3, genSolvablePolynomial2);
            logger.info("Ore multiple: {}, {}", (Object)genSolvablePolynomial3, (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        objectArray = this.syz.leftOreCond(genSolvablePolynomial, genSolvablePolynomial2);
        return objectArray;
    }

    public C[] rightOreCond(C c, C gcdRingElem) {
        if (c == null || c.isZERO() || gcdRingElem == null || gcdRingElem.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        Object[] objectArray = new GcdRingElem[2];
        if (c instanceof GenSolvablePolynomial && gcdRingElem instanceof GenSolvablePolynomial) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)c;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)((Object)gcdRingElem);
            GenSolvablePolynomial<C>[] genSolvablePolynomialArray = this.rightOreCond(genSolvablePolynomial, genSolvablePolynomial2);
            objectArray[0] = (GcdRingElem)((Object)genSolvablePolynomialArray[0]);
            objectArray[1] = (GcdRingElem)((Object)genSolvablePolynomialArray[1]);
            return objectArray;
        }
        RingFactory<C> ringFactory = this.coFac;
        if (c.equals(gcdRingElem)) {
            objectArray[0] = (GcdRingElem)ringFactory.getONE();
            objectArray[1] = (GcdRingElem)ringFactory.getONE();
            return objectArray;
        }
        if (c.equals(gcdRingElem.negate())) {
            objectArray[0] = (GcdRingElem)ringFactory.getONE();
            objectArray[1] = (GcdRingElem)((GcdRingElem)ringFactory.getONE()).negate();
            return objectArray;
        }
        if (ringFactory.isCommutative()) {
            logger.info("right Ore condition on coefficients, commutative case: {}, {}", c, gcdRingElem);
            GcdRingElem gcdRingElem2 = (GcdRingElem)c.gcd(gcdRingElem);
            if (gcdRingElem2.isONE()) {
                objectArray[0] = gcdRingElem;
                objectArray[1] = c;
                if (objectArray[0].compareTo((GcdRingElem)ringFactory.getZERO()) < 0 && objectArray[1].compareTo((GcdRingElem)ringFactory.getZERO()) < 0) {
                    objectArray[0] = (GcdRingElem)objectArray[0].negate();
                    objectArray[1] = (GcdRingElem)objectArray[1].negate();
                }
                return objectArray;
            }
            GcdRingElem gcdRingElem3 = (GcdRingElem)c.multiply(gcdRingElem);
            GcdRingElem gcdRingElem4 = (GcdRingElem)gcdRingElem3.divide(gcdRingElem2).abs();
            objectArray[0] = (GcdRingElem)gcdRingElem4.divide(c);
            objectArray[1] = (GcdRingElem)gcdRingElem4.divide(gcdRingElem);
            if (objectArray[0].compareTo((GcdRingElem)ringFactory.getZERO()) < 0 && objectArray[1].compareTo((GcdRingElem)ringFactory.getZERO()) < 0) {
                objectArray[0] = (GcdRingElem)objectArray[0].negate();
                objectArray[1] = (GcdRingElem)objectArray[1].negate();
            }
            logger.info("Ore multiple: {}, {}", (Object)gcdRingElem4, (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        if (ringFactory.isField()) {
            logger.info("right Ore condition on coefficients, skew field {} case: {}, {}", ringFactory, c, gcdRingElem);
            objectArray[0] = (GcdRingElem)c.inverse();
            objectArray[1] = (GcdRingElem)gcdRingElem.inverse();
            logger.info("Ore multiple: {}", (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        if (gcdRingElem instanceof StarRingElem) {
            logger.info("right Ore condition on coefficients, StarRing case: {}, {}", c, gcdRingElem);
            GcdRingElem gcdRingElem5 = (GcdRingElem)((StarRingElem)((Object)gcdRingElem)).conjugate();
            objectArray[0] = gcdRingElem.multiply((GcdRingElem)gcdRingElem5);
            objectArray[1] = (GcdRingElem)gcdRingElem5.multiply(c);
            logger.info("Ore multiple: {}", (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        throw new UnsupportedOperationException("rightOreCond not implemented for " + ringFactory.getClass() + ", rf = {}" + ringFactory.toScript());
    }

    public GenSolvablePolynomial<C>[] rightOreCond(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO() || genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            throw new IllegalArgumentException("a and b must be non zero");
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        Object[] objectArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial.equals(genSolvablePolynomial2)) {
            objectArray[0] = genSolvablePolynomialRing.getONE();
            objectArray[1] = genSolvablePolynomialRing.getONE();
            return objectArray;
        }
        if (genSolvablePolynomial.equals(genSolvablePolynomial2.negate())) {
            objectArray[0] = genSolvablePolynomialRing.getONE();
            objectArray[1] = (GenSolvablePolynomial)genSolvablePolynomialRing.getONE().negate();
            return objectArray;
        }
        if (genSolvablePolynomialRing.isCommutative()) {
            logger.info("right Ore condition, polynomial commutative case: {}, {}", genSolvablePolynomial, genSolvablePolynomial2);
            edu.jas.ufd.GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract = GCDFactory.getImplementation(genSolvablePolynomialRing.coFac);
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)greatestCommonDivisorAbstract.lcm(genSolvablePolynomial, genSolvablePolynomial2);
            objectArray[0] = (GenSolvablePolynomial)PolyUtil.basePseudoDivide(genSolvablePolynomial3, genSolvablePolynomial);
            objectArray[1] = (GenSolvablePolynomial)PolyUtil.basePseudoDivide(genSolvablePolynomial3, genSolvablePolynomial2);
            logger.info("Ore multiple: {}, {}", (Object)genSolvablePolynomial3, (Object)Arrays.toString(objectArray));
            return objectArray;
        }
        objectArray = this.syz.rightOreCond(genSolvablePolynomial, genSolvablePolynomial2);
        return objectArray;
    }

    public boolean isLeftOreCond(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2, GenSolvablePolynomial<C> genSolvablePolynomial3, GenSolvablePolynomial<C> genSolvablePolynomial4) {
        return this.syz.isLeftOreCond(genSolvablePolynomial, genSolvablePolynomial2, genSolvablePolynomial3, genSolvablePolynomial4);
    }

    public boolean isRightOreCond(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2, GenSolvablePolynomial<C> genSolvablePolynomial3, GenSolvablePolynomial<C> genSolvablePolynomial4) {
        return this.syz.isRightOreCond(genSolvablePolynomial, genSolvablePolynomial2, genSolvablePolynomial3, genSolvablePolynomial4);
    }

    public GenSolvablePolynomial<C>[] leftGcdCofactors(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        logger.info("leftGCD_in: {}, {}", genSolvablePolynomial, genSolvablePolynomial2);
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[]{this.leftGcd(genSolvablePolynomial, genSolvablePolynomial2), genSolvablePolynomial, genSolvablePolynomial2};
        if (genSolvablePolynomialArray[0].isONE()) {
            return genSolvablePolynomialArray;
        }
        logger.info("leftGCD_out: {}", (Object)genSolvablePolynomialArray[0]);
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = FDUtil.rightBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomialArray[0]);
        if (!genSolvablePolynomialArray2[1].isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray3 = FDUtil.rightBasePseudoQuotientRemainder(genSolvablePolynomial2, genSolvablePolynomialArray[0]);
        if (!genSolvablePolynomialArray3[1].isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        genSolvablePolynomialArray[1] = genSolvablePolynomialArray2[0];
        genSolvablePolynomialArray[2] = genSolvablePolynomialArray3[0];
        return genSolvablePolynomialArray;
    }

    public GenSolvablePolynomial<C>[] rightGcdCofactors(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        logger.info("rightGCD_in: {}, {}", genSolvablePolynomial, genSolvablePolynomial2);
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[]{this.rightGcd(genSolvablePolynomial, genSolvablePolynomial2), genSolvablePolynomial, genSolvablePolynomial2};
        if (genSolvablePolynomialArray[0].isONE()) {
            return genSolvablePolynomialArray;
        }
        logger.info("rightGCD_out: {}", (Object)genSolvablePolynomialArray[0]);
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial, genSolvablePolynomialArray[0]);
        if (!genSolvablePolynomialArray2[1].isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray3 = FDUtil.leftBasePseudoQuotientRemainder(genSolvablePolynomial2, genSolvablePolynomialArray[0]);
        if (!genSolvablePolynomialArray3[1].isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        genSolvablePolynomialArray[1] = genSolvablePolynomialArray2[0];
        genSolvablePolynomialArray[2] = genSolvablePolynomialArray3[0];
        return genSolvablePolynomialArray;
    }
}

