/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.fd.GreatestCommonDivisorFake;
import edu.jas.fd.GreatestCommonDivisorPrimitive;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.fd.SGCDFactory;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SGCDParallelProxyTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenSolvablePolynomialRing<BigRational> dfac;
    RecSolvablePolynomialRing<BigRational> rfac;
    BigRational ai;
    BigRational bi;
    BigRational ci;
    BigRational di;
    BigRational ei;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    GenSolvablePolynomial<GenPolynomial<BigRational>> ar;
    GenSolvablePolynomial<GenPolynomial<BigRational>> br;
    GenSolvablePolynomial<GenPolynomial<BigRational>> cr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> dr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> er;
    int rl = 5;
    int kl = 5;
    int ll = 7;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SGCDParallelProxyTest.suite());
        ComputerThreads.terminate();
    }

    public SGCDParallelProxyTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SGCDParallelProxyTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        String[] stringArray = new String[]{"a1", "a2", "a3", "a4"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.rfac = null;
    }

    public void testBigRational() {
        BigRational bigRational = new BigRational();
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = SGCDFactory.getProxy(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd_par != null " + greatestCommonDivisorAbstract), (greatestCommonDivisorAbstract != null ? 1 : 0) != 0);
        GreatestCommonDivisorFake<BigRational> greatestCommonDivisorFake = new GreatestCommonDivisorFake<BigRational>(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd != null " + greatestCommonDivisorFake), (greatestCommonDivisorFake != null ? 1 : 0) != 0);
        this.dfac = new GenSolvablePolynomialRing<BigRational>(bigRational, 4, this.to);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl + i * 10, this.ll + i, this.el, this.q);
            this.b = this.dfac.random(this.kl + i * 10, this.ll + i, this.el, this.q);
            this.c = this.dfac.random(this.kl + 2, this.ll, this.el, this.q);
            this.c = (GenSolvablePolynomial)greatestCommonDivisorFake.leftPrimitivePart(this.c).abs();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            SGCDParallelProxyTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            long l = System.currentTimeMillis();
            this.d = greatestCommonDivisorAbstract.leftGcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            this.e = FDUtil.leftBaseSparsePseudoRemainder(this.d, this.c);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            this.c = (GenSolvablePolynomial)greatestCommonDivisorFake.rightPrimitivePart(this.c).abs();
            this.a = this.c.multiply((BigRational)((Object)this.a));
            this.b = this.c.multiply((BigRational)((Object)this.b));
            l = System.currentTimeMillis();
            this.d = greatestCommonDivisorAbstract.rightGcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            this.e = FDUtil.rightBaseSparsePseudoRemainder(this.d, this.c);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GreatestCommonDivisorAbstract<ModInteger> greatestCommonDivisorAbstract = SGCDFactory.getProxy(modIntegerRing);
        SGCDParallelProxyTest.assertTrue((String)("fd_par != null " + greatestCommonDivisorAbstract), (greatestCommonDivisorAbstract != null ? 1 : 0) != 0);
        GreatestCommonDivisorFake<ModInteger> greatestCommonDivisorFake = new GreatestCommonDivisorFake<ModInteger>(modIntegerRing);
        SGCDParallelProxyTest.assertTrue((String)("fd != null " + greatestCommonDivisorFake), (greatestCommonDivisorFake != null ? 1 : 0) != 0);
        GenSolvablePolynomialRing<ModInteger> genSolvablePolynomialRing = new GenSolvablePolynomialRing<ModInteger>(modIntegerRing, 4, this.to);
        for (int i = 0; i < 1; ++i) {
            GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial = genSolvablePolynomialRing.random(this.kl + i * 2, this.ll + i, this.el, this.q);
            GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial2 = genSolvablePolynomialRing.random(this.kl + i * 2, this.ll + i, this.el, this.q);
            GenPolynomial genPolynomial = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
            genPolynomial = (GenSolvablePolynomial)greatestCommonDivisorFake.leftPrimitivePart((GenSolvablePolynomial<ModInteger>)genPolynomial).abs();
            if (genSolvablePolynomial.isZERO() || genSolvablePolynomial2.isZERO() || genPolynomial.isZERO()) continue;
            SGCDParallelProxyTest.assertTrue((String)("length( c" + i + " ) <> 0"), (genPolynomial.length() > 0 ? 1 : 0) != 0);
            genSolvablePolynomial = genSolvablePolynomial.multiply(genPolynomial);
            genSolvablePolynomial2 = genSolvablePolynomial2.multiply(genPolynomial);
            long l = System.currentTimeMillis();
            GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial3 = greatestCommonDivisorAbstract.leftGcd(genSolvablePolynomial, genSolvablePolynomial2);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial4 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial3, genPolynomial);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ac,bc) " + genSolvablePolynomial4 + ", " + genSolvablePolynomial3 + ", " + (GenSolvablePolynomial)genPolynomial), (boolean)genSolvablePolynomial4.isZERO());
            genPolynomial = (GenSolvablePolynomial)greatestCommonDivisorFake.rightPrimitivePart((GenSolvablePolynomial<ModInteger>)genPolynomial).abs();
            genSolvablePolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(genSolvablePolynomial);
            genSolvablePolynomial2 = ((GenSolvablePolynomial)genPolynomial).multiply(genSolvablePolynomial2);
            l = System.currentTimeMillis();
            genSolvablePolynomial3 = greatestCommonDivisorAbstract.rightGcd(genSolvablePolynomial, genSolvablePolynomial2);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            genSolvablePolynomial4 = FDUtil.rightBaseSparsePseudoRemainder(genSolvablePolynomial3, genPolynomial);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ac,bc) " + genSolvablePolynomial4), (boolean)genSolvablePolynomial4.isZERO());
        }
    }

    public void testBigInteger() {
        BigInteger bigInteger = new BigInteger();
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = SGCDFactory.getImplementation(bigInteger);
        SGCDParallelProxyTest.assertTrue((String)("fd = Primitive " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorPrimitive));
    }

    public void testBigComplex() {
        BigComplex bigComplex = new BigComplex();
        GreatestCommonDivisorAbstract<BigComplex> greatestCommonDivisorAbstract = SGCDFactory.getImplementation(bigComplex);
        SGCDParallelProxyTest.assertTrue((String)("fd != Simple " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSimple));
    }

    public void testBigRationalBase() {
        BigRational bigRational = new BigRational();
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = SGCDFactory.getProxy(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd_par != null " + greatestCommonDivisorAbstract), (greatestCommonDivisorAbstract != null ? 1 : 0) != 0);
        GreatestCommonDivisorFake<BigRational> greatestCommonDivisorFake = new GreatestCommonDivisorFake<BigRational>(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd != null " + greatestCommonDivisorFake), (greatestCommonDivisorFake != null ? 1 : 0) != 0);
        boolean bl = true;
        this.dfac = new GenSolvablePolynomialRing<BigRational>(bigRational, 1, this.to);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl + i * 10, this.ll + i, this.el, this.q);
            this.b = this.dfac.random(this.kl + i * 10, this.ll + i, this.el, this.q);
            this.c = this.dfac.random(this.kl + 2, this.ll, this.el, this.q);
            this.c = (GenSolvablePolynomial)greatestCommonDivisorFake.leftPrimitivePart(this.c).abs();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            SGCDParallelProxyTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            long l = System.currentTimeMillis();
            this.d = greatestCommonDivisorAbstract.leftBaseGcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            this.e = FDUtil.leftBaseSparsePseudoRemainder(this.d, this.c);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            this.c = (GenSolvablePolynomial)greatestCommonDivisorFake.rightPrimitivePart(this.c).abs();
            this.a = this.c.multiply((BigRational)((Object)this.a));
            this.b = this.c.multiply((BigRational)((Object)this.b));
            l = System.currentTimeMillis();
            this.d = greatestCommonDivisorAbstract.rightBaseGcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            this.e = FDUtil.rightBaseSparsePseudoRemainder(this.d, this.c);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testBigRationalLeftRecursiveUniv() {
        BigRational bigRational = new BigRational();
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = SGCDFactory.getProxy(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd_par != null " + greatestCommonDivisorAbstract), (greatestCommonDivisorAbstract != null ? 1 : 0) != 0);
        GreatestCommonDivisorFake<BigRational> greatestCommonDivisorFake = new GreatestCommonDivisorFake<BigRational>(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd != null " + greatestCommonDivisorFake), (greatestCommonDivisorFake != null ? 1 : 0) != 0);
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl + i, this.ll, this.el, this.q);
            this.br = this.rfac.random(this.kl + i, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = (GenSolvablePolynomial)greatestCommonDivisorFake.leftRecursivePrimitivePart(this.cr).abs();
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            SGCDParallelProxyTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.ar = this.ar.multiply((GenPolynomial<BigRational>)this.cr);
            this.br = this.br.multiply((GenPolynomial<BigRational>)this.cr);
            long l = System.currentTimeMillis();
            this.dr = greatestCommonDivisorAbstract.leftRecursiveUnivariateGcd(this.ar, this.br);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            this.er = FDUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ac,bc) " + this.cr + " ~| " + this.dr), (this.er.isZERO() || this.dr.isONE() ? 1 : 0) != 0);
        }
    }

    public void testBigRationalRightRecursiveUniv() {
        BigRational bigRational = new BigRational();
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = SGCDFactory.getProxy(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd_par != null " + greatestCommonDivisorAbstract), (greatestCommonDivisorAbstract != null ? 1 : 0) != 0);
        GreatestCommonDivisorFake<BigRational> greatestCommonDivisorFake = new GreatestCommonDivisorFake<BigRational>(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd != null " + greatestCommonDivisorFake), (greatestCommonDivisorFake != null ? 1 : 0) != 0);
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl + i, this.ll, this.el, this.q);
            this.br = this.rfac.random(this.kl + i, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            SGCDParallelProxyTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.cr = (GenSolvablePolynomial)greatestCommonDivisorFake.rightRecursivePrimitivePart(this.cr).abs();
            this.ar = this.cr.multiply((GenPolynomial<BigRational>)this.ar);
            this.br = this.cr.multiply((GenPolynomial<BigRational>)this.br);
            long l = System.currentTimeMillis();
            this.dr = greatestCommonDivisorAbstract.rightRecursiveUnivariateGcd(this.ar, this.br);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            this.er = FDUtil.recursiveRightSparsePseudoRemainder(this.dr, this.cr);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ca,cb) " + this.cr + " ~| " + this.dr), (this.er.isZERO() || this.dr.isONE() ? 1 : 0) != 0);
        }
    }

    public void testBigRationalLeftRecursive() {
        BigRational bigRational = new BigRational();
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(2);
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = SGCDFactory.getProxy(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd_par != null " + greatestCommonDivisorAbstract), (greatestCommonDivisorAbstract != null ? 1 : 0) != 0);
        GreatestCommonDivisorFake<BigRational> greatestCommonDivisorFake = new GreatestCommonDivisorFake<BigRational>(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd != null " + greatestCommonDivisorFake), (greatestCommonDivisorFake != null ? 1 : 0) != 0);
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl + i, this.ll, this.el, this.q);
            this.br = this.rfac.random(this.kl + i, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = (GenSolvablePolynomial)greatestCommonDivisorFake.leftRecursivePrimitivePart(this.cr).abs();
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            SGCDParallelProxyTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.ar = this.ar.multiply((GenPolynomial<BigRational>)this.cr);
            this.br = this.br.multiply((GenPolynomial<BigRational>)this.cr);
            long l = System.currentTimeMillis();
            this.dr = greatestCommonDivisorAbstract.leftRecursiveGcd(this.ar, this.br);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            this.er = FDUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ac,bc) " + this.cr + " ~| " + this.dr), (this.er.isZERO() || this.dr.isONE() ? 1 : 0) != 0);
        }
    }

    public void testBigRationalRightRecursive() {
        BigRational bigRational = new BigRational();
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(2);
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = SGCDFactory.getProxy(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd_par != null " + greatestCommonDivisorAbstract), (greatestCommonDivisorAbstract != null ? 1 : 0) != 0);
        GreatestCommonDivisorFake<BigRational> greatestCommonDivisorFake = new GreatestCommonDivisorFake<BigRational>(bigRational);
        SGCDParallelProxyTest.assertTrue((String)("fd != null " + greatestCommonDivisorFake), (greatestCommonDivisorFake != null ? 1 : 0) != 0);
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl + i, this.ll, this.el, this.q);
            this.br = this.rfac.random(this.kl + i, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = (GenSolvablePolynomial)greatestCommonDivisorFake.rightRecursivePrimitivePart(this.cr).abs();
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            SGCDParallelProxyTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.ar = this.cr.multiply((GenPolynomial<BigRational>)this.ar);
            this.br = this.cr.multiply((GenPolynomial<BigRational>)this.br);
            long l = System.currentTimeMillis();
            this.dr = greatestCommonDivisorAbstract.rightRecursiveGcd(this.ar, this.br);
            l = System.currentTimeMillis() - l;
            SGCDParallelProxyTest.assertTrue((String)("time >= 0: " + l), (l >= 0L ? 1 : 0) != 0);
            this.er = FDUtil.recursiveRightSparsePseudoRemainder(this.dr, this.cr);
            SGCDParallelProxyTest.assertTrue((String)("c | gcd(ca,cb) " + this.cr + " ~| " + this.dr), (this.er.isZERO() || this.dr.isONE() ? 1 : 0) != 0);
        }
    }
}

