/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigRational;
import edu.jas.fd.SolvableQuotient;
import edu.jas.fd.SolvableQuotientRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolvableQuotientTest
extends TestCase {
    SolvableQuotientRing<BigRational> zFac;
    SolvableQuotientRing<BigRational> efac;
    GenSolvablePolynomialRing<BigRational> mfac;
    SolvableQuotient<BigRational> a;
    SolvableQuotient<BigRational> b;
    SolvableQuotient<BigRational> c;
    SolvableQuotient<BigRational> d;
    SolvableQuotient<BigRational> e;
    SolvableQuotient<BigRational> az;
    SolvableQuotient<BigRational> bz;
    SolvableQuotient<BigRational> cz;
    SolvableQuotient<BigRational> dz;
    SolvableQuotient<BigRational> ez;
    int rl = 4;
    int kl = 2;
    int ll = 3;
    int el = 2;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SolvableQuotientTest.suite());
    }

    public SolvableQuotientTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableQuotientTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.mfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.rl, termOrder, stringArray);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.mfac);
        this.efac = new SolvableQuotientRing<BigRational>(this.mfac);
        this.zFac = new SolvableQuotientRing<BigRational>(this.mfac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.efac = null;
        this.zFac = null;
        ComputerThreads.terminate();
    }

    public void testConstruction() {
        String string = this.efac.toScript();
        SolvableQuotientTest.assertTrue((String)("SRF in efac: " + string), (string.indexOf("SRF") >= 0 ? 1 : 0) != 0);
        string = this.efac.toString();
        SolvableQuotientTest.assertTrue((String)("RatFunc in efac: " + string), (string.indexOf("RatFunc") >= 0 ? 1 : 0) != 0);
        int n = this.efac.hashCode();
        SolvableQuotientTest.assertTrue((String)"hashCode != 0", (n != 0 ? 1 : 0) != 0);
        this.c = this.efac.getONE();
        SolvableQuotientTest.assertTrue((String)"length( c ) = 1", (this.c.num.length() == 1 ? 1 : 0) != 0);
        SolvableQuotientTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        SolvableQuotientTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        string = this.c.toScript();
        SolvableQuotientTest.assertTrue((String)("1 in c: " + string), (string.indexOf("1") >= 0 ? 1 : 0) != 0);
        SolvableQuotientTest.assertTrue((String)("1 in c: " + string), (string.indexOf("1") >= 0 ? 1 : 0) != 0);
        this.d = this.efac.getZERO();
        SolvableQuotientTest.assertTrue((String)"length( d ) = 0", (this.d.num.length() == 0 ? 1 : 0) != 0);
        SolvableQuotientTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        SolvableQuotientTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (SolvableQuotient<BigRational> solvableQuotient : this.efac.generators()) {
            SolvableQuotientTest.assertFalse((String)"not isZERO( g )", (boolean)solvableQuotient.isZERO());
        }
        SolvableQuotientTest.assertTrue((String)"isAssociative: ", (boolean)this.efac.isAssociative());
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.efac.random(this.kl * i, this.ll + i / 2, this.el, this.q);
            if (this.a.isZERO() || this.a.isONE()) continue;
            SolvableQuotientTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.num.length() >= 0 ? 1 : 0) != 0);
            SolvableQuotientTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            SolvableQuotientTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            SolvableQuotientTest.assertEquals((String)"a == a: ", this.a, this.a);
            int n = this.a.hashCode();
            SolvableQuotientTest.assertTrue((String)"hashCode != 0", (n != 0 ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum((SolvableQuotient<BigRational>)this.efac.getZERO());
        this.d = this.a.subtract((SolvableQuotient<BigRational>)this.efac.getZERO());
        SolvableQuotientTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((SolvableQuotient)this.efac.getZERO()).sum(this.a);
        this.d = ((SolvableQuotient)this.efac.getZERO()).subtract(this.a.negate());
        SolvableQuotientTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        SolvableQuotientTest.assertEquals((String)("(a+b-b) == a: " + this.a + ", " + this.b), this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        SolvableQuotientTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = new SolvableQuotient<BigRational>(this.efac, (GenSolvablePolynomial<BigRational>)this.mfac.univariate(1, 2L));
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        SolvableQuotientTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
    }

    public void testMultiplication() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.multiply((BigRational)this.efac.getONE());
        this.d = ((SolvableQuotient)this.efac.getONE()).multiply(this.a);
        SolvableQuotientTest.assertEquals((String)"a*1 = 1*a", this.c, this.a);
        SolvableQuotientTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.c = new SolvableQuotient<BigRational>(this.efac, (GenSolvablePolynomial<BigRational>)this.mfac.univariate(1, 2L));
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        SolvableQuotientTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply((BigRational)((Object)this.a));
            SolvableQuotientTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
        this.c = new SolvableQuotient<BigRational>(this.efac, (GenSolvablePolynomial<BigRational>)this.mfac.univariate(1, 2L));
        GenSolvablePolynomial genSolvablePolynomial = this.c.num;
        this.d = this.a.multiply((BigRational)((Object)genSolvablePolynomial));
        this.e = this.a.multiply((BigRational)((Object)this.c));
        SolvableQuotientTest.assertEquals((String)"a*c.n = a*c", this.d, this.e);
        ExpVector expVector = genSolvablePolynomial.leadingExpVector();
        this.d = this.a.multiply(expVector);
        SolvableQuotientTest.assertEquals((String)"a*ldt(c.n) = a*c", this.d, this.e);
        BigRational bigRational = BigRational.ONE;
        bigRational = bigRational.sum(bigRational);
        this.d = this.a.multiply(bigRational);
        this.e = this.d.multiply(BigRational.HALF);
        SolvableQuotientTest.assertEquals((String)"a = (a*2)*1/2", this.a, this.e);
    }

    public void testAdditionGcd() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.az = new SolvableQuotient<BigRational>(this.zFac, this.a.num, this.a.den, true);
        this.bz = new SolvableQuotient<BigRational>(this.zFac, this.b.num, this.b.den, true);
        long l = System.currentTimeMillis();
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        this.d = this.d.monic();
        l = System.currentTimeMillis() - l;
        SolvableQuotientTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        long l2 = System.currentTimeMillis();
        this.cz = this.az.sum(this.bz);
        this.dz = this.cz.subtract(this.bz);
        this.dz = this.dz.monic();
        l2 = System.currentTimeMillis() - l2;
        SolvableQuotientTest.assertEquals((String)"a+b-b = a", this.az, this.dz);
        if (l2 >= 0L || l >= 0L) {
            return;
        }
        System.out.println("te = " + l);
        System.out.println("tz = " + l2);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        SolvableQuotientTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.cz = new SolvableQuotient<BigRational>(this.zFac, this.c.num, this.c.den, true);
        l = System.currentTimeMillis();
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        l = System.currentTimeMillis() - l;
        SolvableQuotientTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        l2 = System.currentTimeMillis();
        this.dz = this.cz.sum(this.az.sum(this.bz));
        this.ez = this.cz.sum(this.az).sum(this.bz);
        l2 = System.currentTimeMillis() - l2;
        SolvableQuotientTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.dz, this.ez);
        System.out.println("te = " + l);
        System.out.println("tz = " + l2);
        this.c = this.a.sum((SolvableQuotient<BigRational>)this.efac.getZERO());
        this.d = this.a.subtract((SolvableQuotient<BigRational>)this.efac.getZERO());
        SolvableQuotientTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((SolvableQuotient)this.efac.getZERO()).sum(this.a);
        this.d = ((SolvableQuotient)this.efac.getZERO()).subtract(this.a.negate());
        SolvableQuotientTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testParse() {
        this.a = this.efac.random(this.kl, this.ll, this.el + 1, this.q);
        PrettyPrint.setPretty();
        String string = this.a.toString();
        this.b = this.efac.parse(string);
        SolvableQuotientTest.assertEquals((String)"parse(a.toSting()) = a", this.a, this.b);
    }

    public void testEgcdFraction() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        SolvableQuotient<BigRational>[] solvableQuotientArray = this.a.egcd(this.b);
        SolvableQuotient<BigRational> solvableQuotient = solvableQuotientArray[0];
        SolvableQuotient<BigRational> solvableQuotient2 = solvableQuotientArray[1];
        SolvableQuotient<BigRational> solvableQuotient3 = solvableQuotientArray[2];
        this.c = this.a.multiply((BigRational)((Object)solvableQuotient2)).sum(this.b.multiply((BigRational)((Object)solvableQuotient3)));
        SolvableQuotientTest.assertEquals((String)("egcd[0] == c: " + solvableQuotient + "!=" + this.c), solvableQuotient, this.c);
        this.c = this.a.rightFraction();
        SolvableQuotientTest.assertTrue((String)("isRightFraction: " + this.a + "rf" + this.c), (boolean)this.a.isRightFraction(this.c));
    }
}

