/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseSeqIter<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseSeqIter.class);
    private static final boolean debug = logger.isDebugEnabled();

    public GroebnerBaseSeqIter() {
    }

    public GroebnerBaseSeqIter(Reduction<C> reduction) {
        super(reduction);
    }

    public GroebnerBaseSeqIter(PairList<C> pairList) {
        super(pairList);
    }

    public GroebnerBaseSeqIter(Reduction<C> reduction, PairList<C> pairList) {
        super(reduction, pairList);
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.monic(list2)).size() <= 1) {
            return list2;
        }
        list2 = OrderedPolynomialList.sort(list2);
        logger.info("G-sort = {}", list2);
        List<GenPolynomial<C>> list3 = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial : list2) {
            GenPolynomial<C> genPolynomial2;
            if (debug) {
                logger.info("p = {}", genPolynomial);
            }
            if ((genPolynomial2 = this.red.normalform(list3, genPolynomial)).isZERO() || (list3 = this.GB(n, list3, genPolynomial2)).size() <= 0 || !list3.get(0).isONE()) continue;
            return list3;
        }
        return list3;
    }

    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list);
        GenPolynomial<C> genPolynomial2 = genPolynomial.monic();
        if (arrayList.isEmpty()) {
            arrayList.add(genPolynomial2);
            return arrayList;
        }
        if (genPolynomial2.isZERO()) {
            return arrayList;
        }
        if (genPolynomial2.isONE()) {
            arrayList.clear();
            arrayList.add(genPolynomial2);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = ((GenPolynomial)arrayList.get((int)0)).ring;
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        list = arrayList;
        PairList<C> pairList = this.strategy.create(n, genPolynomialRing);
        pairList.setList(list);
        list.add(genPolynomial2);
        pairList.put(genPolynomial2);
        logger.info("start {}", pairList);
        while (pairList.hasNext()) {
            GenPolynomial genPolynomial3;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenPolynomial genPolynomial4 = pair.pi;
            GenPolynomial genPolynomial5 = pair.pj;
            if (debug) {
                logger.debug("pi    = {}", (Object)genPolynomial4);
                logger.debug("pj    = {}", (Object)genPolynomial5);
            }
            if ((genPolynomial3 = this.red.SPolynomial(genPolynomial4, genPolynomial5)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.debug("ht(S) = {}", (Object)genPolynomial3.leadingExpVector());
            }
            GenPolynomial<C> genPolynomial6 = this.red.normalform(list, genPolynomial3);
            if (debug) {
                logger.info("ht(H) = {}", genPolynomial6.monic());
            }
            if (genPolynomial6.isZERO()) {
                pair.setZero();
                continue;
            }
            genPolynomial6 = genPolynomial6.monic();
            if (debug) {
                logger.info("ht(H) = {}", (Object)genPolynomial6.leadingExpVector());
            }
            if ((genPolynomial6 = genPolynomial6.monic()).isONE()) {
                list.clear();
                list.add(genPolynomial6);
                pairList.putOne();
                logger.info("end {}", pairList);
                return list;
            }
            if (debug) {
                logger.info("H = {}", genPolynomial6);
            }
            if (genPolynomial6.length() <= 0) continue;
            list.add(genPolynomial6);
            pairList.put(genPolynomial6);
        }
        logger.debug("#sequential list = {}", (Object)list.size());
        list = this.minimalGB(list);
        logger.info("end {}", pairList);
        return list;
    }
}

