/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.OrderedWordPairlist;
import edu.jas.gb.WordGroebnerBaseAbstract;
import edu.jas.gb.WordPair;
import edu.jas.gb.WordPairList;
import edu.jas.gb.WordReduction;
import edu.jas.kern.LocalTimeStatus;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingElem;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WordGroebnerBaseSeq<C extends RingElem<C>>
extends WordGroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(WordGroebnerBaseSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final LocalTimeStatus timestatus = new LocalTimeStatus(true, 20000L, false);

    public WordGroebnerBaseSeq() {
    }

    public WordGroebnerBaseSeq(WordReduction<C> wordReduction) {
        super(wordReduction);
    }

    public WordGroebnerBaseSeq(WordReduction<C> wordReduction, WordPairList<C> wordPairList) {
        super(wordReduction, wordPairList);
    }

    @Override
    public List<GenWordPolynomial<C>> GB(List<GenWordPolynomial<C>> list) {
        List<GenWordPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolyUtil.wordMonic(list2)).size() <= 1) {
            return list2;
        }
        GenWordPolynomialRing genWordPolynomialRing = list2.get((int)0).ring;
        if (!genWordPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        OrderedWordPairlist orderedWordPairlist = (OrderedWordPairlist)this.strategy.create(genWordPolynomialRing);
        orderedWordPairlist.put(list2);
        logger.info("start {}", (Object)orderedWordPairlist);
        this.timestatus.restart();
        int n = 0;
        while (orderedWordPairlist.hasNext()) {
            List list3;
            WordPair wordPair = orderedWordPairlist.removeNext();
            if (wordPair == null) continue;
            GenWordPolynomial genWordPolynomial = wordPair.pi;
            GenWordPolynomial genWordPolynomial2 = wordPair.pj;
            if (debug) {
                logger.info("pi   = {}, pj = {}", genWordPolynomial, genWordPolynomial2);
            }
            if ((list3 = this.red.SPolynomials(genWordPolynomial, genWordPolynomial2)).isEmpty()) continue;
            for (GenWordPolynomial genWordPolynomial3 : list3) {
                if (genWordPolynomial3.isZERO()) continue;
                if (debug) {
                    logger.info("ht(S) = {}", (Object)genWordPolynomial3.leadingWord());
                }
                boolean bl = orderedWordPairlist.criterion3(wordPair.i, wordPair.j, genWordPolynomial3.leadingWord());
                GenWordPolynomial<C> genWordPolynomial4 = this.red.normalform(list2, genWordPolynomial3);
                if (debug) {
                    logger.info("ht(H) = {}", genWordPolynomial4.monic());
                }
                if (genWordPolynomial4.isZERO()) continue;
                if (!bl) {
                    logger.info("criterion3({},{}) wrong: {} --> {}", (Object)wordPair.i, (Object)wordPair.j, (Object)genWordPolynomial3.leadingWord(), (Object)genWordPolynomial4.leadingWord());
                }
                genWordPolynomial4 = genWordPolynomial4.monic();
                if (debug) {
                    logger.info("ht(H) = {}", (Object)genWordPolynomial4.leadingWord());
                }
                if (genWordPolynomial4.isONE()) {
                    list2.clear();
                    list2.add(genWordPolynomial4);
                    return list2;
                }
                if (debug) {
                    logger.info("H = {}", genWordPolynomial4);
                }
                if (genWordPolynomial4.length() > 0) {
                    list2.add(genWordPolynomial4);
                    orderedWordPairlist.put(genWordPolynomial4);
                }
                if (genWordPolynomial4.degree() > 9L) {
                    this.timestatus.checkTime("word GB degree > 9: " + genWordPolynomial4.degree());
                }
                if (!genWordPolynomial3.leadingWord().dependencyOnVariables().equals(genWordPolynomial4.leadingWord().dependencyOnVariables())) continue;
                logger.info("LT depend: {} --> {}", genWordPolynomial3.leadingWord().dependencyOnVariables(), genWordPolynomial4.leadingWord().dependencyOnVariables());
                logger.info("LT depend: {} --> {}", genWordPolynomial3, genWordPolynomial4);
                if (++n <= 500) continue;
                this.timestatus.checkTime("no convergence in word GB: > 500: " + n);
            }
        }
        list2 = this.minimalGB(list2);
        logger.info("end   {}", (Object)orderedWordPairlist);
        return list2;
    }
}

