/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolyModUtil {
    private static final Logger logger = LogManager.getLogger(PolyModUtil.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> syzLcm(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.isONE()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial;
        }
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(genSolvablePolynomial);
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(genSolvablePolynomial2);
        List<GenSolvablePolynomial<C>> list = PolyGBUtil.intersect(genSolvablePolynomialRing, arrayList, arrayList2);
        GenSolvablePolynomial<C> genSolvablePolynomial3 = null;
        for (GenSolvablePolynomial<C> genSolvablePolynomial4 : list) {
            if (genSolvablePolynomial4 == null || genSolvablePolynomial4.isZERO()) continue;
            if (genSolvablePolynomial3 == null) {
                genSolvablePolynomial3 = genSolvablePolynomial4;
                continue;
            }
            if (genSolvablePolynomial3.compareTo(genSolvablePolynomial4) <= 0) continue;
            genSolvablePolynomial3 = genSolvablePolynomial4;
        }
        if (genSolvablePolynomial3 == null) {
            throw new RuntimeException("this cannot happen: lcm == null: " + list);
        }
        return genSolvablePolynomial3;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> syzGcd(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        return PolyModUtil.syzLeftGcd(genSolvablePolynomialRing, genSolvablePolynomial, genSolvablePolynomial2);
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> syzLeftGcd(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial.isConstant()) {
            return genSolvablePolynomialRing.getONE();
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomialRing.getONE();
        }
        if (genSolvablePolynomial.totalDegree() > 3L || genSolvablePolynomial2.totalDegree() > 3L) {
            logger.warn("skipping GB computation: degs = {}, {}", (Object)genSolvablePolynomial.totalDegree(), (Object)genSolvablePolynomial2.totalDegree());
            return genSolvablePolynomialRing.getONE();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genSolvablePolynomial);
        arrayList.add(genSolvablePolynomial2);
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        logger.warn("left syzGcd computing GB: {}", arrayList);
        List list = solvableGroebnerBaseSeq.rightGB(arrayList);
        if (debug) {
            logger.info("G = {}", list);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        logger.warn("gcd not determined, set to 1: {}", list);
        return genSolvablePolynomialRing.getONE();
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> syzRightGcd(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial.isConstant()) {
            return genSolvablePolynomialRing.getONE();
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomialRing.getONE();
        }
        if (genSolvablePolynomial.totalDegree() > 3L || genSolvablePolynomial2.totalDegree() > 3L) {
            logger.warn("skipping GB computation: degs = {}, {}", (Object)genSolvablePolynomial.totalDegree(), (Object)genSolvablePolynomial2.totalDegree());
            return genSolvablePolynomialRing.getONE();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genSolvablePolynomial);
        arrayList.add(genSolvablePolynomial2);
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        logger.warn("right syzGcd computing GB: {}", arrayList);
        List list = solvableGroebnerBaseSeq.leftGB(arrayList);
        if (debug) {
            logger.info("G = {}", list);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        logger.warn("gcd not determined, set to 1: {}", list);
        return genSolvablePolynomialRing.getONE();
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] syzGcdCofactors(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[]{PolyModUtil.syzGcd(genSolvablePolynomialRing, genSolvablePolynomial, genSolvablePolynomial2), genSolvablePolynomial, genSolvablePolynomial2};
        if (genSolvablePolynomialArray[0].isONE()) {
            return genSolvablePolynomialArray;
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray2 = PolyGBUtil.quotientRemainder(genSolvablePolynomial, genSolvablePolynomialArray[0]);
        if (!genSolvablePolynomialArray2[1].isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        GenSolvablePolynomial<C>[] genSolvablePolynomialArray3 = PolyGBUtil.quotientRemainder(genSolvablePolynomial2, genSolvablePolynomialArray[0]);
        if (!genSolvablePolynomialArray3[1].isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomialRing.getONE();
            return genSolvablePolynomialArray;
        }
        genSolvablePolynomialArray[1] = genSolvablePolynomialArray2[0];
        genSolvablePolynomialArray[2] = genSolvablePolynomialArray3[0];
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> syzLcm(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(genPolynomial);
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(genPolynomial2);
        List<GenPolynomial<C>> list = PolyGBUtil.intersect(genPolynomialRing, arrayList, arrayList2);
        if (list.size() != 1) {
            logger.warn("lcm not unique: {}", list);
        }
        GenPolynomial<C> genPolynomial3 = list.get(0);
        return genPolynomial3;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> syzGcd(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial.isONE()) {
            return genPolynomial;
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial2;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = genPolynomial.multiply(genPolynomial2);
        GenPolynomial<C> genPolynomial4 = PolyModUtil.syzLcm(genPolynomialRing, genPolynomial, genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial3, genPolynomial4);
        return genPolynomial5;
    }
}

