/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gbufd.SGBFactory;
import edu.jas.gbufd.SolvableSyzygyAbstract;
import edu.jas.gbufd.SolvableSyzygySeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.RingElem;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolvableSyzygyTest
extends TestCase {
    BigRational cfac;
    GenSolvablePolynomialRing<BigRational> fac;
    PolynomialList<BigRational> F;
    List<GenSolvablePolynomial<BigRational>> G;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    GenSolvablePolynomial<BigRational> zero;
    GenSolvablePolynomial<BigRational> one;
    TermOrder tord;
    RelationTable table;
    List<GenSolvablePolynomial<BigRational>> L;
    List<List<GenSolvablePolynomial<BigRational>>> K;
    List<GenSolvablePolynomial<BigRational>> V;
    List<List<GenSolvablePolynomial<BigRational>>> W;
    ModuleList<BigRational> M;
    ModuleList<BigRational> N;
    ModuleList<BigRational> Z;
    SolvableGroebnerBaseAbstract<BigRational> sbb;
    SolvableGroebnerBase<BigRational> msbb;
    SolvableSyzygyAbstract<BigRational> ssz;
    int rl = 4;
    int kl = 3;
    int ll = 7;
    int el = 2;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SolvableSyzygyTest.suite());
    }

    public SolvableSyzygyTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableSyzygyTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.tord = new TermOrder();
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.fac = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, stringArray);
        this.table = this.fac.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.L = null;
        this.K = null;
        this.V = null;
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO());
        do {
            this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.b.isZERO());
        do {
            this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.c.isZERO());
        do {
            this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.d.isZERO());
        this.e = this.d;
        this.one = this.fac.getONE();
        this.zero = this.fac.getZERO();
        this.sbb = SGBFactory.getImplementation(this.cfac);
        this.msbb = new SolvableGroebnerBaseSeq<BigRational>();
        this.ssz = new SolvableSyzygySeq<BigRational>(this.cfac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.L = null;
        this.K = null;
        this.V = null;
        this.fac = null;
        this.tord = null;
        this.table = null;
        this.sbb = null;
        this.msbb = null;
        this.ssz = null;
    }

    public void testSequentialSolvableSyzygy() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c, d } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialWeylSolvableSyzygy() {
        int n = 4;
        this.fac = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.fac);
        this.table = this.fac.table;
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelations(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c, d } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialModSolvableSyzygy() {
        this.W = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        SolvableSyzygyTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.M));
        this.N = this.msbb.leftGB(this.M);
        SolvableSyzygyTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.N));
        this.Z = this.ssz.leftZeroRelations(this.N);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a) } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.N));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.N = this.msbb.leftGB(this.M);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.msbb.isLeftGB(this.N));
        this.Z = this.ssz.leftZeroRelations(this.N);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.N));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.N = this.msbb.leftGB(this.M);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a,b,c) } )", (boolean)this.msbb.isLeftGB(this.N));
        this.Z = this.ssz.leftZeroRelations(this.N);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a,b,c } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.N));
    }

    public void testSequentialArbitrarySyzygy() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableSyzygyTest.assertTrue((String)"isGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b, c, d } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialArbitrarySyzygyCLO() {
        PolynomialList polynomialList = null;
        String string = "Rat(x,y) G ( ( x y + x ), ( y^2 + 1 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            polynomialList = genPolynomialTokenizer.nextSolvablePolynomialSet();
        }
        catch (ClassCastException classCastException) {
            SolvableSyzygyTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            SolvableSyzygyTest.fail((String)("" + iOException));
        }
        this.L = polynomialList.castToSolvableList();
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialArbitrarySyzygyWA32() {
        PolynomialList polynomialList = null;
        String string = "Rat(e1,e2,e3) L RelationTable (  ( e3 ), ( e1 ), ( e1 e3 - e1 ),  ( e3 ), ( e2 ), ( e2 e3 - e2 ) )(  ( e1 e3^3 + e2^2 ),  ( e1^3 e2^2 + e3 ),  ( e3^3 + e3^2 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            polynomialList = genPolynomialTokenizer.nextSolvablePolynomialSet();
        }
        catch (ClassCastException classCastException) {
            SolvableSyzygyTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            SolvableSyzygyTest.fail((String)("" + iOException));
        }
        this.L = polynomialList.castToSolvableList();
        this.K = this.ssz.leftZeroRelationsArbitrary(this.L);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.K, this.L));
    }

    public void testSequentialArbitraryModSolvableSyzygy() {
        this.W = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        SolvableSyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        SolvableSyzygyTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.msbb.isLeftGB(this.M));
        this.Z = this.ssz.leftZeroRelationsArbitrary(this.M);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a) } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.M));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.Z = this.ssz.leftZeroRelationsArbitrary(this.M);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.M));
        SolvableSyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.Z = this.ssz.leftZeroRelationsArbitrary(this.M);
        SolvableSyzygyTest.assertTrue((String)"is ZR( { a,b,c } )", (boolean)this.ssz.isLeftZeroRelation(this.Z, this.M));
    }

    public void testOreConditions() {
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.fac);
        do {
            this.a = this.fac.random(this.kl, this.ll - 1, this.el, this.q);
        } while (this.a.isZERO());
        do {
            this.b = this.fac.random(this.kl, this.ll - 1, this.el, this.q);
        } while (this.b.isZERO());
        GenSolvablePolynomial<BigRational>[] genSolvablePolynomialArray = this.ssz.leftOreCond(this.a, this.b);
        this.c = genSolvablePolynomialArray[0].multiply((BigRational)((Object)this.a));
        this.d = genSolvablePolynomialArray[1].multiply((BigRational)((Object)this.b));
        SolvableSyzygyTest.assertEquals((String)"c_0 * a = c_1 * b: ", this.c, this.d);
        SolvableSyzygyTest.assertTrue((String)"left Ore condition: ", (boolean)this.ssz.isLeftOreCond(this.a, this.b, genSolvablePolynomialArray));
        genSolvablePolynomialArray = this.ssz.rightOreCond(this.a, this.b);
        this.c = this.a.multiply((BigRational)((Object)genSolvablePolynomialArray[0]));
        this.d = this.b.multiply((BigRational)((Object)genSolvablePolynomialArray[1]));
        SolvableSyzygyTest.assertEquals((String)"a * c_0 = b * c_1: ", this.c, this.d);
        SolvableSyzygyTest.assertTrue((String)"right Ore condition: ", (boolean)this.ssz.isRightOreCond(this.a, this.b, genSolvablePolynomialArray));
    }

    public void testResidueOreConditions() {
        GenSolvablePolynomial<BigRational> genSolvablePolynomial;
        GenSolvablePolynomial<BigRational> genSolvablePolynomial22;
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.fac);
        this.F = new PolynomialList<BigRational>((GenPolynomialRing<BigRational>)this.fac, this.fac.generators());
        List<GenSolvablePolynomial<BigRational>> list = this.F.castToSolvableList();
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>(list.size() - 1);
        long l = 2L;
        for (GenSolvablePolynomial<BigRational> genSolvablePolynomial22 : list) {
            if (genSolvablePolynomial22.isONE()) continue;
            genSolvablePolynomial = genSolvablePolynomial22.multiply((BigRational)((Object)genSolvablePolynomial22));
            genSolvablePolynomial = (GenSolvablePolynomial<BigRational>)genSolvablePolynomial.subtract((BigRational)((Object)((GenSolvablePolynomial<BigRational>)this.fac.fromInteger(l++))));
            this.L.add(genSolvablePolynomial);
        }
        do {
            this.a = this.fac.random(this.kl, this.ll - 2, this.el, this.q);
        } while (this.a.isZERO());
        do {
            this.b = this.fac.random(this.kl, this.ll - 2, this.el, this.q);
        } while (this.b.isZERO());
        GenSolvablePolynomial<BigRational>[] genSolvablePolynomialArray = this.ssz.leftOreCond(this.a, this.b);
        this.c = genSolvablePolynomialArray[0].multiply((BigRational)((Object)this.a));
        this.d = genSolvablePolynomialArray[1].multiply((BigRational)((Object)this.b));
        SolvableSyzygyTest.assertEquals((String)"c_0 * a = c_1 * b: ", this.c, this.d);
        SolvableSyzygyTest.assertTrue((String)"left Ore condition: ", (boolean)this.ssz.isLeftOreCond(this.a, this.b, genSolvablePolynomialArray));
        genSolvablePolynomial22 = this.sbb.sred.leftNormalform(this.L, this.a);
        genSolvablePolynomial = this.sbb.sred.leftNormalform(this.L, this.b);
        GenSolvablePolynomial<GenSolvablePolynomial<BigRational>> genSolvablePolynomial3 = genSolvablePolynomialArray[0].multiply((BigRational)((Object)genSolvablePolynomial22));
        GenSolvablePolynomial<GenSolvablePolynomial<BigRational>> genSolvablePolynomial4 = genSolvablePolynomialArray[1].multiply((BigRational)((Object)genSolvablePolynomial));
        genSolvablePolynomial3 = this.sbb.sred.leftNormalform(this.L, genSolvablePolynomial3);
        genSolvablePolynomial4 = this.sbb.sred.leftNormalform(this.L, genSolvablePolynomial4);
        SolvableSyzygyTest.assertEquals((String)"cr_0 * ar = cr_1 * br: ", genSolvablePolynomial3, genSolvablePolynomial4);
        GenSolvablePolynomial<BigRational> genSolvablePolynomial5 = this.sbb.sred.leftNormalform(this.L, genSolvablePolynomialArray[0]);
        GenSolvablePolynomial<BigRational> genSolvablePolynomial6 = this.sbb.sred.leftNormalform(this.L, genSolvablePolynomialArray[1]);
        genSolvablePolynomial3 = genSolvablePolynomial5.multiply((BigRational)((Object)genSolvablePolynomial22));
        genSolvablePolynomial4 = genSolvablePolynomial6.multiply((BigRational)((Object)genSolvablePolynomial));
        genSolvablePolynomialArray[0] = genSolvablePolynomial5;
        genSolvablePolynomialArray[1] = genSolvablePolynomial6;
        genSolvablePolynomialArray = this.ssz.leftOreCond(genSolvablePolynomial22, genSolvablePolynomial);
        genSolvablePolynomial3 = genSolvablePolynomialArray[0].multiply((BigRational)((Object)genSolvablePolynomial22));
        genSolvablePolynomial4 = genSolvablePolynomialArray[1].multiply((BigRational)((Object)genSolvablePolynomial));
        SolvableSyzygyTest.assertEquals((String)"c_0 * a = c_1 * b: ", genSolvablePolynomial3, genSolvablePolynomial4);
        genSolvablePolynomial3 = this.sbb.sred.leftNormalform(this.L, genSolvablePolynomial3);
        genSolvablePolynomial4 = this.sbb.sred.leftNormalform(this.L, genSolvablePolynomial4);
        SolvableSyzygyTest.assertEquals((String)"cr_0 * ar = cr_1 * br: ", genSolvablePolynomial3, genSolvablePolynomial4);
    }

    public void testOreConditionsQuat() {
        GenPolynomial genPolynomial;
        GenPolynomial genPolynomial2;
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        GenSolvablePolynomialRing<BigQuaternion> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigQuaternion>(bigQuaternionRing, this.fac);
        SolvableSyzygySeq<BigQuaternion> solvableSyzygySeq = new SolvableSyzygySeq<BigQuaternion>(bigQuaternionRing);
        WeylRelations<BigQuaternion> weylRelations = new WeylRelations<BigQuaternion>();
        weylRelations.generate(genSolvablePolynomialRing);
        while ((genPolynomial2 = genSolvablePolynomialRing.random(1, 3, this.el, this.q)).isZERO()) {
        }
        while ((genPolynomial = genSolvablePolynomialRing.random(1, 3, this.el, this.q)).isZERO()) {
        }
        System.out.println("a = " + (GenSolvablePolynomial)genPolynomial2);
        System.out.println("b = " + (GenSolvablePolynomial)genPolynomial);
        GenSolvablePolynomial<BigQuaternion>[] genSolvablePolynomialArray = solvableSyzygySeq.leftOreCond((GenSolvablePolynomial<BigQuaternion>)genPolynomial2, (GenSolvablePolynomial<BigQuaternion>)genPolynomial);
        System.out.println("oc[0] = " + genSolvablePolynomialArray[0]);
        System.out.println("oc[1] = " + genSolvablePolynomialArray[1]);
        GenSolvablePolynomial<RingElem<BigQuaternion>> genSolvablePolynomial = genSolvablePolynomialArray[0].multiply((BigQuaternion)((Object)genPolynomial2));
        GenSolvablePolynomial<RingElem<BigQuaternion>> genSolvablePolynomial2 = genSolvablePolynomialArray[1].multiply((BigQuaternion)((Object)genPolynomial));
        SolvableSyzygyTest.assertEquals((String)("c_0 * a = c_1 * b: " + genSolvablePolynomialRing.toScript()), genSolvablePolynomial, genSolvablePolynomial2);
        SolvableSyzygyTest.assertTrue((String)"left Ore condition: ", (boolean)solvableSyzygySeq.isLeftOreCond((GenSolvablePolynomial<BigQuaternion>)genPolynomial2, (GenSolvablePolynomial<BigQuaternion>)genPolynomial, genSolvablePolynomialArray));
        genSolvablePolynomialArray = solvableSyzygySeq.rightOreCond((GenSolvablePolynomial<BigQuaternion>)genPolynomial2, (GenSolvablePolynomial<BigQuaternion>)genPolynomial);
        System.out.println("oc[0] = " + genSolvablePolynomialArray[0]);
        System.out.println("oc[1] = " + genSolvablePolynomialArray[1]);
        genSolvablePolynomial = ((GenSolvablePolynomial)genPolynomial2).multiply(genSolvablePolynomialArray[0]);
        genSolvablePolynomial2 = ((GenSolvablePolynomial)genPolynomial).multiply(genSolvablePolynomialArray[1]);
        SolvableSyzygyTest.assertEquals((String)("a * c_0 = b * c_1: " + genSolvablePolynomialRing.toScript()), genSolvablePolynomial, genSolvablePolynomial2);
        SolvableSyzygyTest.assertTrue((String)"right Ore condition: ", (boolean)solvableSyzygySeq.isRightOreCond((GenSolvablePolynomial<BigQuaternion>)genPolynomial2, (GenSolvablePolynomial<BigQuaternion>)genPolynomial, genSolvablePolynomialArray));
    }
}

