/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.kern;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComputerThreads {
    private static final Logger logger = LogManager.getLogger(ComputerThreads.class);
    public static boolean NO_THREADS = false;
    public static final int N_CPUS = Runtime.getRuntime().availableProcessors();
    public static final int N_THREADS = N_CPUS < 3 ? 3 : N_CPUS + N_CPUS / 2;
    static long timeout = 10L;
    static TimeUnit timeunit = TimeUnit.SECONDS;
    static ExecutorService pool = null;

    private ComputerThreads() {
    }

    public static synchronized boolean isRunning() {
        if (pool == null) {
            return false;
        }
        return !pool.isTerminated() && !pool.isShutdown();
    }

    public static synchronized ExecutorService getPool() {
        if (pool == null) {
            pool = Executors.newCachedThreadPool();
        }
        return pool;
    }

    public static synchronized void terminate() {
        if (pool == null) {
            return;
        }
        if (pool instanceof ThreadPoolExecutor) {
            List<Runnable> list;
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)pool;
            logger.info("number of CPUs            {}", (Object)N_CPUS);
            logger.info("core number of threads    {}", (Object)N_THREADS);
            logger.info("current number of threads {}", (Object)threadPoolExecutor.getPoolSize());
            logger.info("maximal number of threads {}", (Object)threadPoolExecutor.getLargestPoolSize());
            BlockingQueue<Runnable> blockingQueue = threadPoolExecutor.getQueue();
            if (blockingQueue != null) {
                logger.info("queued tasks              {}", (Object)blockingQueue.size());
            }
            if ((list = threadPoolExecutor.shutdownNow()).size() != 0) {
                logger.info("unfinished tasks          {}", (Object)list.size());
            }
            logger.info("number of scheduled tasks  {}", (Object)threadPoolExecutor.getTaskCount());
            logger.info("number of completed tasks {}", (Object)threadPoolExecutor.getCompletedTaskCount());
        }
        pool = null;
    }

    public static synchronized void setNoThreads() {
        NO_THREADS = true;
    }

    public static synchronized void setThreads() {
        NO_THREADS = false;
    }

    public static synchronized void setTimeout(long l) {
        timeout = l;
    }

    public static synchronized long getTimeout() {
        return timeout;
    }

    public static synchronized void setTimeUnit(TimeUnit timeUnit) {
        timeunit = timeUnit;
    }

    public static synchronized TimeUnit getTimeUnit() {
        return timeunit;
    }
}

