/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.kern;

import edu.jas.kern.Scripting;
import edu.jas.kern.StringUtil;
import java.io.StringReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class KernUtilTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run((Test)KernUtilTest.suite());
    }

    public KernUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(KernUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testStringUtil() {
        StringReader stringReader = new StringReader(" ein text - noch ein / text { wort } [1, 2, 3] [[1, 4], [2], [3, 5]]");
        String string = StringUtil.nextString(stringReader);
        KernUtilTest.assertEquals((String)"s==ein", (String)string, (String)"ein");
        string = StringUtil.nextString(stringReader);
        KernUtilTest.assertEquals((String)"s==text", (String)string, (String)"text");
        string = StringUtil.nextString(stringReader, '/');
        KernUtilTest.assertEquals((String)"s== - noch ein ", (String)string, (String)"- noch ein");
        try {
            string = StringUtil.nextPairedString(stringReader, '#', '#');
            KernUtilTest.fail((String)"exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        string = StringUtil.nextPairedString(stringReader, '{', '}');
        KernUtilTest.assertEquals((String)"s==wort", (String)string, (String)"wort");
        string = StringUtil.nextPairedString(stringReader, '[', ']');
        KernUtilTest.assertEquals((String)"s==1, 2, 3", (String)string, (String)"1, 2, 3");
        string = StringUtil.nextPairedString(stringReader, '[', ']');
        KernUtilTest.assertEquals((String)"s==[1, 4], [2], [3, 5]", (String)string, (String)"[1, 4], [2], [3, 5]");
    }

    public void testStackTrace() {
        String string = StringUtil.selectStackTrace(".*KernUtilTest.*");
        KernUtilTest.assertTrue((String)"s contains KernUtilTest", (string.indexOf("KernUtilTest") >= 0 ? 1 : 0) != 0);
    }

    public void testScripting() {
        Scripting.Lang lang = Scripting.getLang();
        KernUtilTest.assertEquals((String)"s == Python", (Object)((Object)lang), (Object)((Object)Scripting.Lang.Python));
        Scripting.CAS cAS = Scripting.getCAS();
        KernUtilTest.assertEquals((String)"c == JAS", (Object)((Object)cAS), (Object)((Object)Scripting.CAS.JAS));
        int n = Scripting.getPrecision();
        KernUtilTest.assertTrue((String)"p < 0", (n < 0 ? 1 : 0) != 0);
    }
}

