/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PreemptingException;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenExteriorPolynomialRing;
import edu.jas.poly.IndexFactory;
import edu.jas.poly.IndexList;
import edu.jas.poly.IndexListMonomial;
import edu.jas.poly.IndexListPolyIterator;
import edu.jas.structure.Element;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import edu.jas.structure.UnaryFunctor;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GenExteriorPolynomial<C extends RingElem<C>>
implements RingElem<GenExteriorPolynomial<C>>,
Iterable<IndexListMonomial<C>> {
    public final GenExteriorPolynomialRing<C> ring;
    final SortedMap<IndexList, C> val;
    private static final Logger logger = LogManager.getLogger(GenExteriorPolynomial.class);
    private static final boolean debug = logger.isDebugEnabled();

    private GenExteriorPolynomial(GenExteriorPolynomialRing<C> genExteriorPolynomialRing, TreeMap<IndexList, C> treeMap) {
        this.ring = genExteriorPolynomialRing;
        this.val = treeMap;
        if (this.ring.checkPreempt && Thread.currentThread().isInterrupted()) {
            logger.debug("throw PreemptingException");
            throw new PreemptingException();
        }
    }

    public GenExteriorPolynomial(GenExteriorPolynomialRing<C> genExteriorPolynomialRing) {
        this(genExteriorPolynomialRing, (C)new TreeMap(genExteriorPolynomialRing.ixfac.getDescendComparator()));
    }

    public GenExteriorPolynomial(GenExteriorPolynomialRing<C> genExteriorPolynomialRing, C c, IndexList indexList) {
        this(genExteriorPolynomialRing);
        if (!c.isZERO() && !indexList.isZERO()) {
            this.val.put(indexList, c);
        }
    }

    public GenExteriorPolynomial(GenExteriorPolynomialRing<C> genExteriorPolynomialRing, C c) {
        this(genExteriorPolynomialRing, c, genExteriorPolynomialRing.wone);
    }

    public GenExteriorPolynomial(GenExteriorPolynomialRing<C> genExteriorPolynomialRing, IndexList indexList) {
        this(genExteriorPolynomialRing, (RingElem)genExteriorPolynomialRing.coFac.getONE(), indexList);
    }

    public GenExteriorPolynomial(GenExteriorPolynomialRing<C> genExteriorPolynomialRing, ExpVector expVector) {
        this(genExteriorPolynomialRing, (RingElem)genExteriorPolynomialRing.coFac.getONE(), genExteriorPolynomialRing.ixfac.valueOf(expVector));
    }

    public GenExteriorPolynomial(GenExteriorPolynomialRing<C> genExteriorPolynomialRing, C c, ExpVector expVector) {
        this(genExteriorPolynomialRing, c, genExteriorPolynomialRing.ixfac.valueOf(expVector));
    }

    protected GenExteriorPolynomial(GenExteriorPolynomialRing<C> genExteriorPolynomialRing, SortedMap<IndexList, C> sortedMap) {
        this(genExteriorPolynomialRing);
        this.val.putAll(sortedMap);
    }

    @Override
    public GenExteriorPolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenExteriorPolynomial<C> copy() {
        return new GenExteriorPolynomial<C>(this.ring, this.val);
    }

    public int length() {
        return this.val.size();
    }

    public SortedMap<IndexList, C> getMap() {
        return Collections.unmodifiableSortedMap(this.val);
    }

    public void doPutToMap(IndexList indexList, C c) {
        RingElem ringElem;
        if (debug && (ringElem = (RingElem)this.val.get(indexList)) != null) {
            logger.error("map entry exists {} to {} new {}", (Object)indexList, (Object)ringElem, c);
        }
        if (!c.isZERO() && !indexList.isZERO()) {
            this.val.put(indexList, c);
        }
    }

    public void doRemoveFromMap(IndexList indexList, C c) {
        RingElem ringElem = (RingElem)this.val.remove(indexList);
        if (debug) {
            if (c == null) {
                return;
            }
            if (!c.equals(ringElem)) {
                logger.error("map entry wrong {} to {} old {}", (Object)indexList, c, (Object)ringElem);
            }
        }
    }

    public void doPutToMap(SortedMap<IndexList, C> sortedMap) {
        for (Map.Entry<IndexList, C> entry : sortedMap.entrySet()) {
            RingElem ringElem;
            IndexList indexList = entry.getKey();
            if (debug && (ringElem = (RingElem)this.val.get(indexList)) != null) {
                logger.error("map entry exists {} to {} new {}", (Object)indexList, (Object)ringElem, entry.getValue());
            }
            if ((ringElem = (RingElem)entry.getValue()).isZERO() || indexList.isZERO()) continue;
            this.val.put(indexList, ringElem);
        }
    }

    public String toString() {
        if (this.isZERO()) {
            return "0";
        }
        if (this.isONE()) {
            return "1";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.val.size() > 1) {
            stringBuffer.append("( ");
        }
        boolean bl = false;
        boolean bl2 = true;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            if (bl2) {
                bl2 = false;
            } else if (ringElem.signum() < 0) {
                stringBuffer.append(" - ");
                ringElem = (RingElem)ringElem.negate();
            } else {
                stringBuffer.append(" + ");
            }
            IndexList indexList = entry.getKey();
            if (!ringElem.isONE() || indexList.isONE()) {
                String string;
                if (bl) {
                    stringBuffer.append("( ");
                }
                if ((string = ringElem.toString()).indexOf("+") >= 0 || string.indexOf("-") >= 0) {
                    stringBuffer.append("( " + string + " )");
                } else {
                    stringBuffer.append(string);
                }
                if (bl) {
                    stringBuffer.append(" )");
                }
            }
            stringBuffer.append(" ");
            stringBuffer.append(indexList.toString());
        }
        if (this.val.size() > 1) {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        if (this.isZERO()) {
            return "0";
        }
        if (this.isONE()) {
            return "1";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.val.size() > 1) {
            stringBuffer.append("( ");
        }
        boolean bl = true;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            if (bl) {
                bl = false;
            } else if (ringElem.signum() < 0) {
                stringBuffer.append(" - ");
                ringElem = (RingElem)ringElem.negate();
            } else {
                stringBuffer.append(" + ");
            }
            IndexList indexList = entry.getKey();
            if (!ringElem.isONE() || indexList.isONE()) {
                String string = ringElem.toScript();
                if (string.indexOf("+") >= 0 || string.indexOf("-") >= 0) {
                    stringBuffer.append("( " + string + " )");
                } else {
                    stringBuffer.append(string);
                }
                if (!indexList.isONE()) {
                    stringBuffer.append(" * ");
                }
            }
            stringBuffer.append(indexList.toScript());
        }
        if (this.val.size() > 1) {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((GenExteriorPolynomialRing)this.factory()).toScript();
    }

    @Override
    public boolean isZERO() {
        return this.val.size() == 0;
    }

    @Override
    public boolean isONE() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem ringElem = (RingElem)this.val.get(this.ring.wone);
        if (ringElem == null) {
            return false;
        }
        return ringElem.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem ringElem = (RingElem)this.val.get(this.ring.wone);
        if (ringElem == null) {
            return false;
        }
        return ringElem.isUnit();
    }

    public boolean isConstant() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem ringElem = (RingElem)this.val.get(this.ring.wone);
        return ringElem != null;
    }

    public boolean isHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        long l = -1L;
        for (IndexList indexList : this.val.keySet()) {
            if (l < 0L) {
                l = indexList.degree();
                continue;
            }
            if (l == (long)indexList.degree()) continue;
            return false;
        }
        return true;
    }

    public GenExteriorPolynomial<C> form(long l) {
        return this.homogeneousPart(l);
    }

    public GenExteriorPolynomial<C> homogeneousPart(long l) {
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            IndexList indexList = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            if ((long)indexList.degree() != l) continue;
            sortedMap.put(indexList, ringElem);
        }
        return element;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenExteriorPolynomial)) {
            return false;
        }
        GenExteriorPolynomial genExteriorPolynomial = (GenExteriorPolynomial)object;
        return this.compareTo(genExteriorPolynomial) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode() << 27;
        return n += this.val.hashCode();
    }

    @Override
    public int compareTo(GenExteriorPolynomial<C> genExteriorPolynomial) {
        if (genExteriorPolynomial == null) {
            return 1;
        }
        SortedMap<IndexList, C> sortedMap = this.val;
        SortedMap<IndexList, C> sortedMap2 = genExteriorPolynomial.val;
        Iterator<Map.Entry<IndexList, C>> iterator = sortedMap.entrySet().iterator();
        Iterator<Map.Entry<IndexList, C>> iterator2 = sortedMap2.entrySet().iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext() && iterator2.hasNext()) {
            IndexList indexList;
            Map.Entry<IndexList, C> entry = iterator.next();
            Map.Entry<IndexList, C> entry2 = iterator2.next();
            IndexList indexList2 = entry.getKey();
            n = indexList2.compareTo(indexList = entry2.getKey());
            if (n != 0) {
                return n;
            }
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)entry2.getValue();
            n2 = ringElem.compareTo(ringElem2);
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return n2;
    }

    @Override
    public int signum() {
        if (this.isZERO()) {
            return 0;
        }
        IndexList indexList = this.val.firstKey();
        RingElem ringElem = (RingElem)this.val.get(indexList);
        return ringElem.signum();
    }

    public int numberOfVariables() {
        return this.ring.ixfac.length();
    }

    public Map.Entry<IndexList, C> leadingMonomial() {
        if (this.val.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<IndexList, C>> iterator = this.val.entrySet().iterator();
        return iterator.next();
    }

    public IndexList leadingIndexList() {
        if (this.val.size() == 0) {
            return this.ring.wone;
        }
        return this.val.firstKey();
    }

    public IndexList trailingIndexList() {
        if (this.val.size() == 0) {
            return this.ring.wone;
        }
        return this.val.lastKey();
    }

    public C leadingBaseCoefficient() {
        if (this.val.size() == 0) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)((RingElem)this.val.get(this.val.firstKey()));
    }

    public C trailingBaseCoefficient() {
        RingElem ringElem = (RingElem)this.val.get(this.ring.wone);
        if (ringElem == null) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)ringElem;
    }

    public C coefficient(IndexList indexList) {
        RingElem ringElem = (RingElem)this.val.get(indexList);
        if (ringElem == null) {
            ringElem = (RingElem)this.ring.coFac.getZERO();
        }
        return (C)ringElem;
    }

    public GenExteriorPolynomial<C> reductum() {
        if (this.val.size() <= 1) {
            return this.ring.getZERO();
        }
        Iterator<IndexList> iterator = this.val.keySet().iterator();
        IndexList indexList = iterator.next();
        indexList = iterator.next();
        SortedMap<IndexList, C> sortedMap = this.val.tailMap(indexList);
        return new GenExteriorPolynomial<C>(this.ring, sortedMap);
    }

    public long degree() {
        if (this.val.size() == 0) {
            return 0L;
        }
        long l = 0L;
        for (IndexList indexList : this.val.keySet()) {
            long l2 = indexList.degree();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public long maxDegree() {
        if (this.val.size() == 0) {
            return 0L;
        }
        long l = 0L;
        for (IndexList indexList : this.val.keySet()) {
            long l2 = indexList.maxDeg();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public C maxNorm() {
        RingElem ringElem = this.ring.getZEROCoefficient();
        for (RingElem ringElem2 : this.val.values()) {
            RingElem ringElem3 = (RingElem)ringElem2.abs();
            if (ringElem.compareTo((RingElem)ringElem3) >= 0) continue;
            ringElem = ringElem3;
        }
        return (C)ringElem;
    }

    public C sumNorm() {
        RingElem ringElem = this.ring.getZEROCoefficient();
        for (RingElem ringElem2 : this.val.values()) {
            RingElem ringElem3 = (RingElem)ringElem2.abs();
            ringElem = ringElem.sum((RingElem)ringElem3);
        }
        return (C)ringElem;
    }

    @Override
    public GenExteriorPolynomial<C> sum(GenExteriorPolynomial<C> genExteriorPolynomial) {
        if (genExteriorPolynomial == null) {
            return this;
        }
        if (genExteriorPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genExteriorPolynomial;
        }
        assert (this.ring.ixfac == genExteriorPolynomial.ring.ixfac);
        Element element = this.copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        SortedMap<IndexList, C> sortedMap2 = genExteriorPolynomial.val;
        for (Map.Entry<IndexList, C> entry : sortedMap2.entrySet()) {
            IndexList indexList = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)sortedMap.get(indexList);
            if (ringElem2 != null) {
                if (!(ringElem2 = ringElem2.sum(ringElem)).isZERO()) {
                    sortedMap.put(indexList, ringElem2);
                    continue;
                }
                sortedMap.remove(indexList);
                continue;
            }
            sortedMap.put(indexList, ringElem);
        }
        return element;
    }

    public GenExteriorPolynomial<C> sum(C c, IndexList indexList) {
        if (c == null) {
            return this;
        }
        if (c.isZERO()) {
            return this;
        }
        if (indexList == null) {
            return this;
        }
        if (indexList.isZERO()) {
            return this;
        }
        Element element = this.copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        RingElem ringElem = (RingElem)sortedMap.get(indexList);
        if (ringElem != null) {
            if (!(ringElem = (RingElem)ringElem.sum(c)).isZERO()) {
                sortedMap.put(indexList, ringElem);
            } else {
                sortedMap.remove(indexList);
            }
        } else {
            sortedMap.put(indexList, c);
        }
        return element;
    }

    @Override
    public GenExteriorPolynomial<C> sum(C c) {
        return this.sum(c, this.ring.wone);
    }

    @Override
    public GenExteriorPolynomial<C> subtract(GenExteriorPolynomial<C> genExteriorPolynomial) {
        if (genExteriorPolynomial == null) {
            return this;
        }
        if (genExteriorPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genExteriorPolynomial.negate();
        }
        assert (this.ring.ixfac == genExteriorPolynomial.ring.ixfac);
        Element element = this.copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        SortedMap<IndexList, C> sortedMap2 = genExteriorPolynomial.val;
        for (Map.Entry<IndexList, C> entry : sortedMap2.entrySet()) {
            IndexList indexList = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)sortedMap.get(indexList);
            if (ringElem2 != null) {
                if (!(ringElem2 = ringElem2.subtract(ringElem)).isZERO()) {
                    sortedMap.put(indexList, ringElem2);
                    continue;
                }
                sortedMap.remove(indexList);
                continue;
            }
            sortedMap.put(indexList, (RingElem)ringElem.negate());
        }
        return element;
    }

    public GenExteriorPolynomial<C> subtract(C c, IndexList indexList) {
        if (c == null) {
            return this;
        }
        if (c.isZERO()) {
            return this;
        }
        if (indexList == null) {
            return this;
        }
        if (indexList.isZERO()) {
            return this;
        }
        Element element = this.copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        RingElem ringElem = (RingElem)sortedMap.get(indexList);
        if (ringElem != null) {
            if (!(ringElem = (RingElem)ringElem.subtract(c)).isZERO()) {
                sortedMap.put(indexList, ringElem);
            } else {
                sortedMap.remove(indexList);
            }
        } else {
            sortedMap.put(indexList, (RingElem)c.negate());
        }
        return element;
    }

    @Override
    public GenExteriorPolynomial<C> subtract(C c) {
        return this.subtract(c, this.ring.wone);
    }

    @Override
    public GenExteriorPolynomial<C> negate() {
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            sortedMap.put(entry.getKey(), (RingElem)ringElem.negate());
        }
        return element;
    }

    @Override
    public GenExteriorPolynomial<C> abs() {
        if (this.leadingBaseCoefficient().signum() < 0) {
            return this.negate();
        }
        return this;
    }

    @Override
    public GenExteriorPolynomial<C> multiply(GenExteriorPolynomial<C> genExteriorPolynomial) {
        if (genExteriorPolynomial == null) {
            return this.ring.getZERO();
        }
        if (genExteriorPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.ixfac == genExteriorPolynomial.ring.ixfac) : " " + this.ring + " != " + genExteriorPolynomial.ring;
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            IndexList indexList = entry.getKey();
            for (Map.Entry<IndexList, C> entry2 : genExteriorPolynomial.val.entrySet()) {
                RingElem ringElem2;
                IndexList indexList2;
                RingElem ringElem3 = (RingElem)entry2.getValue();
                IndexList indexList3 = entry2.getKey();
                RingElem ringElem4 = ringElem.multiply(ringElem3);
                if (ringElem4.isZERO() || (indexList2 = indexList.multiply(indexList3)).isZERO()) continue;
                if (indexList2.sign < 0) {
                    ringElem4 = (RingElem)ringElem4.negate();
                    indexList2 = indexList2.negate();
                }
                if ((ringElem2 = (RingElem)sortedMap.get(indexList2)) == null) {
                    sortedMap.put(indexList2, ringElem4);
                    continue;
                }
                if (!(ringElem2 = ringElem2.sum(ringElem4)).isZERO()) {
                    sortedMap.put(indexList2, ringElem2);
                    continue;
                }
                sortedMap.remove(indexList2);
            }
        }
        return element;
    }

    public GenExteriorPolynomial<C> interiorLeftProduct(GenExteriorPolynomial<C> genExteriorPolynomial) {
        if (genExteriorPolynomial == null) {
            return this.ring.getZERO();
        }
        if (genExteriorPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.ixfac == genExteriorPolynomial.ring.ixfac) : " " + this.ring + " != " + genExteriorPolynomial.ring;
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            IndexList indexList = entry.getKey();
            for (Map.Entry<IndexList, C> entry2 : genExteriorPolynomial.val.entrySet()) {
                RingElem ringElem2;
                IndexList indexList2;
                RingElem ringElem3 = (RingElem)entry2.getValue();
                IndexList indexList3 = entry2.getKey();
                RingElem ringElem4 = ringElem.multiply(ringElem3);
                if (ringElem4.isZERO() || (indexList2 = indexList.interiorLeftProduct(indexList3)).isZERO()) continue;
                if (indexList2.sign < 0) {
                    ringElem4 = (RingElem)ringElem4.negate();
                    indexList2 = indexList2.negate();
                }
                if ((ringElem2 = (RingElem)sortedMap.get(indexList2)) == null) {
                    sortedMap.put(indexList2, ringElem4);
                    continue;
                }
                if (!(ringElem2 = ringElem2.sum(ringElem4)).isZERO()) {
                    sortedMap.put(indexList2, ringElem2);
                    continue;
                }
                sortedMap.remove(indexList2);
            }
        }
        return element;
    }

    public GenExteriorPolynomial<C> interiorRightProduct(GenExteriorPolynomial<C> genExteriorPolynomial) {
        if (genExteriorPolynomial == null) {
            return this.ring.getZERO();
        }
        if (genExteriorPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.ixfac == genExteriorPolynomial.ring.ixfac) : " " + this.ring + " != " + genExteriorPolynomial.ring;
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            IndexList indexList = entry.getKey();
            for (Map.Entry<IndexList, C> entry2 : genExteriorPolynomial.val.entrySet()) {
                RingElem ringElem2;
                IndexList indexList2;
                RingElem ringElem3 = (RingElem)entry2.getValue();
                IndexList indexList3 = entry2.getKey();
                RingElem ringElem4 = ringElem.multiply(ringElem3);
                if (ringElem4.isZERO() || (indexList2 = indexList.interiorRightProduct(indexList3)).isZERO()) continue;
                if (indexList2.sign < 0) {
                    ringElem4 = (RingElem)ringElem4.negate();
                    indexList2 = indexList2.negate();
                }
                if ((ringElem2 = (RingElem)sortedMap.get(indexList2)) == null) {
                    sortedMap.put(indexList2, ringElem4);
                    continue;
                }
                if (!(ringElem2 = ringElem2.sum(ringElem4)).isZERO()) {
                    sortedMap.put(indexList2, ringElem2);
                    continue;
                }
                sortedMap.remove(indexList2);
            }
        }
        return element;
    }

    public GenExteriorPolynomial<C> multiply(GenExteriorPolynomial<C> genExteriorPolynomial, GenExteriorPolynomial<C> genExteriorPolynomial2) {
        if (genExteriorPolynomial.isZERO() || genExteriorPolynomial2.isZERO()) {
            return this.ring.getZERO();
        }
        if (genExteriorPolynomial.isONE()) {
            return this.multiply((C)genExteriorPolynomial2);
        }
        if (genExteriorPolynomial2.isONE()) {
            return genExteriorPolynomial.multiply(this);
        }
        return genExteriorPolynomial.multiply(this).multiply(genExteriorPolynomial2);
    }

    @Override
    public GenExteriorPolynomial<C> multiply(C c) {
        if (c == null) {
            return this.ring.getZERO();
        }
        if (c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            IndexList indexList = entry.getKey();
            RingElem ringElem2 = (RingElem)ringElem.multiply(c);
            if (ringElem2.isZERO()) continue;
            sortedMap.put(indexList, ringElem2);
        }
        return element;
    }

    public GenExteriorPolynomial<C> multiply(C ringElem, C c) {
        if (ringElem == null || c == null) {
            return this.ring.getZERO();
        }
        if (ringElem.isZERO() || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem2 = (RingElem)entry.getValue();
            IndexList indexList = entry.getKey();
            RingElem ringElem3 = (RingElem)ringElem.multiply((RingElem)ringElem2).multiply(c);
            if (ringElem3.isZERO()) continue;
            sortedMap.put(indexList, ringElem3);
        }
        return element;
    }

    public GenExteriorPolynomial<C> monic() {
        if (this.isZERO()) {
            return this;
        }
        C c = this.leadingBaseCoefficient();
        if (!c.isUnit()) {
            return this;
        }
        RingElem ringElem = (RingElem)c.inverse();
        return this.multiply((C)ringElem);
    }

    public GenExteriorPolynomial<C> multiply(C c, IndexList indexList) {
        if (c == null) {
            return this.ring.getZERO();
        }
        if (c.isZERO()) {
            return this.ring.getZERO();
        }
        if (indexList == null) {
            return this.ring.getZERO();
        }
        if (indexList.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            IndexList indexList2;
            RingElem ringElem = (RingElem)entry.getValue();
            IndexList indexList3 = entry.getKey();
            RingElem ringElem2 = (RingElem)ringElem.multiply(c);
            if (ringElem2.isZERO() || (indexList2 = indexList3.multiply(indexList)).isZERO()) continue;
            if (indexList2.sign < 0) {
                ringElem2 = (RingElem)ringElem2.negate();
                indexList2 = indexList2.negate();
            }
            sortedMap.put(indexList2, ringElem2);
        }
        return element;
    }

    public GenExteriorPolynomial<C> multiply(IndexList indexList, IndexList indexList2) {
        if (indexList == null) {
            return this.ring.getZERO();
        }
        if (indexList.isZERO()) {
            return this.ring.getZERO();
        }
        if (indexList2 == null) {
            return this.ring.getZERO();
        }
        if (indexList2.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (indexList.isONE()) {
            return this.multiply(indexList2);
        }
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            IndexList indexList3;
            RingElem ringElem = (RingElem)entry.getValue();
            IndexList indexList4 = entry.getKey();
            IndexList indexList5 = indexList4.multiply(indexList2);
            if (indexList5.isZERO()) continue;
            if (indexList5.sign < 0) {
                ringElem = (RingElem)ringElem.negate();
                indexList5 = indexList5.negate();
            }
            if ((indexList3 = indexList.multiply(indexList5)).isZERO()) continue;
            if (indexList3.sign < 0) {
                ringElem = (RingElem)ringElem.negate();
                indexList3 = indexList3.negate();
            }
            sortedMap.put(indexList3, ringElem);
        }
        return element;
    }

    public GenExteriorPolynomial<C> multiply(C c, IndexList indexList, IndexList indexList2) {
        if (c == null) {
            return this.ring.getZERO();
        }
        if (c.isZERO()) {
            return this.ring.getZERO();
        }
        if (indexList == null) {
            return this.ring.getZERO();
        }
        if (indexList.isZERO()) {
            return this.ring.getZERO();
        }
        if (indexList2 == null) {
            return this.ring.getZERO();
        }
        if (indexList2.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (indexList.isONE()) {
            return this.multiply(c, indexList2);
        }
        RingElem ringElem = (RingElem)this.ring.coFac.getONE();
        return this.multiply(ringElem, indexList, c, indexList2);
    }

    public GenExteriorPolynomial<C> multiply(C ringElem, IndexList indexList, C c, IndexList indexList2) {
        if (ringElem == null) {
            return this.ring.getZERO();
        }
        if (ringElem.isZERO()) {
            return this.ring.getZERO();
        }
        if (c == null) {
            return this.ring.getZERO();
        }
        if (c.isZERO()) {
            return this.ring.getZERO();
        }
        if (indexList == null) {
            return this.ring.getZERO();
        }
        if (indexList.isZERO()) {
            return this.ring.getZERO();
        }
        if (indexList2 == null) {
            return this.ring.getZERO();
        }
        if (indexList2.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            IndexList indexList3;
            IndexList indexList4;
            IndexList indexList5;
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = (RingElem)ringElem.multiply((RingElem)ringElem2).multiply(c);
            if (ringElem3.isZERO() || (indexList5 = (indexList4 = entry.getKey()).multiply(indexList2)).isZERO()) continue;
            if (indexList5.sign < 0) {
                ringElem3 = (RingElem)ringElem3.negate();
                indexList5 = indexList5.negate();
            }
            if ((indexList3 = indexList.multiply(indexList5)).isZERO()) continue;
            if (indexList3.sign < 0) {
                ringElem3 = (RingElem)ringElem3.negate();
                indexList3 = indexList3.negate();
            }
            sortedMap.put(indexList3, ringElem3);
        }
        return element;
    }

    @Override
    public GenExteriorPolynomial<C> multiply(IndexList indexList) {
        if (indexList == null) {
            return this.ring.getZERO();
        }
        if (indexList.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            IndexList indexList2 = entry.getKey();
            IndexList indexList3 = indexList2.multiply(indexList);
            if (indexList3.isZERO()) continue;
            if (indexList3.sign < 0) {
                ringElem = (RingElem)ringElem.negate();
                indexList3 = indexList3.negate();
            }
            sortedMap.put(indexList3, ringElem);
        }
        return element;
    }

    @Override
    public GenExteriorPolynomial<C> multiply(Map.Entry<IndexList, C> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply((C)((RingElem)entry.getValue()), entry.getKey());
    }

    @Override
    public GenExteriorPolynomial<C> divide(C c) {
        if (c == null || c.isZERO()) {
            throw new ArithmeticException(this.getClass().getName() + " division by zero");
        }
        if (this.isZERO() || c.isONE()) {
            return this;
        }
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem;
            IndexList indexList = entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = (RingElem)ringElem2.divide(c);
            if (debug && !(ringElem = (RingElem)ringElem2.remainder(c)).isZERO()) {
                logger.info("divide x = {}", (Object)ringElem);
                throw new ArithmeticException(this.getClass().getName() + " no exact division: " + ringElem2 + "/" + c);
            }
            if (ringElem3.isZERO()) {
                throw new ArithmeticException(this.getClass().getName() + " no exact division: " + ringElem2 + "/" + c + ", in " + this);
            }
            sortedMap.put(indexList, ringElem3);
        }
        return element;
    }

    public GenExteriorPolynomial<C> coeffPrimitivePart() {
        if (this.isZERO() || this.isONE()) {
            return this;
        }
        RingElem ringElem = (RingElem)this.ring.coFac.getZERO();
        for (RingElem ringElem2 : this.val.values()) {
            ringElem = ringElem.gcd(ringElem2);
        }
        return this.divide((C)ringElem).abs();
    }

    public GenExteriorPolynomial<C>[] quotientRemainder(GenExteriorPolynomial<C> genExteriorPolynomial) {
        IndexList indexList;
        if (genExteriorPolynomial == null || genExteriorPolynomial.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        GenExteriorPolynomial[] genExteriorPolynomialArray = new GenExteriorPolynomial[2];
        if (this.isZERO()) {
            genExteriorPolynomialArray[0] = this.ring.getZERO();
            genExteriorPolynomialArray[1] = this.ring.getZERO();
            return genExteriorPolynomialArray;
        }
        C c = genExteriorPolynomial.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbcf not invertible " + c);
        }
        RingElem ringElem = (RingElem)c.inverse();
        RingElem ringElem2 = (RingElem)this.ring.coFac.getONE();
        assert (this.ring.ixfac == genExteriorPolynomial.ring.ixfac);
        IndexFactory.IndexListComparator indexListComparator = this.ring.ixfac.getDescendComparator();
        IndexList indexList2 = genExteriorPolynomial.leadingIndexList();
        GenExteriorPolynomial<C> genExteriorPolynomial2 = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        GenExteriorPolynomial<GenExteriorPolynomial<GenExteriorPolynomial<C>>> genExteriorPolynomial3 = this.copy();
        while (!genExteriorPolynomial3.isZERO() && indexList2.divides(indexList = genExteriorPolynomial3.leadingIndexList())) {
            RingElem ringElem3 = genExteriorPolynomial3.leadingBaseCoefficient();
            IndexList indexList3 = indexList2.interiorRightProduct(indexList);
            ringElem3 = ringElem3.multiply((RingElem)ringElem);
            genExteriorPolynomial2 = genExteriorPolynomial2.sum(ringElem3, indexList3);
            GenExteriorPolynomial<C> genExteriorPolynomial4 = genExteriorPolynomial.multiply(ringElem3, indexList3);
            IndexList indexList4 = (genExteriorPolynomial3 = genExteriorPolynomial3.subtract((GenExteriorPolynomial<GenExteriorPolynomial<C>>)genExteriorPolynomial4)).leadingIndexList();
            if (indexListComparator.compare(indexList, indexList4) <= 0) continue;
            throw new RuntimeException("possible infinite loop: f = " + indexList + ", fr = " + indexList4);
        }
        genExteriorPolynomialArray[0] = genExteriorPolynomial2;
        genExteriorPolynomialArray[1] = genExteriorPolynomial3;
        return genExteriorPolynomialArray;
    }

    @Override
    public GenExteriorPolynomial<C> divide(GenExteriorPolynomial<C> genExteriorPolynomial) {
        return this.quotientRemainder(genExteriorPolynomial)[0];
    }

    @Override
    public GenExteriorPolynomial<C> remainder(GenExteriorPolynomial<C> genExteriorPolynomial) {
        return this.quotientRemainder(genExteriorPolynomial)[1];
    }

    @Override
    public GenExteriorPolynomial<C> gcd(GenExteriorPolynomial<C> genExteriorPolynomial) {
        throw new UnsupportedOperationException("no gcd for exterior polynomials");
    }

    public GenExteriorPolynomial<C>[] egcd(GenExteriorPolynomial<C> genExteriorPolynomial) {
        throw new UnsupportedOperationException("no gcd for exterior polynomials");
    }

    @Override
    public GenExteriorPolynomial<C> inverse() {
        if (this.isUnit()) {
            RingElem ringElem = (RingElem)this.leadingBaseCoefficient().inverse();
            return ((GenExteriorPolynomial)this.ring.getONE()).multiply((C)ringElem);
        }
        throw new NotInvertibleException("element not invertible " + this + " :: " + this.ring);
    }

    public GenExteriorPolynomial<C> shiftIndex(int n) {
        if (n == 0) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        List<IndexList> list = this.ring.ixfac.generators();
        long l = this.maxDegree();
        if (l + (long)n >= (long)list.size()) {
            throw new IllegalArgumentException("ixfac to small: " + (l + (long)n) + " >= " + list.size());
        }
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            IndexList indexList = entry.getKey();
            int n2 = indexList.getVal(0);
            IndexList indexList2 = list.get(n2 += n);
            sortedMap.put(indexList2, ringElem);
        }
        return element;
    }

    public Iterator<C> coefficientIterator() {
        return this.val.values().iterator();
    }

    public Iterator<IndexList> indexListIterator() {
        return this.val.keySet().iterator();
    }

    @Override
    public Iterator<IndexListMonomial<C>> iterator() {
        return new IndexListPolyIterator<C>(this.val);
    }

    public GenExteriorPolynomial<C> map(UnaryFunctor<? super C, C> unaryFunctor) {
        Element element = ((GenExteriorPolynomial)this.ring.getZERO()).copy();
        SortedMap<IndexList, C> sortedMap = ((GenExteriorPolynomial)element).val;
        for (Map.Entry<IndexList, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)unaryFunctor.eval((Element)entry.getValue());
            if (ringElem == null || ringElem.isZERO()) continue;
            sortedMap.put(entry.getKey(), ringElem);
        }
        return element;
    }
}

