/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PreemptStatus;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenExteriorPolynomial;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.IndexFactory;
import edu.jas.poly.IndexList;
import edu.jas.poly.IndexListMonomial;
import edu.jas.poly.Monomial;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenVector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GenExteriorPolynomialRing<C extends RingElem<C>>
implements RingFactory<GenExteriorPolynomial<C>> {
    public final RingFactory<C> coFac;
    public final IndexFactory ixfac;
    public final GenExteriorPolynomial<C> ZERO;
    public final GenExteriorPolynomial<C> ONE;
    public final IndexList wone;
    static final Random random = new Random();
    private int isField = -1;
    private static final Logger logger = LogManager.getLogger(GenExteriorPolynomialRing.class);
    final boolean checkPreempt = PreemptStatus.isAllowed();

    public GenExteriorPolynomialRing(RingFactory<C> ringFactory, IndexFactory indexFactory) {
        this.coFac = ringFactory;
        this.ixfac = indexFactory;
        this.ZERO = new GenExteriorPolynomial(this);
        RingElem ringElem = (RingElem)this.coFac.getONE();
        this.wone = this.ixfac.getONE();
        this.ONE = new GenExteriorPolynomial<RingElem>(this, ringElem, this.wone);
    }

    public GenExteriorPolynomialRing(RingFactory<C> ringFactory, String[] stringArray) {
        this(ringFactory, new IndexFactory(stringArray.length));
    }

    public GenExteriorPolynomialRing(RingFactory<C> ringFactory, String string) {
        this(ringFactory, new IndexFactory(string.length()));
    }

    public GenExteriorPolynomialRing(RingFactory<C> ringFactory, GenExteriorPolynomialRing genExteriorPolynomialRing) {
        this(ringFactory, genExteriorPolynomialRing.ixfac);
    }

    public GenExteriorPolynomialRing(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing.coFac, new IndexFactory(genPolynomialRing.nvar));
    }

    public GenExteriorPolynomialRing<C> copy() {
        return new GenExteriorPolynomialRing<C>(this.coFac, this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ExteriorPolyRing(");
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toString().trim());
        }
        stringBuffer.append(", \"");
        stringBuffer.append(this.ixfac.toString());
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("ExtPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("ExtPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(", \"");
        stringBuffer.append(this.ixfac.toScript());
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenExteriorPolynomialRing)) {
            return false;
        }
        GenExteriorPolynomialRing genExteriorPolynomialRing = (GenExteriorPolynomialRing)object;
        if (!this.coFac.equals(genExteriorPolynomialRing.coFac)) {
            return false;
        }
        return this.ixfac.equals(genExteriorPolynomialRing.ixfac);
    }

    public int hashCode() {
        int n = this.coFac.hashCode() << 11;
        return n += this.ixfac.hashCode();
    }

    public C getZEROCoefficient() {
        return (C)((RingElem)this.coFac.getZERO());
    }

    public C getONECoefficient() {
        return (C)((RingElem)this.coFac.getONE());
    }

    @Override
    public GenExteriorPolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenExteriorPolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative() && this.ixfac.length() < 1;
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isFinite() {
        return this.coFac.isFinite();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.coFac.isField() && this.ixfac.length() < 1) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public GenExteriorPolynomial<C> valueOf(C c) {
        return new GenExteriorPolynomial<C>(this, c);
    }

    public GenExteriorPolynomial<C> valueOf(IndexList indexList) {
        return this.valueOf((RingElem)this.coFac.getONE(), this.ixfac.valueOf(indexList));
    }

    public GenExteriorPolynomial<C> valueOf(ExpVector expVector) {
        return this.valueOf((RingElem)this.coFac.getONE(), this.ixfac.valueOf(expVector));
    }

    public GenExteriorPolynomial<C> valueOf(C c, IndexList indexList) {
        return new GenExteriorPolynomial<C>(this, c, indexList);
    }

    public GenExteriorPolynomial<C> valueOf(C c, ExpVector expVector) {
        return new GenExteriorPolynomial<C>(this, c, this.ixfac.valueOf(expVector));
    }

    public GenExteriorPolynomial<C> valueOf(GenPolynomial<C> genPolynomial) {
        if (genPolynomial.isZERO()) {
            return this.getZERO();
        }
        if (genPolynomial.isONE()) {
            return this.getONE();
        }
        Element element = ((GenExteriorPolynomial)this.getZERO()).copy();
        for (Map.Entry entry : genPolynomial.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector = entry.getKey();
            IndexList indexList = this.ixfac.valueOf(expVector);
            if (indexList.isZERO()) continue;
            ((GenExteriorPolynomial)element).doPutToMap(indexList, ringElem);
        }
        return element;
    }

    public GenExteriorPolynomial<C> valueOf(GenExteriorPolynomial<C> genExteriorPolynomial) {
        if (genExteriorPolynomial.isZERO()) {
            return this.getZERO();
        }
        if (genExteriorPolynomial.isONE()) {
            return this.getONE();
        }
        Element element = ((GenExteriorPolynomial)this.getZERO()).copy();
        for (Map.Entry entry : genExteriorPolynomial.val.entrySet()) {
            IndexList indexList;
            RingElem ringElem = (RingElem)entry.getValue();
            IndexList indexList2 = entry.getKey();
            if (indexList2.isZERO() || (indexList = this.ixfac.valueOf(indexList2.val)).isZERO()) continue;
            ((GenExteriorPolynomial)element).doPutToMap(indexList, ringElem);
        }
        return element;
    }

    public List<GenExteriorPolynomial<C>> valueOf(List<GenPolynomial<C>> list) {
        ArrayList<GenExteriorPolynomial<C>> arrayList = new ArrayList<GenExteriorPolynomial<C>>(list.size());
        if (list.isEmpty()) {
            return arrayList;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            GenExteriorPolynomial<C> genExteriorPolynomial = this.valueOf(genPolynomial);
            arrayList.add(genExteriorPolynomial);
        }
        return arrayList;
    }

    public GenExteriorPolynomial<C> getIMAX() {
        return this.valueOf((RingElem)this.coFac.getONE(), this.ixfac.imax);
    }

    @Override
    public GenExteriorPolynomial<C> fromInteger(long l) {
        return new GenExteriorPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(l), this.wone);
    }

    @Override
    public GenExteriorPolynomial<C> fromInteger(BigInteger bigInteger) {
        return new GenExteriorPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(bigInteger), this.wone);
    }

    public GenExteriorPolynomial<C> fromVector(GenVector<C> genVector) {
        if (genVector == null || genVector.isZERO()) {
            return this.ZERO;
        }
        List<IndexList> list = this.ixfac.generators();
        GenExteriorPolynomial<C> genExteriorPolynomial = this.copy(this.ZERO);
        SortedMap sortedMap = genExteriorPolynomial.val;
        int n = -1;
        for (RingElem ringElem : genVector.val) {
            ++n;
            if (ringElem.isZERO()) continue;
            IndexList indexList = list.get(n);
            sortedMap.put(indexList, ringElem);
        }
        return genExteriorPolynomial;
    }

    public List<GenExteriorPolynomial<C>> fromMatrix(GenMatrix<C> genMatrix) {
        ArrayList<GenExteriorPolynomial<C>> arrayList = new ArrayList<GenExteriorPolynomial<C>>();
        if (genMatrix == null || genMatrix.isZERO()) {
            return arrayList;
        }
        for (int i = 0; i < genMatrix.ring.rows; ++i) {
            GenVector<C> genVector = genMatrix.getRow(i);
            if (genVector.isZERO()) continue;
            GenExteriorPolynomial<C> genExteriorPolynomial = this.fromVector(genVector);
            arrayList.add(genExteriorPolynomial);
        }
        return arrayList;
    }

    public C determinant(List<GenExteriorPolynomial<C>> list) {
        RingElem ringElem = (RingElem)this.coFac.getZERO();
        if (list == null || list.isEmpty()) {
            return (C)ringElem;
        }
        GenExteriorPolynomial<GenExteriorPolynomial<GenExteriorPolynomial<C>>> genExteriorPolynomial = this.getONE();
        for (GenExteriorPolynomial<C> genExteriorPolynomial2 : list) {
            if (genExteriorPolynomial2.isZERO()) {
                return (C)ringElem;
            }
            if (!(genExteriorPolynomial = genExteriorPolynomial.multiply((GenExteriorPolynomial<GenExteriorPolynomial<C>>)genExteriorPolynomial2)).isZERO()) continue;
            return (C)ringElem;
        }
        if (genExteriorPolynomial.length() > 1) {
            return (C)ringElem;
        }
        ringElem = genExteriorPolynomial.leadingBaseCoefficient();
        return (C)ringElem;
    }

    public GenExteriorPolynomial<C> fromPolynomial(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.ZERO;
        }
        if (genPolynomial.ring.nvar != 1) {
            throw new IllegalArgumentException("no univariate polynomial");
        }
        int n = (int)genPolynomial.degree();
        if (n > this.ixfac.imax.maxDeg()) {
            throw new IllegalArgumentException("ensure deg <= ixfax.maxDeg: " + n + " > " + this.ixfac.imax.maxDeg());
        }
        if (this.ixfac.imax.minDeg() > 0) {
            throw new IllegalArgumentException("ensure ixfax.minDeg == 0: " + this.ixfac.imax.minDeg());
        }
        List<IndexList> list = this.ixfac.generators();
        GenExteriorPolynomial<C> genExteriorPolynomial = this.copy(this.ZERO);
        SortedMap sortedMap = genExteriorPolynomial.val;
        for (Monomial<C> monomial : genPolynomial) {
            int n2 = (int)monomial.e.getVal(0);
            IndexList indexList = list.get(n2);
            Object c = monomial.c;
            sortedMap.put(indexList, c);
        }
        return genExteriorPolynomial;
    }

    public C resultant(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        GenExteriorPolynomial<C> genExteriorPolynomial;
        int n;
        Iterable<IndexListMonomial<Object>> iterable;
        Object object = (RingElem)this.coFac.getZERO();
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial2 == null || genPolynomial2.isZERO()) {
            return (C)object;
        }
        int n2 = (int)genPolynomial.degree();
        int n3 = (int)genPolynomial2.degree();
        GenExteriorPolynomial<C> genExteriorPolynomial2 = this.fromPolynomial(genPolynomial);
        GenExteriorPolynomial<C> genExteriorPolynomial3 = this.fromPolynomial(genPolynomial2);
        if (n2 < n3) {
            iterable = genExteriorPolynomial2;
            genExteriorPolynomial2 = genExteriorPolynomial3;
            genExteriorPolynomial3 = iterable;
            n = n2;
            n2 = n3;
            n3 = n;
        }
        iterable = new ArrayList(n2 + n3);
        for (n = n3 - 1; n >= 0; --n) {
            genExteriorPolynomial = genExteriorPolynomial2.shiftIndex(n);
            iterable.add(genExteriorPolynomial);
        }
        for (n = n2 - 1; n >= 0; --n) {
            genExteriorPolynomial = genExteriorPolynomial3.shiftIndex(n);
            iterable.add(genExteriorPolynomial);
        }
        object = this.determinant((List<GenExteriorPolynomial<C>>)iterable);
        return (C)object;
    }

    @Override
    public GenExteriorPolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public GenExteriorPolynomial<C> random(int n, Random random) {
        return this.random(5, n, 3, random);
    }

    public GenExteriorPolynomial<C> random(int n, int n2, int n3) {
        return this.random(n, n2, n3, random);
    }

    public GenExteriorPolynomial<C> random(int n, int n2, int n3, Random random) {
        GenExteriorPolynomial<RingElem> genExteriorPolynomial = this.getZERO();
        int n4 = Math.min(n3, this.ixfac.imaxlength);
        for (int i = 0; i < n2; ++i) {
            int n5 = Math.abs(random.nextInt() % n4);
            IndexList indexList = this.ixfac.random(n5, 0.5f, random).abs();
            RingElem ringElem = (RingElem)this.coFac.random(n, random);
            genExteriorPolynomial = genExteriorPolynomial.sum(ringElem, indexList);
        }
        return genExteriorPolynomial;
    }

    public GenExteriorPolynomial<C> randomForm(int n, int n2, int n3) {
        return this.randomForm(n, n2, n3, random);
    }

    public GenExteriorPolynomial<C> randomForm(int n, int n2, int n3, Random random) {
        GenExteriorPolynomial<RingElem> genExteriorPolynomial = this.getZERO();
        if (n3 > this.ixfac.imaxlength || n3 < 0) {
            return genExteriorPolynomial;
        }
        if (n3 == 0) {
            return this.getZERO();
        }
        for (int i = 0; i < n2; ++i) {
            IndexList indexList = this.ixfac.random(n3, 0.5f, random).abs();
            if (indexList.length() != n3) continue;
            RingElem ringElem = (RingElem)this.coFac.random(n, random);
            genExteriorPolynomial = genExteriorPolynomial.sum(ringElem, indexList);
        }
        return genExteriorPolynomial;
    }

    @Override
    public GenExteriorPolynomial<C> copy(GenExteriorPolynomial<C> genExteriorPolynomial) {
        return new GenExteriorPolynomial(this, genExteriorPolynomial.val);
    }

    @Override
    public GenExteriorPolynomial<C> parse(String string) {
        String string2 = string;
        if (!string.contains("|")) {
            string2 = string2.replace("{", "").replace("}", "");
        }
        return this.parse(new StringReader(string2));
    }

    @Override
    public GenExteriorPolynomial<C> parse(Reader reader) {
        GenExteriorPolynomial genExteriorPolynomial;
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(reader);
        try {
            genExteriorPolynomial = genPolynomialTokenizer.nextExteriorPolynomial(this);
        }
        catch (IOException iOException) {
            genExteriorPolynomial = null;
            iOException.printStackTrace();
            logger.error("{} parse {}", (Object)iOException, (Object)this);
        }
        return genExteriorPolynomial;
    }

    public GenExteriorPolynomial<C> univariate(int n) {
        GenExteriorPolynomial<RingElem> genExteriorPolynomial = this.getZERO();
        List<IndexList> list = this.ixfac.generators();
        if (0 <= n && n < list.size()) {
            RingElem ringElem = (RingElem)this.coFac.getONE();
            IndexList indexList = list.get(n);
            genExteriorPolynomial = genExteriorPolynomial.sum(ringElem, indexList);
        }
        return genExteriorPolynomial;
    }

    public List<GenExteriorPolynomial<C>> univariateList() {
        int n = this.ixfac.length();
        ArrayList<GenExteriorPolynomial<C>> arrayList = new ArrayList<GenExteriorPolynomial<C>>(n);
        for (int i = 0; i < n; ++i) {
            GenExteriorPolynomial<C> genExteriorPolynomial = this.univariate(i);
            arrayList.add(genExteriorPolynomial);
        }
        return arrayList;
    }

    public List<GenExteriorPolynomial<C>> getGenerators() {
        List<GenExteriorPolynomial<C>> list = this.univariateList();
        ArrayList<GenExteriorPolynomial<C>> arrayList = new ArrayList<GenExteriorPolynomial<C>>(list.size() + 1);
        arrayList.add((GenExteriorPolynomial<C>)this.getONE());
        arrayList.addAll(list);
        return arrayList;
    }

    @Override
    public List<GenExteriorPolynomial<C>> generators() {
        List list = this.coFac.generators();
        List<GenExteriorPolynomial<C>> list2 = this.univariateList();
        ArrayList<GenExteriorPolynomial<C>> arrayList = new ArrayList<GenExteriorPolynomial<C>>(list2.size() + list.size());
        for (RingElem ringElem : list) {
            arrayList.add(((GenExteriorPolynomial)this.getONE()).multiply(ringElem));
        }
        arrayList.addAll(list2);
        return arrayList;
    }
}

