/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenExteriorPolynomial;
import edu.jas.poly.GenExteriorPolynomialRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.IndexFactory;
import edu.jas.poly.IndexList;
import edu.jas.poly.IndexListMonomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.AlgebraElem;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenExteriorPolynomialTest
extends TestCase {
    int rl = 6;
    int kl = 8;
    int ll = 6;
    int el = 4;
    float ql = 0.4f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenExteriorPolynomialTest.suite());
    }

    public GenExteriorPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenExteriorPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstructors() {
        BigInteger bigInteger = new BigInteger();
        IndexFactory indexFactory = new IndexFactory(6);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigInteger>(bigInteger, indexFactory);
        GenExteriorPolynomialTest.assertFalse((String)"not commutative", (boolean)genExteriorPolynomialRing.isCommutative());
        GenExteriorPolynomialTest.assertTrue((String)"associative", (boolean)genExteriorPolynomialRing.isAssociative());
        GenExteriorPolynomialTest.assertFalse((String)"not field", (boolean)genExteriorPolynomialRing.isField());
        GenExteriorPolynomialTest.assertEquals((String)"pf == pf: ", genExteriorPolynomialRing, genExteriorPolynomialRing);
        String string = genExteriorPolynomialRing.toScript();
        GenExteriorPolynomialTest.assertTrue((String)("#s >= 35: " + string), (string.length() >= 35 ? 1 : 0) != 0);
        string = genExteriorPolynomialRing.toString();
        GenExteriorPolynomialTest.assertTrue((String)("#s >= 40: " + string), (string.length() >= 40 ? 1 : 0) != 0);
        Element element = genExteriorPolynomialRing.getONE();
        GenExteriorPolynomialTest.assertTrue((String)"p == 1", (boolean)((GenExteriorPolynomial)element).isONE());
        element = genExteriorPolynomialRing.getZERO();
        GenExteriorPolynomialTest.assertTrue((String)"p == 0", (boolean)((GenExteriorPolynomial)element).isZERO());
        List<GenExteriorPolynomial<BigInteger>> list = genExteriorPolynomialRing.generators();
        GenExteriorPolynomialTest.assertTrue((String)"#gens == 7", (list.size() == 7 ? 1 : 0) != 0);
        list = genExteriorPolynomialRing.getGenerators();
        GenExteriorPolynomialTest.assertTrue((String)"#gens == 7", (list.size() == 7 ? 1 : 0) != 0);
        RingElem ringElem = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing);
        GenExteriorPolynomialTest.assertTrue((String)"p.equals(pe) = ", (boolean)((GenExteriorPolynomial)element).equals(ringElem));
        GenExteriorPolynomialTest.assertTrue((String)"p.equals(p) = ", (boolean)((GenExteriorPolynomial)element).equals(element));
        ringElem = (RingElem)ringElem.sum(element);
        GenExteriorPolynomialTest.assertTrue((String)"pe.isZERO() = ", (boolean)ringElem.isZERO());
        element = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        element = ((GenExteriorPolynomial)element).subtract(element);
        GenExteriorPolynomialTest.assertTrue((String)"p.isZERO() = ", (boolean)((GenExteriorPolynomial)element).isZERO());
        IndexFactory indexFactory2 = new IndexFactory(3);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing2 = new GenExteriorPolynomialRing<BigInteger>(genExteriorPolynomialRing, indexFactory2);
        AbelianGroupElem abelianGroupElem = genExteriorPolynomialRing2.getONE();
        GenExteriorPolynomialTest.assertTrue((String)"pp == 1", (boolean)((GenExteriorPolynomial)abelianGroupElem).isONE());
        abelianGroupElem = genExteriorPolynomialRing2.random(this.kl, this.ll, this.el);
        abelianGroupElem = genExteriorPolynomialRing2.getZERO();
        GenExteriorPolynomialTest.assertTrue((String)"pp == 0", (boolean)((GenExteriorPolynomial)abelianGroupElem).isZERO());
        List<GenExteriorPolynomial<BigInteger>> list2 = genExteriorPolynomialRing2.generators();
        GenExteriorPolynomialTest.assertTrue((String)"#pgens == 7+3", (list2.size() == 10 ? 1 : 0) != 0);
        RingElem ringElem2 = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing2);
        GenExteriorPolynomialTest.assertTrue((String)"pp.equals(ppe) = ", (boolean)((GenExteriorPolynomial)abelianGroupElem).equals(ringElem2));
        GenExteriorPolynomialTest.assertTrue((String)"pp.equals(pp) = ", (boolean)((GenExteriorPolynomial)abelianGroupElem).equals(abelianGroupElem));
        ringElem2 = (RingElem)ringElem2.sum(abelianGroupElem);
        GenExteriorPolynomialTest.assertTrue((String)"ppe.isZERO() = ", (boolean)ringElem2.isZERO());
        abelianGroupElem = genExteriorPolynomialRing2.random(this.kl, this.ll, this.el);
        abelianGroupElem = ((GenExteriorPolynomial)abelianGroupElem).subtract(abelianGroupElem);
        GenExteriorPolynomialTest.assertTrue((String)"pp.isZERO() = ", (boolean)((GenExteriorPolynomial)abelianGroupElem).isZERO());
        IndexFactory indexFactory3 = new IndexFactory(3);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing3 = new GenExteriorPolynomialRing<BigInteger>(genExteriorPolynomialRing2, indexFactory3);
        AbelianGroupElem abelianGroupElem2 = genExteriorPolynomialRing3.getONE();
        GenExteriorPolynomialTest.assertTrue((String)"ppp == 1", (boolean)((GenExteriorPolynomial)abelianGroupElem2).isONE());
        abelianGroupElem2 = genExteriorPolynomialRing3.random(this.kl, this.ll, this.el);
        abelianGroupElem2 = genExteriorPolynomialRing3.getZERO();
        GenExteriorPolynomialTest.assertTrue((String)"ppp == 0", (boolean)((GenExteriorPolynomial)abelianGroupElem2).isZERO());
        List<GenExteriorPolynomial<BigInteger>> list3 = genExteriorPolynomialRing3.generators();
        GenExteriorPolynomialTest.assertTrue((String)"#ppgens == 7+3+3", (list3.size() == 13 ? 1 : 0) != 0);
        RingElem ringElem3 = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing3);
        GenExteriorPolynomialTest.assertTrue((String)"ppp.equals(pppe) = ", (boolean)((GenExteriorPolynomial)abelianGroupElem2).equals(ringElem3));
        GenExteriorPolynomialTest.assertTrue((String)"ppp.equals(ppp) = ", (boolean)((GenExteriorPolynomial)abelianGroupElem2).equals(abelianGroupElem2));
        ringElem3 = (RingElem)ringElem3.sum(abelianGroupElem2);
        GenExteriorPolynomialTest.assertTrue((String)"pppe.isZERO() = ", (boolean)ringElem3.isZERO());
        abelianGroupElem2 = genExteriorPolynomialRing3.random(this.kl, this.ll, this.el);
        abelianGroupElem2 = ((GenExteriorPolynomial)abelianGroupElem2).subtract(abelianGroupElem2);
        GenExteriorPolynomialTest.assertTrue((String)"ppp.isZERO() = ", (boolean)((GenExteriorPolynomial)abelianGroupElem2).isZERO());
    }

    public void testAccessors() {
        BigInteger bigInteger = new BigInteger();
        IndexFactory indexFactory = new IndexFactory(6);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigInteger>(bigInteger, indexFactory);
        Element element = genExteriorPolynomialRing.getONE();
        IndexList indexList = ((GenExteriorPolynomial)element).leadingIndexList();
        BigInteger bigInteger2 = (BigInteger)((GenExteriorPolynomial)element).leadingBaseCoefficient();
        AbelianGroupElem<GenExteriorPolynomial<Object>> abelianGroupElem = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing, bigInteger2, indexList);
        GenExteriorPolynomialTest.assertEquals((String)"1 == 1 ", (Object)element, abelianGroupElem);
        GenExteriorPolynomial<GenExteriorPolynomial<BigInteger>> genExteriorPolynomial = ((GenExteriorPolynomial)element).reductum();
        GenExteriorPolynomialTest.assertTrue((String)"red(1) == 0 ", (boolean)genExteriorPolynomial.isZERO());
        element = genExteriorPolynomialRing.getZERO();
        indexList = ((GenExteriorPolynomial)element).leadingIndexList();
        bigInteger2 = (BigInteger)((GenExteriorPolynomial)element).leadingBaseCoefficient();
        abelianGroupElem = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing, bigInteger2, indexList);
        GenExteriorPolynomialTest.assertEquals((String)"0 == 0 ", element, abelianGroupElem);
        genExteriorPolynomial = ((GenExteriorPolynomial)element).reductum();
        GenExteriorPolynomialTest.assertTrue((String)"red(0) == 0 ", (boolean)genExteriorPolynomial.isZERO());
        element = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        indexList = ((GenExteriorPolynomial)element).leadingIndexList();
        bigInteger2 = (BigInteger)((GenExteriorPolynomial)element).leadingBaseCoefficient();
        genExteriorPolynomial = ((GenExteriorPolynomial)element).reductum();
        abelianGroupElem = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing, bigInteger2, indexList);
        abelianGroupElem = genExteriorPolynomial.sum((GenExteriorPolynomial<BigInteger>)abelianGroupElem);
        GenExteriorPolynomialTest.assertEquals((String)"p == lm(f)+red(f) ", element, abelianGroupElem);
        Element element2 = element;
        abelianGroupElem = genExteriorPolynomialRing.getZERO();
        while (!((GenExteriorPolynomial)element2).isZERO()) {
            indexList = ((GenExteriorPolynomial)element2).leadingIndexList();
            bigInteger2 = (BigInteger)((GenExteriorPolynomial)element2).leadingBaseCoefficient();
            genExteriorPolynomial = ((GenExteriorPolynomial)element2).reductum();
            abelianGroupElem = ((GenExteriorPolynomial)abelianGroupElem).sum((GenExteriorPolynomial<Object>)((Object)bigInteger2), indexList);
            element2 = genExteriorPolynomial;
        }
        GenExteriorPolynomialTest.assertEquals((String)"p == lm(f)+lm(red(f))+... ", element, abelianGroupElem);
    }

    public void testAddition() {
        BigInteger bigInteger = new BigInteger();
        IndexFactory indexFactory = new IndexFactory(6);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigInteger>(bigInteger, indexFactory);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial2 = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        GenExteriorPolynomial genExteriorPolynomial3 = genExteriorPolynomial.sum((BigInteger)((Object)genExteriorPolynomial2));
        GenExteriorPolynomial<RingElem<GenExteriorPolynomial<Object>>> genExteriorPolynomial4 = genExteriorPolynomial3.subtract(genExteriorPolynomial2);
        GenExteriorPolynomialTest.assertEquals((String)"a+b-b = a", genExteriorPolynomial, genExteriorPolynomial4);
        GenExteriorPolynomialTest.assertTrue((String)"deg(a+b) >= deg(a)", (genExteriorPolynomial3.degree() >= genExteriorPolynomial.degree() ? 1 : 0) != 0);
        GenExteriorPolynomialTest.assertTrue((String)"deg(a+b) >= deg(b)", (genExteriorPolynomial3.degree() >= genExteriorPolynomial2.degree() ? 1 : 0) != 0);
        genExteriorPolynomial3 = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        genExteriorPolynomial4 = genExteriorPolynomial.sum((BigInteger)((Object)genExteriorPolynomial2.sum((BigInteger)((Object)genExteriorPolynomial3))));
        GenExteriorPolynomial<GenExteriorPolynomial<GenExteriorPolynomial<BigInteger>>> genExteriorPolynomial5 = genExteriorPolynomial.sum((BigInteger)((Object)genExteriorPolynomial2)).sum(genExteriorPolynomial3);
        GenExteriorPolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", genExteriorPolynomial4, genExteriorPolynomial5);
        IndexList indexList = indexFactory.random(this.rl);
        BigInteger bigInteger2 = bigInteger.random(this.kl);
        genExteriorPolynomial2 = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing, bigInteger2, indexList);
        genExteriorPolynomial3 = genExteriorPolynomial.sum((BigInteger)((Object)genExteriorPolynomial2));
        genExteriorPolynomial4 = genExteriorPolynomial.sum(bigInteger2, indexList);
        GenExteriorPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", genExteriorPolynomial3, genExteriorPolynomial4);
        genExteriorPolynomial3 = genExteriorPolynomial.subtract((BigInteger)((Object)genExteriorPolynomial2));
        genExteriorPolynomial4 = genExteriorPolynomial.subtract(bigInteger2, indexList);
        GenExteriorPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", genExteriorPolynomial3, genExteriorPolynomial4);
        genExteriorPolynomial2 = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing, bigInteger2, indexList);
        genExteriorPolynomial3 = genExteriorPolynomial2.sum((BigInteger)((Object)genExteriorPolynomial));
        genExteriorPolynomial4 = genExteriorPolynomial.sum(bigInteger2, indexList);
        GenExteriorPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", genExteriorPolynomial3, genExteriorPolynomial4);
        genExteriorPolynomial3 = genExteriorPolynomial.subtract((BigInteger)((Object)genExteriorPolynomial2));
        genExteriorPolynomial4 = genExteriorPolynomial.subtract(bigInteger2, indexList);
        GenExteriorPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", genExteriorPolynomial3, genExteriorPolynomial4);
    }

    public void testMultiplication() {
        BigInteger bigInteger = new BigInteger();
        IndexFactory indexFactory = new IndexFactory(6);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigInteger>(bigInteger, indexFactory);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial2 = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        GenExteriorPolynomial genExteriorPolynomial3 = genExteriorPolynomial.multiply((BigInteger)((Object)genExteriorPolynomial2));
        GenExteriorPolynomial<RingElem<GenExteriorPolynomial<Object>>> genExteriorPolynomial4 = genExteriorPolynomial2.multiply((BigInteger)((Object)genExteriorPolynomial));
        GenExteriorPolynomialTest.assertTrue((String)"maxNorm(a*b) >= maxNorm(a)", (((BigInteger)((Object)genExteriorPolynomial3.maxNorm())).compareTo(genExteriorPolynomial.maxNorm()) >= 0 ? 1 : 0) != 0);
        GenExteriorPolynomialTest.assertTrue((String)"maxNorm(a*b) >= maxNorm(b)", (((BigInteger)((Object)genExteriorPolynomial3.maxNorm())).compareTo(genExteriorPolynomial2.maxNorm()) >= 0 ? 1 : 0) != 0);
        genExteriorPolynomial3 = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        genExteriorPolynomial4 = genExteriorPolynomial.multiply((BigInteger)((Object)genExteriorPolynomial2.multiply((BigInteger)((Object)genExteriorPolynomial3))));
        GenExteriorPolynomial<GenExteriorPolynomial<GenExteriorPolynomial<BigInteger>>> genExteriorPolynomial5 = genExteriorPolynomial.multiply((BigInteger)((Object)genExteriorPolynomial2)).multiply(genExteriorPolynomial3);
        GenExteriorPolynomialTest.assertEquals((String)"a*(b*c) = (a*b)*c:", genExteriorPolynomial4, genExteriorPolynomial5);
        genExteriorPolynomial5 = genExteriorPolynomial2.multiply((BigInteger)((Object)genExteriorPolynomial), (BigInteger)((Object)genExteriorPolynomial3));
        GenExteriorPolynomialTest.assertEquals((String)"a*(b*c) = a*b*c:", genExteriorPolynomial4, genExteriorPolynomial5);
        IndexList indexList = indexFactory.random(this.rl);
        BigInteger bigInteger2 = bigInteger.random(this.kl);
        genExteriorPolynomial2 = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing, bigInteger2, indexList);
        genExteriorPolynomial3 = genExteriorPolynomial.multiply((BigInteger)((Object)genExteriorPolynomial2));
        genExteriorPolynomial4 = genExteriorPolynomial.multiply(bigInteger2, indexList);
        GenExteriorPolynomialTest.assertEquals((String)"a*p(x,u) = a*(x,u)", genExteriorPolynomial3, genExteriorPolynomial4);
        genExteriorPolynomial2 = new GenExteriorPolynomial<BigInteger>(genExteriorPolynomialRing, bigInteger2, indexList);
        genExteriorPolynomial3 = genExteriorPolynomial.multiply((BigInteger)((Object)genExteriorPolynomial2));
        genExteriorPolynomial4 = genExteriorPolynomial.multiply(bigInteger2, indexList);
        GenExteriorPolynomialTest.assertEquals((String)"a*p(x,u) = a*(x,u)", genExteriorPolynomial3, genExteriorPolynomial4);
        BigInteger bigInteger3 = bigInteger.random(this.kl);
        genExteriorPolynomial3 = genExteriorPolynomial.multiply(bigInteger2, bigInteger3);
        genExteriorPolynomial4 = genExteriorPolynomial.multiply(bigInteger3, bigInteger2);
        GenExteriorPolynomialTest.assertEquals((String)"x a y = y a x", genExteriorPolynomial3, genExteriorPolynomial4);
        IndexList indexList2 = indexFactory.random(this.rl);
        genExteriorPolynomial3 = genExteriorPolynomial.multiply(bigInteger2, indexList, bigInteger3, indexList2);
        genExteriorPolynomial4 = genExteriorPolynomial.multiply(bigInteger3, indexList, bigInteger2, indexList2);
        GenExteriorPolynomialTest.assertEquals((String)"x u a y v = y u a x v", genExteriorPolynomial3, genExteriorPolynomial4);
        genExteriorPolynomial3 = genExteriorPolynomial.multiply(indexList, indexList2);
        genExteriorPolynomial4 = genExteriorPolynomial.multiply(bigInteger.getONE(), indexList, indexList2);
        GenExteriorPolynomialTest.assertEquals((String)"u a v = 1 u a v", genExteriorPolynomial3, genExteriorPolynomial4);
    }

    public void testDistributive() {
        BigInteger bigInteger = new BigInteger();
        IndexFactory indexFactory = new IndexFactory(6);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigInteger>(bigInteger, indexFactory);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial2 = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial3 = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        GenExteriorPolynomial<GenExteriorPolynomial<GenExteriorPolynomial<BigInteger>>> genExteriorPolynomial4 = genExteriorPolynomial.multiply((BigInteger)((Object)genExteriorPolynomial2.sum((BigInteger)((Object)genExteriorPolynomial3))));
        GenExteriorPolynomial<GenExteriorPolynomial<GenExteriorPolynomial<BigInteger>>> genExteriorPolynomial5 = genExteriorPolynomial.multiply((BigInteger)((Object)genExteriorPolynomial2)).sum((GenExteriorPolynomial<BigInteger>)genExteriorPolynomial.multiply((BigInteger)((Object)genExteriorPolynomial3)));
        GenExteriorPolynomialTest.assertEquals((String)"a(b+c) = ab+ac", genExteriorPolynomial4, genExteriorPolynomial5);
    }

    public void testDivision() {
        BigRational bigRational = new BigRational();
        IndexFactory indexFactory = new IndexFactory(6);
        GenExteriorPolynomialRing<BigRational> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigRational>(bigRational, indexFactory);
        GenExteriorPolynomial<BigRational> genExteriorPolynomial = genExteriorPolynomialRing.random(this.kl + 2, this.ll, this.el);
        GenExteriorPolynomial<BigRational> genExteriorPolynomial2 = genExteriorPolynomialRing.random(this.kl - 1, this.ll, 2);
        GenExteriorPolynomial<BigRational>[] genExteriorPolynomialArray = genExteriorPolynomial.quotientRemainder((GenExteriorPolynomial<BigRational>)genExteriorPolynomialRing.getONE());
        GenExteriorPolynomial<BigRational> genExteriorPolynomial3 = genExteriorPolynomialArray[0];
        GenExteriorPolynomial<BigRational> genExteriorPolynomial4 = genExteriorPolynomialArray[1];
        GenExteriorPolynomial<GenExteriorPolynomial<BigRational>> genExteriorPolynomial5 = genExteriorPolynomial3.multiply((BigRational)genExteriorPolynomialRing.getONE()).sum((BigRational)((Object)genExteriorPolynomial4));
        GenExteriorPolynomialTest.assertEquals((String)"a = 0 a + a: ", genExteriorPolynomial, genExteriorPolynomial5);
    }

    public void testParser() {
        Element element;
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"a", "b", "c", "d", "e", "f"};
        IndexFactory indexFactory = new IndexFactory(6);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigInteger>(bigInteger, indexFactory);
        GenExteriorPolynomialTest.assertFalse((String)"not commutative", (boolean)genExteriorPolynomialRing.isCommutative());
        GenExteriorPolynomialTest.assertTrue((String)"associative", (boolean)genExteriorPolynomialRing.isAssociative());
        GenExteriorPolynomialTest.assertFalse((String)"not field", (boolean)genExteriorPolynomialRing.isField());
        List<GenExteriorPolynomial<BigInteger>> list = genExteriorPolynomialRing.generators();
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial = list.get(1);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial2 = list.get(2);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial3 = list.get(3);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial4 = list.get(4);
        GenExteriorPolynomialTest.assertEquals((String)"#s == 5: ", (int)genExteriorPolynomial.toString().length(), (int)5);
        GenExteriorPolynomialTest.assertEquals((String)"#s == 4: ", (int)genExteriorPolynomial2.toScript().length(), (int)4);
        GenExteriorPolynomial<GenExteriorPolynomial<GenExteriorPolynomial<BigInteger>>> genExteriorPolynomial5 = genExteriorPolynomial.multiply((BigInteger)((Object)genExteriorPolynomial2)).subtract((GenExteriorPolynomial<BigInteger>)genExteriorPolynomial3.multiply((BigInteger)((Object)genExteriorPolynomial4)));
        StringReader stringReader = new StringReader("1 E(1,2) - 1 E(3,4)");
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            element = genPolynomialTokenizer.nextExteriorPolynomial(genExteriorPolynomialRing);
        }
        catch (IOException iOException) {
            element = null;
            iOException.printStackTrace();
        }
        GenExteriorPolynomialTest.assertEquals((String)"parse() == ab - ba: ", (Object)element, genExteriorPolynomial5);
        element = genExteriorPolynomialRing.parse("1 E(1,2) - 1 E(3,4)");
        GenExteriorPolynomialTest.assertEquals((String)"parse() == 1 E(1,2) - 1 E(3,4): ", (Object)element, genExteriorPolynomial5);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray);
        GenExteriorPolynomialTest.assertTrue((String)"commutative", (boolean)genPolynomialRing.isCommutative());
        GenExteriorPolynomialTest.assertTrue((String)"associative", (boolean)genPolynomialRing.isAssociative());
        GenExteriorPolynomialTest.assertFalse((String)"not field", (boolean)genPolynomialRing.isField());
        stringReader = new StringReader("E(1,2) - E(3,4)");
        genPolynomialTokenizer = new GenPolynomialTokenizer(genPolynomialRing, stringReader);
        try {
            element = genPolynomialTokenizer.nextExteriorPolynomial();
        }
        catch (IOException iOException) {
            element = null;
            iOException.printStackTrace();
        }
        GenExteriorPolynomialTest.assertEquals((String)"parse() == E(1,2) - E(3,4): ", (Object)element, genExteriorPolynomial5);
    }

    public void testIterators() {
        BigInteger bigInteger = new BigInteger();
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigInteger>(bigInteger, "abcdef");
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial = genExteriorPolynomialRing.random(this.kl, 2 * this.ll, this.el);
        for (IndexListMonomial<BigInteger> indexListMonomial : genExteriorPolynomial) {
            GenExteriorPolynomialTest.assertFalse((String)"m.c == 0 ", (boolean)indexListMonomial.coefficient().isZERO());
            GenExteriorPolynomialTest.assertFalse((String)"m.e == 0 ", (boolean)indexListMonomial.indexlist().isZERO());
        }
    }

    public void testMatrix() {
        BigRational bigRational = new BigRational();
        int n = 13;
        IndexFactory indexFactory = new IndexFactory(n);
        GenExteriorPolynomialRing<BigRational> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigRational>(bigRational, indexFactory);
        int n2 = n;
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, n2, n2);
        AlgebraElem algebraElem = genMatrixRing.getONE();
        List list = genExteriorPolynomialRing.fromMatrix((GenMatrix<BigRational>)algebraElem);
        GenExteriorPolynomialTest.assertEquals((String)"#em == #A: ", (int)list.size(), (int)algebraElem.ring.rows);
        BigRational bigRational2 = genExteriorPolynomialRing.determinant(list);
        GenExteriorPolynomialTest.assertTrue((String)"det(em) == 1: ", (boolean)bigRational2.isONE());
        algebraElem = genMatrixRing.getZERO();
        list = genExteriorPolynomialRing.fromMatrix((GenMatrix<BigRational>)algebraElem);
        GenExteriorPolynomialTest.assertEquals((String)"#em == #A: ", (int)list.size(), (int)0);
        bigRational2 = genExteriorPolynomialRing.determinant(list);
        GenExteriorPolynomialTest.assertTrue((String)"det(em) == 0: ", (boolean)bigRational2.isZERO());
        algebraElem = genMatrixRing.randomUpper(3, 0.55f);
        list = genExteriorPolynomialRing.fromMatrix((GenMatrix<BigRational>)algebraElem);
        GenExteriorPolynomialTest.assertTrue((String)"#em <= #A: ", (list.size() <= algebraElem.matrix.size() ? 1 : 0) != 0);
        bigRational2 = genExteriorPolynomialRing.determinant(list);
        GenExteriorPolynomialTest.assertTrue((String)"det(em) == 0: ", (boolean)bigRational2.isZERO());
        algebraElem = genMatrixRing.random(5, 0.67f);
        list = genExteriorPolynomialRing.fromMatrix((GenMatrix<BigRational>)algebraElem);
        GenExteriorPolynomialTest.assertTrue((String)"#em <= #A: ", (list.size() <= algebraElem.matrix.size() ? 1 : 0) != 0);
        bigRational2 = genExteriorPolynomialRing.determinant(list);
        GenExteriorPolynomialTest.assertFalse((String)"det(em) != 0: ", (boolean)bigRational2.isZERO());
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, new String[]{"lambda"});
        BigRational bigRational3 = genPolynomialRing.determinant((GenMatrix<BigRational>)algebraElem);
        GenExteriorPolynomialTest.assertEquals((String)"det_exterior(A) == det_charpol(A): ", (Object)bigRational2, (Object)bigRational3);
    }

    public void testConversion() {
        BigRational bigRational = new BigRational();
        IndexFactory indexFactory = new IndexFactory(0, 20);
        GenExteriorPolynomialRing<BigRational> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigRational>(bigRational, indexFactory);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, new String[]{"a", "b", "c", "d"});
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl / 2, this.ll, 2, this.ql);
        GenExteriorPolynomial<BigRational> genExteriorPolynomial = genExteriorPolynomialRing.valueOf(genPolynomial);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        List<GenExteriorPolynomial<BigRational>> list = genExteriorPolynomialRing.valueOf(arrayList);
        GenExteriorPolynomialTest.assertEquals((String)"a == El[0]: ", genExteriorPolynomial, list.get(0));
        GenExteriorPolynomialTest.assertEquals((String)"sumNorm(p) == sumNorm(a): ", (Object)genPolynomial.sumNorm(), (Object)genExteriorPolynomial.sumNorm());
        GenExteriorPolynomial<BigRational> genExteriorPolynomial2 = genExteriorPolynomialRing.valueOf(genExteriorPolynomial);
        GenExteriorPolynomialTest.assertEquals((String)"a == b: ", genExteriorPolynomial, genExteriorPolynomial2);
        Element element = genExteriorPolynomialRing.fromInteger(7L);
        GenExteriorPolynomialTest.assertEquals((String)"7 == ldcf(c): ", (Object)bigRational.fromInteger(7L), ((GenExteriorPolynomial)element).leadingBaseCoefficient());
    }

    public void testResultant() {
        BigRational bigRational = new BigRational();
        IndexFactory indexFactory = new IndexFactory(0, 20);
        GenExteriorPolynomialRing<BigRational> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigRational>(bigRational, indexFactory);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, new String[]{"i"});
        GenPolynomial<RingElem<BigRational>> genPolynomial = genPolynomialRing.random(this.kl / 2, this.ll, this.el, this.ql);
        GenPolynomial<RingElem<BigRational>> genPolynomial2 = genPolynomialRing.random(this.kl / 2, this.ll, this.el, this.ql);
        BigRational bigRational2 = genExteriorPolynomialRing.resultant(genPolynomial, genPolynomial2);
        GenPolynomial<BigRational> genPolynomial3 = genPolynomial.gcd(genPolynomial2);
        GenExteriorPolynomialTest.assertTrue((String)("res != 0 && gcd == 1: " + bigRational2 + ", " + genPolynomial3), (!bigRational2.isZERO() && genPolynomial3.isONE() ? 1 : 0) != 0);
        GenPolynomial<RingElem<BigRational>> genPolynomial4 = genPolynomialRing.random(this.kl / 3, this.ll, this.el / 2, this.ql);
        genPolynomial4 = genPolynomial4.sum((BigRational)((Object)genPolynomialRing.generators().get(1)));
        genPolynomial = genPolynomial.multiply((RingElem<BigRational>)genPolynomial4);
        genPolynomial2 = genPolynomial2.multiply((BigRational)((Object)genPolynomial4));
        bigRational2 = genExteriorPolynomialRing.resultant(genPolynomial, genPolynomial2);
        genPolynomial3 = genPolynomial.gcd(genPolynomial2);
        GenExteriorPolynomialTest.assertTrue((String)("res == 0 && gcd != 1: " + bigRational2 + ", " + genPolynomial3), (bigRational2.isZERO() && !genPolynomial3.isONE() ? 1 : 0) != 0);
    }

    public void testExample() {
        BigInteger bigInteger = new BigInteger();
        IndexFactory indexFactory = new IndexFactory(4);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigInteger>(bigInteger, indexFactory);
        GenExteriorPolynomialTest.assertFalse((String)"not commutative", (boolean)genExteriorPolynomialRing.isCommutative());
        GenExteriorPolynomialTest.assertTrue((String)"associative", (boolean)genExteriorPolynomialRing.isAssociative());
        GenExteriorPolynomialTest.assertFalse((String)"not field", (boolean)genExteriorPolynomialRing.isField());
        Element element = genExteriorPolynomialRing.parse("E(1,2,3,4)");
        System.out.println("emaxd = " + (GenExteriorPolynomial)element + ", imax = " + genExteriorPolynomialRing.ixfac.imax);
        Element element2 = genExteriorPolynomialRing.parse("1 E(1) + 5 E(2) - 2 E(3) + 1 E(4)");
        Element element3 = genExteriorPolynomialRing.parse("4 E(1) + 3 E(2) + 6 E(3) + 1 E(4)");
        System.out.println("p1 = " + (GenExteriorPolynomial)element2);
        System.out.println("p2 = " + (GenExteriorPolynomial)element3);
        Element element4 = genExteriorPolynomialRing.parse("3 E(1) - 2 E(2) - 1 E(3) + 1 E(4)");
        Element element5 = genExteriorPolynomialRing.parse("1 E(2) + 5 E(3) + 1 E(4)");
        System.out.println("q1 = " + (GenExteriorPolynomial)element4);
        System.out.println("q2 = " + (GenExteriorPolynomial)element5);
        Element element6 = genExteriorPolynomialRing.parse("1 E(3) + 1 E(4)");
        System.out.println("s = " + (GenExteriorPolynomial)element6);
        AbelianGroupElem abelianGroupElem = ((GenExteriorPolynomial)element2).multiply(element3).abs();
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial = ((GenExteriorPolynomial)((GenExteriorPolynomial)element4).multiply(element5).abs()).divide(new BigInteger(3L));
        System.out.println("g1 = p1 /\\ p2 = " + (GenExteriorPolynomial)abelianGroupElem);
        System.out.println("g2 = q1 /\\ q2 = " + genExteriorPolynomial);
        System.out.println("pp(g2) = " + ((GenExteriorPolynomial)element4).multiply(element5).coeffPrimitivePart());
        GenExteriorPolynomialTest.assertEquals((String)"g2 == pp(g2): ", genExteriorPolynomial, ((GenExteriorPolynomial)element4).multiply(element5).coeffPrimitivePart());
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial2 = ((GenExteriorPolynomial)((GenExteriorPolynomial)abelianGroupElem).multiply(element6).abs()).divide(new BigInteger(17L));
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial3 = genExteriorPolynomial.multiply((BigInteger)element6);
        System.out.println("e1 = g1 /\\ s = " + genExteriorPolynomial2);
        System.out.println("e2 = g2 /\\ s = " + genExteriorPolynomial3);
        GenExteriorPolynomialTest.assertEquals((String)"e1 == pp(e1): ", genExteriorPolynomial2, ((GenExteriorPolynomial)abelianGroupElem).multiply(element6).coeffPrimitivePart());
        AbelianGroupElem abelianGroupElem2 = genExteriorPolynomial2.interiorRightProduct((GenExteriorPolynomial<BigInteger>)element).abs();
        AbelianGroupElem abelianGroupElem3 = genExteriorPolynomial3.interiorRightProduct((GenExteriorPolynomial<BigInteger>)element).abs();
        System.out.println("e1dual = e1 |_ emaxd = " + (GenExteriorPolynomial)abelianGroupElem2);
        System.out.println("e2dual = e2 |_ emaxd = " + (GenExteriorPolynomial)abelianGroupElem3);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial4 = ((GenExteriorPolynomial)((GenExteriorPolynomial)abelianGroupElem2).multiply(abelianGroupElem3).abs()).divide(new BigInteger(5L));
        System.out.println("q  = (e1dual /\\ e2dual) = " + genExteriorPolynomial4);
        GenExteriorPolynomialTest.assertEquals((String)"q == pp(q): ", genExteriorPolynomial4, ((GenExteriorPolynomial)abelianGroupElem2).multiply(abelianGroupElem3).coeffPrimitivePart());
        AbelianGroupElem abelianGroupElem4 = genExteriorPolynomial4.interiorRightProduct((GenExteriorPolynomial<BigInteger>)element).abs();
        System.out.println("qs = (e1dual /\\ e2dual) |_ emaxd = " + (GenExteriorPolynomial)abelianGroupElem4);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial5 = ((GenExteriorPolynomial)genExteriorPolynomial2.interiorLeftProduct((GenExteriorPolynomial<BigInteger>)abelianGroupElem3).abs()).divide(new BigInteger(5L));
        System.out.println("qt = e1 _| e2dual                = " + genExteriorPolynomial5);
        GenExteriorPolynomialTest.assertEquals((String)"qt == pp(qt): ", genExteriorPolynomial5, genExteriorPolynomial2.interiorLeftProduct((GenExteriorPolynomial<BigInteger>)abelianGroupElem3).coeffPrimitivePart());
        GenExteriorPolynomialTest.assertEquals((String)"qs == qt: ", (Object)abelianGroupElem4, genExteriorPolynomial5);
        GenExteriorPolynomial genExteriorPolynomial6 = ((GenExteriorPolynomial)abelianGroupElem).interiorRightProduct(element);
        AbelianGroupElem abelianGroupElem5 = genExteriorPolynomial.interiorRightProduct((GenExteriorPolynomial<BigInteger>)element).abs();
        System.out.println("g1dual = g1 |_ emaxd = " + genExteriorPolynomial6);
        System.out.println("g2dual = g2 |_ emaxd = " + (GenExteriorPolynomial)abelianGroupElem5);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial7 = ((GenExteriorPolynomial)genExteriorPolynomial3.interiorLeftProduct(genExteriorPolynomial6).abs()).divide(new BigInteger(5L));
        System.out.println("s1 = e2 _| g1dual = " + genExteriorPolynomial7);
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial8 = ((GenExteriorPolynomial)genExteriorPolynomial2.interiorLeftProduct((GenExteriorPolynomial<BigInteger>)abelianGroupElem5).abs()).divide(new BigInteger(5L));
        System.out.println("s2 = e1 _| g2dual = " + genExteriorPolynomial8);
        System.out.println(" s /\\ qs =  s \\in qs = " + ((GenExteriorPolynomial)element6).multiply(abelianGroupElem4));
        System.out.println("qs /\\ e1 = qs \\in e1 = " + ((GenExteriorPolynomial)abelianGroupElem4).multiply(genExteriorPolynomial2));
        System.out.println("qs /\\ e2 = qs \\in e2 = " + ((GenExteriorPolynomial)abelianGroupElem4).multiply(genExteriorPolynomial3));
        GenExteriorPolynomialTest.assertTrue((String)"qs /\\ s == 0: ", (boolean)((GenExteriorPolynomial)abelianGroupElem4).multiply(element6).isZERO());
        GenExteriorPolynomialTest.assertTrue((String)"qs /\\ e1 == 0: ", (boolean)((GenExteriorPolynomial)abelianGroupElem4).multiply(genExteriorPolynomial2).isZERO());
        GenExteriorPolynomialTest.assertTrue((String)"qs /\\ e2 == 0: ", (boolean)((GenExteriorPolynomial)abelianGroupElem4).multiply(genExteriorPolynomial3).isZERO());
    }

    public void testDerivation() {
        BigRational bigRational = new BigRational();
        String[] stringArray = new String[]{"x1", "x2", "x3"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray);
        String string = genPolynomialRing.toScript();
        GenExteriorPolynomialTest.assertEquals((String)("#s == 38: " + string), (int)string.length(), (int)38);
        string = genPolynomialRing.toString();
        GenExteriorPolynomialTest.assertEquals((String)("#s == 31: " + string), (int)string.length(), (int)31);
        Element element = genPolynomialRing.getONE();
        GenExteriorPolynomialTest.assertTrue((String)"p == 1", (boolean)((GenPolynomial)element).isONE());
        element = genPolynomialRing.getZERO();
        GenExteriorPolynomialTest.assertTrue((String)"p == 0", (boolean)((GenPolynomial)element).isZERO());
        List<GenPolynomial<BigRational>> list = genPolynomialRing.generators();
        GenExteriorPolynomialTest.assertTrue((String)"#gens == 4", (list.size() == 4 ? 1 : 0) != 0);
        RingElem ringElem = new GenPolynomial<BigRational>(genPolynomialRing);
        GenExteriorPolynomialTest.assertTrue((String)"p.equals(pe) = ", (boolean)((GenPolynomial)element).equals(ringElem));
        GenExteriorPolynomialTest.assertTrue((String)"p.equals(p) = ", (boolean)((GenPolynomial)element).equals(element));
        ringElem = (RingElem)ringElem.sum(element);
        GenExteriorPolynomialTest.assertTrue((String)"pe.isZERO() = ", (boolean)ringElem.isZERO());
        element = genPolynomialRing.random(this.kl, this.ll, this.el, this.ql);
        element = ((GenPolynomial)element).subtract(element);
        GenExteriorPolynomialTest.assertTrue((String)"p.isZERO() = ", (boolean)((GenPolynomial)element).isZERO());
        IndexFactory indexFactory = new IndexFactory(3);
        GenExteriorPolynomialRing<BigRational> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigRational>(genPolynomialRing, indexFactory);
        Element element2 = genExteriorPolynomialRing.getONE();
        GenExteriorPolynomialTest.assertTrue((String)"pp == 1", (boolean)((GenExteriorPolynomial)element2).isONE());
        element2 = genExteriorPolynomialRing.getZERO();
        GenExteriorPolynomialTest.assertTrue((String)"pp == 0", (boolean)((GenExteriorPolynomial)element2).isZERO());
        List<GenExteriorPolynomial<BigRational>> list2 = genExteriorPolynomialRing.generators();
        GenExteriorPolynomialTest.assertTrue((String)"#pgens == 4+3", (list2.size() == 7 ? 1 : 0) != 0);
        GenExteriorPolynomialTest.assertFalse((String)"commutative", (boolean)genExteriorPolynomialRing.isCommutative());
        GenExteriorPolynomialTest.assertTrue((String)"associative", (boolean)genExteriorPolynomialRing.isAssociative());
        GenExteriorPolynomialTest.assertFalse((String)"not field", (boolean)genExteriorPolynomialRing.isField());
        GenExteriorPolynomialTest.assertEquals((String)"ppf == ppf: ", genExteriorPolynomialRing, genExteriorPolynomialRing);
        element2 = genExteriorPolynomialRing.random(this.kl, this.ll, this.el);
        long l = ((GenExteriorPolynomial)element2).degree();
        GenExteriorPolynomial genExteriorPolynomial = PolyUtil.exteriorDerivativePoly(element2);
        GenExteriorPolynomialTest.assertTrue((String)"deg >= 0: ", (l >= 0L && genExteriorPolynomial.degree() >= 0L ? 1 : 0) != 0);
        l = genExteriorPolynomial.degree();
        genExteriorPolynomial = PolyUtil.exteriorDerivativePoly(genExteriorPolynomial);
        GenExteriorPolynomialTest.assertTrue((String)"deg >= 0: ", (l >= 0L && genExteriorPolynomial.degree() >= 0L ? 1 : 0) != 0);
        StringReader stringReader = new StringReader("{x1 + x2 + x3} E(1) E(2)");
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            element2 = genPolynomialTokenizer.nextExteriorPolynomial(genExteriorPolynomialRing);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        l = ((GenExteriorPolynomial)element2).degree();
        genExteriorPolynomial = PolyUtil.exteriorDerivativePoly(element2);
        GenExteriorPolynomialTest.assertTrue((String)"deg >= 0: ", (l >= 0L && genExteriorPolynomial.degree() >= 0L ? 1 : 0) != 0);
        l = genExteriorPolynomial.degree();
        genExteriorPolynomial = PolyUtil.exteriorDerivativePoly(genExteriorPolynomial);
        GenExteriorPolynomialTest.assertTrue((String)"deg >= 0: ", (l >= 0L && genExteriorPolynomial.degree() >= 0L ? 1 : 0) != 0);
        GenExteriorPolynomialTest.assertTrue((String)"der(der) == 0: ", (boolean)genExteriorPolynomial.isZERO());
        stringReader = new StringReader("x3 E(1) + x3 E(2)");
        genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            element2 = genPolynomialTokenizer.nextExteriorPolynomial(genExteriorPolynomialRing);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        l = ((GenExteriorPolynomial)element2).degree();
        genExteriorPolynomial = PolyUtil.exteriorDerivativePoly(element2);
        GenExteriorPolynomialTest.assertTrue((String)"deg >= 0: ", (l >= 0L && genExteriorPolynomial.degree() >= 0L ? 1 : 0) != 0);
        l = genExteriorPolynomial.degree();
        genExteriorPolynomial = PolyUtil.exteriorDerivativePoly(genExteriorPolynomial);
        GenExteriorPolynomialTest.assertTrue((String)"deg >= 0: ", (l >= 0L && genExteriorPolynomial.degree() >= 0L ? 1 : 0) != 0);
        GenExteriorPolynomialTest.assertTrue((String)"der(der) == 0: ", (boolean)genExteriorPolynomial.isZERO());
    }

    public void testForms() {
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial;
        int n;
        BigInteger bigInteger = new BigInteger();
        IndexFactory indexFactory = new IndexFactory(6, false);
        IndexFactory indexFactory2 = new IndexFactory(6, true);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing = new GenExteriorPolynomialRing<BigInteger>(bigInteger, indexFactory);
        GenExteriorPolynomialRing<BigInteger> genExteriorPolynomialRing2 = new GenExteriorPolynomialRing<BigInteger>(bigInteger, indexFactory2);
        Element<GenExteriorPolynomial<BigInteger>> element = genExteriorPolynomialRing.getONE();
        GenExteriorPolynomialTest.assertTrue((String)"homogen(p): ", (boolean)((GenExteriorPolynomial)element).isHomogeneous());
        GenExteriorPolynomial<BigInteger> genExteriorPolynomial2 = genExteriorPolynomialRing.random(this.kl, this.ll * 4, this.rl);
        for (n = 0; n <= indexFactory.imaxlength; ++n) {
            genExteriorPolynomial = genExteriorPolynomial2.homogeneousPart(n);
            GenExteriorPolynomialTest.assertTrue((String)"homogen(h): ", (boolean)genExteriorPolynomial.isHomogeneous());
            GenExteriorPolynomial<BigInteger> genExteriorPolynomial3 = genExteriorPolynomial2.form(n);
            GenExteriorPolynomialTest.assertTrue((String)"homogen(f): ", (boolean)genExteriorPolynomial3.isHomogeneous());
            GenExteriorPolynomialTest.assertEquals((String)"homogen(h) == form(h): ", genExteriorPolynomial, genExteriorPolynomial3);
        }
        element = genExteriorPolynomialRing2.getZERO();
        for (n = 0; n <= indexFactory.imaxlength; ++n) {
            genExteriorPolynomial = genExteriorPolynomialRing2.randomForm(this.kl, this.ll, n);
            GenExteriorPolynomialTest.assertTrue((String)"homogen(hf): ", (boolean)genExteriorPolynomial.isHomogeneous());
            GenExteriorPolynomialTest.assertTrue((String)"deg(hf): ", (genExteriorPolynomial.isZERO() || genExteriorPolynomial.degree() == (long)n ? 1 : 0) != 0);
            element = ((GenExteriorPolynomial)element).sum(genExteriorPolynomial);
        }
    }
}

