/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.ModIntegerRing;
import edu.jas.kern.PreemptStatus;
import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialIterator;
import edu.jas.poly.GenPolynomialMonomialIterator;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolynomialComparator;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import edu.jas.vector.GenVector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenPolynomialRing<C extends RingElem<C>>
implements RingFactory<GenPolynomial<C>>,
Iterable<GenPolynomial<C>> {
    public final RingFactory<C> coFac;
    public final int nvar;
    public final TermOrder tord;
    protected boolean partial;
    protected String[] vars;
    private static AtomicLong varCounter = new AtomicLong(0L);
    public GenPolynomial<C> ZERO;
    public GenPolynomial<C> ONE;
    public final ExpVector evzero;
    protected static final Random random = new Random();
    protected int isField = -1;
    private static final Logger logger = LogManager.getLogger(GenPolynomialRing.class);
    static int creations = 0;
    volatile boolean checkPreempt = PreemptStatus.isAllowed();

    public GenPolynomialRing(RingFactory<C> ringFactory, int n) {
        this(ringFactory, n, new TermOrder(), null);
    }

    public GenPolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder) {
        this(ringFactory, n, termOrder, null);
    }

    public GenPolynomialRing(RingFactory<C> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, stringArray);
    }

    public GenPolynomialRing(RingFactory<C> ringFactory, int n, String[] stringArray) {
        this(ringFactory, n, new TermOrder(), stringArray);
    }

    public GenPolynomialRing(RingFactory<C> ringFactory, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, stringArray.length, termOrder, stringArray);
    }

    public GenPolynomialRing(RingFactory<C> ringFactory, String[] stringArray, TermOrder termOrder) {
        this(ringFactory, stringArray.length, termOrder, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenPolynomialRing(RingFactory<C> ringFactory, int n, TermOrder termOrder, String[] stringArray) {
        this.coFac = ringFactory;
        this.nvar = n;
        this.tord = termOrder;
        this.partial = false;
        this.vars = stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length);
        RingElem ringElem = (RingElem)this.coFac.getONE();
        GenPolynomialRing genPolynomialRing = this;
        synchronized (genPolynomialRing) {
            this.evzero = ExpVector.create(this.nvar);
            this.ZERO = new GenPolynomial(this);
            this.ONE = new GenPolynomial<RingElem>(this, ringElem, this.evzero);
        }
        if (this.vars == null) {
            if (PrettyPrint.isTrue()) {
                this.vars = GenPolynomialRing.newVars("x", this.nvar);
            }
        } else if (this.vars.length != this.nvar) {
            throw new IllegalArgumentException("incompatible variable size " + this.vars.length + ", " + this.nvar);
        }
    }

    public GenPolynomialRing(RingFactory<C> ringFactory, GenPolynomialRing genPolynomialRing) {
        this(ringFactory, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
    }

    public GenPolynomialRing(GenPolynomialRing<C> genPolynomialRing, TermOrder termOrder) {
        this(genPolynomialRing.coFac, genPolynomialRing.nvar, termOrder, genPolynomialRing.vars);
    }

    public GenPolynomialRing<C> copy() {
        return new GenPolynomialRing<C>(this.coFac, this);
    }

    public String toString() {
        Object object = null;
        if (PrettyPrint.isTrue()) {
            Iterable iterable;
            String string = this.coFac.getClass().getSimpleName();
            if (this.coFac instanceof AlgebraicNumberRing) {
                iterable = (AlgebraicNumberRing)this.coFac;
                object = "AN[ (" + ((AlgebraicNumberRing)iterable).ring.varsToString() + ") (" + ((AlgebraicNumberRing)iterable).toString() + ") ]";
            }
            if (this.coFac instanceof GenPolynomialRing) {
                iterable = (GenPolynomialRing)this.coFac;
                object = "IntFunc( " + ((GenPolynomialRing)iterable).toString() + " )";
            }
            if (this.coFac instanceof ModIntegerRing) {
                iterable = (ModIntegerRing)this.coFac;
                object = "Mod " + ((ModIntegerRing)iterable).getModul() + " ";
            }
            if (object == null && ((String)(object = this.coFac.toString())).matches("[0-9].*")) {
                object = string;
            }
            object = (String)object + "( " + this.varsToString() + " ) " + this.tord.toString() + " ";
        } else {
            Iterable iterable;
            object = this.getClass().getSimpleName() + "[ " + this.coFac.toString() + " ";
            if (this.coFac instanceof AlgebraicNumberRing) {
                iterable = (AlgebraicNumberRing)this.coFac;
                object = "AN[ (" + ((AlgebraicNumberRing)iterable).ring.varsToString() + ") (" + ((AlgebraicNumberRing)iterable).modul + ") ]";
            }
            if (this.coFac instanceof GenPolynomialRing) {
                iterable = (GenPolynomialRing)this.coFac;
                object = "IntFunc( " + ((GenPolynomialRing)iterable).toString() + " )";
            }
            if (this.coFac instanceof ModIntegerRing) {
                iterable = (ModIntegerRing)this.coFac;
                object = "Mod " + ((ModIntegerRing)iterable).getModul() + " ";
            }
            object = (String)object + "( " + this.varsToString() + " ) " + this.tord.toString() + " ]";
        }
        return object;
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("PolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("PolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",\"" + this.varsToString() + "\"");
        String string = this.tord.toScript();
        stringBuffer.append("," + string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toScript(ExpVector expVector) {
        if (expVector == null) {
            return "null";
        }
        if (this.vars != null) {
            return expVector.toScript(this.vars);
        }
        return expVector.toScript();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenPolynomialRing)) {
            return false;
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)object;
        if (this.nvar != genPolynomialRing.nvar) {
            return false;
        }
        if (!this.coFac.equals(genPolynomialRing.coFac)) {
            return false;
        }
        if (!this.tord.equals(genPolynomialRing.tord)) {
            return false;
        }
        return Arrays.deepEquals(this.vars, genPolynomialRing.vars);
    }

    public int hashCode() {
        int n = this.nvar << 27;
        n += this.coFac.hashCode() << 11;
        n += this.tord.hashCode() << 9;
        return n += Arrays.hashCode(this.vars);
    }

    public int getCreations() {
        return creations;
    }

    public String[] getVars() {
        return Arrays.copyOf(this.vars, this.vars.length);
    }

    public String[] setVars(String[] stringArray) {
        if (stringArray.length != this.nvar) {
            throw new IllegalArgumentException("v not matching number of variables: " + Arrays.toString(stringArray) + ", nvar " + this.nvar);
        }
        String[] stringArray2 = this.vars;
        this.vars = Arrays.copyOf(stringArray, stringArray.length);
        return stringArray2;
    }

    public String varsToString() {
        if (this.vars == null) {
            return "#" + this.nvar;
        }
        return ExpVector.varsToString(this.vars);
    }

    public C getZEROCoefficient() {
        return (C)((RingElem)this.coFac.getZERO());
    }

    public C getONECoefficient() {
        return (C)((RingElem)this.coFac.getONE());
    }

    @Override
    public synchronized GenPolynomial<C> getZERO() {
        if (this.ZERO == null || !this.ZERO.isZERO()) {
            GenPolynomial<C> genPolynomial = this.ZERO;
            this.ZERO = new GenPolynomial(this);
            logger.info("warn: ZERO@get |{}| wrong fix to {}", genPolynomial, this.ZERO);
        }
        return this.ZERO;
    }

    @Override
    public synchronized GenPolynomial<C> getONE() {
        if (this.ONE == null || !this.ONE.isONE()) {
            this.ONE = new GenPolynomial<RingElem>(this, (RingElem)this.coFac.getONE(), this.evzero);
            logger.info("warn: ONE@get {}", this.ONE);
        }
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.coFac.isField() && this.nvar == 0) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public GenPolynomial<C> valueOf(C c) {
        return new GenPolynomial<C>(this, c);
    }

    public GenPolynomial<C> valueOf(ExpVector expVector) {
        if (expVector == null) {
            return this.getZERO();
        }
        return new GenPolynomial<RingElem>(this, (RingElem)this.coFac.getONE(), expVector);
    }

    public List<GenPolynomial<C>> valueOf(Iterable<ExpVector> iterable) {
        if (iterable == null) {
            return null;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        for (ExpVector expVector : iterable) {
            GenPolynomial<C> genPolynomial = this.valueOf(expVector);
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    public GenPolynomial<C> valueOf(C c, ExpVector expVector) {
        return new GenPolynomial<C>(this, c, expVector);
    }

    public GenPolynomial<C> valueOf(Monomial<C> monomial) {
        return new GenPolynomial(this, monomial.c, monomial.e);
    }

    @Override
    public GenPolynomial<C> fromInteger(long l) {
        return new GenPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(l), this.evzero);
    }

    @Override
    public GenPolynomial<C> fromInteger(BigInteger bigInteger) {
        return new GenPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(bigInteger), this.evzero);
    }

    public GenPolynomial<C> fromVector(GenVector<C> genVector) {
        if (genVector == null || genVector.isZERO()) {
            return this.ZERO;
        }
        if (this.nvar != 1) {
            throw new IllegalArgumentException("no univariate polynomial ring");
        }
        GenPolynomial<C> genPolynomial = this.copy(this.ZERO);
        SortedMap sortedMap = genPolynomial.val;
        long l = -1L;
        for (RingElem ringElem : genVector.val) {
            ++l;
            if (ringElem.isZERO()) continue;
            ExpVector expVector = ExpVector.create(1, 0, l);
            sortedMap.put(expVector, ringElem);
        }
        return genPolynomial;
    }

    @Override
    public GenPolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public GenPolynomial<C> random(int n, Random random) {
        if (this.nvar == 1) {
            return this.random(3, n, n, 0.5f, random);
        }
        return this.random(3, n, n, 0.3f, random);
    }

    public GenPolynomial<C> random(int n, int n2, int n3, float f) {
        return this.random(n, n2, n3, f, random);
    }

    public GenPolynomial<C> random(int n, int n2, int n3, float f, Random random) {
        GenPolynomial<RingElem> genPolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            ExpVector expVector = ExpVector.random(this.nvar, n3, f, random);
            RingElem ringElem = (RingElem)this.coFac.random(n, random);
            genPolynomial = genPolynomial.sum(ringElem, expVector);
        }
        return genPolynomial;
    }

    @Override
    public GenPolynomial<C> copy(GenPolynomial<C> genPolynomial) {
        return new GenPolynomial(this, genPolynomial.val);
    }

    @Override
    public List<GenPolynomial<C>> copy(List<GenPolynomial<C>> list) {
        if (list == null) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            arrayList.add(this.copy(genPolynomial));
        }
        return arrayList;
    }

    @Override
    public GenPolynomial<C> parse(String string) {
        String string2 = string;
        if (!string.contains("|")) {
            string2 = string2.replace("{", "").replace("}", "");
        }
        return this.parse(new StringReader(string2));
    }

    @Override
    public GenPolynomial<C> parse(Reader reader) {
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this, reader);
        GenPolynomial<C> genPolynomial = null;
        try {
            genPolynomial = genPolynomialTokenizer.nextPolynomial();
        }
        catch (IOException iOException) {
            logger.error("{} parse {}", (Object)iOException, (Object)this);
            genPolynomial = this.ZERO;
        }
        return genPolynomial;
    }

    public GenPolynomial<C> univariate(String string) {
        return this.univariate(string, 1L);
    }

    public GenPolynomial<C> univariate(String string, long l) {
        int n;
        if (this.vars == null) {
            throw new IllegalArgumentException("no variables defined for polynomial ring");
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("no variable name given");
        }
        for (n = 0; n < this.vars.length && !string.equals(this.vars[n]); ++n) {
        }
        if (n >= this.vars.length) {
            throw new IllegalArgumentException("variable '" + string + "' not defined in polynomial ring");
        }
        return this.univariate(0, this.nvar - n - 1, l);
    }

    public GenPolynomial<C> univariate(int n) {
        return this.univariate(0, n, 1L);
    }

    public GenPolynomial<C> univariate(int n, long l) {
        return this.univariate(0, n, l);
    }

    public GenPolynomial<C> univariate(int n, int n2, long l) {
        GenPolynomial<RingElem> genPolynomial = this.getZERO();
        int n3 = this.nvar - n;
        if (0 <= n2 && n2 < n3) {
            RingElem ringElem = (RingElem)this.coFac.getONE();
            ExpVector expVector = ExpVector.create(n3, n2, l);
            if (n > 0) {
                expVector = expVector.extend(n, 0, 0L);
            }
            genPolynomial = genPolynomial.sum(ringElem, expVector);
        }
        return genPolynomial;
    }

    public List<GenPolynomial<C>> getGenerators() {
        List<GenPolynomial<C>> list = this.univariateList();
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size() + 1);
        arrayList.add((GenPolynomial<C>)this.getONE());
        arrayList.addAll(list);
        return arrayList;
    }

    @Override
    public List<GenPolynomial<C>> generators() {
        List list = this.coFac.generators();
        List<GenPolynomial<C>> list2 = this.univariateList();
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list2.size() + list.size());
        for (RingElem ringElem : list) {
            arrayList.add(((GenPolynomial)this.getONE()).multiply(ringElem));
        }
        arrayList.addAll(list2);
        return arrayList;
    }

    public List<GenPolynomial<C>> generators(int n) {
        List list = this.coFac.generators();
        List<GenPolynomial<C>> list2 = this.univariateList(n);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list2.size() + list.size());
        for (RingElem ringElem : list) {
            arrayList.add(((GenPolynomial)this.getONE()).multiply(ringElem));
        }
        arrayList.addAll(list2);
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return this.nvar == 0 && this.coFac.isFinite();
    }

    public List<? extends GenPolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    public List<? extends GenPolynomial<C>> univariateList(int n) {
        return this.univariateList(n, 1L);
    }

    public List<? extends GenPolynomial<C>> univariateList(int n, long l) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(this.nvar);
        int n2 = this.nvar - n;
        for (int i = 0; i < n2; ++i) {
            GenPolynomial<C> genPolynomial = this.univariate(n, n2 - 1 - i, l);
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    public GenPolynomialRing<C> extend(int n) {
        return this.extend(n, false);
    }

    public GenPolynomialRing<C> extend(int n, boolean bl) {
        String[] stringArray = GenPolynomialRing.newVars("e", n);
        return this.extend(stringArray, bl);
    }

    public GenPolynomialRing<C> extend(String[] stringArray) {
        return this.extend(stringArray, false);
    }

    public GenPolynomialRing<C> extend(String[] stringArray, boolean bl) {
        int n;
        if (stringArray == null || this.vars == null) {
            throw new IllegalArgumentException("vn and vars may not be null");
        }
        int n2 = stringArray.length;
        String[] stringArray2 = new String[this.vars.length + n2];
        for (n = 0; n < this.vars.length; ++n) {
            stringArray2[n] = this.vars[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[this.vars.length + n] = stringArray[n];
        }
        TermOrder termOrder = this.tord.extend(this.nvar, n2, bl);
        GenPolynomialRing<C> genPolynomialRing = new GenPolynomialRing<C>(this.coFac, this.nvar + n2, termOrder, stringArray2);
        return genPolynomialRing;
    }

    public GenPolynomialRing<C> extendLower(int n) {
        String[] stringArray = GenPolynomialRing.newVars("e", n);
        return this.extendLower(stringArray);
    }

    public GenPolynomialRing<C> extendLower(String[] stringArray) {
        return this.extendLower(stringArray, false);
    }

    public GenPolynomialRing<C> extendLower(String[] stringArray, boolean bl) {
        int n;
        if (stringArray == null || this.vars == null) {
            throw new IllegalArgumentException("vn and vars may not be null");
        }
        int n2 = stringArray.length;
        String[] stringArray2 = new String[this.vars.length + n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        for (n = 0; n < this.vars.length; ++n) {
            stringArray2[stringArray.length + n] = this.vars[n];
        }
        TermOrder termOrder = this.tord.extendLower(this.nvar, n2, bl);
        GenPolynomialRing<C> genPolynomialRing = new GenPolynomialRing<C>(this.coFac, this.nvar + n2, termOrder, stringArray2);
        return genPolynomialRing;
    }

    public GenPolynomialRing<C> contract(int n) {
        String[] stringArray = null;
        if (this.vars != null) {
            stringArray = new String[this.vars.length - n];
            for (int i = 0; i < this.vars.length - n; ++i) {
                stringArray[i] = this.vars[i];
            }
        }
        TermOrder termOrder = this.tord.contract(n, this.nvar - n);
        GenPolynomialRing<C> genPolynomialRing = new GenPolynomialRing<C>(this.coFac, this.nvar - n, termOrder, stringArray);
        return genPolynomialRing;
    }

    public GenPolynomialRing<GenPolynomial<C>> recursive(int n) {
        if (n <= 0 || n >= this.nvar) {
            throw new IllegalArgumentException("wrong: 0 < " + n + " < " + this.nvar);
        }
        GenPolynomialRing<C> genPolynomialRing = this.contract(n);
        String[] stringArray = null;
        if (this.vars != null) {
            stringArray = new String[n];
            int n2 = 0;
            for (int i = this.nvar - n; i < this.nvar; ++i) {
                stringArray[n2++] = this.vars[i];
            }
        }
        TermOrder termOrder = this.tord.contract(0, n);
        GenPolynomialRing<GenPolynomial<C>> genPolynomialRing2 = new GenPolynomialRing<GenPolynomial<C>>(genPolynomialRing, n, termOrder, stringArray);
        return genPolynomialRing2;
    }

    public GenPolynomialRing<C> distribute() {
        RingFactory<C> ringFactory;
        if (!(this.coFac instanceof GenPolynomialRing)) {
            return this;
        }
        RingFactory<C> ringFactory2 = ringFactory = this.coFac;
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)ringFactory2;
        GenPolynomialRing<C> genPolynomialRing2 = genPolynomialRing.vars != null ? this.extend(genPolynomialRing.vars) : this.extend(genPolynomialRing.nvar);
        return genPolynomialRing2;
    }

    public GenPolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    public GenPolynomialRing<C> reverse(boolean bl) {
        String[] stringArray = null;
        if (this.vars != null) {
            int n;
            stringArray = new String[this.vars.length];
            int n2 = this.tord.getSplit();
            if (bl && n2 < this.vars.length) {
                for (n = 0; n < n2; ++n) {
                    stringArray[this.vars.length - n2 + n] = this.vars[this.vars.length - n2 + n];
                }
                for (n = 0; n < this.vars.length - n2; ++n) {
                    stringArray[n] = this.vars[this.vars.length - n2 - n - 1];
                }
            } else {
                for (n = 0; n < this.vars.length; ++n) {
                    stringArray[n] = this.vars[this.vars.length - 1 - n];
                }
            }
        }
        TermOrder termOrder = this.tord.reverse(bl);
        GenPolynomialRing<C> genPolynomialRing = new GenPolynomialRing<C>(this.coFac, this.nvar, termOrder, stringArray);
        genPolynomialRing.partial = bl;
        return genPolynomialRing;
    }

    public PolynomialComparator<C> getComparator() {
        return new PolynomialComparator(this.tord, false);
    }

    public PolynomialComparator<C> getComparator(boolean bl) {
        return new PolynomialComparator(this.tord, bl);
    }

    public static String[] newVars(String string, int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            long l = varCounter.getAndIncrement();
            stringArray[i] = string + l;
        }
        return stringArray;
    }

    public String[] newVars(String string) {
        return GenPolynomialRing.newVars(string, this.nvar);
    }

    public static String[] newVars(int n) {
        return GenPolynomialRing.newVars("x", n);
    }

    public String[] newVars() {
        return GenPolynomialRing.newVars(this.nvar);
    }

    public static String[] permuteVars(List<Integer> list, String[] stringArray) {
        if (stringArray == null || stringArray.length <= 1) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (Integer n2 : list) {
            stringArray2[n++] = stringArray[n2];
        }
        return stringArray2;
    }

    public GenPolynomialRing<C> permutation(List<Integer> list) {
        if (this.nvar <= 1) {
            return this;
        }
        TermOrder termOrder = this.tord.permutation(list);
        if (this.vars == null) {
            return new GenPolynomialRing<C>(this.coFac, this.nvar, termOrder);
        }
        String[] stringArray = new String[this.vars.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.vars[stringArray.length - 1 - i];
        }
        String[] stringArray2 = GenPolynomialRing.permuteVars(list, stringArray);
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = stringArray2[stringArray2.length - 1 - i];
        }
        return new GenPolynomialRing<C>(this.coFac, this.nvar, termOrder, stringArray3);
    }

    public GenPolynomial<C> charPolynomial(GenMatrix<C> genMatrix) {
        if (genMatrix == null || genMatrix.isZERO()) {
            return this.ZERO;
        }
        if (this.nvar != 1) {
            throw new IllegalArgumentException("no univariate polynomial ring");
        }
        GenMatrixRing genMatrixRing = genMatrix.ring;
        int n = genMatrixRing.rows;
        BigInteger bigInteger = this.coFac.characteristic();
        if (bigInteger.signum() > 0 && bigInteger.compareTo(BigInteger.valueOf(n)) <= 0) {
            throw new UnsupportedOperationException("characteristic <= n: " + bigInteger + " <= " + n);
        }
        GenPolynomial<Object> genPolynomial = this.copy(this.ZERO);
        GenMatrix<RingElem> genMatrix2 = genMatrixRing.getZERO();
        MonoidElem monoidElem = genMatrixRing.getONE();
        ExpVector expVector = ExpVector.create(1, 0, n);
        RingElem ringElem = (RingElem)this.coFac.getONE();
        genPolynomial = genPolynomial.sum(ringElem, expVector);
        RingElem ringElem2 = (RingElem)this.coFac.getONE();
        GenMatrix<RingElem> genMatrix3 = null;
        GenMatrix<RingElem> genMatrix4 = null;
        for (int i = 1; i <= n; ++i) {
            genMatrix4 = genMatrix3 == null ? genMatrix.multiply(genMatrix2) : genMatrix3;
            GenMatrix<RingElem> genMatrix5 = ((GenMatrix)monoidElem).multiply(ringElem2);
            genMatrix4 = genMatrix4.sum(genMatrix5);
            genMatrix3 = genMatrix.multiply(genMatrix4);
            RingElem ringElem3 = genMatrix3.trace();
            RingElem ringElem4 = (RingElem)((RingElem)this.coFac.fromInteger(i)).inverse();
            ringElem3 = (RingElem)ringElem3.multiply((RingElem)ringElem4).negate();
            genMatrix2 = genMatrix4;
            ringElem2 = ringElem3;
            expVector = ExpVector.create(1, 0, n - i);
            genPolynomial = genPolynomial.sum(ringElem2, expVector);
        }
        return genPolynomial;
    }

    public C determinantFromCharPol(GenPolynomial<C> genPolynomial) {
        RingElem ringElem = (RingElem)this.coFac.getZERO();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return (C)ringElem;
        }
        ringElem = genPolynomial.trailingBaseCoefficient();
        if (genPolynomial.degree() % 2L != 0L) {
            ringElem = (RingElem)ringElem.negate();
        }
        return (C)ringElem;
    }

    public C determinant(GenMatrix<C> genMatrix) {
        GenPolynomial<C> genPolynomial = this.charPolynomial(genMatrix);
        return this.determinantFromCharPol(genPolynomial);
    }

    public C traceFromCharPol(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return (C)((RingElem)this.coFac.getZERO());
        }
        long l = genPolynomial.degree();
        ExpVector expVector = ExpVector.create(1, 0, l - 1L);
        RingElem ringElem = (RingElem)genPolynomial.coefficient(expVector).negate();
        return (C)ringElem;
    }

    @Override
    public Iterator<GenPolynomial<C>> iterator() {
        if (this.coFac.isFinite()) {
            return new GenPolynomialIterator(this);
        }
        logger.warn("ring of coefficients {} is infinite, constructing iterator only over monomials", this.coFac);
        return new GenPolynomialMonomialIterator(this);
    }
}

