/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.StringUtil;
import edu.jas.poly.ExpVector;
import edu.jas.poly.IndexList;
import edu.jas.poly.WordFactory;
import edu.jas.structure.MonoidFactory;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexFactory
implements MonoidFactory<IndexList> {
    public final int imaxlength;
    public final String vname;
    public final IndexList imax;
    final boolean weak;
    private static final Random random = new Random();
    private static final Logger logger = LogManager.getLogger(WordFactory.class);
    public final IndexList ONE;
    public static final String DEFAULT_VNAME = "E";
    public static final int DEFAULT_SIZE = 4;
    private final IndexListComparator horder = new IndexListComparator(){

        @Override
        public int compare(IndexList indexList, IndexList indexList2) {
            return -indexList.strongCompareTo(indexList2);
        }
    };
    private final IndexListComparator lorder = new IndexListComparator(){

        @Override
        public int compare(IndexList indexList, IndexList indexList2) {
            return indexList.strongCompareTo(indexList2);
        }
    };
    private final IndexListComparator hweak = new IndexListComparator(){

        @Override
        public int compare(IndexList indexList, IndexList indexList2) {
            return -indexList.weakCompareTo(indexList2);
        }
    };
    private final IndexListComparator lweak = new IndexListComparator(){

        @Override
        public int compare(IndexList indexList, IndexList indexList2) {
            return indexList.weakCompareTo(indexList2);
        }
    };

    public IndexFactory() {
        this(4, DEFAULT_VNAME);
    }

    public IndexFactory(int n) {
        this(1, n, DEFAULT_VNAME, false);
    }

    public IndexFactory(int n, boolean bl) {
        this(1, n, DEFAULT_VNAME, bl);
    }

    public IndexFactory(int n, String string) {
        this(1, n, string, false);
    }

    public IndexFactory(int n, String string, boolean bl) {
        this(1, n, string, bl);
    }

    public IndexFactory(int n, int n2) {
        this(n, n2, DEFAULT_VNAME, false);
    }

    public IndexFactory(int n, int n2, String string, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("negative length index not allowed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("negative start index not allowed");
        }
        this.imaxlength = n2;
        this.vname = string;
        this.weak = bl;
        this.imax = new IndexList(this, 1, IndexFactory.sequenceArray(n, this.imaxlength));
        this.ONE = new IndexList(this, 1, IndexFactory.sequenceArray(n, 0));
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public boolean isCommutative() {
        return this.imaxlength == 0;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public IndexList fromInteger(long l) {
        throw new UnsupportedOperationException("not implemented for IndexFactory");
    }

    @Override
    public IndexList fromInteger(BigInteger bigInteger) {
        throw new UnsupportedOperationException("not implemented for IndexFactory");
    }

    public IndexList valueOf(ExpVector expVector) {
        if (expVector == null) {
            return this.getZERO();
        }
        int n = expVector.length();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l = expVector.getVal(i);
            if (l <= 0L) continue;
            if (l > 1L) {
                return this.getZERO();
            }
            nArray[n2++] = i;
        }
        int[] nArray2 = Arrays.copyOf(nArray, n2);
        return new IndexList(this, nArray2);
    }

    @Override
    public IndexList valueOf(String string) {
        return this.sequence(0, string.length());
    }

    public IndexList valueOf(Collection<Integer> collection) {
        if (collection == null) {
            return this.getZERO();
        }
        int n = collection.size();
        int[] nArray = new int[n];
        int n2 = 0;
        for (Integer n3 : collection) {
            int n4 = n3;
            if (n4 < 0) continue;
            nArray[n2++] = n4;
        }
        Object object = Arrays.copyOf(nArray, n2);
        return new IndexList(this, (int[])object);
    }

    public IndexList valueOf(int[] nArray) {
        if (nArray == null) {
            return this.getZERO();
        }
        int n = nArray.length;
        IndexList indexList = new IndexList(this, new int[0]);
        int[] nArray2 = new int[1];
        for (int i = 0; i < n; ++i) {
            nArray2[0] = nArray[i];
            IndexList indexList2 = new IndexList(this, nArray2);
            if (!(indexList = indexList.exteriorProduct(indexList2)).isZERO()) continue;
            return indexList;
        }
        return indexList;
    }

    public IndexList valueOf(IndexList indexList) {
        if (indexList == null) {
            return this.getZERO();
        }
        return this.valueOf(indexList.val);
    }

    @Override
    public List<IndexList> generators() {
        ArrayList<IndexList> arrayList = new ArrayList<IndexList>();
        for (int i = 0; i < this.imax.val.length; ++i) {
            int[] nArray = new int[]{this.imax.val[i]};
            IndexList indexList = new IndexList(this, nArray);
            arrayList.add(indexList);
        }
        return arrayList;
    }

    @Override
    public IndexList copy(IndexList indexList) {
        if (indexList == null) {
            return indexList;
        }
        return indexList.copy();
    }

    public int length() {
        return this.imaxlength;
    }

    public String toString() {
        if (!this.weak) {
            return this.imax.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(this.imax.toString());
        stringBuffer.append("[" + this.weak + "]");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        if (!this.weak) {
            return this.imax.toScript();
        }
        StringBuffer stringBuffer = new StringBuffer(this.imax.toScript());
        stringBuffer.append("[" + this.weak + "]");
        return stringBuffer.toString();
    }

    @Override
    public IndexList parse(String string) throws NumberFormatException {
        int[] nArray = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        string = string.trim();
        int n = string.indexOf(40);
        int n2 = string.indexOf(41, n + 1);
        if (n >= 0 && n2 >= 0) {
            int n3;
            String string2;
            int n4;
            ++n;
            while ((n4 = string.indexOf(44, n)) >= 0) {
                string2 = string.substring(n, n4);
                n3 = Integer.parseInt(string2);
                arrayList.add(n3);
                n = n4 + 1;
            }
            if (n <= n2) {
                string2 = string.substring(n, n2);
                n3 = Integer.parseInt(string2);
                arrayList.add(n3);
            }
            int n5 = arrayList.size();
            nArray = new int[n5];
            for (int i = 0; i < n5; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
        }
        return this.valueOf(nArray);
    }

    @Override
    public IndexList parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    public boolean equals(Object object) {
        if (!(object instanceof IndexFactory)) {
            return false;
        }
        IndexFactory indexFactory = (IndexFactory)object;
        int n = this.imax.compareTo(indexFactory.imax);
        return 0 == n;
    }

    public int hashCode() {
        int n = this.imax.hashCode();
        return n;
    }

    public IndexList getZERO() {
        return new IndexList(this);
    }

    @Override
    public IndexList getONE() {
        return this.ONE;
    }

    @Override
    public final IndexList random(int n) {
        return this.random(n, 0.5f, random);
    }

    @Override
    public final IndexList random(int n, Random random) {
        return this.random(n, 0.5f, random);
    }

    public final IndexList random(int n, float f) {
        return this.random(n, f, random);
    }

    public final IndexList random(int n, float f, Random random) {
        int n2;
        if (n > this.imaxlength || n < 0) {
            throw new IllegalArgumentException("r > imaxlength not allowed: " + n + " > " + this.imaxlength);
        }
        if (n == 0) {
            return this.getZERO();
        }
        int[] nArray = new int[n];
        int n3 = 1;
        float f2 = random.nextFloat();
        if (f2 < f * 0.001f) {
            return this.getONE();
        }
        if (f2 < f * f) {
            n3 = -1;
        }
        int n4 = 0;
        for (int i = n2 = Math.max(Math.min(Math.abs(random.nextInt()) % this.imaxlength, this.imaxlength - n - 1), 1); i <= this.imaxlength && n4 < n; ++i) {
            f2 = random.nextFloat();
            if (!(f2 < f)) continue;
            nArray[n4++] = i;
        }
        int[] nArray2 = Arrays.copyOf(nArray, n4);
        return new IndexList(this, n3, nArray2);
    }

    public final IndexList sequence(int n, int n2) {
        return new IndexList(this, 1, IndexFactory.sequenceArray(n, n2));
    }

    public static int[] sequenceArray(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("s < 0 not allowed: " + n + " < 0");
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n + i;
        }
        return nArray;
    }

    public IndexListComparator getDescendComparator() {
        if (this.weak) {
            return this.hweak;
        }
        return this.horder;
    }

    public IndexListComparator getAscendComparator() {
        if (this.weak) {
            return this.lweak;
        }
        return this.lorder;
    }

    public static abstract class IndexListComparator
    implements Comparator<IndexList>,
    Serializable {
        @Override
        public abstract int compare(IndexList var1, IndexList var2);
    }
}

