/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.poly.IndexFactory;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.MonoidFactory;
import java.util.Arrays;

public class IndexList
implements MonoidElem<IndexList> {
    public final int[] val;
    public int sign;
    public final IndexFactory mono;

    public IndexList(IndexFactory indexFactory) {
        this(indexFactory, 0, null);
    }

    public IndexList(IndexFactory indexFactory, int[] nArray) {
        this(indexFactory, 1, nArray);
    }

    public IndexList(IndexFactory indexFactory, int n, int[] nArray) {
        this.sign = n;
        this.mono = indexFactory;
        if (nArray == null) {
            if (n != 0) {
                throw new IllegalArgumentException("inconsistent: s = " + n + ", v = " + nArray);
            }
            this.val = nArray;
            this.sign = 0;
        } else {
            this.val = Arrays.copyOf(nArray, nArray.length);
        }
    }

    public IndexList(IndexFactory indexFactory, String string) throws NumberFormatException {
        this(indexFactory, indexFactory.parse((String)string).val);
    }

    @Override
    public MonoidFactory<IndexList> factory() {
        return this.mono;
    }

    public boolean isConformant() {
        if (this.sign == 0 && this.val == null) {
            return true;
        }
        IndexList indexList = this.mono.valueOf(this.val);
        return this.abs().equals(indexList.abs());
    }

    @Override
    public IndexList copy() {
        return new IndexList(this.mono, this.sign, this.val);
    }

    public int[] getVal() {
        return this.val;
    }

    public int getVal(int n) {
        return this.val[n];
    }

    protected int setVal(int n, int n2) {
        int n3 = this.val[n];
        this.val[n] = n2;
        return n3;
    }

    public int length() {
        if (this.sign == 0) {
            return -1;
        }
        return this.val.length;
    }

    public String toString() {
        if (this.sign == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sign > 0) {
            stringBuffer.append(this.mono.vname + "(");
        } else {
            stringBuffer.append(this.mono.vname + "[-1](");
        }
        for (int i = 0; i < this.length(); ++i) {
            stringBuffer.append(this.getVal(i));
            if (i >= this.length() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        return "IndexFactory()";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IndexList)) {
            return false;
        }
        IndexList indexList = (IndexList)object;
        int n = this.compareTo(indexList);
        return 0 == n;
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.val) + this.sign;
        return n;
    }

    public long bitLength() {
        long l = 2L;
        for (int i = 0; i < this.val.length; ++i) {
            l += BigInteger.bitLength(this.val[i]);
        }
        return l;
    }

    public boolean isZERO() {
        return this.sign == 0;
    }

    @Override
    public boolean isONE() {
        return this.sign != 0 && this.val.length == 0;
    }

    @Override
    public boolean isUnit() {
        return this.isONE() || this.negate().isONE();
    }

    public IndexList abs() {
        if (this.sign >= 0) {
            return this;
        }
        return new IndexList(this.mono, 1, this.val);
    }

    public IndexList negate() {
        if (this.sign == 0) {
            return this;
        }
        return new IndexList(this.mono, -this.sign, this.val);
    }

    public IndexList exteriorProduct(IndexList indexList) {
        if (this.isZERO() || indexList.isZERO()) {
            return this.mono.getZERO();
        }
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = this.val;
        int[] nArray2 = indexList.val;
        int n4 = 0;
        int[] nArray3 = new int[nArray.length + nArray2.length];
        int n5 = 0;
        int n6 = 0;
        while (n5 < nArray.length && n6 < nArray2.length) {
            int n7 = nArray[n5];
            int n8 = nArray2[n6];
            if (n7 == n8) {
                return this.mono.getZERO();
            }
            if (n7 < n8) {
                nArray3[n4++] = n7;
                ++n5;
                ++n2;
                continue;
            }
            nArray3[n4++] = n8;
            ++n6;
            ++n3;
            if (n2 % 2 == 0) continue;
            n = -n;
        }
        if (n5 == nArray.length) {
            while (n6 < nArray2.length) {
                nArray3[n4++] = nArray2[n6++];
            }
        } else {
            n2 += nArray.length - n5;
            while (n5 < nArray.length) {
                nArray3[n4++] = nArray[n5++];
            }
        }
        if (n2 % 2 != 0 && n3 % 2 != 0) {
            n = -n;
        }
        return new IndexList(this.mono, n, nArray3);
    }

    @Override
    public IndexList multiply(IndexList indexList) {
        return this.exteriorProduct(indexList);
    }

    public IndexList interiorLeftProduct(IndexList indexList) {
        return indexList.interiorRightProduct(this);
    }

    public IndexList interiorRightProduct(IndexList indexList) {
        if (!this.divides(indexList)) {
            return this.mono.getZERO();
        }
        int[] nArray = this.val;
        int[] nArray2 = indexList.val;
        int[] nArray3 = new int[nArray2.length - nArray.length];
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            int n4 = nArray2[i];
            boolean bl = false;
            for (int j = 0; j < nArray.length; ++j) {
                if (n4 != nArray[j]) continue;
                bl = true;
                break;
            }
            if (!bl) {
                nArray3[n++] = n4;
                ++n3;
                continue;
            }
            if (n3 % 2 == 0) continue;
            n2 = -n2;
        }
        return new IndexList(this.mono, n2, nArray3);
    }

    public boolean divides(IndexList indexList) {
        if (this.isZERO() || indexList.isZERO()) {
            return false;
        }
        if (this.val.length > indexList.val.length) {
            return false;
        }
        int[] nArray = indexList.val;
        for (int i = 0; i < this.val.length; ++i) {
            int n = this.val[i];
            boolean bl = false;
            for (int j = i; j < nArray.length; ++j) {
                if (n != nArray[j]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public IndexList inverse() {
        throw new UnsupportedOperationException("inverse not implemented");
    }

    @Override
    public IndexList divide(IndexList indexList) {
        return this.interiorRightProduct(indexList);
    }

    @Override
    public IndexList remainder(IndexList indexList) {
        throw new UnsupportedOperationException("remainder not implemented");
    }

    public int signum() {
        return this.sign;
    }

    public int degree() {
        if (this.sign == 0) {
            return -1;
        }
        return this.val.length;
    }

    public int maxDeg() {
        if (this.degree() < 1) {
            return -1;
        }
        return this.val[this.val.length - 1];
    }

    public int minDeg() {
        if (this.degree() < 1) {
            return -1;
        }
        return this.val[0];
    }

    @Override
    public int compareTo(IndexList indexList) {
        return this.strongCompareTo(indexList);
    }

    public int weakCompareTo(IndexList indexList) {
        if (this.sign == 0 && indexList.sign == 0) {
            return 0;
        }
        if (this.sign == 0) {
            return -1;
        }
        if (indexList.sign == 0) {
            return 1;
        }
        if (this.sign < indexList.sign) {
            return -1;
        }
        if (this.sign > indexList.sign) {
            return 1;
        }
        int[] nArray = indexList.val;
        int n = Math.min(this.val.length, nArray.length);
        for (int i = 0; i < n; ++i) {
            if (this.val[i] < nArray[i]) {
                return -1;
            }
            if (this.val[i] <= nArray[i]) continue;
            return 1;
        }
        if (this.val.length < nArray.length) {
            return -1;
        }
        if (this.val.length > nArray.length) {
            return 1;
        }
        return 0;
    }

    public int strongCompareTo(IndexList indexList) {
        if (this.sign == 0 && indexList.sign == 0) {
            return 0;
        }
        if (this.sign == 0) {
            return -1;
        }
        if (indexList.sign == 0) {
            return 1;
        }
        int[] nArray = indexList.val;
        if (this.val.length < nArray.length) {
            return -1;
        }
        if (this.val.length > nArray.length) {
            return 1;
        }
        int n = Math.min(this.val.length, nArray.length);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.val[i] < nArray[i]) {
                n2 = -1;
                break;
            }
            if (this.val[i] <= nArray[i]) continue;
            n2 = 1;
            break;
        }
        return n2;
    }
}

