/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.IndexFactory;
import edu.jas.poly.IndexList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class IndexListTest
extends TestCase {
    IndexList a;
    IndexList b;
    IndexList c;
    IndexList d;
    IndexList e;
    IndexFactory idf;
    int ll = 11;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IndexListTest.suite());
    }

    public IndexListTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(IndexListTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.idf = new IndexFactory(this.ll);
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        this.b = this.a = this.idf.random(0, this.q);
        IndexListTest.assertEquals((String)"() = ()", (Object)this.a, (Object)this.b);
        IndexListTest.assertTrue((String)"length( () ) = 0", (this.a.length() <= 0 ? 1 : 0) != 0);
        IndexListTest.assertTrue((String)"isZERO( () )", (boolean)this.a.isZERO());
        IndexListTest.assertFalse((String)"isONE( () )", (boolean)this.a.isONE());
        IndexListTest.assertFalse((String)"isUnit( () )", (boolean)this.a.isUnit());
        this.b = this.idf.random(10, this.q);
        IndexListTest.assertTrue((String)"length( () ) = 0", (this.b.length() >= 0 ? 1 : 0) != 0);
        IndexListTest.assertFalse((String)"isZERO( () )", (boolean)this.b.isZERO());
        IndexListTest.assertFalse((String)"isONE( () )", (boolean)this.b.isONE());
        IndexListTest.assertFalse((String)"isUnit( () )", (boolean)this.b.isUnit());
        this.c = new IndexList(this.idf);
        IndexListTest.assertTrue((String)"length( 0 ) = -1", (this.c.length() < 0 ? 1 : 0) != 0);
        IndexListTest.assertTrue((String)"isZERO( () )", (boolean)this.c.isZERO());
        IndexListTest.assertFalse((String)"isONE( () )", (boolean)this.c.isONE());
        IndexListTest.assertFalse((String)"isUnit( () )", (boolean)this.c.isUnit());
        this.c = this.idf.getONE();
        IndexListTest.assertTrue((String)"length( 1 ) = 1", (this.c.length() >= 0 ? 1 : 0) != 0);
        IndexListTest.assertFalse((String)"isZERO( () )", (boolean)this.c.isZERO());
        IndexListTest.assertTrue((String)"isONE( () )", (boolean)this.c.isONE());
        IndexListTest.assertTrue((String)"isUnit( () )", (boolean)this.c.isUnit());
        String string = this.b.toString();
        String string2 = this.b.toScript();
        IndexListTest.assertEquals((String)"s == t: ", (String)string, (String)string2);
        IndexFactory indexFactory = new IndexFactory(this.idf.imaxlength, "I");
        IndexListTest.assertEquals((String)"idf == ids: ", (int)this.idf.length(), (int)indexFactory.length());
        IndexListTest.assertEquals((String)"idf == ids: ", (Object)this.idf, (Object)indexFactory);
        indexFactory = new IndexFactory(this.idf.imaxlength);
        IndexListTest.assertEquals((String)"idf == ids: ", (int)this.idf.length(), (int)indexFactory.length());
        IndexListTest.assertEquals((String)"idf == ids: ", (Object)this.idf, (Object)indexFactory);
    }

    public void testRandom() {
        this.a = this.idf.random(5);
        this.b = this.idf.random(7);
        this.c = this.idf.random(9);
        IndexListTest.assertFalse((String)"a != (): ", (boolean)this.a.isZERO());
        IndexListTest.assertFalse((String)"b != (): ", (boolean)this.b.isZERO());
        IndexListTest.assertFalse((String)"c != (): ", (boolean)this.c.isZERO());
        IndexListTest.assertFalse((String)"a != b: ", (boolean)this.a.equals(this.b));
        IndexListTest.assertFalse((String)"a != c: ", (boolean)this.a.equals(this.c));
        IndexListTest.assertFalse((String)"c != b: ", (boolean)this.c.equals(this.b));
        this.d = this.c.abs();
        IndexListTest.assertTrue((String)"sign(d) > 0: ", (this.d.signum() > 0 ? 1 : 0) != 0);
        if (this.d.degree() > 1) {
            IndexListTest.assertTrue((String)"minDeg < maxDeg: ", (this.d.minDeg() < this.d.maxDeg() ? 1 : 0) != 0);
        }
    }

    public void testMultiplication() {
        this.a = this.idf.random(9, 0.2f);
        this.b = this.idf.random(7, 0.3f);
        this.c = this.a.multiply(this.b);
        this.d = this.b.multiply(this.a);
        if (this.c.isZERO()) {
            return;
        }
        boolean bl = this.a.divides(this.c);
        IndexListTest.assertTrue((String)"a | c: ", (boolean)bl);
        bl = this.b.divides(this.c);
        IndexListTest.assertTrue((String)"b | c: ", (boolean)bl);
        IndexList indexList = this.a.interiorRightProduct(this.c);
        IndexList indexList2 = this.b.interiorRightProduct(this.c);
        IndexListTest.assertEquals((String)"a == cb: ", (Object)this.a.abs(), (Object)indexList2.abs());
        IndexListTest.assertEquals((String)"b == ca: ", (Object)this.b.abs(), (Object)indexList.abs());
        indexList = this.c.interiorLeftProduct(this.a);
        indexList2 = this.c.interiorLeftProduct(this.b);
    }

    public void testSequence() {
        this.a = this.idf.sequence(0, 4);
        this.b = this.idf.sequence(4, 3);
        this.c = this.idf.sequence(0, 7);
        IndexListTest.assertFalse((String)"a != (): ", (boolean)this.a.isZERO());
        IndexListTest.assertFalse((String)"b != (): ", (boolean)this.b.isZERO());
        IndexListTest.assertFalse((String)"c != (): ", (boolean)this.c.isZERO());
        IndexListTest.assertFalse((String)"a != b: ", (boolean)this.a.equals(this.b));
        IndexListTest.assertFalse((String)"a != c: ", (boolean)this.a.equals(this.c));
        IndexListTest.assertFalse((String)"c != b: ", (boolean)this.c.equals(this.b));
        this.d = this.a.multiply(this.b);
        this.e = this.b.multiply(this.a);
        IndexListTest.assertEquals((String)"c == ab: ", (Object)this.c, (Object)this.d);
        IndexList indexList = this.a.interiorRightProduct(this.d);
        IndexList indexList2 = this.b.interiorRightProduct(this.d);
        IndexListTest.assertEquals((String)"a == cb: ", (Object)this.a.abs(), (Object)indexList2.abs());
        IndexListTest.assertEquals((String)"b == ca: ", (Object)this.b.abs(), (Object)indexList.abs());
    }

    public void testValueOf() {
        ExpVector expVector = ExpVector.random(4, 2L, 0.8f);
        this.a = this.idf.valueOf(expVector);
        if (!this.a.isZERO()) {
            IndexListTest.assertTrue((String)("depend(ef) == deg(a): " + expVector + ", " + this.a), (expVector.dependentVariables() == this.a.degree() ? 1 : 0) != 0);
        }
        String string = this.a.toString() + " = " + this.a.toScript();
        IndexListTest.assertTrue((String)("as != ''" + string), (string.length() >= 0 ? 1 : 0) != 0);
        List<Integer> list = Arrays.asList(1, 4, 7, 8, 13, 17);
        this.a = this.idf.valueOf(list);
        IndexListTest.assertTrue((String)("deg(a) == #W " + list + ", " + this.a), (list.size() == this.a.degree() ? 1 : 0) != 0);
        int[] nArray = new int[]{1, 4, 7, 8, 13, 17, 4, 1};
        this.a = this.idf.valueOf(nArray);
        IndexListTest.assertTrue((String)("a == 0: " + this.a), (boolean)this.a.isZERO());
        this.a = this.idf.valueOf((int[])null);
        IndexListTest.assertTrue((String)("a == 0: " + this.a), (boolean)this.a.isZERO());
        nArray = new int[]{7, 8, 13, 17, 4, 1};
        this.a = this.idf.valueOf(nArray);
        IndexListTest.assertTrue((String)("deg(a) == #w: " + this.a), (this.a.degree() == nArray.length ? 1 : 0) != 0);
        IndexListTest.assertTrue((String)("sign(a) < 0: " + this.a), (this.a.signum() < 0 ? 1 : 0) != 0);
        IndexListTest.assertTrue((String)("check(a) == true: " + this.a), (boolean)this.a.isConformant());
        this.b = new IndexList(this.idf, nArray);
        IndexListTest.assertFalse((String)("check(b) == false: " + this.b), (boolean)this.b.isConformant());
        this.c = this.idf.valueOf(this.b);
        IndexListTest.assertTrue((String)("check(b) == true: " + this.c), (boolean)this.c.isConformant());
    }
}

