/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.RingElem;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RatGenSolvablePolynomialTest
extends TestCase {
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    GenSolvablePolynomial<BigRational> f;
    GenSolvablePolynomial<BigRational> x1;
    GenSolvablePolynomial<BigRational> x2;
    int rl = 6;
    int kl = 10;
    int ll = 5;
    int el = 3;
    float q = 0.5f;
    RelationTable<BigRational> table;
    GenSolvablePolynomialRing<BigRational> ring;
    GenSolvablePolynomialRing<BigRational> fac;
    BigRational cfac;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RatGenSolvablePolynomialTest.suite());
    }

    public RatGenSolvablePolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RatGenSolvablePolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl);
        this.fac = this.ring;
        this.table = this.ring.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.table = null;
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testGenerate() {
        String string = this.fac.toScript();
        RatGenSolvablePolynomialTest.assertTrue((String)("#s == 51: " + string), (string.length() == 51 ? 1 : 0) != 0);
        List list = this.fac.generators();
        RatGenSolvablePolynomialTest.assertFalse((String)"#gens != () ", (boolean)list.isEmpty());
        HashSet hashSet = new HashSet(list);
        RatGenSolvablePolynomialTest.assertEquals((String)"#gens == #set: ", (int)list.size(), (int)hashSet.size());
        this.a = this.fac.getZERO();
        this.b = this.fac.getONE();
        RatGenSolvablePolynomialTest.assertFalse((String)"0 not in #set: ", (boolean)hashSet.contains(this.a));
        RatGenSolvablePolynomialTest.assertTrue((String)"1 in #set: ", (boolean)hashSet.contains(this.b));
        RatGenSolvablePolynomialTest.assertEquals((String)"#gens == rl+1 ", (int)(this.rl + 1), (int)list.size());
        HashSet<Integer> hashSet2 = new HashSet<Integer>(hashSet.size());
        for (GenPolynomial genPolynomial : list) {
            RatGenSolvablePolynomialTest.assertTrue((String)"red(p) == 0 ", (boolean)genPolynomial.reductum().isZERO());
            hashSet2.add(genPolynomial.hashCode());
        }
        RatGenSolvablePolynomialTest.assertEquals((String)"#gens == #iset: ", (int)list.size(), (int)hashSet2.size());
    }

    public void testConstructor() {
        this.a = new GenSolvablePolynomial<BigRational>(this.ring);
        RatGenSolvablePolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        RatGenSolvablePolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        RatGenSolvablePolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        RatGenSolvablePolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        RatGenSolvablePolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatGenSolvablePolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        RatGenSolvablePolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        RatGenSolvablePolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        RatGenSolvablePolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        RatGenSolvablePolynomialTest.assertTrue((String)"isCommutative()", (boolean)this.ring.isCommutative());
        for (int i = 0; i < 2; ++i) {
            this.a = this.ring.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            RatGenSolvablePolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            RatGenSolvablePolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            RatGenSolvablePolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (GenSolvablePolynomial)this.a.subtract((BigRational)((Object)this.a));
        RatGenSolvablePolynomialTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (GenSolvablePolynomial)this.a.sum((BigRational)((Object)this.a));
        this.c = (GenSolvablePolynomial)this.b.subtract((BigRational)((Object)this.a));
        RatGenSolvablePolynomialTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        RatGenSolvablePolynomialTest.assertTrue((String)"a+a-a = a", (boolean)this.c.equals(this.a));
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (GenSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (GenSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        RatGenSolvablePolynomialTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        RatGenSolvablePolynomialTest.assertTrue((String)"a+b = b+a", (boolean)this.c.equals(this.d));
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (GenSolvablePolynomial)this.a.sum((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = (GenSolvablePolynomial)this.a.sum((BigRational)((Object)this.b)).sum(this.c);
        RatGenSolvablePolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        RatGenSolvablePolynomialTest.assertTrue((String)"a+(b+c) = (a+b)+c", (boolean)this.d.equals(this.e));
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        BigRational bigRational = this.cfac.random(this.kl);
        this.b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(bigRational, expVector);
        this.c = (GenSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        this.d = (GenSolvablePolynomial)this.a.sum(bigRational, expVector);
        RatGenSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (GenSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (GenSolvablePolynomial)this.a.subtract(bigRational, expVector);
        RatGenSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((GenSolvablePolynomial)this.ring.getONE()).multiply(bigRational, expVector);
        this.c = (GenSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (GenSolvablePolynomial)this.a.sum(bigRational, expVector);
        RatGenSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (GenSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (GenSolvablePolynomial)this.a.subtract(bigRational, expVector);
        RatGenSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = (GenSolvablePolynomial)this.d.subtract((BigRational)((Object)this.c));
        RatGenSolvablePolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        RatGenSolvablePolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        RatGenSolvablePolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        RatGenSolvablePolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        RatGenSolvablePolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        BigRational bigRational = ((BigRational)this.a.leadingBaseCoefficient()).inverse();
        this.c = this.a.monic();
        this.d = this.a.multiply((RingElem)bigRational);
        RatGenSolvablePolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        ExpVector expVector = this.ring.evzero;
        BigRational bigRational2 = ((BigRational)this.b.leadingBaseCoefficient()).inverse();
        this.c = this.b.monic();
        this.d = this.b.multiply((RingElem)bigRational2, expVector);
        RatGenSolvablePolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = ((GenSolvablePolynomial)this.ring.getONE()).multiply(bigRational2, expVector);
        this.d = this.b.multiply((BigRational)((Object)this.e));
        RatGenSolvablePolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.d = this.e.multiply((BigRational)((Object)this.b));
        RatGenSolvablePolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b) (0))*b", this.c, this.d);
        this.d = this.a.monic();
        RatGenSolvablePolynomialTest.assertTrue((String)"a.monic(): ", (boolean)((BigRational)this.d.leadingBaseCoefficient()).isONE());
    }

    public void testWeyl() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        RatGenSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        RatGenSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = (GenSolvablePolynomial)this.d.subtract((BigRational)((Object)this.c));
        RatGenSolvablePolynomialTest.assertTrue((String)("!isZERO( a*b-b*a ) " + this.e), (!this.e.isZERO() ? 1 : 0) != 0);
        RatGenSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        RatGenSolvablePolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        RatGenSolvablePolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
    }

    public void testDivide() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        RatGenSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        RatGenSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        do {
            this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO());
        do {
            this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        } while (this.b.isZERO());
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatGenSolvablePolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = (GenSolvablePolynomial)this.d.subtract((BigRational)((Object)this.c));
        RatGenSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (!this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.e = this.c.divide(this.a);
        this.f = this.c.rightDivide(this.b);
        RatGenSolvablePolynomialTest.assertEquals((String)("b == b*a/a: " + this.e), this.e, this.b);
        RatGenSolvablePolynomialTest.assertEquals((String)("a == b*a/b: " + this.e), this.f, this.a);
        this.e = this.d.rightDivide(this.a);
        this.f = this.d.divide(this.b);
        RatGenSolvablePolynomialTest.assertEquals((String)("b == a*b/a: " + this.e), this.e, this.b);
        RatGenSolvablePolynomialTest.assertEquals((String)("a == a*b/b: " + this.e), this.f, this.a);
    }

    public void testBLAS1() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        ExpVector expVector = ExpVector.random(n, this.el, this.q);
        BigRational bigRational = BigRational.ONE.random(this.kl);
        this.d = this.a.subtractMultiple(bigRational, this.b);
        this.e = (GenSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b.multiplyLeft((RingElem)bigRational)));
        RatGenSolvablePolynomialTest.assertEquals((String)"a - (lc) b == a - ((lc) b)", this.d, this.e);
        this.d = this.a.subtractMultiple(bigRational, expVector, this.b);
        this.e = (GenSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b.multiplyLeft(bigRational, expVector)));
        RatGenSolvablePolynomialTest.assertEquals((String)"a - (lc ev) b == a - ((lc ev) b)", this.d, this.e);
        ExpVector expVector2 = ExpVector.random(n, this.el, this.q);
        BigRational bigRational2 = BigRational.ONE.random(this.kl);
        this.d = this.a.scaleSubtractMultiple(bigRational2, bigRational, expVector, this.b);
        this.e = (GenSolvablePolynomial)this.a.multiplyLeft((RingElem)bigRational2).subtract(this.b.multiplyLeft(bigRational, expVector));
        RatGenSolvablePolynomialTest.assertEquals((String)"(tc) a - (lc ev) b == ((tc) a - ((lc ev) b))", this.d, this.e);
        this.d = this.a.scaleSubtractMultiple(bigRational2, expVector2, bigRational, expVector, this.b);
        this.e = (GenSolvablePolynomial)this.a.multiplyLeft(bigRational2, expVector2).subtract((BigRational)((Object)this.b.multiplyLeft(bigRational, expVector)));
        RatGenSolvablePolynomialTest.assertEquals((String)"(tc fv) a - (lc ev) b == ((tc fv) a - ((lc ev) b))", this.d, this.e);
        this.d = this.a.scaleSubtractMultiple(bigRational2, bigRational, this.b);
        this.e = (GenSolvablePolynomial)this.a.multiplyLeft((RingElem)bigRational2).subtract(this.b.multiplyLeft((RingElem)bigRational));
        RatGenSolvablePolynomialTest.assertEquals((String)"tc a - lc b == (tc a) - (lc b)", this.d, this.e);
    }

    public void testDistributive() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigRational)((Object)((GenSolvablePolynomial)this.b.sum((BigRational)((Object)this.c)))));
        this.e = (GenSolvablePolynomial)this.a.multiply((BigRational)((Object)this.b)).sum(this.a.multiply((BigRational)((Object)this.c)));
        RatGenSolvablePolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }
}

