/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.TermOrderOptimization;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TermOrderOptimizationTest
extends TestCase {
    int rl = 7;
    int kl = 3;
    int ll = 10;
    int el = 7;
    float q = 0.5f;
    GenPolynomialRing<BigRational> fac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    GenPolynomialRing<GenPolynomial<BigRational>> rfac;
    GenPolynomial<GenPolynomial<BigRational>> ar;
    GenPolynomial<GenPolynomial<BigRational>> br;
    GenPolynomial<GenPolynomial<BigRational>> cr;
    GenPolynomial<GenPolynomial<BigRational>> dr;
    GenPolynomial<GenPolynomial<BigRational>> er;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TermOrderOptimizationTest.suite());
    }

    public TermOrderOptimizationTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(TermOrderOptimizationTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testPermutation() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(2);
        arrayList.add(1);
        arrayList.add(4);
        arrayList.add(0);
        arrayList.add(3);
        List<Integer> list = TermOrderOptimization.inversePermutation(arrayList);
        TermOrderOptimizationTest.assertFalse((String)"P != id", (boolean)TermOrderOptimization.isIdentityPermutation(arrayList));
        TermOrderOptimizationTest.assertFalse((String)"S != id", (boolean)TermOrderOptimization.isIdentityPermutation(list));
        List<Integer> list2 = TermOrderOptimization.multiplyPermutation(arrayList, list);
        List<Integer> list3 = TermOrderOptimization.multiplyPermutation(list, arrayList);
        TermOrderOptimizationTest.assertTrue((String)"T == id", (boolean)TermOrderOptimization.isIdentityPermutation(list2));
        TermOrderOptimizationTest.assertTrue((String)"U == id", (boolean)TermOrderOptimization.isIdentityPermutation(list3));
    }

    public void testPolyOptimization() {
        BigRational bigRational = new BigRational();
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.fac.random(this.kl, this.ll, this.el, this.q);
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.a);
        arrayList.add(this.b);
        arrayList.add(this.c);
        arrayList.add(this.d);
        arrayList.add(this.e);
        long l = ((Object)arrayList).toString().length();
        OptimizedPolynomialList<BigRational> optimizedPolynomialList = TermOrderOptimization.optimizeTermOrder(this.fac, arrayList);
        OptimizedPolynomialList optimizedPolynomialList2 = TermOrderOptimization.optimizeTermOrder(optimizedPolynomialList.ring, optimizedPolynomialList.list);
        TermOrderOptimizationTest.assertEquals((String)"Fo == Fo2: ", optimizedPolynomialList, optimizedPolynomialList2);
        List<Integer> list = TermOrderOptimization.inversePermutation(optimizedPolynomialList.perm);
        GenPolynomialRing genPolynomialRing = optimizedPolynomialList.ring.permutation(list);
        List list2 = TermOrderOptimization.permutation(list, genPolynomialRing, optimizedPolynomialList.list);
        TermOrderOptimizationTest.assertEquals((String)"r == ri: ", this.fac, genPolynomialRing);
        TermOrderOptimizationTest.assertEquals((String)"F == Fi: ", arrayList, list2);
        String string = optimizedPolynomialList.toString();
        TermOrderOptimizationTest.assertTrue((String)("#s >= t: " + string), ((long)string.length() >= l ? 1 : 0) != 0);
    }

    public void testPolyCoefOptimization() {
        BigRational bigRational = new BigRational();
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.rfac = new GenPolynomialRing<BigRational>(this.fac, 3);
        this.ar = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.dr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.er = this.rfac.random(this.kl, this.ll, this.el, this.q);
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.ar);
        arrayList.add(this.br);
        arrayList.add(this.cr);
        arrayList.add(this.dr);
        arrayList.add(this.er);
        OptimizedPolynomialList optimizedPolynomialList = TermOrderOptimization.optimizeTermOrderOnCoefficients(this.rfac, arrayList);
        OptimizedPolynomialList optimizedPolynomialList2 = TermOrderOptimization.optimizeTermOrderOnCoefficients(optimizedPolynomialList.ring, optimizedPolynomialList.list);
        TermOrderOptimizationTest.assertEquals((String)"Fo == Fo2: ", optimizedPolynomialList, optimizedPolynomialList2);
        List<Integer> list = TermOrderOptimization.inversePermutation(optimizedPolynomialList.perm);
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)optimizedPolynomialList.ring.coFac;
        genPolynomialRing = genPolynomialRing.permutation(list);
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing, this.rfac);
        List list2 = TermOrderOptimization.permutationOnCoefficients(list, genPolynomialRing2, optimizedPolynomialList.list);
        TermOrderOptimizationTest.assertEquals((String)"r == ri: ", this.rfac, genPolynomialRing2);
        TermOrderOptimizationTest.assertEquals((String)"F == Fi: ", arrayList, list2);
    }
}

