/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.TermOrder;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TermOrderTest
extends TestCase {
    ExpVector a;
    ExpVector b;
    ExpVector c;
    ExpVector d;
    TermOrder t;
    TermOrder s;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TermOrderTest.suite());
    }

    public TermOrderTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(TermOrderTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.s = null;
        this.t = null;
    }

    protected void tearDown() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.s = null;
        this.t = null;
    }

    public void testConstructor() {
        this.s = new TermOrder();
        this.t = new TermOrder();
        TermOrderTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
        String string = this.t.toString();
        String string2 = this.s.toString();
        TermOrderTest.assertEquals((String)"x = y", (String)string, (String)string2);
        this.t = new TermOrder(2);
        string = "INVLEX";
        boolean bl = this.t.toString().startsWith(string);
        TermOrderTest.assertTrue((String)"INVLEX(.)", (boolean)bl);
        this.s = new TermOrder(4);
        this.t = new TermOrder(4);
        TermOrderTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
    }

    public void testConstructorSplit() {
        int n = 10;
        int n2 = 5;
        this.s = new TermOrder(4, 4, n, n2);
        this.t = new TermOrder(4, 4, n, n2);
        TermOrderTest.assertEquals((String)"t == s", (Object)this.t, (Object)this.s);
        String string = this.t.toString();
        String string2 = this.s.toString();
        TermOrderTest.assertEquals((String)"x == y", (String)string, (String)string2);
        this.s = new TermOrder(4, 2, n, n2);
        this.t = new TermOrder(4, 2, n, n2);
        TermOrderTest.assertEquals((String)"t == s", (Object)this.t, (Object)this.s);
        this.s = new TermOrder(2, 4, n, n2, true);
        this.t = new TermOrder(2, 4, n, n2, true);
        TermOrderTest.assertEquals((String)"t == s", (Object)this.t, (Object)this.s);
    }

    public void testConstructorWeight() {
        long[][] lArrayArray = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        this.s = new TermOrder(lArrayArray);
        this.t = new TermOrder(lArrayArray);
        TermOrderTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
        String string = this.t.toString();
        String string2 = this.s.toString();
        TermOrderTest.assertEquals((String)"x = y", (String)string, (String)string2);
        string = "W(";
        boolean bl = this.t.toString().startsWith(string);
        TermOrderTest.assertTrue((String)"W(.)", (boolean)bl);
    }

    public void testCompareWeight() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        this.c = this.a.sum(this.b);
        long[][] lArrayArray = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        this.t = new TermOrder(lArrayArray);
        int n = ExpVector.EVIWLC(lArrayArray, this.c, this.a);
        int n2 = ExpVector.EVIWLC(lArrayArray, this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n2);
        n = ExpVector.EVIWLC(lArrayArray, this.a, this.c);
        n2 = ExpVector.EVIWLC(lArrayArray, this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n2);
        n = ExpVector.EVIWLC(lArrayArray, this.a, this.a);
        n2 = ExpVector.EVIWLC(lArrayArray, this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n2);
    }

    public void testCompareWeight2() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        this.c = this.a.sum(this.b);
        long[][] lArrayArray = new long[][]{{1L, 1L, 1L, 1L, 1L}, {1L, 1L, 1L, 1L, 1L}};
        this.t = new TermOrder(lArrayArray);
        int n = ExpVector.EVIWLC(lArrayArray, this.c, this.a);
        int n2 = ExpVector.EVIWLC(lArrayArray, this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n2);
        n = ExpVector.EVIWLC(lArrayArray, this.a, this.c);
        n2 = ExpVector.EVIWLC(lArrayArray, this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n2);
        n = ExpVector.EVIWLC(lArrayArray, this.a, this.a);
        n2 = ExpVector.EVIWLC(lArrayArray, this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n2);
    }

    public void testCompareWeightSplit() {
        float f = 0.9f;
        int n = 8;
        int n2 = 4;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = this.a.sum(this.b);
        long[][] lArrayArray = new long[][]{{1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L}};
        int n3 = ExpVector.EVIWLC(lArrayArray, this.c, this.a);
        int n4 = ExpVector.EVIWLC(lArrayArray, this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray, this.c, this.a, 0, n2);
        n4 = ExpVector.EVIWLC(lArrayArray, this.c, this.b, 0, n2);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray, this.c, this.a, n2, n);
        n4 = ExpVector.EVIWLC(lArrayArray, this.c, this.b, n2, n);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray, this.a, this.c);
        n4 = ExpVector.EVIWLC(lArrayArray, this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray, this.a, this.c, 0, n2);
        n4 = ExpVector.EVIWLC(lArrayArray, this.b, this.c, 0, n2);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray, this.a, this.c, n2, n);
        n4 = ExpVector.EVIWLC(lArrayArray, this.b, this.c, n2, n);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray, this.a, this.a);
        n4 = ExpVector.EVIWLC(lArrayArray, this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray, this.a, this.a, 0, n2);
        n4 = ExpVector.EVIWLC(lArrayArray, this.b, this.b, 0, n2);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray, this.a, this.a, n2, n);
        n4 = ExpVector.EVIWLC(lArrayArray, this.b, this.b, n2, n);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n4);
        long[][] lArrayArray2 = new long[][]{{1L, 1L, 1L, 1L, 0L, 0L, 0L, 0L}, {0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L}};
        n3 = ExpVector.EVIWLC(lArrayArray2, this.c, this.a);
        n4 = ExpVector.EVIWLC(lArrayArray2, this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray2, this.c, this.a, 0, n2);
        n4 = ExpVector.EVIWLC(lArrayArray2, this.c, this.b, 0, n2);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray2, this.c, this.a, n2, n);
        n4 = ExpVector.EVIWLC(lArrayArray2, this.c, this.b, n2, n);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray2, this.a, this.c);
        n4 = ExpVector.EVIWLC(lArrayArray2, this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray2, this.a, this.c, 0, n2);
        n4 = ExpVector.EVIWLC(lArrayArray2, this.b, this.c, 0, n2);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray2, this.a, this.c, n2, n);
        n4 = ExpVector.EVIWLC(lArrayArray2, this.b, this.c, n2, n);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray2, this.a, this.a);
        n4 = ExpVector.EVIWLC(lArrayArray2, this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray2, this.a, this.a, 0, n2);
        n4 = ExpVector.EVIWLC(lArrayArray2, this.b, this.b, 0, n2);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n4);
        n3 = ExpVector.EVIWLC(lArrayArray2, this.a, this.a, n2, n);
        n4 = ExpVector.EVIWLC(lArrayArray2, this.b, this.b, n2, n);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n4);
    }

    public void testAscendComparator() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder();
        int n = this.t.getAscendComparator().compare(this.c, this.a);
        int n2 = this.t.getAscendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n2);
        n = this.t.getAscendComparator().compare(this.a, this.c);
        n2 = this.t.getAscendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n2);
        n = this.t.getAscendComparator().compare(this.a, this.a);
        n2 = this.t.getAscendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n2);
    }

    public void testAscendComparatorSplit() {
        float f = 0.9f;
        int n = 10;
        int n2 = 5;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder(4, 2, n, n2);
        int n3 = this.t.getAscendComparator().compare(this.c, this.a);
        int n4 = this.t.getAscendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = this.t.getAscendComparator().compare(this.a, this.c);
        n4 = this.t.getAscendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = this.t.getAscendComparator().compare(this.a, this.a);
        n4 = this.t.getAscendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n4);
    }

    public void testAscendComparatorWeightSplit() {
        float f = 0.9f;
        int n = 8;
        long[][] lArrayArray = new long[][]{{1L, 2L, 3L, 4L, 5L, 0L, 0L, 0L}, {0L, 0L, 0L, 0L, 0L, 1L, 2L, 3L}};
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder(lArrayArray);
        TermOrder termOrder = new TermOrder(lArrayArray);
        int n2 = this.t.getAscendComparator().compare(this.c, this.a);
        int n3 = this.t.getAscendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n2);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n3);
        int n4 = termOrder.getAscendComparator().compare(this.c, this.a);
        int n5 = termOrder.getAscendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x2 = 1", (int)1, (int)n4);
        TermOrderTest.assertEquals((String)"y2 = 1", (int)1, (int)n5);
        TermOrderTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
        n2 = this.t.getAscendComparator().compare(this.a, this.c);
        n3 = this.t.getAscendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n2);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n3);
        n4 = termOrder.getAscendComparator().compare(this.a, this.c);
        n5 = termOrder.getAscendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x2 = -1", (int)-1, (int)n4);
        TermOrderTest.assertEquals((String)"y2 = -1", (int)-1, (int)n5);
        TermOrderTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
        n2 = this.t.getAscendComparator().compare(this.a, this.a);
        n3 = this.t.getAscendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n2);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n3);
        n4 = termOrder.getAscendComparator().compare(this.a, this.a);
        n5 = termOrder.getAscendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x2 = 0", (int)0, (int)n4);
        TermOrderTest.assertEquals((String)"y2 = 0", (int)0, (int)n5);
        TermOrderTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
    }

    public void testDescendComparator() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder();
        int n = this.t.getDescendComparator().compare(this.c, this.a);
        int n2 = this.t.getDescendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n2);
        n = this.t.getDescendComparator().compare(this.a, this.c);
        n2 = this.t.getDescendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n2);
        n = this.t.getDescendComparator().compare(this.a, this.a);
        n2 = this.t.getDescendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n2);
    }

    public void testDescendComparatorSplit() {
        float f = 0.9f;
        int n = 10;
        int n2 = 5;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder(4, 2, n, n2);
        int n3 = this.t.getDescendComparator().compare(this.c, this.a);
        int n4 = this.t.getDescendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = this.t.getDescendComparator().compare(this.a, this.c);
        n4 = this.t.getDescendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = this.t.getDescendComparator().compare(this.a, this.a);
        n4 = this.t.getDescendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n4);
    }

    public void testDescendComparatorWeightSplit() {
        float f = 0.9f;
        int n = 8;
        long[][] lArrayArray = new long[][]{{1L, 2L, 3L, 4L, 5L, 0L, 0L, 0L}, {0L, 0L, 0L, 0L, 0L, 1L, 2L, 3L}};
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = new TermOrder(lArrayArray);
        TermOrder termOrder = new TermOrder(lArrayArray);
        int n2 = this.t.getDescendComparator().compare(this.c, this.a);
        int n3 = this.t.getDescendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x = -1", (int)-1, (int)n2);
        TermOrderTest.assertEquals((String)"y = -1", (int)-1, (int)n3);
        int n4 = termOrder.getDescendComparator().compare(this.c, this.a);
        int n5 = termOrder.getDescendComparator().compare(this.c, this.b);
        TermOrderTest.assertEquals((String)"x2 = -1", (int)-1, (int)n4);
        TermOrderTest.assertEquals((String)"y2 = -1", (int)-1, (int)n5);
        TermOrderTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
        n2 = this.t.getDescendComparator().compare(this.a, this.c);
        n3 = this.t.getDescendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x = 1", (int)1, (int)n2);
        TermOrderTest.assertEquals((String)"y = 1", (int)1, (int)n3);
        n4 = termOrder.getDescendComparator().compare(this.a, this.c);
        n5 = termOrder.getDescendComparator().compare(this.b, this.c);
        TermOrderTest.assertEquals((String)"x2 = 1", (int)1, (int)n4);
        TermOrderTest.assertEquals((String)"y2 = 1", (int)1, (int)n5);
        TermOrderTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
        n2 = this.t.getDescendComparator().compare(this.a, this.a);
        n3 = this.t.getDescendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x = 0", (int)0, (int)n2);
        TermOrderTest.assertEquals((String)"y = 0", (int)0, (int)n3);
        n4 = termOrder.getDescendComparator().compare(this.a, this.a);
        n5 = termOrder.getDescendComparator().compare(this.b, this.b);
        TermOrderTest.assertEquals((String)"x2 = 0", (int)0, (int)n4);
        TermOrderTest.assertEquals((String)"y2 = 0", (int)0, (int)n5);
        TermOrderTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
    }

    public void testException() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        int n = 99;
        try {
            this.t = new TermOrder(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        TermOrderTest.fail((String)"IllegalArgumentException");
    }

    public void testExceptionSplit() {
        float f = 0.9f;
        int n = 10;
        int n2 = 5;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        int n3 = 99;
        try {
            this.t = new TermOrder(n3, n3, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        TermOrderTest.fail((String)"IllegalArgumentException");
    }

    public void testCompareException() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        int n = 12;
        int n2 = 0;
        try {
            this.t = new TermOrder(n);
            n2 = this.t.getDescendComparator().compare(this.a, this.b);
            TermOrderTest.fail((String)("IllegalArgumentException " + n2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCompareExceptionSplit() {
        float f = 0.9f;
        int n = 10;
        int n2 = 5;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        int n3 = 10;
        int n4 = 0;
        try {
            this.t = new TermOrder(n3, n3, n, n2);
            n4 = this.t.getDescendComparator().compare(this.a, this.b);
            TermOrderTest.fail((String)("IllegalArgumentException " + n4));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCompareExceptionWeigth() {
        float f = 0.9f;
        int n = 10;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        int n2 = 0;
        try {
            this.t = new TermOrder((long[][])null);
            n2 = this.t.getDescendComparator().compare(this.a, this.b);
            TermOrderTest.fail((String)("IllegalArgumentException " + n2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

