/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.Coefficients;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesMap;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.BinaryFunctor;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.Selector;
import edu.jas.structure.UnaryFunctor;
import java.util.List;

public class Examples {
    public static void main(String[] stringArray) {
        Examples.example2();
        Examples.example4();
        Examples.example6();
        Examples.example8();
        Examples.example9();
        Examples.example10();
        Examples.example11();
        Examples.example1();
        Examples.example3();
        Examples.example5();
        Examples.example7();
        if (stringArray.length > 0) {
            Examples.example12();
        }
        Examples.example13();
        Examples.example14();
    }

    static UnivPowerSeries<BigInteger> integersFrom(final int n) {
        UnivPowerSeriesRing<BigInteger> univPowerSeriesRing = new UnivPowerSeriesRing<BigInteger>(new BigInteger());
        return new UnivPowerSeries<BigInteger>(univPowerSeriesRing, new Coefficients<BigInteger>(){

            @Override
            public BigInteger generate(int n2) {
                return new BigInteger(n + n2);
            }
        });
    }

    public static void example1() {
        UnivPowerSeries<BigInteger> univPowerSeries = Examples.integersFrom(0);
        BigInteger bigInteger = new BigInteger(1L);
        BigInteger bigInteger2 = univPowerSeries.evaluate(bigInteger);
        System.out.println("integers(" + bigInteger + ") = " + bigInteger2);
        bigInteger = new BigInteger(0L);
        bigInteger2 = univPowerSeries.evaluate(bigInteger);
        System.out.println("integers(" + bigInteger + ") = " + bigInteger2);
        bigInteger = new BigInteger(2L);
        bigInteger2 = univPowerSeries.evaluate(bigInteger);
        System.out.println("integers(" + bigInteger + ") = " + bigInteger2);
    }

    public static void example2() {
        UnivPowerSeries<BigInteger> univPowerSeries = Examples.integersFrom(0);
        System.out.print("integer coefficients = ");
        UnivPowerSeries<BigInteger> univPowerSeries2 = univPowerSeries;
        for (int i = 0; i < 20; ++i) {
            BigInteger bigInteger = univPowerSeries2.leadingCoefficient();
            System.out.print(bigInteger.toString() + ", ");
            univPowerSeries2 = univPowerSeries2.reductum();
        }
        System.out.println("...");
    }

    public static void example3() {
        BigInteger bigInteger = new BigInteger(1L);
        UnivPowerSeriesRing<BigInteger> univPowerSeriesRing = new UnivPowerSeriesRing<BigInteger>(bigInteger);
        System.out.println("ups = " + univPowerSeriesRing);
        System.out.println("ups.isCommutative() = " + univPowerSeriesRing.isCommutative());
        System.out.println("ups.isAssociative() = " + univPowerSeriesRing.isAssociative());
        System.out.println("ups.isField()       = " + univPowerSeriesRing.isField());
        System.out.println("ups.getZERO()       = " + (UnivPowerSeries)univPowerSeriesRing.getZERO());
        System.out.println("ups.getONE()        = " + (UnivPowerSeries)univPowerSeriesRing.getONE());
        UnivPowerSeries<BigInteger> univPowerSeries = univPowerSeriesRing.random();
        System.out.println("rnd = " + univPowerSeries);
        System.out.println("rnd = " + univPowerSeries);
        System.out.println("rnd.isUnit()       = " + univPowerSeries.isUnit());
    }

    public static void example4() {
        UnivPowerSeries<BigInteger> univPowerSeries = Examples.integersFrom(0);
        System.out.println("integers = " + univPowerSeries);
    }

    public static void example6() {
        UnivPowerSeriesRing<BigInteger> univPowerSeriesRing = new UnivPowerSeriesRing<BigInteger>(new BigInteger());
        UnivPowerSeries<BigInteger> univPowerSeries = univPowerSeriesRing.fixPoint(new UnivPowerSeriesMap<BigInteger>(){

            @Override
            public UnivPowerSeries<BigInteger> map(UnivPowerSeries<BigInteger> univPowerSeries) {
                return univPowerSeries.map(new UnaryFunctor<BigInteger, BigInteger>(){

                    @Override
                    public BigInteger eval(BigInteger bigInteger) {
                        return bigInteger.sum(new BigInteger(1L));
                    }
                }).prepend(new BigInteger(0L));
            }
        });
        System.out.println("integers1 = " + univPowerSeries);
        System.out.println("integers2 = " + univPowerSeries);
    }

    public static void example8() {
        final BigInteger bigInteger = new BigInteger(0L);
        final BigInteger bigInteger2 = new BigInteger(1L);
        UnivPowerSeriesRing<BigInteger> univPowerSeriesRing = new UnivPowerSeriesRing<BigInteger>(bigInteger);
        UnivPowerSeries<BigInteger> univPowerSeries = univPowerSeriesRing.fixPoint(new UnivPowerSeriesMap<BigInteger>(){

            @Override
            public UnivPowerSeries<BigInteger> map(UnivPowerSeries<BigInteger> univPowerSeries) {
                return univPowerSeries.zip(new Sum(), univPowerSeries.prepend(bigInteger2)).prepend(bigInteger);
            }
        });
        System.out.println("fibs1 = " + univPowerSeries.toString());
        System.out.println("fibs2 = " + univPowerSeries.toString());
    }

    public static void example9() {
        UnivPowerSeries<BigInteger> univPowerSeries = Examples.integersFrom(0);
        System.out.println("      integers = " + univPowerSeries);
        UnivPowerSeries<BigInteger> univPowerSeries2 = univPowerSeries.sum(univPowerSeries);
        System.out.println("doubleintegers = " + univPowerSeries2);
        UnivPowerSeries<BigInteger> univPowerSeries3 = univPowerSeries.subtract(univPowerSeries);
        System.out.println("null  integers = " + univPowerSeries3);
        univPowerSeries2 = univPowerSeries.multiply(new BigInteger(2L));
        System.out.println("doubleintegers = " + univPowerSeries2);
        univPowerSeries3 = univPowerSeries.multiply(new BigInteger(0L));
        System.out.println("null  integers = " + univPowerSeries3);
        UnivPowerSeries<BigInteger> univPowerSeries4 = univPowerSeries.select(new Odds<BigInteger>(new BigInteger()));
        System.out.println("odd   integers = " + univPowerSeries4);
    }

    public static void example10() {
        final BigInteger bigInteger = new BigInteger();
        UnivPowerSeriesRing<BigInteger> univPowerSeriesRing = new UnivPowerSeriesRing<BigInteger>(bigInteger);
        UnivPowerSeries<BigInteger> univPowerSeries = Examples.integersFrom(0);
        System.out.println("      integers = " + univPowerSeries);
        UnivPowerSeries<BigInteger> univPowerSeries2 = new UnivPowerSeries<BigInteger>(univPowerSeriesRing, new Coefficients<BigInteger>(){

            @Override
            public BigInteger generate(int n) {
                if (n == 0) {
                    return bigInteger.getONE();
                }
                return bigInteger.getZERO();
            }
        });
        System.out.println("ONE  = " + univPowerSeries2);
        UnivPowerSeries<BigInteger> univPowerSeries3 = new UnivPowerSeries<BigInteger>(univPowerSeriesRing, new Coefficients<BigInteger>(){

            @Override
            public BigInteger generate(int n) {
                return bigInteger.getZERO();
            }
        });
        System.out.println("ZERO = " + univPowerSeries3);
        UnivPowerSeries<BigInteger> univPowerSeries4 = univPowerSeries.multiply(univPowerSeries2);
        System.out.println("integers       = " + univPowerSeries4);
        UnivPowerSeries<BigInteger> univPowerSeries5 = univPowerSeries.multiply(univPowerSeries3);
        System.out.println("null  integers = " + univPowerSeries5);
        AbelianGroupElem abelianGroupElem = univPowerSeries.negate();
        System.out.println("-integers      = " + (UnivPowerSeries)abelianGroupElem);
        UnivPowerSeries<BigInteger> univPowerSeries6 = univPowerSeries2.multiply(univPowerSeries2);
        System.out.println("integers one   = " + univPowerSeries6);
        UnivPowerSeries<BigInteger> univPowerSeries7 = univPowerSeries.multiply(univPowerSeries);
        System.out.println("integers 2     = " + univPowerSeries7);
        MonoidElem monoidElem = univPowerSeries2.inverse();
        System.out.println("integers inv1  = " + (UnivPowerSeries)monoidElem);
        UnivPowerSeries<BigInteger> univPowerSeries8 = univPowerSeries.reductum();
        System.out.println("integers intr  = " + univPowerSeries8);
        MonoidElem monoidElem2 = univPowerSeries2.sum(univPowerSeries3).inverse();
        System.out.println("integers ints2inv = " + (UnivPowerSeries)monoidElem2);
        UnivPowerSeries<BigInteger> univPowerSeries9 = univPowerSeries7.multiply((UnivPowerSeries<BigInteger>)monoidElem2);
        System.out.println("integers one1  = " + univPowerSeries9);
        MonoidElem monoidElem3 = ((UnivPowerSeries)monoidElem2).inverse();
        System.out.println("integers ii    = " + (UnivPowerSeries)monoidElem3);
        UnivPowerSeries<BigInteger> univPowerSeries10 = univPowerSeries.subtract(univPowerSeries.divide(univPowerSeries7).multiply(univPowerSeries7));
        System.out.println("integers rem   = " + univPowerSeries10);
    }

    public static void example11() {
        UnivPowerSeries<BigInteger> univPowerSeries = Examples.integersFrom(0);
        System.out.println("      integers = " + univPowerSeries);
        UnivPowerSeries<BigInteger> univPowerSeries2 = univPowerSeries.multiply(new BigInteger(2L));
        System.out.println("    2*integers = " + univPowerSeries2);
        System.out.println("integers < 2*integers  = " + univPowerSeries.compareTo(univPowerSeries2));
        System.out.println("2*integers > integers  = " + univPowerSeries2.compareTo(univPowerSeries));
        System.out.println("2*integers == integers = " + univPowerSeries2.equals(univPowerSeries));
        System.out.println("integers == integers   = " + univPowerSeries.equals(univPowerSeries.copy()));
        System.out.println("integers.hashCode()    = " + univPowerSeries.hashCode());
    }

    public static void example5() {
        UnivPowerSeries<BigInteger> univPowerSeries = Examples.integersFrom(0);
        System.out.println("      integers = " + univPowerSeries);
        UnivPowerSeries<BigInteger> univPowerSeries2 = univPowerSeries.multiply(univPowerSeries);
        System.out.println("integers 2     = " + univPowerSeries2);
        UnivPowerSeries<BigInteger> univPowerSeries3 = univPowerSeries2.divide(univPowerSeries);
        System.out.println("q1             = " + univPowerSeries3);
        UnivPowerSeries<BigInteger> univPowerSeries4 = univPowerSeries.divide(univPowerSeries2);
        System.out.println("q2             = " + univPowerSeries4);
        UnivPowerSeries<BigInteger> univPowerSeries5 = univPowerSeries2.remainder(univPowerSeries);
        System.out.println("r1             = " + univPowerSeries5);
        UnivPowerSeries<BigInteger> univPowerSeries6 = univPowerSeries.remainder(univPowerSeries2);
        System.out.println("r2             = " + univPowerSeries6);
        UnivPowerSeries<BigInteger> univPowerSeries7 = univPowerSeries3.multiply(univPowerSeries).sum(univPowerSeries5);
        System.out.println("qr1            = " + univPowerSeries7);
        UnivPowerSeries<BigInteger> univPowerSeries8 = univPowerSeries4.multiply(univPowerSeries2).sum(univPowerSeries6);
        System.out.println("qr2            = " + univPowerSeries8);
        System.out.println("sign(qr1-ints2) = " + univPowerSeries7.compareTo(univPowerSeries2));
        System.out.println("sign(qr2-integers) = " + univPowerSeries8.compareTo(univPowerSeries));
        UnivPowerSeries<BigInteger> univPowerSeries9 = univPowerSeries2.gcd(univPowerSeries);
        System.out.println("g               = " + univPowerSeries9);
    }

    public static void example7() {
        final BigRational bigRational = new BigRational();
        final UnivPowerSeriesRing<BigRational> univPowerSeriesRing = new UnivPowerSeriesRing<BigRational>(bigRational, 11, "y");
        UnivPowerSeries<BigRational> univPowerSeries = univPowerSeriesRing.fixPoint(new UnivPowerSeriesMap<BigRational>(){

            @Override
            public UnivPowerSeries<BigRational> map(UnivPowerSeries<BigRational> univPowerSeries) {
                return univPowerSeries.integrate(bigRational.getONE());
            }
        });
        System.out.println("exp = " + univPowerSeries);
        UnivPowerSeries<BigRational> univPowerSeries2 = univPowerSeriesRing.fixPoint(new UnivPowerSeriesMap<BigRational>(){

            @Override
            public UnivPowerSeries<BigRational> map(UnivPowerSeries<BigRational> univPowerSeries) {
                return univPowerSeries.multiply(univPowerSeries).sum((UnivPowerSeries<BigRational>)univPowerSeriesRing.getONE()).integrate(bigRational.getZERO());
            }
        });
        System.out.println("tan = " + univPowerSeries2);
        UnivPowerSeries<BigRational> univPowerSeries3 = new UnivPowerSeries<BigRational>(univPowerSeriesRing, new Coefficients<BigRational>(){

            @Override
            public BigRational generate(int n) {
                BigRational bigRational2;
                if (n == 0) {
                    bigRational2 = bigRational.getZERO();
                } else if (n == 1) {
                    bigRational2 = bigRational.getONE();
                } else {
                    bigRational2 = ((BigRational)this.get(n - 2)).negate();
                    bigRational2 = bigRational2.divide(bigRational.fromInteger(n)).divide(bigRational.fromInteger(n - 1));
                }
                return bigRational2;
            }
        });
        System.out.println("sin = " + univPowerSeries3);
        UnivPowerSeries<BigRational> univPowerSeries4 = univPowerSeriesRing.fixPoint(new UnivPowerSeriesMap<BigRational>(){

            @Override
            public UnivPowerSeries<BigRational> map(UnivPowerSeries<BigRational> univPowerSeries) {
                return ((UnivPowerSeries)univPowerSeries.negate()).integrate(bigRational.getONE()).integrate(bigRational.getZERO());
            }
        });
        System.out.println("sin1 = " + univPowerSeries4);
        UnivPowerSeries<BigRational> univPowerSeries5 = new UnivPowerSeries<BigRational>(univPowerSeriesRing, new Coefficients<BigRational>(){

            @Override
            public BigRational generate(int n) {
                BigRational bigRational2;
                if (n == 0) {
                    bigRational2 = bigRational.getONE();
                } else if (n == 1) {
                    bigRational2 = bigRational.getZERO();
                } else {
                    bigRational2 = ((BigRational)this.get(n - 2)).negate();
                    bigRational2 = bigRational2.divide(bigRational.fromInteger(n)).divide(bigRational.fromInteger(n - 1));
                }
                return bigRational2;
            }
        });
        System.out.println("cos = " + univPowerSeries5);
        UnivPowerSeries<BigRational> univPowerSeries6 = univPowerSeriesRing.fixPoint(new UnivPowerSeriesMap<BigRational>(){

            @Override
            public UnivPowerSeries<BigRational> map(UnivPowerSeries<BigRational> univPowerSeries) {
                return ((UnivPowerSeries)univPowerSeries.negate()).integrate(bigRational.getZERO()).integrate(bigRational.getONE());
            }
        });
        System.out.println("cos1 = " + univPowerSeries6);
        UnivPowerSeries<BigRational> univPowerSeries7 = univPowerSeriesRing.solveODE((UnivPowerSeries<BigRational>)univPowerSeries4.negate(), bigRational.getONE());
        System.out.println("cos2 = " + univPowerSeries7);
        UnivPowerSeries<BigRational> univPowerSeries8 = univPowerSeriesRing.solveODE(univPowerSeries6, bigRational.getZERO());
        System.out.println("sin2 = " + univPowerSeries8);
        UnivPowerSeries<BigRational> univPowerSeries9 = new UnivPowerSeries<BigRational>(univPowerSeriesRing, new Coefficients<BigRational>(){

            @Override
            public BigRational generate(int n) {
                BigRational bigRational2;
                if (n == 0) {
                    bigRational2 = bigRational.getZERO();
                } else if (n == 1) {
                    bigRational2 = bigRational.getONE();
                } else {
                    bigRational2 = (BigRational)this.get(n - 2);
                    bigRational2 = bigRational2.divide(bigRational.fromInteger(n)).divide(bigRational.fromInteger(n - 1));
                }
                return bigRational2;
            }
        });
        System.out.println("sinh = " + univPowerSeries9);
        UnivPowerSeries<BigRational> univPowerSeries10 = new UnivPowerSeries<BigRational>(univPowerSeriesRing, new Coefficients<BigRational>(){

            @Override
            public BigRational generate(int n) {
                BigRational bigRational2;
                if (n == 0) {
                    bigRational2 = bigRational.getONE();
                } else if (n == 1) {
                    bigRational2 = bigRational.getZERO();
                } else {
                    bigRational2 = (BigRational)this.get(n - 2);
                    bigRational2 = bigRational2.divide(bigRational.fromInteger(n)).divide(bigRational.fromInteger(n - 1));
                }
                return bigRational2;
            }
        });
        System.out.println("cosh = " + univPowerSeries10);
        UnivPowerSeries<BigRational> univPowerSeries11 = univPowerSeries9.sum(univPowerSeries10);
        System.out.println("sinh+cosh = " + univPowerSeries11);
        System.out.println("sinh+cosh == exp: " + univPowerSeries11.equals(univPowerSeries));
    }

    public static void example12() {
        final BigComplex bigComplex = new BigComplex();
        final BigComplex bigComplex2 = BigComplex.I;
        UnivPowerSeriesRing<BigComplex> univPowerSeriesRing = new UnivPowerSeriesRing<BigComplex>(bigComplex);
        UnivPowerSeries<BigComplex> univPowerSeries = univPowerSeriesRing.fixPoint(new UnivPowerSeriesMap<BigComplex>(){

            @Override
            public UnivPowerSeries<BigComplex> map(UnivPowerSeries<BigComplex> univPowerSeries) {
                return univPowerSeries.integrate(bigComplex2);
            }
        });
        System.out.println("exp = " + univPowerSeries);
        UnivPowerSeries<BigComplex> univPowerSeries2 = univPowerSeriesRing.fixPoint(new UnivPowerSeriesMap<BigComplex>(){

            @Override
            public UnivPowerSeries<BigComplex> map(UnivPowerSeries<BigComplex> univPowerSeries) {
                return ((UnivPowerSeries)univPowerSeries.negate()).integrate(bigComplex.getONE()).integrate(bigComplex.getZERO());
            }
        });
        System.out.println("sin = " + univPowerSeries2);
        UnivPowerSeries<BigComplex> univPowerSeries3 = univPowerSeriesRing.fixPoint(new UnivPowerSeriesMap<BigComplex>(){

            @Override
            public UnivPowerSeries<BigComplex> map(UnivPowerSeries<BigComplex> univPowerSeries) {
                return ((UnivPowerSeries)univPowerSeries.negate()).integrate(bigComplex.getZERO()).integrate(bigComplex.getONE());
            }
        });
        System.out.println("cos = " + univPowerSeries3);
        UnivPowerSeries<BigComplex> univPowerSeries4 = univPowerSeries3.sum(univPowerSeries2.multiply(bigComplex2));
        System.out.println("cpis = " + univPowerSeries4);
    }

    public static void example13() {
        BigRational bigRational = new BigRational();
        UnivPowerSeriesRing<BigRational> univPowerSeriesRing = new UnivPowerSeriesRing<BigRational>(bigRational, 11, "y");
        UnivPowerSeries<BigRational> univPowerSeries = univPowerSeriesRing.getEXP();
        System.out.println("exp = " + univPowerSeries);
        System.out.println("exp(1) = " + univPowerSeries.evaluate(bigRational.getONE()));
        System.out.println("exp(0) = " + univPowerSeries.evaluate(bigRational.getZERO()));
        BigDecimal bigDecimal = new BigDecimal();
        UnivPowerSeriesRing<BigDecimal> univPowerSeriesRing2 = new UnivPowerSeriesRing<BigDecimal>(bigDecimal, 11, "z");
        UnivPowerSeries<BigDecimal> univPowerSeries2 = univPowerSeriesRing2.getEXP();
        System.out.println("exp = " + univPowerSeries2);
        System.out.println("exp(1) = " + univPowerSeries2.evaluate(bigDecimal.getONE()));
        System.out.println("exp(0) = " + univPowerSeries2.evaluate(bigDecimal.getZERO()));
    }

    public static void example14() {
        BigRational bigRational = new BigRational();
        UnivPowerSeriesRing<BigRational> univPowerSeriesRing = new UnivPowerSeriesRing<BigRational>(bigRational, 11, "t");
        System.out.println("pfac = " + univPowerSeriesRing);
        System.out.println("pfac = " + univPowerSeriesRing.toScript());
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(univPowerSeriesRing, new String[]{"x"});
        System.out.println("fac = " + genPolynomialRing);
        System.out.println("fac = " + genPolynomialRing.toScript());
        List<UnivPowerSeries<BigRational>> list = univPowerSeriesRing.generators();
        System.out.println("gens = " + list);
        Element element = genPolynomialRing.parse("x^2 - x");
        System.out.println("p = " + (GenPolynomial)element);
        GenPolynomial<UnivPowerSeries<BigRational>> genPolynomial = ((GenPolynomial)element).sum(list.get(1).multiply(list.get(1)));
        System.out.println("s = " + genPolynomial);
        GenPolynomial<GenPolynomial<UnivPowerSeries<BigRational>>> genPolynomial2 = ((GenPolynomial)element).multiply(genPolynomial);
        System.out.println("q = " + genPolynomial2);
        GenPolynomial<UnivPowerSeries<BigRational>> genPolynomial3 = genPolynomial2.gcd((GenPolynomial<GenPolynomial<UnivPowerSeries<BigRational>>>)genPolynomial);
        System.out.println("r = " + genPolynomial3);
    }

    static class Odds<C extends RingElem<C>>
    implements Selector<C> {
        C two;
        RingFactory<C> fac;

        public Odds(RingFactory<C> ringFactory) {
            this.fac = ringFactory;
            this.two = (RingElem)this.fac.fromInteger(2L);
        }

        @Override
        public boolean select(C c) {
            return ((RingElem)c.remainder(this.two)).isONE();
        }
    }

    static class Sum<C extends RingElem<C>>
    implements BinaryFunctor<C, C, C> {
        Sum() {
        }

        @Override
        public C eval(C c, C c2) {
            return (C)((RingElem)c.sum(c2));
        }
    }
}

