/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.util.CartesianProductLong;
import edu.jas.util.LongIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class ExpVectorIterator
implements Iterator<ExpVector> {
    ExpVector current;
    Iterator<List<Long>> liter;
    protected int totalDegree;
    protected boolean empty;
    final long upperBound;
    final boolean infinite;
    final int nvar;

    public ExpVectorIterator(int n) {
        this(n, true, Long.MAX_VALUE);
    }

    public ExpVectorIterator(int n, long l) {
        this(n, false, l);
    }

    protected ExpVectorIterator(int n, boolean bl, long l) {
        this.infinite = bl;
        this.upperBound = l;
        if (this.upperBound < 0L) {
            throw new IllegalArgumentException("negative upper bound not allowed");
        }
        this.totalDegree = 0;
        if (!this.infinite) {
            this.totalDegree = (int)this.upperBound;
        }
        LongIterable longIterable = new LongIterable();
        longIterable.setNonNegativeIterator();
        longIterable.setUpperBound(this.totalDegree);
        ArrayList<LongIterable> arrayList = new ArrayList<LongIterable>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(longIterable);
        }
        CartesianProductLong cartesianProductLong = new CartesianProductLong(arrayList, this.totalDegree);
        this.liter = cartesianProductLong.iterator();
        this.empty = (long)this.totalDegree > this.upperBound || !this.liter.hasNext();
        this.current = ExpVector.create(n);
        if (!this.empty) {
            List<Long> list = this.liter.next();
            this.current = ExpVector.create(list);
        }
        this.nvar = n;
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.empty;
    }

    @Override
    public synchronized ExpVector next() {
        ExpVector expVector = this.current;
        if (this.liter.hasNext()) {
            List<Long> list = this.liter.next();
            this.current = ExpVector.create(list);
            return expVector;
        }
        if ((long)this.totalDegree >= this.upperBound) {
            this.empty = true;
            return expVector;
        }
        ++this.totalDegree;
        if ((long)this.totalDegree >= this.upperBound && !this.infinite) {
            throw new NoSuchElementException("invalid call of next()");
        }
        LongIterable longIterable = new LongIterable();
        longIterable.setNonNegativeIterator();
        longIterable.setUpperBound(this.totalDegree);
        ArrayList<LongIterable> arrayList = new ArrayList<LongIterable>(this.nvar);
        for (int i = 0; i < this.nvar; ++i) {
            arrayList.add(longIterable);
        }
        CartesianProductLong cartesianProductLong = new CartesianProductLong(arrayList, this.totalDegree);
        this.liter = cartesianProductLong.iterator();
        List<Long> list = this.liter.next();
        this.current = ExpVector.create(list);
        return expVector;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannot remove elements");
    }
}

