/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInt;
import edu.jas.arith.ModIntRing;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.Power;
import edu.jas.ufd.EvalPoints;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import edu.jas.vector.GenVector;
import edu.jas.vector.LinAlg;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PolyUfdUtilTest
extends TestCase {
    TermOrder to = TermOrderByName.INVLEX;
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    GenPolynomialRing<BigRational> crfac;
    GenPolynomialRing<GenPolynomial<BigRational>> rrfac;
    GenPolynomial<GenPolynomial<BigRational>> arr;
    GenPolynomial<GenPolynomial<BigRational>> brr;
    GenPolynomial<GenPolynomial<BigRational>> crr;
    GenPolynomial<GenPolynomial<BigRational>> drr;
    GenPolynomial<GenPolynomial<BigRational>> err;
    GenPolynomial<GenPolynomial<BigRational>> frr;
    int rl = 5;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)PolyUfdUtilTest.suite());
        ComputerThreads.terminate();
    }

    public PolyUfdUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(PolyUfdUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
        ComputerThreads.terminate();
    }

    protected static java.math.BigInteger getPrime1() {
        long l = 2L;
        for (int i = 1; i < 60; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 93L));
    }

    protected static java.math.BigInteger getPrime2() {
        long l = 2L;
        for (int i = 1; i < 30; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 35L));
    }

    public void testKroneckerSubstitution() {
        for (int i = 0; i < 10; ++i) {
            this.a = this.dfac.random(this.kl, this.ll * 2, this.el * 5, this.q);
            long l = this.a.degree() + 1L;
            this.b = PolyUfdUtil.substituteKronecker(this.a, l);
            this.c = PolyUfdUtil.backSubstituteKronecker(this.dfac, this.b, l);
            this.e = this.a.subtract((BigInteger)((Object)this.c));
            PolyUfdUtilTest.assertTrue((String)"back(subst(a)) = a", (boolean)this.e.isZERO());
        }
    }

    public void testAlgebraicNumberField() {
        int n = 11;
        ModLongRing modLongRing = new ModLongRing(32003L);
        AlgebraicNumberRing<ModLong> algebraicNumberRing = PolyUfdUtil.algebraicNumberField(modLongRing, n);
        PolyUfdUtilTest.assertTrue((String)"gfpq.isField: ", (boolean)algebraicNumberRing.isField());
        ModIntegerRing modIntegerRing = new ModIntegerRing(PolyUfdUtilTest.getPrime1());
        AlgebraicNumberRing<ModInteger> algebraicNumberRing2 = PolyUfdUtil.algebraicNumberField(modIntegerRing, n);
        PolyUfdUtilTest.assertTrue((String)"gfPq.isField: ", (boolean)algebraicNumberRing2.isField());
        BigRational bigRational = BigRational.ONE;
        AlgebraicNumberRing<BigRational> algebraicNumberRing3 = PolyUfdUtil.algebraicNumberField(bigRational, n);
        PolyUfdUtilTest.assertTrue((String)"gfqq.isField: ", (boolean)algebraicNumberRing3.isField());
    }

    public void testRecursivePseudoDivisionDense() {
        String[] stringArray = new String[]{"x"};
        String[] stringArray2 = new String[]{"t"};
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.to, stringArray);
        this.rfac = new GenPolynomialRing<BigInteger>(this.dfac, this.to, stringArray2);
        QuotientRing<BigInteger> quotientRing = new QuotientRing<BigInteger>(this.dfac);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(quotientRing, this.rfac);
        this.ar = this.rfac.random(this.kl, 2 * this.ll, this.el + 4, this.q);
        this.br = this.rfac.random(this.kl, 2 * this.ll, this.el + 2, this.q);
        this.dr = PolyUtil.recursivePseudoDivide(this.ar, this.br);
        this.cr = PolyUtil.recursiveDensePseudoRemainder(this.ar, this.br);
        GenPolynomial genPolynomial = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.ar);
        GenPolynomial genPolynomial2 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.br);
        GenPolynomial genPolynomial3 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.cr);
        GenPolynomial genPolynomial4 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.dr);
        GenPolynomial genPolynomial5 = genPolynomial.divide(genPolynomial2);
        GenPolynomial genPolynomial6 = genPolynomial.remainder(genPolynomial2);
        GenPolynomial genPolynomial7 = genPolynomial5.multiply(genPolynomial2).sum(genPolynomial6);
        PolyUfdUtilTest.assertEquals((String)"ap = qp bp + rp: ", genPolynomial, genPolynomial7);
        PolyUfdUtilTest.assertEquals((String)"cp = rp: ", genPolynomial6.monic(), genPolynomial3.monic());
        PolyUfdUtilTest.assertEquals((String)"dp = qp: ", genPolynomial5.monic(), genPolynomial4.monic());
    }

    public void testRecursivePseudoDivisionSparse() {
        String[] stringArray = new String[]{"x"};
        String[] stringArray2 = new String[]{"t"};
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.to, stringArray);
        this.rfac = new GenPolynomialRing<BigInteger>(this.dfac, this.to, stringArray2);
        QuotientRing<BigInteger> quotientRing = new QuotientRing<BigInteger>(this.dfac);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(quotientRing, this.rfac);
        this.ar = this.rfac.random(this.kl, 2 * this.ll, this.el + 4, this.q);
        this.br = this.rfac.random(this.kl, 2 * this.ll, this.el + 2, this.q);
        this.dr = PolyUtil.recursivePseudoDivide(this.ar, this.br);
        this.cr = PolyUtil.recursiveSparsePseudoRemainder(this.ar, this.br);
        boolean bl = PolyUtil.isRecursivePseudoQuotientRemainder(this.ar, this.br, this.dr, this.cr);
        PolyUfdUtilTest.assertTrue((String)("lc^n a = q b + r: " + this.dr + "*b + " + this.cr), (boolean)bl);
        GenPolynomial genPolynomial = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.ar);
        GenPolynomial genPolynomial2 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.br);
        GenPolynomial genPolynomial3 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.cr);
        GenPolynomial genPolynomial4 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.dr);
        GenPolynomial genPolynomial5 = genPolynomial.divide(genPolynomial2);
        GenPolynomial genPolynomial6 = genPolynomial.remainder(genPolynomial2);
        GenPolynomial genPolynomial7 = genPolynomial5.multiply(genPolynomial2).sum(genPolynomial6);
        PolyUfdUtilTest.assertEquals((String)"ap = qp bp + rp: ", genPolynomial, genPolynomial7);
        PolyUfdUtilTest.assertEquals((String)"cp = rp: ", genPolynomial6.monic(), genPolynomial3.monic());
        PolyUfdUtilTest.assertEquals((String)"dp = qp: ", genPolynomial5.monic(), genPolynomial4.monic());
    }

    public void testRecursiveIntegerFromRationalCoefficients() {
        this.crfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.cfac);
        this.rrfac = new GenPolynomialRing<BigRational>(this.crfac, this.rfac);
        this.arr = this.rrfac.random(this.kl * this.kl, 2 * this.ll, this.el + 4, this.q);
        this.arr = this.arr.sum((GenPolynomial<BigRational>)this.arr).multiply(this.arr);
        this.ar = PolyUfdUtil.integerFromRationalCoefficients(this.rfac, this.arr);
        this.crr = PolyUtil.monic(this.arr);
        this.err = PolyUfdUtil.fromIntegerCoefficients(this.rrfac, this.ar);
        this.err = PolyUtil.monic(this.err);
        PolyUfdUtilTest.assertEquals((String)"crr != err: ", this.crr, this.err);
    }

    public void testNormAlgebraicNumberField() {
        int n = 5;
        BigRational bigRational = BigRational.ONE;
        AlgebraicNumberRing<BigRational> algebraicNumberRing = PolyUfdUtil.algebraicNumberField(bigRational, n);
        PolyUfdUtilTest.assertTrue((String)"gfqq.isField: ", (boolean)algebraicNumberRing.isField());
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(algebraicNumberRing, new String[]{"x"}, TermOrderByName.INVLEX);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(2, 4, 3, 0.4f).monic();
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(2, 4, 3, 0.4f).monic();
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial3 = genPolynomial.multiply((BigRational)((Object)genPolynomial2));
        GenPolynomial genPolynomial4 = PolyUfdUtil.norm(genPolynomial);
        GenPolynomial genPolynomial5 = PolyUfdUtil.norm(genPolynomial2);
        GenPolynomial<BigRational> genPolynomial6 = PolyUfdUtil.norm(genPolynomial3);
        GenPolynomial genPolynomial7 = genPolynomial4.multiply(genPolynomial5);
        if (genPolynomial7.equals(genPolynomial6)) {
            PolyUfdUtilTest.assertEquals((String)"normP*normQ == norm(P*Q)", genPolynomial7, genPolynomial6);
            return;
        }
        GenPolynomial genPolynomial8 = genPolynomial6.remainder(genPolynomial7);
        if (genPolynomial8.isZERO()) {
            PolyUfdUtilTest.assertTrue((String)"norm(P*Q) mod normP*normQ == 0", (boolean)genPolynomial8.isZERO());
            return;
        }
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigRational);
        GenPolynomial<BigRational> genPolynomial9 = greatestCommonDivisorAbstract.gcd(genPolynomial7, genPolynomial6);
        if (!genPolynomial9.isONE()) {
            PolyUfdUtilTest.assertFalse((String)"gcd(norm(P*Q), normP*normQ) != 1", (boolean)genPolynomial9.isONE());
            return;
        }
        FactorAbstract<BigRational> factorAbstract = FactorFactory.getImplementation(bigRational);
        SortedMap sortedMap = factorAbstract.factors(genPolynomial7);
        System.out.println("fnPQ = " + sortedMap);
        SortedMap<GenPolynomial<BigRational>, Long> sortedMap2 = factorAbstract.factors(genPolynomial6);
        System.out.println("fnR = " + sortedMap2);
    }

    public void testMultiNormAlgebraicNumberField() {
        int n = 5;
        BigRational bigRational = BigRational.ONE;
        AlgebraicNumberRing<BigRational> algebraicNumberRing = PolyUfdUtil.algebraicNumberField(bigRational, n);
        PolyUfdUtilTest.assertTrue((String)"gfqq.isField: ", (boolean)algebraicNumberRing.isField());
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(algebraicNumberRing, new String[]{"x", "y"}, TermOrderByName.INVLEX);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(2, 4, 2, 0.2f).monic();
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(2, 4, 2, 0.2f).monic();
        GenPolynomial<GenPolynomial<BigRational>> genPolynomial3 = genPolynomial.multiply((BigRational)((Object)genPolynomial2));
        GenPolynomial genPolynomial4 = PolyUfdUtil.norm(genPolynomial);
        GenPolynomial genPolynomial5 = PolyUfdUtil.norm(genPolynomial2);
        GenPolynomial<BigRational> genPolynomial6 = PolyUfdUtil.norm(genPolynomial3);
        GenPolynomial genPolynomial7 = genPolynomial4.multiply(genPolynomial5);
        if (genPolynomial7.equals(genPolynomial6)) {
            PolyUfdUtilTest.assertEquals((String)"normP*normQ == norm(P*Q)", genPolynomial7, genPolynomial6);
            return;
        }
        GenPolynomial genPolynomial8 = genPolynomial6.remainder(genPolynomial7);
        if (genPolynomial8.isZERO()) {
            PolyUfdUtilTest.assertTrue((String)"norm(P*Q) mod normP*normQ == 0", (boolean)genPolynomial8.isZERO());
            return;
        }
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigRational);
        GenPolynomial<BigRational> genPolynomial9 = greatestCommonDivisorAbstract.gcd(genPolynomial7, genPolynomial6);
        if (!genPolynomial9.isONE()) {
            PolyUfdUtilTest.assertFalse((String)"gcd(norm(P*Q), normP*normQ) != 1", (boolean)genPolynomial9.isONE());
            return;
        }
        FactorAbstract<BigRational> factorAbstract = FactorFactory.getImplementation(bigRational);
        SortedMap sortedMap = factorAbstract.factors(genPolynomial7);
        System.out.println("fnPQ = " + sortedMap);
        SortedMap<GenPolynomial<BigRational>, Long> sortedMap2 = factorAbstract.factors(genPolynomial6);
        System.out.println("fnR = " + sortedMap2);
    }

    public void testQmatix() {
        int n = 11;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"x"});
        Element element = genPolynomialRing.parse("x^6 - 3 x^5 + x^4 - 3 x^3 - x^2 -3 x + 1");
        int n2 = (int)((GenPolynomial)element).degree(0);
        ArrayList arrayList = PolyUfdUtil.constructQmatrix(element);
        int n3 = arrayList.size();
        int n4 = arrayList.get(0).size();
        PolyUfdUtilTest.assertTrue((String)("size(Q) == deg(a): " + arrayList), (n3 == n2 ? 1 : 0) != 0);
        PolyUfdUtilTest.assertTrue((String)("size(Q(0)) == deg(a): " + arrayList), (n4 == n2 ? 1 : 0) != 0);
        GenMatrixRing<ModInt> genMatrixRing = new GenMatrixRing<ModInt>(modIntRing, n3, n4);
        GenMatrix<ModInt> genMatrix = new GenMatrix<ModInt>(genMatrixRing, arrayList);
        GenMatrix<ModInt> genMatrix2 = genMatrix.subtract((GenMatrix<ModInt>)genMatrixRing.getONE());
        LinAlg<ModInt> linAlg = new LinAlg<ModInt>();
        List<GenVector<Object>> list = linAlg.nullSpaceBasis(genMatrix2);
        GenMatrix<ModInt> genMatrix3 = genMatrixRing.fromVectors(list);
        AbelianGroupElem abelianGroupElem = genMatrix3.negate();
        int n5 = ((GenMatrix)abelianGroupElem).ring.rows;
        PolyUfdUtilTest.assertTrue((String)("0 <= k && k < n: " + (GenMatrix)abelianGroupElem), (0 <= n5 && n5 < n3 ? 1 : 0) != 0);
        while (((GenPolynomial)(element = genPolynomialRing.random(10))).isZERO() || ((GenPolynomial)element).degree(0) <= 1L) {
        }
        n2 = (int)((GenPolynomial)element).degree(0);
        arrayList = PolyUfdUtil.constructQmatrix(element);
        n3 = arrayList.size();
        n4 = arrayList.get(0).size();
        PolyUfdUtilTest.assertTrue((String)("size(Q) == deg(a): " + arrayList), (n3 == n2 ? 1 : 0) != 0);
        PolyUfdUtilTest.assertTrue((String)("size(Q(0)) == deg(a): " + arrayList), (n4 == n2 ? 1 : 0) != 0);
        ArrayList arrayList2 = arrayList;
        genMatrixRing = new GenMatrixRing<ModInt>(modIntRing, n3, n4);
        genMatrix = new GenMatrix<ModInt>(genMatrixRing, arrayList);
        genMatrix2 = genMatrix.subtract((GenMatrix<ModInt>)genMatrixRing.getONE());
        list = linAlg.nullSpaceBasis(genMatrix2);
        genMatrix3 = genMatrixRing.fromVectors(list);
        abelianGroupElem = genMatrix3.negate();
        n5 = ((GenMatrix)abelianGroupElem).ring.rows;
        PolyUfdUtilTest.assertTrue((String)("0 <= k && k < n: " + (GenMatrix)abelianGroupElem), (0 <= n5 && n5 <= n3 ? 1 : 0) != 0);
        GenPolynomial<ModInt> genPolynomial = genPolynomialRing.univariate(0);
        GenPolynomial<GenPolynomial> genPolynomial2 = genPolynomialRing.getONE();
        ArrayList<GenPolynomial<GenPolynomial>> arrayList3 = new ArrayList<GenPolynomial<GenPolynomial>>();
        arrayList3.add(genPolynomial2);
        GenPolynomial genPolynomial3 = (GenPolynomial)Power.modPositivePower(genPolynomial, n, element);
        arrayList3.add(genPolynomial3);
        genPolynomial2 = genPolynomial3;
        for (int i = 2; i < n2; ++i) {
            genPolynomial2 = genPolynomial2.multiply(genPolynomial3).remainder((GenPolynomial<GenPolynomial>)element);
            arrayList3.add(genPolynomial2);
        }
        PolyUfdUtilTest.assertTrue((String)("deg(r) < deg(A): " + arrayList3), (genPolynomial2.degree(0) <= ((GenPolynomial)element).degree(0) ? 1 : 0) != 0);
        UnivPowerSeriesRing<ModInt> univPowerSeriesRing = new UnivPowerSeriesRing<ModInt>(genPolynomialRing);
        ArrayList arrayList4 = new ArrayList();
        for (GenPolynomial genPolynomial4 : arrayList3) {
            UnivPowerSeries<ModInt> univPowerSeries = univPowerSeriesRing.fromPolynomial(genPolynomial4);
            ArrayList<ModInt> arrayList5 = new ArrayList<ModInt>();
            for (int i = 0; i < n2; ++i) {
                ModInt modInt = univPowerSeries.coefficient(i);
                arrayList5.add(modInt);
            }
            arrayList4.add(arrayList5);
        }
        PolyUfdUtilTest.assertEquals((String)"Qa == Qb: ", arrayList2, arrayList4);
    }

    public void testSearchEvaluationPoints() {
        this.crfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.dfac);
        SquarefreeAbstract<GenPolynomial<BigInteger>> squarefreeAbstract = SquarefreeFactory.getImplementation(this.dfac.coFac);
        SquarefreeAbstract<GenPolynomial<BigRational>> squarefreeAbstract2 = SquarefreeFactory.getImplementation(this.crfac.coFac);
        for (int i = 0; i < 5; ++i) {
            this.a = this.dfac.random(this.kl, this.ll * 2, this.el * 5, this.q);
            this.a = squarefreeAbstract.squarefreePart(this.a);
            EvalPoints<BigInteger> evalPoints = PolyUfdUtil.evaluationPoints(this.a);
            PolyUfdUtilTest.assertFalse((String)"L != (): ", (boolean)evalPoints.evalPoints.isEmpty());
            GenPolynomial<BigRational> genPolynomial = this.crfac.random(this.kl, this.ll, this.el * 2, this.q * 1.5f);
            genPolynomial = squarefreeAbstract2.squarefreePart(genPolynomial);
            EvalPoints<BigRational> evalPoints2 = PolyUfdUtil.evaluationPoints(genPolynomial);
            PolyUfdUtilTest.assertFalse((String)"Lr != (): ", (boolean)evalPoints2.evalPoints.isEmpty());
        }
    }
}

