/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.LongIterable;
import edu.jas.util.LongIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class CartesianProductLongIterator
implements Iterator<List<Long>> {
    final List<LongIterable> comps;
    final List<LongIterator> compit;
    List<Long> current;
    boolean empty;
    public final long upperBound;

    public CartesianProductLongIterator(List<LongIterable> list, long l) {
        if (list == null) {
            throw new IllegalArgumentException("null comps not allowed");
        }
        this.comps = list;
        this.upperBound = l;
        this.current = new ArrayList<Long>(list.size());
        this.compit = new ArrayList<LongIterator>(list.size());
        this.empty = false;
        for (LongIterable longIterable : list) {
            LongIterator longIterator = (LongIterator)longIterable.iterator();
            if (longIterator.getUpperBound() < this.upperBound) {
                throw new IllegalArgumentException("each iterator (" + longIterator.getUpperBound() + ") must be able to reach total upper bound " + this.upperBound);
            }
            if (!longIterator.hasNext()) {
                this.empty = true;
                this.current.clear();
                return;
            }
            this.current.add(longIterator.next());
            this.compit.add(longIterator);
        }
        LongIterator longIterator = this.compit.get(this.compit.size() - 1);
        long l2 = -1L;
        while (longIterator.hasNext() && (l2 = longIterator.next().longValue()) < this.upperBound) {
        }
        if (l2 >= 0L) {
            this.current.set(this.current.size() - 1, l2);
        }
        if (this.totalDegree(this.current) != this.upperBound) {
            this.empty = true;
            this.current.clear();
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.empty;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized List<Long> next() {
        if (this.empty) {
            throw new NoSuchElementException("invalid call of next()");
        }
        var1_1 = new ArrayList<Long>(this.current);
        while (true) {
            for (var2_2 = this.compit.size() - 1; var2_2 >= 0 && !(var3_4 = this.compit.get(var2_2)).hasNext(); --var2_2) {
            }
            if (var2_2 < 0) {
                this.empty = true;
                return var1_1;
            }
            var3_3 = 0L;
            for (var5_6 = 0; var5_6 < var2_2; ++var5_6) {
                var3_3 += this.current.get(var5_6).longValue();
            }
            if (var3_3 >= this.upperBound) {
                if (this.current.get(0) == this.upperBound) {
                    this.empty = true;
                    return var1_1;
                }
                var3_3 = this.upperBound;
            }
            var5_5 = this.upperBound - var3_3;
            for (var7_8 = var2_2 + 1; var7_8 < this.compit.size(); ++var7_8) {
                var8_9 = (LongIterator)this.comps.get(var7_8).iterator();
                var8_9.setUpperBound(var5_5);
                this.compit.set(var7_8, var8_9);
            }
            for (var7_8 = var2_2; var7_8 < this.compit.size(); ++var7_8) {
                var8_9 = this.compit.get(var7_8);
                var9_10 = var8_9.next();
                this.current.set(var7_8, (Long)var9_10);
            }
            var7_7 = this.totalDegree(this.current);
            if (var7_7 == this.upperBound) {
                return var1_1;
            }
            if (var7_7 > this.upperBound) ** continue;
            var9_10 = this.compit.get(this.compit.size() - 1);
            var10_11 = -1L;
            while (var7_7 < this.upperBound && var9_10.hasNext()) {
                ++var7_7;
                var10_11 = var9_10.next();
            }
            if (var10_11 >= 0L) {
                this.current.set(this.current.size() - 1, var10_11);
            }
            if (var7_7 == this.upperBound) break;
        }
        return var1_1;
    }

    public long totalDegree(List<Long> list) {
        long l = 0L;
        for (Long l2 : list) {
            l += l2.longValue();
        }
        return l;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannot remove tuples");
    }
}

