/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.PrimitiveElement;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.Complex;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.AlgebraicRoots;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.List;

public class AlgebraicRootsPrimElem<C extends GcdRingElem<C> & Rational>
extends AlgebraicRoots<C>
implements Serializable {
    public final PrimitiveElement<C> pelem;
    public final List<AlgebraicNumber<C>> runit;

    protected AlgebraicRootsPrimElem() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public AlgebraicRootsPrimElem(GenPolynomial<C> genPolynomial, GenPolynomial<Complex<C>> genPolynomial2, List<RealAlgebraicNumber<C>> list, List<ComplexAlgebraicNumber<C>> list2, PrimitiveElement<C> primitiveElement, List<AlgebraicNumber<C>> list3) {
        super(genPolynomial, genPolynomial2, list, list2);
        this.pelem = primitiveElement;
        this.runit = list3;
    }

    public AlgebraicRootsPrimElem(AlgebraicRoots<C> algebraicRoots, PrimitiveElement<C> primitiveElement) {
        this(algebraicRoots.p, algebraicRoots.cp, algebraicRoots.real, algebraicRoots.complex, primitiveElement, null);
    }

    public AlgebraicRootsPrimElem(AlgebraicRoots<C> algebraicRoots, PrimitiveElement<C> primitiveElement, List<AlgebraicNumber<C>> list) {
        this(algebraicRoots.p, algebraicRoots.cp, algebraicRoots.real, algebraicRoots.complex, primitiveElement, list);
    }

    @Override
    public String toString() {
        if (this.runit == null) {
            return super.toString();
        }
        return super.toString() + ", " + this.runit.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer(super.toScript());
        if (this.runit == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(" [");
        boolean bl = true;
        for (AlgebraicNumber<C> algebraicNumber : this.runit) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(algebraicNumber.toScript());
        }
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }

    @Override
    public String toDecimalScript() {
        return super.toDecimalScript();
    }

    @Override
    public AlgebraicRootsPrimElem<C> copy() {
        return new AlgebraicRootsPrimElem<C>(this.p, this.cp, this.real, this.complex, this.pelem, this.runit);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AlgebraicRootsPrimElem)) {
            return false;
        }
        AlgebraicRootsPrimElem algebraicRootsPrimElem = null;
        try {
            algebraicRootsPrimElem = (AlgebraicRootsPrimElem)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return super.equals(algebraicRootsPrimElem);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

