/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseSeqIter;
import edu.jas.gb.OrderedMinPairlist;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBaseSeqIterTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    List<GenPolynomial<BigRational>> G;
    PolynomialList<BigRational> F;
    GroebnerBaseAbstract<BigRational> bb;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 4;
    int kl = 7;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GroebnerBaseSeqIterTest.suite());
    }

    public GroebnerBaseSeqIterTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseSeqIterTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBaseSeqIter<BigRational>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseSeqIterTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqIterTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseSeqIterTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqIterTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseSeqIterTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqIterTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseSeqIterTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqIterTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseSeqIterTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSeqIterTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7GBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        String string2 = "(x,y,z) L ( ( z y**2 + 2 x + 1/2 )( z x**2 - y**2 - 1/2 x )( -z + y**2 x + 4 x**2 + 1/4 ) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseSeqIterTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseSeqIterTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        GroebnerBaseSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseSeqIterTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }

    public void testTrinks7GBaseSyz() {
        GroebnerBaseSeqIter groebnerBaseSeqIter = new GroebnerBaseSeqIter(new ReductionSeq(), new OrderedSyzPairlist());
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        String string2 = "(x,y,z) L ( ( z y**2 + 2 x + 1/2 )( z x**2 - y**2 - 1/2 x )( -z + y**2 x + 4 x**2 + 1/4 ) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseSeqIterTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseSeqIterTest.fail((String)("" + iOException));
        }
        this.G = groebnerBaseSeqIter.GB(this.F.list);
        GroebnerBaseSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)groebnerBaseSeqIter.isGB(this.G));
        GroebnerBaseSeqIterTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        GroebnerBaseSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
    }

    public void testTrinks7GBaseMin() {
        this.bb = new GroebnerBaseSeqIter<BigRational>(new ReductionSeq(), new OrderedMinPairlist());
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseSeqIterTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseSeqIterTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        GroebnerBaseSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseSeqIterTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }
}

