/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PreemptingException;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.AlgebraicNotInvertibleException;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyIterator;
import edu.jas.poly.PolySpliterator;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import edu.jas.structure.UnaryFunctor;
import edu.jas.util.MapEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenPolynomial<C extends RingElem<C>>
implements RingElem<GenPolynomial<C>>,
Iterable<Monomial<C>> {
    public final GenPolynomialRing<C> ring;
    protected final SortedMap<ExpVector, C> val;
    protected transient int hash = -1;
    protected transient long blen = -1L;
    private static final Logger logger = LogManager.getLogger(GenPolynomial.class);
    private static final boolean debug = logger.isDebugEnabled();

    private GenPolynomial(GenPolynomialRing<C> genPolynomialRing, TreeMap<ExpVector, C> treeMap) {
        this.ring = genPolynomialRing;
        this.val = treeMap;
        if (this.ring.checkPreempt && Thread.currentThread().isInterrupted()) {
            logger.debug("throw PreemptingException");
            throw new PreemptingException();
        }
    }

    public GenPolynomial(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing, (C)new TreeMap(genPolynomialRing.tord.getDescendComparator()));
    }

    public GenPolynomial(GenPolynomialRing<C> genPolynomialRing, C c, ExpVector expVector) {
        this(genPolynomialRing);
        if (!c.isZERO()) {
            this.val.put(expVector, c);
        }
    }

    public GenPolynomial(GenPolynomialRing<C> genPolynomialRing, C c) {
        this(genPolynomialRing, c, genPolynomialRing.evzero);
    }

    public GenPolynomial(GenPolynomialRing<C> genPolynomialRing, ExpVector expVector) {
        this(genPolynomialRing, (RingElem)genPolynomialRing.coFac.getONE(), expVector);
    }

    protected GenPolynomial(GenPolynomialRing<C> genPolynomialRing, SortedMap<ExpVector, C> sortedMap) {
        this(genPolynomialRing);
        if (sortedMap.size() > 0) {
            ++GenPolynomialRing.creations;
            this.val.putAll(sortedMap);
            assert (!this.val.values().contains(genPolynomialRing.coFac.getZERO())) : "illegal coefficient zero: " + sortedMap;
        }
    }

    protected GenPolynomial(GenPolynomialRing<C> genPolynomialRing, Map<ExpVector, C> map) {
        this(genPolynomialRing);
        if (map.size() > 0) {
            ++GenPolynomialRing.creations;
            this.val.putAll(map);
            assert (!this.val.values().contains(genPolynomialRing.coFac.getZERO())) : "illegal coefficient zero: " + map;
        }
    }

    @Override
    public GenPolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenPolynomial<C> copy() {
        return new GenPolynomial<C>(this.ring, this.val);
    }

    public int length() {
        return this.val.size();
    }

    public SortedMap<ExpVector, C> getMap() {
        return Collections.unmodifiableSortedMap(this.val);
    }

    public void doPutToMap(ExpVector expVector, C c) {
        if (debug) {
            RingElem ringElem = (RingElem)this.val.get(expVector);
            if (ringElem != null) {
                logger.error("map entry exists " + expVector + " to " + ringElem + " new " + c);
            }
            this.hash = -1;
            this.blen = -1L;
        }
        if (!c.isZERO()) {
            this.val.put(expVector, c);
        }
    }

    public void doRemoveFromMap(ExpVector expVector, C c) {
        RingElem ringElem = (RingElem)this.val.remove(expVector);
        this.hash = -1;
        this.blen = -1L;
        if (c == null) {
            return;
        }
        if (!c.equals(ringElem)) {
            logger.error("map entry wrong " + expVector + " to " + c + " old " + ringElem);
            throw new RuntimeException("c != b");
        }
    }

    public void doPutToMap(SortedMap<ExpVector, C> sortedMap) {
        for (Map.Entry<ExpVector, C> entry : sortedMap.entrySet()) {
            RingElem ringElem;
            ExpVector expVector = entry.getKey();
            if (debug) {
                ringElem = (RingElem)this.val.get(expVector);
                if (ringElem != null) {
                    logger.error("map entry exists " + expVector + " to " + ringElem + " new " + entry.getValue());
                }
                this.hash = -1;
                this.blen = -1L;
            }
            if ((ringElem = (RingElem)entry.getValue()).isZERO()) continue;
            this.val.put(expVector, ringElem);
        }
    }

    public String toString() {
        if (this.ring.vars != null) {
            return this.toString(this.ring.vars);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName() + ":");
        stringBuffer.append(this.ring.coFac.getClass().getSimpleName());
        if (this.ring.coFac.characteristic().signum() != 0) {
            stringBuffer.append("(" + this.ring.coFac.characteristic() + ")");
        }
        stringBuffer.append("[ ");
        boolean bl = true;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(((RingElem)entry.getValue()).toString());
            stringBuffer.append(" ");
            stringBuffer.append(entry.getKey().toString());
        }
        stringBuffer.append(" ] ");
        return stringBuffer.toString();
    }

    public String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (PrettyPrint.isTrue()) {
            if (this.val.isEmpty()) {
                stringBuffer.append("0");
            } else {
                boolean bl = true;
                for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
                    RingElem ringElem = (RingElem)entry.getValue();
                    if (bl) {
                        bl = false;
                    } else if (ringElem.signum() < 0) {
                        stringBuffer.append(" - ");
                        ringElem = (RingElem)ringElem.negate();
                    } else {
                        stringBuffer.append(" + ");
                    }
                    ExpVector expVector = entry.getKey();
                    if (!ringElem.isONE() || expVector.isZERO()) {
                        String string = ringElem.toString();
                        if (string.indexOf("-") >= 0 || string.indexOf("+") >= 0) {
                            stringBuffer.append("( ");
                            stringBuffer.append(string);
                            stringBuffer.append(" )");
                        } else {
                            stringBuffer.append(string);
                        }
                        stringBuffer.append(" ");
                    }
                    if (expVector != null && stringArray != null) {
                        stringBuffer.append(expVector.toString(stringArray));
                        continue;
                    }
                    stringBuffer.append(expVector);
                }
            }
        } else {
            stringBuffer.append(this.getClass().getSimpleName() + "[ ");
            if (this.val.isEmpty()) {
                stringBuffer.append("0");
            } else {
                boolean bl = true;
                for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
                    RingElem ringElem = (RingElem)entry.getValue();
                    if (bl) {
                        bl = false;
                    } else if (ringElem.signum() < 0) {
                        stringBuffer.append(" - ");
                        ringElem = (RingElem)ringElem.negate();
                    } else {
                        stringBuffer.append(" + ");
                    }
                    ExpVector expVector = entry.getKey();
                    if (!ringElem.isONE() || expVector.isZERO()) {
                        stringBuffer.append(ringElem.toString());
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(expVector.toString(stringArray));
                }
            }
            stringBuffer.append(" ] ");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        String[] stringArray;
        if (this.isZERO()) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.val.size() > 1) {
            stringBuffer.append("( ");
        }
        if ((stringArray = this.ring.vars) == null) {
            stringArray = GenPolynomialRing.newVars("x", this.ring.nvar);
        }
        Pattern pattern = Pattern.compile("\\s*\\(.+\\)\\s*");
        boolean bl = true;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            boolean bl2;
            RingElem ringElem = (RingElem)entry.getValue();
            if (bl) {
                bl = false;
            } else if (ringElem.signum() < 0) {
                stringBuffer.append(" - ");
                ringElem = (RingElem)ringElem.negate();
            } else {
                stringBuffer.append(" + ");
            }
            ExpVector expVector = entry.getKey();
            String string = ringElem.toScript();
            boolean bl3 = bl2 = (string.indexOf("-") >= 0 || string.indexOf("+") >= 0) && !pattern.matcher(string).matches();
            if (!ringElem.isONE() || expVector.isZERO()) {
                if (bl2) {
                    stringBuffer.append("( ");
                }
                stringBuffer.append(string);
                if (bl2) {
                    stringBuffer.append(" )");
                }
                if (!expVector.isZERO()) {
                    stringBuffer.append(" * ");
                }
            }
            stringBuffer.append(expVector.toScript(stringArray));
        }
        if (this.val.size() > 1) {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((GenPolynomialRing)this.factory()).toScript();
    }

    @Override
    public boolean isZERO() {
        return this.val.isEmpty();
    }

    @Override
    public boolean isONE() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem ringElem = (RingElem)this.val.get(this.ring.evzero);
        if (ringElem == null) {
            return false;
        }
        return ringElem.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem ringElem = (RingElem)this.val.get(this.ring.evzero);
        if (ringElem == null) {
            return false;
        }
        return ringElem.isUnit();
    }

    public boolean isConstant() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem ringElem = (RingElem)this.val.get(this.ring.evzero);
        return ringElem != null;
    }

    public boolean isHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        long l = -1L;
        for (ExpVector expVector : this.val.keySet()) {
            if (l < 0L) {
                l = expVector.totalDeg();
                continue;
            }
            if (l == expVector.totalDeg()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenPolynomial)) {
            return false;
        }
        GenPolynomial genPolynomial = (GenPolynomial)object;
        return this.compareTo(genPolynomial) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.hash;
        if (n == -1) {
            this.hash = n = this.val.hashCode();
        }
        return n;
    }

    @Override
    public int compareTo(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return 1;
        }
        SortedMap<ExpVector, C> sortedMap = this.val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial.val;
        Iterator<Map.Entry<ExpVector, C>> iterator = sortedMap.entrySet().iterator();
        Iterator<Map.Entry<ExpVector, C>> iterator2 = sortedMap2.entrySet().iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext() && iterator2.hasNext()) {
            ExpVector expVector;
            Map.Entry<ExpVector, C> entry = iterator.next();
            Map.Entry<ExpVector, C> entry2 = iterator2.next();
            ExpVector expVector2 = entry.getKey();
            n = expVector2.compareTo(expVector = entry2.getKey());
            if (n != 0) {
                return n;
            }
            if (n2 != 0) continue;
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)entry2.getValue();
            n2 = ringElem.compareTo(ringElem2);
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return n2;
    }

    @Override
    public int signum() {
        if (this.isZERO()) {
            return 0;
        }
        ExpVector expVector = this.val.firstKey();
        RingElem ringElem = (RingElem)this.val.get(expVector);
        return ringElem.signum();
    }

    public int numberOfVariables() {
        return this.ring.nvar;
    }

    public Map.Entry<ExpVector, C> leadingMonomial() {
        if (this.val.isEmpty()) {
            return null;
        }
        ExpVector expVector = this.val.firstKey();
        return new MapEntry<ExpVector, RingElem>(expVector, (RingElem)this.val.get(expVector));
    }

    public ExpVector leadingExpVector() {
        if (this.val.isEmpty()) {
            return null;
        }
        return this.val.firstKey();
    }

    public ExpVector trailingExpVector() {
        if (this.val.isEmpty()) {
            return null;
        }
        return this.val.lastKey();
    }

    public C leadingBaseCoefficient() {
        if (this.val.isEmpty()) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)((RingElem)this.val.get(this.val.firstKey()));
    }

    public C trailingBaseCoefficient() {
        RingElem ringElem = (RingElem)this.val.get(this.ring.evzero);
        if (ringElem == null) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)ringElem;
    }

    public C coefficient(ExpVector expVector) {
        RingElem ringElem = (RingElem)this.val.get(expVector);
        if (ringElem == null) {
            ringElem = (RingElem)this.ring.coFac.getZERO();
        }
        return (C)ringElem;
    }

    public GenPolynomial<C> reductum() {
        if (this.val.size() <= 1) {
            return this.ring.getZERO();
        }
        Iterator<ExpVector> iterator = this.val.keySet().iterator();
        ExpVector expVector = iterator.next();
        expVector = iterator.next();
        SortedMap<ExpVector, C> sortedMap = this.val.tailMap(expVector);
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        ((GenPolynomial)element).doPutToMap(sortedMap);
        return element;
    }

    public long degree(int n) {
        if (this.val.isEmpty()) {
            return -1L;
        }
        int n2 = n >= 0 ? this.ring.nvar - 1 - n : this.ring.nvar + n;
        long l = 0L;
        if (n2 < 0) {
            return l;
        }
        for (ExpVector expVector : this.val.keySet()) {
            long l2 = expVector.getVal(n2);
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public long degree() {
        if (this.val.isEmpty()) {
            return -1L;
        }
        long l = 0L;
        for (ExpVector expVector : this.val.keySet()) {
            long l2 = expVector.maxDeg();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public long degreeMin() {
        if (this.val.isEmpty()) {
            return -1L;
        }
        long l = Long.MAX_VALUE;
        for (ExpVector expVector : this.val.keySet()) {
            long l2 = expVector.minDeg();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    public long totalDegree() {
        if (this.val.isEmpty()) {
            return -1L;
        }
        long l = 0L;
        for (ExpVector expVector : this.val.keySet()) {
            long l2 = expVector.totalDeg();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public long weightDegree() {
        long[][] lArray = this.ring.tord.getWeight();
        if (lArray == null || lArray.length == 0) {
            return this.totalDegree();
        }
        if (this.val.isEmpty()) {
            return -1L;
        }
        long l = 0L;
        for (ExpVector expVector : this.val.keySet()) {
            long l2 = expVector.weightDeg(lArray);
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public GenPolynomial<C> leadingWeightPolynomial() {
        if (this.val.isEmpty()) {
            return this.ring.getZERO();
        }
        long[][] lArray = this.ring.tord.getWeight();
        long l = this.weightDegree();
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            ExpVector expVector = entry.getKey();
            long l2 = expVector.weightDeg(lArray);
            if (l2 < l) continue;
            ((GenPolynomial)element).val.put(expVector, (RingElem)entry.getValue());
        }
        return element;
    }

    public GenPolynomial<C> leadingFacetPolynomial(ExpVector expVector, ExpVector expVector2) {
        if (this.val.isEmpty()) {
            return this.ring.getZERO();
        }
        long[] lArray = expVector2.getVal();
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            long l;
            long l2;
            ExpVector expVector3 = entry.getKey();
            if (expVector.equals(expVector3)) {
                ((GenPolynomial)element).val.put(expVector3, (RingElem)entry.getValue());
                continue;
            }
            ExpVector expVector4 = expVector.subtract(expVector3);
            if (expVector4.compareTo(expVector2) == 0) {
                ((GenPolynomial)element).val.put(expVector3, (RingElem)entry.getValue());
                continue;
            }
            long l3 = expVector4.weightDeg(lArray);
            if (l3 * l3 != (l2 = expVector4.weightDeg(expVector4.getVal())) * (l = expVector2.weightDeg(lArray))) continue;
            ((GenPolynomial)element).val.put(expVector3, (RingElem)entry.getValue());
            logger.info("ab = " + l3 + ", a = " + l2 + ", b = " + l + ", u = " + expVector + ", e = " + expVector3 + ", v = " + expVector4);
        }
        return element;
    }

    public boolean isWeightHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        long[][] lArray = this.ring.tord.getWeight();
        if (lArray == null || lArray.length == 0) {
            return this.isHomogeneous();
        }
        long l = -1L;
        for (ExpVector expVector : this.val.keySet()) {
            if (l < 0L) {
                l = expVector.weightDeg(lArray);
                continue;
            }
            if (l == expVector.weightDeg(lArray)) continue;
            return false;
        }
        return true;
    }

    public ExpVector degreeVector() {
        if (this.val.isEmpty()) {
            return null;
        }
        ExpVector expVector = this.ring.evzero;
        for (ExpVector expVector2 : this.val.keySet()) {
            expVector = expVector.lcm(expVector2);
        }
        return expVector;
    }

    public List<ExpVector> deltaExpVectors() {
        ArrayList<ExpVector> arrayList = new ArrayList<ExpVector>(this.val.size());
        if (this.val.isEmpty()) {
            return arrayList;
        }
        ExpVector expVector = null;
        for (ExpVector expVector2 : this.val.keySet()) {
            if (expVector == null) {
                expVector = expVector2;
                continue;
            }
            ExpVector expVector3 = expVector.subtract(expVector2);
            arrayList.add(expVector3);
        }
        return arrayList;
    }

    public List<ExpVector> deltaExpVectors(ExpVector expVector) {
        ArrayList<ExpVector> arrayList = new ArrayList<ExpVector>(this.val.size());
        if (this.val.isEmpty()) {
            return arrayList;
        }
        for (ExpVector expVector2 : this.val.keySet()) {
            ExpVector expVector3 = expVector.subtract(expVector2);
            if (expVector3.isZERO()) continue;
            arrayList.add(expVector3);
        }
        return arrayList;
    }

    public C maxNorm() {
        RingElem ringElem = this.ring.getZEROCoefficient();
        for (RingElem ringElem2 : this.val.values()) {
            RingElem ringElem3 = (RingElem)ringElem2.abs();
            if (ringElem.compareTo((RingElem)ringElem3) >= 0) continue;
            ringElem = ringElem3;
        }
        return (C)ringElem;
    }

    public C sumNorm() {
        RingElem ringElem = this.ring.getZEROCoefficient();
        for (RingElem ringElem2 : this.val.values()) {
            RingElem ringElem3 = (RingElem)ringElem2.abs();
            ringElem = ringElem.sum((RingElem)ringElem3);
        }
        return (C)ringElem;
    }

    @Override
    public GenPolynomial<C> sum(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genPolynomial;
        }
        if (this.length() < 3 * genPolynomial.length() / 5) {
            return genPolynomial.sum(this);
        }
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        Element element = this.copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial.val;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            ExpVector expVector = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)sortedMap.get(expVector);
            if (ringElem2 != null) {
                if (!(ringElem2 = ringElem2.sum(ringElem)).isZERO()) {
                    sortedMap.put(expVector, ringElem2);
                    continue;
                }
                sortedMap.remove(expVector);
                continue;
            }
            sortedMap.put(expVector, ringElem);
        }
        return element;
    }

    public GenPolynomial<C> sum(C c, ExpVector expVector) {
        if (c == null) {
            return this;
        }
        if (c.isZERO()) {
            return this;
        }
        Element element = this.copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        RingElem ringElem = (RingElem)sortedMap.get(expVector);
        if (ringElem != null) {
            if (!(ringElem = (RingElem)ringElem.sum(c)).isZERO()) {
                sortedMap.put(expVector, ringElem);
            } else {
                sortedMap.remove(expVector);
            }
        } else {
            sortedMap.put(expVector, c);
        }
        return element;
    }

    @Override
    public GenPolynomial<C> sum(Monomial<C> monomial) {
        return this.sum(monomial.coefficient(), monomial.exponent());
    }

    @Override
    public GenPolynomial<C> sum(C c) {
        return this.sum(c, this.ring.evzero);
    }

    public void doAddTo(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return;
        }
        if (this.isZERO()) {
            this.val.putAll(genPolynomial.val);
            return;
        }
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        SortedMap<ExpVector, C> sortedMap = this.val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial.val;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            ExpVector expVector = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)sortedMap.get(expVector);
            if (ringElem2 != null) {
                if (!(ringElem2 = ringElem2.sum(ringElem)).isZERO()) {
                    sortedMap.put(expVector, ringElem2);
                    continue;
                }
                sortedMap.remove(expVector);
                continue;
            }
            sortedMap.put(expVector, ringElem);
        }
    }

    public void doAddTo(C c, ExpVector expVector) {
        if (c == null || c.isZERO()) {
            return;
        }
        SortedMap<ExpVector, C> sortedMap = this.val;
        RingElem ringElem = (RingElem)sortedMap.get(expVector);
        if (ringElem != null) {
            if (!(ringElem = (RingElem)ringElem.sum(c)).isZERO()) {
                sortedMap.put(expVector, ringElem);
            } else {
                sortedMap.remove(expVector);
            }
        } else {
            sortedMap.put(expVector, c);
        }
    }

    public void doAddTo(C c) {
        this.doAddTo(c, this.ring.evzero);
    }

    @Override
    public GenPolynomial<C> subtract(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return this;
        }
        if (genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genPolynomial.negate();
        }
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        Element element = this.copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial.val;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            ExpVector expVector = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)sortedMap.get(expVector);
            if (ringElem2 != null) {
                if (!(ringElem2 = ringElem2.subtract(ringElem)).isZERO()) {
                    sortedMap.put(expVector, ringElem2);
                    continue;
                }
                sortedMap.remove(expVector);
                continue;
            }
            sortedMap.put(expVector, (RingElem)ringElem.negate());
        }
        return element;
    }

    public GenPolynomial<C> subtract(C c, ExpVector expVector) {
        if (c == null || c.isZERO()) {
            return this;
        }
        Element element = this.copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        RingElem ringElem = (RingElem)sortedMap.get(expVector);
        if (ringElem != null) {
            if (!(ringElem = (RingElem)ringElem.subtract(c)).isZERO()) {
                sortedMap.put(expVector, ringElem);
            } else {
                sortedMap.remove(expVector);
            }
        } else {
            sortedMap.put(expVector, (RingElem)c.negate());
        }
        return element;
    }

    @Override
    public GenPolynomial<C> subtract(Monomial<C> monomial) {
        return this.subtract(monomial.coefficient(), monomial.exponent());
    }

    @Override
    public GenPolynomial<C> subtract(C c) {
        return this.subtract(c, this.ring.evzero);
    }

    public GenPolynomial<C> subtractMultiple(C ringElem, GenPolynomial<C> genPolynomial) {
        if (ringElem == null || ringElem.isZERO()) {
            return this;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genPolynomial.multiply((RingElem)ringElem.negate());
        }
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        Element element = this.copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial.val;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            ExpVector expVector = entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector, (RingElem)ringElem2.negate());
        }
        return element;
    }

    public GenPolynomial<C> subtractMultiple(C ringElem, ExpVector expVector, GenPolynomial<C> genPolynomial) {
        if (ringElem == null || ringElem.isZERO()) {
            return this;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genPolynomial.multiply((RingElem)ringElem.negate(), expVector);
        }
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        Element element = this.copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial.val;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = entry.getKey();
            expVector2 = expVector.sum(expVector2);
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector2);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector2, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector2);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector2, (RingElem)ringElem2.negate());
        }
        return element;
    }

    public GenPolynomial<C> scaleSubtractMultiple(C c, C ringElem, GenPolynomial<C> genPolynomial) {
        if (ringElem == null || genPolynomial == null) {
            return this.multiply(c);
        }
        if (ringElem.isZERO() || genPolynomial.isZERO()) {
            return this.multiply(c);
        }
        if (this.isZERO() || c == null || c.isZERO()) {
            return genPolynomial.multiply((RingElem)ringElem.negate());
        }
        if (c.isONE()) {
            return this.subtractMultiple(ringElem, genPolynomial);
        }
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        GenPolynomial<C> genPolynomial2 = this.multiply(c);
        SortedMap<ExpVector, C> sortedMap = genPolynomial2.val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial.val;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            ExpVector expVector = entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector, (RingElem)ringElem2.negate());
        }
        return genPolynomial2;
    }

    public GenPolynomial<C> scaleSubtractMultiple(C c, C ringElem, ExpVector expVector, GenPolynomial<C> genPolynomial) {
        if (ringElem == null || genPolynomial == null) {
            return this.multiply(c);
        }
        if (ringElem.isZERO() || genPolynomial.isZERO()) {
            return this.multiply(c);
        }
        if (this.isZERO() || c == null || c.isZERO()) {
            return genPolynomial.multiply((RingElem)ringElem.negate(), expVector);
        }
        if (c.isONE()) {
            return this.subtractMultiple(ringElem, expVector, genPolynomial);
        }
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        GenPolynomial<C> genPolynomial2 = this.multiply(c);
        SortedMap<ExpVector, C> sortedMap = genPolynomial2.val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial.val;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = entry.getKey();
            expVector2 = expVector.sum(expVector2);
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector2);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector2, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector2);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector2, (RingElem)ringElem2.negate());
        }
        return genPolynomial2;
    }

    public GenPolynomial<C> scaleSubtractMultiple(C c, ExpVector expVector, C ringElem, ExpVector expVector2, GenPolynomial<C> genPolynomial) {
        if (ringElem == null || genPolynomial == null) {
            return this.multiply(c, expVector);
        }
        if (ringElem.isZERO() || genPolynomial.isZERO()) {
            return this.multiply(c, expVector);
        }
        if (this.isZERO() || c == null || c.isZERO()) {
            return genPolynomial.multiply((RingElem)ringElem.negate(), expVector2);
        }
        if (c.isONE() && expVector.isZERO()) {
            return this.subtractMultiple(ringElem, expVector2, genPolynomial);
        }
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        GenPolynomial<C> genPolynomial2 = this.multiply(c, expVector);
        SortedMap<ExpVector, C> sortedMap = genPolynomial2.val;
        SortedMap<ExpVector, C> sortedMap2 = genPolynomial.val;
        for (Map.Entry<ExpVector, C> entry : sortedMap2.entrySet()) {
            ExpVector expVector3 = entry.getKey();
            expVector3 = expVector2.sum(expVector3);
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector3);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector3, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector3);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector3, (RingElem)ringElem2.negate());
        }
        return genPolynomial2;
    }

    public GenPolynomial<C> negateAlt() {
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            sortedMap.put(entry.getKey(), (RingElem)ringElem.negate());
        }
        return element;
    }

    @Override
    public GenPolynomial<C> negate() {
        Element element = this.copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : sortedMap.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            entry.setValue((RingElem)ringElem.negate());
        }
        return element;
    }

    @Override
    public GenPolynomial<C> abs() {
        if (this.leadingBaseCoefficient().signum() < 0) {
            return this.negate();
        }
        return this;
    }

    @Override
    public GenPolynomial<C> multiply(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return this.ring.getZERO();
        }
        if (genPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        if (this instanceof GenSolvablePolynomial && genPolynomial instanceof GenSolvablePolynomial) {
            logger.debug("warn: wrong method dispatch in JRE multiply(S) - trying to fix");
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genPolynomial;
            return genSolvablePolynomial.multiply(genSolvablePolynomial2);
        }
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector = entry.getKey();
            for (Map.Entry<ExpVector, C> entry2 : genPolynomial.val.entrySet()) {
                RingElem ringElem2 = (RingElem)entry2.getValue();
                ExpVector expVector2 = entry2.getKey();
                RingElem ringElem3 = ringElem.multiply(ringElem2);
                if (ringElem3.isZERO()) continue;
                ExpVector expVector3 = expVector.sum(expVector2);
                RingElem ringElem4 = (RingElem)sortedMap.get(expVector3);
                if (ringElem4 == null) {
                    sortedMap.put(expVector3, ringElem3);
                    continue;
                }
                if (!(ringElem4 = ringElem4.sum(ringElem3)).isZERO()) {
                    sortedMap.put(expVector3, ringElem4);
                    continue;
                }
                sortedMap.remove(expVector3);
            }
        }
        return element;
    }

    @Override
    public GenPolynomial<C> multiply(C c) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (this instanceof GenSolvablePolynomial) {
            logger.debug("warn: wrong method dispatch in JRE multiply(s) - trying to fix");
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this;
            return genSolvablePolynomial.multiply((RingElem)c);
        }
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector = entry.getKey();
            RingElem ringElem2 = (RingElem)ringElem.multiply(c);
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector, ringElem2);
        }
        return element;
    }

    public GenPolynomial<C> multiplyLeft(C ringElem) {
        if (ringElem == null || ringElem.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (this instanceof GenSolvablePolynomial) {
            logger.debug("warn: wrong method dispatch in JRE multiply(s) - trying to fix");
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this;
            return genSolvablePolynomial.multiplyLeft(ringElem);
        }
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem2 = (RingElem)entry.getValue();
            ExpVector expVector = entry.getKey();
            RingElem ringElem3 = ringElem.multiply((RingElem)ringElem2);
            if (ringElem3.isZERO()) continue;
            sortedMap.put(expVector, ringElem3);
        }
        return element;
    }

    public GenPolynomial<C> monic() {
        if (this.isZERO()) {
            return this;
        }
        C c = this.leadingBaseCoefficient();
        if (!c.isUnit()) {
            return this;
        }
        RingElem ringElem = (RingElem)c.inverse();
        return this.multiplyLeft(ringElem);
    }

    public GenPolynomial<C> multiply(C c, ExpVector expVector) {
        if (c == null) {
            return this.ring.getZERO();
        }
        if (c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (expVector == null) {
            return this.ring.getZERO();
        }
        if (this instanceof GenSolvablePolynomial) {
            logger.debug("warn: wrong method dispatch in JRE multiply(s,e) - trying to fix");
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this;
            return genSolvablePolynomial.multiply((RingElem)c, expVector);
        }
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = entry.getKey();
            RingElem ringElem2 = (RingElem)ringElem.multiply(c);
            if (ringElem2.isZERO()) continue;
            ExpVector expVector3 = expVector2.sum(expVector);
            sortedMap.put(expVector3, ringElem2);
        }
        return element;
    }

    @Override
    public GenPolynomial<C> multiply(ExpVector expVector) {
        if (expVector == null) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (this instanceof GenSolvablePolynomial) {
            logger.debug("warn: wrong method dispatch in JRE multiply(e) - trying to fix");
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this;
            return genSolvablePolynomial.multiply(expVector);
        }
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = entry.getKey();
            ExpVector expVector3 = expVector2.sum(expVector);
            sortedMap.put(expVector3, ringElem);
        }
        return element;
    }

    @Override
    public GenPolynomial<C> multiply(Map.Entry<ExpVector, C> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply((RingElem)entry.getValue(), entry.getKey());
    }

    @Override
    public GenPolynomial<C> divide(C c) {
        if (c == null || c.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem;
            ExpVector expVector = entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = (RingElem)ringElem2.divide(c);
            if (debug && !(ringElem = (RingElem)ringElem2.remainder(c)).isZERO()) {
                logger.info("divide x = " + ringElem);
                throw new ArithmeticException("no exact division: " + ringElem2 + "/" + c);
            }
            if (ringElem3.isZERO()) {
                throw new ArithmeticException("no exact division: " + ringElem2 + "/" + c + ", in " + this);
            }
            sortedMap.put(expVector, ringElem3);
        }
        return element;
    }

    public GenPolynomial<C> rightDivideCoeff(C c) {
        if (c == null || c.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem;
            ExpVector expVector = entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = (RingElem)ringElem2.rightDivide(c);
            if (debug && !(ringElem = (RingElem)ringElem2.rightRemainder(c)).isZERO()) {
                logger.info("divide x = " + ringElem);
                throw new ArithmeticException("no exact division: " + ringElem2 + "/" + c);
            }
            if (ringElem3.isZERO()) {
                throw new ArithmeticException("no exact division: " + ringElem2 + "/" + c + ", in " + this);
            }
            sortedMap.put(expVector, ringElem3);
        }
        return element;
    }

    public GenPolynomial<C> leftDivideCoeff(C c) {
        if (c == null || c.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem;
            ExpVector expVector = entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = (RingElem)ringElem2.leftDivide(c);
            if (debug && !(ringElem = (RingElem)ringElem2.leftRemainder(c)).isZERO()) {
                logger.info("divide x = " + ringElem);
                throw new ArithmeticException("no exact division: " + ringElem2 + "/" + c);
            }
            if (ringElem3.isZERO()) {
                throw new ArithmeticException("no exact division: " + ringElem2 + "/" + c + ", in " + this);
            }
            sortedMap.put(expVector, ringElem3);
        }
        return element;
    }

    public GenPolynomial<C>[] quotientRemainder(GenPolynomial<C> genPolynomial) {
        GenPolynomial[] genPolynomialArray;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        C c = genPolynomial.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbcf not invertible " + c);
        }
        RingElem ringElem = (RingElem)c.inverse();
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        ExpVector expVector = genPolynomial.leadingExpVector();
        GenPolynomial<C> genPolynomial2 = ((GenPolynomial)this.ring.getZERO()).copy();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial3 = this.copy();
        while (!genPolynomial3.isZERO() && (genPolynomialArray = genPolynomial3.leadingExpVector()).multipleOf(expVector)) {
            RingElem ringElem2 = genPolynomial3.leadingBaseCoefficient();
            ExpVector expVector2 = genPolynomialArray.subtract(expVector);
            ringElem2 = ringElem2.multiply((RingElem)ringElem);
            genPolynomial2 = genPolynomial2.sum(ringElem2, expVector2);
            GenPolynomial<C> genPolynomial4 = genPolynomial.multiply(ringElem2, expVector2);
            genPolynomial3 = genPolynomial3.subtract((GenPolynomial<GenPolynomial<C>>)genPolynomial4);
            assert (!genPolynomialArray.equals(genPolynomial3.leadingExpVector())) : "leadingExpVector not descending: " + (ExpVector)genPolynomialArray;
        }
        genPolynomialArray = new GenPolynomial[]{genPolynomial2, genPolynomial3};
        return genPolynomialArray;
    }

    @Override
    public GenPolynomial<C> divide(GenPolynomial<C> genPolynomial) {
        if (this instanceof GenSolvablePolynomial || genPolynomial instanceof GenSolvablePolynomial) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genPolynomial;
            return genSolvablePolynomial.quotientRemainder(genSolvablePolynomial2)[0];
        }
        return this.quotientRemainder(genPolynomial)[0];
    }

    @Override
    public GenPolynomial<C> remainder(GenPolynomial<C> genPolynomial) {
        ExpVector expVector;
        if (this instanceof GenSolvablePolynomial || genPolynomial instanceof GenSolvablePolynomial) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)this;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genPolynomial;
            return genSolvablePolynomial.quotientRemainder(genSolvablePolynomial2)[1];
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        C c = genPolynomial.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbc not invertible " + c);
        }
        RingElem ringElem = (RingElem)c.inverse();
        assert (this.ring.nvar == genPolynomial.ring.nvar);
        ExpVector expVector2 = genPolynomial.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = this.copy();
        while (!genPolynomial2.isZERO() && (expVector = genPolynomial2.leadingExpVector()).multipleOf(expVector2)) {
            RingElem ringElem2 = genPolynomial2.leadingBaseCoefficient();
            ExpVector expVector3 = expVector.subtract(expVector2);
            ringElem2 = ringElem2.multiply((RingElem)ringElem);
            GenPolynomial<C> genPolynomial3 = genPolynomial.multiply(ringElem2, expVector3);
            genPolynomial2 = genPolynomial2.subtract((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
            assert (!expVector.equals(genPolynomial2.leadingExpVector())) : "leadingExpVector not descending: " + expVector;
        }
        return genPolynomial2;
    }

    @Override
    public GenPolynomial<C> gcd(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genPolynomial;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException("not univariate polynomials" + this.ring);
        }
        GenPolynomial<C> genPolynomial2 = this;
        GenPolynomial<C> genPolynomial3 = genPolynomial;
        while (!genPolynomial3.isZERO()) {
            GenPolynomial<C> genPolynomial4 = genPolynomial2.remainder(genPolynomial3);
            genPolynomial2 = genPolynomial3;
            genPolynomial3 = genPolynomial4;
        }
        return genPolynomial2.monic();
    }

    public GenPolynomial<C>[] egcd(GenPolynomial<C> genPolynomial) {
        GenPolynomial[] genPolynomialArray = new GenPolynomial[]{null, null, null};
        if (genPolynomial == null || genPolynomial.isZERO()) {
            genPolynomialArray[0] = this;
            genPolynomialArray[1] = this.ring.getONE();
            genPolynomialArray[2] = this.ring.getZERO();
            return genPolynomialArray;
        }
        if (this.isZERO()) {
            genPolynomialArray[0] = genPolynomial;
            genPolynomialArray[1] = this.ring.getZERO();
            genPolynomialArray[2] = this.ring.getONE();
            return genPolynomialArray;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomials" + this.ring);
        }
        if (this.isConstant() && genPolynomial.isConstant()) {
            C c = this.leadingBaseCoefficient();
            C c2 = genPolynomial.leadingBaseCoefficient();
            RingElem[] ringElemArray = c.egcd(c2);
            AbelianGroupElem abelianGroupElem = this.ring.getZERO();
            genPolynomialArray[0] = ((GenPolynomial)abelianGroupElem).sum((C)ringElemArray[0]);
            genPolynomialArray[1] = ((GenPolynomial)abelianGroupElem).sum((C)ringElemArray[1]);
            genPolynomialArray[2] = ((GenPolynomial)abelianGroupElem).sum((C)ringElemArray[2]);
            return genPolynomialArray;
        }
        GenPolynomial genPolynomial2 = this;
        GenPolynomial<C> genPolynomial3 = genPolynomial;
        GenPolynomial<RingElem<Object>> genPolynomial4 = ((GenPolynomial)this.ring.getONE()).copy();
        GenPolynomial<GenPolynomial<Element>> genPolynomial5 = ((GenPolynomial)this.ring.getZERO()).copy();
        GenPolynomial<RingElem<Object>> genPolynomial6 = ((GenPolynomial)this.ring.getZERO()).copy();
        GenPolynomial<GenPolynomial<Element>> genPolynomial7 = ((GenPolynomial)this.ring.getONE()).copy();
        while (!genPolynomial3.isZERO()) {
            GenPolynomial<C>[] genPolynomialArray2 = genPolynomial2.quotientRemainder(genPolynomial3);
            genPolynomial2 = genPolynomialArray2[0];
            GenPolynomial<GenPolynomial<Element>> genPolynomial8 = genPolynomial4.subtract((RingElem<Object>)genPolynomial2.multiply((C)genPolynomial5));
            GenPolynomial<GenPolynomial<Element>> genPolynomial9 = genPolynomial6.subtract((RingElem<Object>)genPolynomial2.multiply((C)genPolynomial7));
            genPolynomial4 = genPolynomial5;
            genPolynomial6 = genPolynomial7;
            genPolynomial5 = genPolynomial8;
            genPolynomial7 = genPolynomial9;
            genPolynomial2 = genPolynomial3;
            genPolynomial3 = genPolynomialArray2[1];
        }
        C c = genPolynomial2.leadingBaseCoefficient();
        if (c.isUnit()) {
            RingElem ringElem = (RingElem)c.inverse();
            genPolynomial2 = genPolynomial2.multiply((C)ringElem);
            genPolynomial4 = genPolynomial4.multiply(ringElem);
            genPolynomial6 = genPolynomial6.multiply(ringElem);
        }
        genPolynomialArray[0] = genPolynomial2;
        genPolynomialArray[1] = genPolynomial4;
        genPolynomialArray[2] = genPolynomial6;
        return genPolynomialArray;
    }

    public GenPolynomial<C>[] hegcd(GenPolynomial<C> genPolynomial) {
        GenPolynomial[] genPolynomialArray = new GenPolynomial[]{null, null};
        if (genPolynomial == null || genPolynomial.isZERO()) {
            genPolynomialArray[0] = this;
            genPolynomialArray[1] = this.ring.getONE();
            return genPolynomialArray;
        }
        if (this.isZERO()) {
            genPolynomialArray[0] = genPolynomial;
            return genPolynomialArray;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomials" + this.ring);
        }
        GenPolynomial<RingElem> genPolynomial2 = this;
        GenPolynomial<C> genPolynomial3 = genPolynomial;
        GenPolynomial<RingElem> genPolynomial4 = ((GenPolynomial)this.ring.getONE()).copy();
        GenPolynomial<GenPolynomial<Element>> genPolynomial5 = ((GenPolynomial)this.ring.getZERO()).copy();
        while (!genPolynomial3.isZERO()) {
            GenPolynomial<C>[] genPolynomialArray2 = genPolynomial2.quotientRemainder(genPolynomial3);
            genPolynomial2 = genPolynomialArray2[0];
            GenPolynomial<GenPolynomial<Element>> genPolynomial6 = genPolynomial4.subtract(genPolynomial2.multiply(genPolynomial5));
            genPolynomial4 = genPolynomial5;
            genPolynomial5 = genPolynomial6;
            genPolynomial2 = genPolynomial3;
            genPolynomial3 = genPolynomialArray2[1];
        }
        C c = genPolynomial2.leadingBaseCoefficient();
        if (c.isUnit()) {
            RingElem ringElem = (RingElem)c.inverse();
            genPolynomial2 = genPolynomial2.multiply(ringElem);
            genPolynomial4 = genPolynomial4.multiply(ringElem);
        }
        genPolynomialArray[0] = genPolynomial2;
        genPolynomialArray[1] = genPolynomial4;
        return genPolynomialArray;
    }

    @Override
    public GenPolynomial<C> inverse() {
        if (this.isUnit()) {
            RingElem ringElem = (RingElem)this.leadingBaseCoefficient().inverse();
            return ((GenPolynomial)this.ring.getONE()).multiply((C)ringElem);
        }
        throw new NotInvertibleException("element not invertible " + this + " :: " + this.ring);
    }

    public GenPolynomial<C> modInverse(GenPolynomial<C> genPolynomial) {
        if (this.isZERO()) {
            throw new NotInvertibleException("zero is not invertible");
        }
        GenPolynomial<C>[] genPolynomialArray = this.hegcd(genPolynomial);
        GenPolynomial<C> genPolynomial2 = genPolynomialArray[0];
        if (!genPolynomial2.isUnit()) {
            throw new AlgebraicNotInvertibleException("element not invertible, gcd != 1", genPolynomial, genPolynomial2, genPolynomial.divide(genPolynomial2));
        }
        GenPolynomial<C> genPolynomial3 = genPolynomialArray[1];
        if (genPolynomial3.isZERO()) {
            throw new NotInvertibleException("element not invertible, divisible by modul");
        }
        return genPolynomial3;
    }

    public GenPolynomial<C> extend(GenPolynomialRing<C> genPolynomialRing, int n, long l) {
        if (this.ring.equals(genPolynomialRing)) {
            return this;
        }
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (this.isZERO()) {
            return element;
        }
        int n2 = genPolynomialRing.nvar - this.ring.nvar;
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = expVector.extend(n2, n, l);
            sortedMap.put(expVector2, ringElem);
        }
        return element;
    }

    public GenPolynomial<C> extendLower(GenPolynomialRing<C> genPolynomialRing, int n, long l) {
        if (this.ring.equals(genPolynomialRing)) {
            return this;
        }
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (this.isZERO()) {
            return element;
        }
        int n2 = genPolynomialRing.nvar - this.ring.nvar;
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = expVector.extendLower(n2, n, l);
            sortedMap.put(expVector2, ringElem);
        }
        return element;
    }

    public Map<ExpVector, GenPolynomial<C>> contract(GenPolynomialRing<C> genPolynomialRing) {
        AbelianGroupElem abelianGroupElem = genPolynomialRing.getZERO();
        TermOrder termOrder = new TermOrder(2);
        TreeMap<ExpVector, GenPolynomial<C>> treeMap = new TreeMap<ExpVector, GenPolynomial<C>>(termOrder.getAscendComparator());
        if (this.isZERO()) {
            return treeMap;
        }
        int n = this.ring.nvar - genPolynomialRing.nvar;
        SortedMap<ExpVector, C> sortedMap = this.val;
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = expVector.contract(0, n);
            ExpVector expVector3 = expVector.contract(n, expVector.length() - n);
            GenPolynomial genPolynomial = (GenPolynomial)treeMap.get(expVector2);
            if (genPolynomial == null) {
                genPolynomial = abelianGroupElem;
            }
            genPolynomial = genPolynomial.sum(ringElem, expVector3);
            treeMap.put(expVector2, genPolynomial);
        }
        return treeMap;
    }

    public GenPolynomial<C> contractCoeff(GenPolynomialRing<C> genPolynomialRing) {
        Map<ExpVector, GenPolynomial<C>> map = this.contract(genPolynomialRing);
        GenPolynomial<C> genPolynomial = genPolynomialRing.getZERO();
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : map.entrySet()) {
            if (entry.getKey().isZERO()) {
                genPolynomial = entry.getValue();
                continue;
            }
            throw new RuntimeException("wrong coefficient contraction " + entry + ", pol =  " + genPolynomial);
        }
        return genPolynomial;
    }

    public GenPolynomial<C> extendUnivariate(GenPolynomialRing<C> genPolynomialRing, int n) {
        if (n < 0 || genPolynomialRing.nvar < n) {
            throw new IllegalArgumentException("index " + n + "out of range " + genPolynomialRing.nvar);
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException("polynomial not univariate " + this.ring.nvar);
        }
        if (this.isONE()) {
            return genPolynomialRing.getONE();
        }
        int n2 = genPolynomialRing.nvar - 1 - n;
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (this.isZERO()) {
            return element;
        }
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            long l = expVector.getVal(0);
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = ExpVector.create(genPolynomialRing.nvar, n2, l);
            sortedMap.put(expVector2, ringElem);
        }
        return element;
    }

    public GenPolynomial<C> homogenize(GenPolynomialRing<C> genPolynomialRing) {
        if (this.ring.equals(genPolynomialRing)) {
            throw new UnsupportedOperationException("case with same ring not implemented");
        }
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (this.isZERO()) {
            return element;
        }
        long l = this.totalDegree();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            long l2 = l - expVector.totalDeg();
            ExpVector expVector2 = expVector.extend(1, 0, l2);
            sortedMap.put(expVector2, ringElem);
        }
        return element;
    }

    public GenPolynomial<C> deHomogenize(GenPolynomialRing<C> genPolynomialRing) {
        if (this.ring.equals(genPolynomialRing)) {
            throw new UnsupportedOperationException("case with same ring not implemented");
        }
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (this.isZERO()) {
            return element;
        }
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = expVector.contract(1, genPolynomialRing.nvar);
            sortedMap.put(expVector2, ringElem);
        }
        return element;
    }

    public GenPolynomial<C> reverse(GenPolynomialRing<C> genPolynomialRing) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (this.isZERO()) {
            return element;
        }
        int n = -1;
        if (genPolynomialRing.tord.getEvord2() != 0 && genPolynomialRing.partial) {
            n = genPolynomialRing.tord.getSplit();
        }
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            ExpVector expVector2 = n >= 0 ? expVector.reverse(n) : expVector.reverse();
            RingElem ringElem = (RingElem)entry.getValue();
            sortedMap.put(expVector2, ringElem);
        }
        return element;
    }

    public GenPolynomial<C> inflate(long l) {
        if (l == 1L) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        if (this.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomial" + this.ring);
        }
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        SortedMap<ExpVector, C> sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            ExpVector expVector2 = expVector.scalarMultiply(l);
            RingElem ringElem = (RingElem)entry.getValue();
            sortedMap.put(expVector2, ringElem);
        }
        return element;
    }

    public Iterator<C> coefficientIterator() {
        return this.val.values().iterator();
    }

    public Iterator<ExpVector> exponentIterator() {
        return this.val.keySet().iterator();
    }

    @Override
    public Iterator<Monomial<C>> iterator() {
        return new PolyIterator<C>(this.val);
    }

    @Override
    public Spliterator<Monomial<C>> spliterator() {
        return new PolySpliterator<C>(this.val);
    }

    public GenPolynomial<C> map(UnaryFunctor<? super C, C> unaryFunctor) {
        Element element = ((GenPolynomial)this.ring.getZERO()).copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)unaryFunctor.eval((Element)entry.getValue());
            if (ringElem == null || ringElem.isZERO()) continue;
            sortedMap.put(entry.getKey(), ringElem);
        }
        return element;
    }

    GenPolynomial<C> mapWrong(UnaryFunctor<? super C, C> unaryFunctor) {
        Element element = this.copy();
        SortedMap<ExpVector, C> sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : sortedMap.entrySet()) {
            RingElem ringElem = (RingElem)unaryFunctor.eval((Element)entry.getValue());
            if (ringElem == null || ringElem.isZERO()) continue;
            entry.setValue(ringElem);
        }
        return element;
    }

    public GenPolynomial<C> mapOnStream(Function<? super Map.Entry<ExpVector, C>, ? extends Map.Entry<ExpVector, C>> function) {
        return this.mapOnStream(function, false);
    }

    public GenPolynomial<C> mapOnStream(Function<? super Map.Entry<ExpVector, C>, ? extends Map.Entry<ExpVector, C>> function, boolean bl) {
        Stream stream = bl ? this.val.entrySet().parallelStream() : this.val.entrySet().stream();
        Map<ExpVector, RingElem> map = stream.map(function).filter(entry -> !((RingElem)entry.getValue()).isZERO()).collect(Collectors.toMap(entry -> (ExpVector)entry.getKey(), entry -> (RingElem)entry.getValue()));
        return new GenPolynomial<RingElem>(this.ring, map);
    }

    public long bitLength() {
        if (this.blen < 0L) {
            long l = 0L;
            for (Monomial<C> monomial : this) {
                l += monomial.e.bitLength();
                try {
                    Method method = monomial.c.getClass().getMethod("bitLength", null);
                    l += ((Long)method.invoke(monomial.c, (Object[])null)).longValue();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    logger.error("Exception, class: " + monomial.c.getClass());
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    logger.error("Exception, class: " + monomial.c.getClass());
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.error("Exception, class: " + monomial.c.getClass());
                    throw new RuntimeException(invocationTargetException);
                }
            }
            this.blen = l;
        }
        return this.blen;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.blen = -1L;
        this.hash = -1;
    }
}

