/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PreemptingException;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.Word;
import edu.jas.poly.WordFactory;
import edu.jas.poly.WordMonomial;
import edu.jas.poly.WordPolyIterator;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import edu.jas.structure.UnaryFunctor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GenWordPolynomial<C extends RingElem<C>>
implements RingElem<GenWordPolynomial<C>>,
Iterable<WordMonomial<C>> {
    public final GenWordPolynomialRing<C> ring;
    final SortedMap<Word, C> val;
    private static final Logger logger = LogManager.getLogger(GenWordPolynomial.class);
    private static final boolean debug = logger.isDebugEnabled();

    private GenWordPolynomial(GenWordPolynomialRing<C> genWordPolynomialRing, TreeMap<Word, C> treeMap) {
        this.ring = genWordPolynomialRing;
        this.val = treeMap;
        if (this.ring.checkPreempt && Thread.currentThread().isInterrupted()) {
            logger.debug("throw PreemptingException");
            throw new PreemptingException();
        }
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> genWordPolynomialRing) {
        this(genWordPolynomialRing, (C)new TreeMap(genWordPolynomialRing.alphabet.getDescendComparator()));
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> genWordPolynomialRing, C c, Word word) {
        this(genWordPolynomialRing);
        if (!c.isZERO()) {
            this.val.put(word, c);
        }
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> genWordPolynomialRing, C c) {
        this(genWordPolynomialRing, c, genWordPolynomialRing.wone);
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> genWordPolynomialRing, Word word) {
        this(genWordPolynomialRing, (RingElem)genWordPolynomialRing.coFac.getONE(), word);
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> genWordPolynomialRing, ExpVector expVector) {
        this(genWordPolynomialRing, (RingElem)genWordPolynomialRing.coFac.getONE(), genWordPolynomialRing.alphabet.valueOf(expVector));
    }

    public GenWordPolynomial(GenWordPolynomialRing<C> genWordPolynomialRing, C c, ExpVector expVector) {
        this(genWordPolynomialRing, c, genWordPolynomialRing.alphabet.valueOf(expVector));
    }

    protected GenWordPolynomial(GenWordPolynomialRing<C> genWordPolynomialRing, SortedMap<Word, C> sortedMap) {
        this(genWordPolynomialRing);
        this.val.putAll(sortedMap);
    }

    @Override
    public GenWordPolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenWordPolynomial<C> copy() {
        return new GenWordPolynomial<C>(this.ring, this.val);
    }

    public int length() {
        return this.val.size();
    }

    public SortedMap<Word, C> getMap() {
        return Collections.unmodifiableSortedMap(this.val);
    }

    public void doPutToMap(Word word, C c) {
        RingElem ringElem;
        if (debug && (ringElem = (RingElem)this.val.get(word)) != null) {
            logger.error("map entry exists " + word + " to " + ringElem + " new " + c);
        }
        if (!c.isZERO()) {
            this.val.put(word, c);
        }
    }

    public void doRemoveFromMap(Word word, C c) {
        RingElem ringElem = (RingElem)this.val.remove(word);
        if (debug) {
            if (c == null) {
                return;
            }
            if (!c.equals(ringElem)) {
                logger.error("map entry wrong " + word + " to " + c + " old " + ringElem);
            }
        }
    }

    public void doPutToMap(SortedMap<Word, C> sortedMap) {
        for (Map.Entry<Word, C> entry : sortedMap.entrySet()) {
            RingElem ringElem;
            Word word = entry.getKey();
            if (debug && (ringElem = (RingElem)this.val.get(word)) != null) {
                logger.error("map entry exists " + word + " to " + ringElem + " new " + entry.getValue());
            }
            if ((ringElem = (RingElem)entry.getValue()).isZERO()) continue;
            this.val.put(word, ringElem);
        }
    }

    public String toString() {
        if (this.isZERO()) {
            return "0";
        }
        if (this.isONE()) {
            return "1";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.val.size() > 1) {
            stringBuffer.append("( ");
        }
        boolean bl = false;
        boolean bl2 = true;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            if (bl2) {
                bl2 = false;
            } else if (ringElem.signum() < 0) {
                stringBuffer.append(" - ");
                ringElem = (RingElem)ringElem.negate();
            } else {
                stringBuffer.append(" + ");
            }
            Word word = entry.getKey();
            if (!ringElem.isONE() || word.isONE()) {
                String string;
                if (bl) {
                    stringBuffer.append("( ");
                }
                if ((string = ringElem.toString()).indexOf("+") >= 0 || string.indexOf("-") >= 0) {
                    stringBuffer.append("( " + string + " )");
                } else {
                    stringBuffer.append(string);
                }
                if (bl) {
                    stringBuffer.append(" )");
                }
                if (!word.isONE()) {
                    stringBuffer.append(" ");
                }
            }
            stringBuffer.append(word.toString());
        }
        if (this.val.size() > 1) {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        if (this.isZERO()) {
            return "0";
        }
        if (this.isONE()) {
            return "1";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.val.size() > 1) {
            stringBuffer.append("( ");
        }
        boolean bl = true;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            if (bl) {
                bl = false;
            } else if (ringElem.signum() < 0) {
                stringBuffer.append(" - ");
                ringElem = (RingElem)ringElem.negate();
            } else {
                stringBuffer.append(" + ");
            }
            Word word = entry.getKey();
            if (!ringElem.isONE() || word.isONE()) {
                String string = ringElem.toScript();
                if (string.indexOf("+") >= 0 || string.indexOf("-") >= 0) {
                    stringBuffer.append("( " + string + " )");
                } else {
                    stringBuffer.append(string);
                }
                if (!word.isONE()) {
                    stringBuffer.append(" * ");
                }
            }
            stringBuffer.append(word.toScript());
        }
        if (this.val.size() > 1) {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((GenWordPolynomialRing)this.factory()).toScript();
    }

    @Override
    public boolean isZERO() {
        return this.val.size() == 0;
    }

    @Override
    public boolean isONE() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem ringElem = (RingElem)this.val.get(this.ring.wone);
        if (ringElem == null) {
            return false;
        }
        return ringElem.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem ringElem = (RingElem)this.val.get(this.ring.wone);
        if (ringElem == null) {
            return false;
        }
        return ringElem.isUnit();
    }

    public boolean isConstant() {
        if (this.val.size() != 1) {
            return false;
        }
        RingElem ringElem = (RingElem)this.val.get(this.ring.wone);
        return ringElem != null;
    }

    public boolean isHomogeneous() {
        if (this.val.size() <= 1) {
            return true;
        }
        long l = -1L;
        for (Word word : this.val.keySet()) {
            if (l < 0L) {
                l = word.degree();
                continue;
            }
            if (l == word.degree()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenWordPolynomial)) {
            return false;
        }
        GenWordPolynomial genWordPolynomial = (GenWordPolynomial)object;
        return this.compareTo(genWordPolynomial) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode() << 27;
        return n += this.val.hashCode();
    }

    @Override
    public int compareTo(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null) {
            return 1;
        }
        SortedMap<Word, C> sortedMap = this.val;
        SortedMap<Word, C> sortedMap2 = genWordPolynomial.val;
        Iterator<Map.Entry<Word, C>> iterator = sortedMap.entrySet().iterator();
        Iterator<Map.Entry<Word, C>> iterator2 = sortedMap2.entrySet().iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext() && iterator2.hasNext()) {
            Word word;
            Map.Entry<Word, C> entry = iterator.next();
            Map.Entry<Word, C> entry2 = iterator2.next();
            Word word2 = entry.getKey();
            n = word2.compareTo(word = entry2.getKey());
            if (n != 0) {
                return n;
            }
            if (n2 != 0) continue;
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)entry2.getValue();
            n2 = ringElem.compareTo(ringElem2);
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return n2;
    }

    @Override
    public int signum() {
        if (this.isZERO()) {
            return 0;
        }
        Word word = this.val.firstKey();
        RingElem ringElem = (RingElem)this.val.get(word);
        return ringElem.signum();
    }

    public int numberOfVariables() {
        return this.ring.alphabet.length();
    }

    public Map.Entry<Word, C> leadingMonomial() {
        if (this.val.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<Word, C>> iterator = this.val.entrySet().iterator();
        return iterator.next();
    }

    public Word leadingWord() {
        if (this.val.size() == 0) {
            return this.ring.wone;
        }
        return this.val.firstKey();
    }

    public Word trailingWord() {
        if (this.val.size() == 0) {
            return this.ring.wone;
        }
        return this.val.lastKey();
    }

    public C leadingBaseCoefficient() {
        if (this.val.size() == 0) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)((RingElem)this.val.get(this.val.firstKey()));
    }

    public C trailingBaseCoefficient() {
        RingElem ringElem = (RingElem)this.val.get(this.ring.wone);
        if (ringElem == null) {
            return (C)((RingElem)this.ring.coFac.getZERO());
        }
        return (C)ringElem;
    }

    public C coefficient(Word word) {
        RingElem ringElem = (RingElem)this.val.get(word);
        if (ringElem == null) {
            ringElem = (RingElem)this.ring.coFac.getZERO();
        }
        return (C)ringElem;
    }

    public GenWordPolynomial<C> reductum() {
        if (this.val.size() <= 1) {
            return this.ring.getZERO();
        }
        Iterator<Word> iterator = this.val.keySet().iterator();
        Word word = iterator.next();
        word = iterator.next();
        SortedMap<Word, C> sortedMap = this.val.tailMap(word);
        return new GenWordPolynomial<C>(this.ring, sortedMap);
    }

    public long degree() {
        if (this.val.size() == 0) {
            return 0L;
        }
        long l = 0L;
        for (Word word : this.val.keySet()) {
            long l2 = word.degree();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public C maxNorm() {
        RingElem ringElem = this.ring.getZEROCoefficient();
        for (RingElem ringElem2 : this.val.values()) {
            RingElem ringElem3 = (RingElem)ringElem2.abs();
            if (ringElem.compareTo((RingElem)ringElem3) >= 0) continue;
            ringElem = ringElem3;
        }
        return (C)ringElem;
    }

    public C sumNorm() {
        RingElem ringElem = this.ring.getZEROCoefficient();
        for (RingElem ringElem2 : this.val.values()) {
            RingElem ringElem3 = (RingElem)ringElem2.abs();
            ringElem = ringElem.sum((RingElem)ringElem3);
        }
        return (C)ringElem;
    }

    @Override
    public GenWordPolynomial<C> sum(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null) {
            return this;
        }
        if (genWordPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genWordPolynomial;
        }
        assert (this.ring.alphabet == genWordPolynomial.ring.alphabet);
        Element element = this.copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        SortedMap<Word, C> sortedMap2 = genWordPolynomial.val;
        for (Map.Entry<Word, C> entry : sortedMap2.entrySet()) {
            Word word = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)sortedMap.get(word);
            if (ringElem2 != null) {
                if (!(ringElem2 = ringElem2.sum(ringElem)).isZERO()) {
                    sortedMap.put(word, ringElem2);
                    continue;
                }
                sortedMap.remove(word);
                continue;
            }
            sortedMap.put(word, ringElem);
        }
        return element;
    }

    public GenWordPolynomial<C> sum(C c, Word word) {
        if (c == null) {
            return this;
        }
        if (c.isZERO()) {
            return this;
        }
        Element element = this.copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        RingElem ringElem = (RingElem)sortedMap.get(word);
        if (ringElem != null) {
            if (!(ringElem = (RingElem)ringElem.sum(c)).isZERO()) {
                sortedMap.put(word, ringElem);
            } else {
                sortedMap.remove(word);
            }
        } else {
            sortedMap.put(word, c);
        }
        return element;
    }

    @Override
    public GenWordPolynomial<C> sum(C c) {
        return this.sum(c, this.ring.wone);
    }

    @Override
    public GenWordPolynomial<C> subtract(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null) {
            return this;
        }
        if (genWordPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genWordPolynomial.negate();
        }
        assert (this.ring.alphabet == genWordPolynomial.ring.alphabet);
        Element element = this.copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        SortedMap<Word, C> sortedMap2 = genWordPolynomial.val;
        for (Map.Entry<Word, C> entry : sortedMap2.entrySet()) {
            Word word = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)sortedMap.get(word);
            if (ringElem2 != null) {
                if (!(ringElem2 = ringElem2.subtract(ringElem)).isZERO()) {
                    sortedMap.put(word, ringElem2);
                    continue;
                }
                sortedMap.remove(word);
                continue;
            }
            sortedMap.put(word, (RingElem)ringElem.negate());
        }
        return element;
    }

    public GenWordPolynomial<C> subtract(C c, Word word) {
        if (c == null) {
            return this;
        }
        if (c.isZERO()) {
            return this;
        }
        Element element = this.copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        RingElem ringElem = (RingElem)sortedMap.get(word);
        if (ringElem != null) {
            if (!(ringElem = (RingElem)ringElem.subtract(c)).isZERO()) {
                sortedMap.put(word, ringElem);
            } else {
                sortedMap.remove(word);
            }
        } else {
            sortedMap.put(word, (RingElem)c.negate());
        }
        return element;
    }

    @Override
    public GenWordPolynomial<C> subtract(C c) {
        return this.subtract(c, this.ring.wone);
    }

    @Override
    public GenWordPolynomial<C> negate() {
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            sortedMap.put(entry.getKey(), (RingElem)ringElem.negate());
        }
        return element;
    }

    @Override
    public GenWordPolynomial<C> abs() {
        if (this.leadingBaseCoefficient().signum() < 0) {
            return this.negate();
        }
        return this;
    }

    @Override
    public GenWordPolynomial<C> multiply(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null) {
            return this.ring.getZERO();
        }
        if (genWordPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.alphabet == genWordPolynomial.ring.alphabet) : " " + this.ring + " != " + genWordPolynomial.ring;
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            Word word = entry.getKey();
            for (Map.Entry<Word, C> entry2 : genWordPolynomial.val.entrySet()) {
                RingElem ringElem2 = (RingElem)entry2.getValue();
                Word word2 = entry2.getKey();
                RingElem ringElem3 = ringElem.multiply(ringElem2);
                if (ringElem3.isZERO()) continue;
                Word word3 = word.multiply(word2);
                RingElem ringElem4 = (RingElem)sortedMap.get(word3);
                if (ringElem4 == null) {
                    sortedMap.put(word3, ringElem3);
                    continue;
                }
                if (!(ringElem4 = ringElem4.sum(ringElem3)).isZERO()) {
                    sortedMap.put(word3, ringElem4);
                    continue;
                }
                sortedMap.remove(word3);
            }
        }
        return element;
    }

    public GenWordPolynomial<C> multiply(GenWordPolynomial<C> genWordPolynomial, GenWordPolynomial<C> genWordPolynomial2) {
        if (genWordPolynomial.isZERO() || genWordPolynomial2.isZERO()) {
            return this.ring.getZERO();
        }
        if (genWordPolynomial.isONE()) {
            return this.multiply((C)genWordPolynomial2);
        }
        if (genWordPolynomial2.isONE()) {
            return genWordPolynomial.multiply(this);
        }
        return genWordPolynomial.multiply(this).multiply(genWordPolynomial2);
    }

    @Override
    public GenWordPolynomial<C> multiply(C c) {
        if (c == null) {
            return this.ring.getZERO();
        }
        if (c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            Word word = entry.getKey();
            RingElem ringElem2 = (RingElem)ringElem.multiply(c);
            if (ringElem2.isZERO()) continue;
            sortedMap.put(word, ringElem2);
        }
        return element;
    }

    public GenWordPolynomial<C> multiply(C ringElem, C c) {
        if (ringElem == null || c == null) {
            return this.ring.getZERO();
        }
        if (ringElem.isZERO() || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem2 = (RingElem)entry.getValue();
            Word word = entry.getKey();
            RingElem ringElem3 = (RingElem)ringElem.multiply((RingElem)ringElem2).multiply(c);
            if (ringElem3.isZERO()) continue;
            sortedMap.put(word, ringElem3);
        }
        return element;
    }

    public GenWordPolynomial<C> monic() {
        if (this.isZERO()) {
            return this;
        }
        C c = this.leadingBaseCoefficient();
        if (!c.isUnit()) {
            return this;
        }
        RingElem ringElem = (RingElem)c.inverse();
        return this.multiply((C)ringElem);
    }

    public GenWordPolynomial<C> multiply(C c, Word word) {
        if (c == null) {
            return this.ring.getZERO();
        }
        if (c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            Word word2 = entry.getKey();
            RingElem ringElem2 = (RingElem)ringElem.multiply(c);
            if (ringElem2.isZERO()) continue;
            Word word3 = word2.multiply(word);
            sortedMap.put(word3, ringElem2);
        }
        return element;
    }

    public GenWordPolynomial<C> multiply(Word word, Word word2) {
        if (this.isZERO()) {
            return this;
        }
        if (word.isONE()) {
            return this.multiply(word2);
        }
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            Word word3 = entry.getKey();
            Word word4 = word.multiply(word3.multiply(word2));
            sortedMap.put(word4, ringElem);
        }
        return element;
    }

    public GenWordPolynomial<C> multiply(C c, Word word, Word word2) {
        if (c == null) {
            return this.ring.getZERO();
        }
        if (c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (word.isONE()) {
            return this.multiply(c, word2);
        }
        RingElem ringElem = (RingElem)this.ring.coFac.getONE();
        return this.multiply(ringElem, word, c, word2);
    }

    public GenWordPolynomial<C> multiply(C ringElem, Word word, C c, Word word2) {
        if (ringElem == null) {
            return this.ring.getZERO();
        }
        if (ringElem.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = (RingElem)ringElem.multiply((RingElem)ringElem2).multiply(c);
            if (ringElem3.isZERO()) continue;
            Word word3 = entry.getKey();
            Word word4 = word.multiply(word3).multiply(word2);
            sortedMap.put(word4, ringElem3);
        }
        return element;
    }

    @Override
    public GenWordPolynomial<C> multiply(Word word) {
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            Word word2 = entry.getKey();
            Word word3 = word2.multiply(word);
            sortedMap.put(word3, ringElem);
        }
        return element;
    }

    @Override
    public GenWordPolynomial<C> multiply(Map.Entry<Word, C> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply((C)((RingElem)entry.getValue()), entry.getKey());
    }

    @Override
    public GenWordPolynomial<C> divide(C c) {
        if (c == null || c.isZERO()) {
            throw new ArithmeticException(this.getClass().getName() + " division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (Map.Entry<Word, C> entry : this.val.entrySet()) {
            RingElem ringElem;
            Word word = entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = (RingElem)ringElem2.divide(c);
            if (debug && !(ringElem = (RingElem)ringElem2.remainder(c)).isZERO()) {
                logger.info("divide x = " + ringElem);
                throw new ArithmeticException(this.getClass().getName() + " no exact division: " + ringElem2 + "/" + c);
            }
            if (ringElem3.isZERO()) {
                throw new ArithmeticException(this.getClass().getName() + " no exact division: " + ringElem2 + "/" + c + ", in " + this);
            }
            sortedMap.put(word, ringElem3);
        }
        return element;
    }

    public GenWordPolynomial<C>[] quotientRemainder(GenWordPolynomial<C> genWordPolynomial) {
        GenWordPolynomial[] genWordPolynomialArray;
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            throw new ArithmeticException(this.getClass().getName() + " division by zero");
        }
        C c = genWordPolynomial.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException(this.getClass().getName() + " lbcf not invertible " + c);
        }
        RingElem ringElem = (RingElem)c.inverse();
        RingElem ringElem2 = (RingElem)this.ring.coFac.getONE();
        assert (this.ring.alphabet == genWordPolynomial.ring.alphabet);
        WordFactory.WordComparator wordComparator = this.ring.alphabet.getDescendComparator();
        Word word = genWordPolynomial.leadingWord();
        GenWordPolynomial<C> genWordPolynomial2 = ((GenWordPolynomial)this.ring.getZERO()).copy();
        GenWordPolynomial<GenWordPolynomial<RingElem>> genWordPolynomial3 = this.copy();
        while (!genWordPolynomial3.isZERO() && (genWordPolynomialArray = genWordPolynomial3.leadingWord()).multipleOf(word)) {
            RingElem ringElem3 = genWordPolynomial3.leadingBaseCoefficient();
            Word[] wordArray = genWordPolynomialArray.divideWord(word);
            ringElem3 = ringElem3.multiply((RingElem)ringElem);
            genWordPolynomial2 = genWordPolynomial2.sum(ringElem3, wordArray[0].multiply(wordArray[1]));
            GenWordPolynomial<RingElem> genWordPolynomial4 = genWordPolynomial.multiply(ringElem3, wordArray[0], ringElem2, wordArray[1]);
            Word word2 = (genWordPolynomial3 = genWordPolynomial3.subtract(genWordPolynomial4)).leadingWord();
            if (wordComparator.compare((Word)genWordPolynomialArray, word2) <= 0) continue;
            throw new RuntimeException("possible infinite loop: f = " + (Word)genWordPolynomialArray + ", fr = " + word2);
        }
        genWordPolynomialArray = new GenWordPolynomial[]{genWordPolynomial2, genWordPolynomial3};
        return genWordPolynomialArray;
    }

    @Override
    public GenWordPolynomial<C> divide(GenWordPolynomial<C> genWordPolynomial) {
        return this.quotientRemainder(genWordPolynomial)[0];
    }

    @Override
    public GenWordPolynomial<C> remainder(GenWordPolynomial<C> genWordPolynomial) {
        Word word;
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            throw new ArithmeticException(this.getClass().getName() + " division by zero");
        }
        C c = genWordPolynomial.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException(this.getClass().getName() + " lbc not invertible " + c);
        }
        RingElem ringElem = (RingElem)c.inverse();
        RingElem ringElem2 = (RingElem)this.ring.coFac.getONE();
        assert (this.ring.alphabet == genWordPolynomial.ring.alphabet);
        WordFactory.WordComparator wordComparator = this.ring.alphabet.getDescendComparator();
        Word word2 = genWordPolynomial.leadingWord();
        GenWordPolynomial<GenWordPolynomial<RingElem>> genWordPolynomial2 = this.copy();
        while (!genWordPolynomial2.isZERO() && (word = genWordPolynomial2.leadingWord()).multipleOf(word2)) {
            RingElem ringElem3 = genWordPolynomial2.leadingBaseCoefficient();
            Word[] wordArray = word.divideWord(word2);
            GenWordPolynomial<RingElem> genWordPolynomial3 = genWordPolynomial.multiply(ringElem3 = ringElem3.multiply((RingElem)ringElem), wordArray[0], ringElem2, wordArray[1]);
            Word word3 = (genWordPolynomial2 = genWordPolynomial2.subtract(genWordPolynomial3)).leadingWord();
            if (wordComparator.compare(word, word3) <= 0) continue;
            throw new RuntimeException("possible infinite loop: f = " + word + ", fr = " + word3);
        }
        return genWordPolynomial2;
    }

    @Override
    public GenWordPolynomial<C> gcd(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genWordPolynomial;
        }
        if (this.ring.alphabet.length() != 1) {
            throw new IllegalArgumentException("no univariate polynomial " + this.ring);
        }
        GenWordPolynomial<C> genWordPolynomial2 = this;
        GenWordPolynomial<C> genWordPolynomial3 = genWordPolynomial;
        while (!genWordPolynomial3.isZERO()) {
            GenWordPolynomial<C> genWordPolynomial4 = genWordPolynomial2.remainder(genWordPolynomial3);
            genWordPolynomial2 = genWordPolynomial3;
            genWordPolynomial3 = genWordPolynomial4;
        }
        return genWordPolynomial2.monic();
    }

    public GenWordPolynomial<C>[] egcd(GenWordPolynomial<C> genWordPolynomial) {
        GenWordPolynomial[] genWordPolynomialArray = new GenWordPolynomial[]{null, null, null};
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            genWordPolynomialArray[0] = this;
            genWordPolynomialArray[1] = this.ring.getONE();
            genWordPolynomialArray[2] = this.ring.getZERO();
            return genWordPolynomialArray;
        }
        if (this.isZERO()) {
            genWordPolynomialArray[0] = genWordPolynomial;
            genWordPolynomialArray[1] = this.ring.getZERO();
            genWordPolynomialArray[2] = this.ring.getONE();
            return genWordPolynomialArray;
        }
        if (this.ring.alphabet.length() != 1) {
            throw new IllegalArgumentException("no univariate polynomial " + this.ring);
        }
        if (this.isConstant() && genWordPolynomial.isConstant()) {
            C c = this.leadingBaseCoefficient();
            C c2 = genWordPolynomial.leadingBaseCoefficient();
            RingElem[] ringElemArray = c.egcd(c2);
            AbelianGroupElem abelianGroupElem = this.ring.getZERO();
            genWordPolynomialArray[0] = ((GenWordPolynomial)abelianGroupElem).sum((C)ringElemArray[0]);
            genWordPolynomialArray[1] = ((GenWordPolynomial)abelianGroupElem).sum((C)ringElemArray[1]);
            genWordPolynomialArray[2] = ((GenWordPolynomial)abelianGroupElem).sum((C)ringElemArray[2]);
            return genWordPolynomialArray;
        }
        GenWordPolynomial genWordPolynomial2 = this;
        GenWordPolynomial<C> genWordPolynomial3 = genWordPolynomial;
        GenWordPolynomial<RingElem<Object>> genWordPolynomial4 = ((GenWordPolynomial)this.ring.getONE()).copy();
        GenWordPolynomial<GenWordPolynomial<Element>> genWordPolynomial5 = ((GenWordPolynomial)this.ring.getZERO()).copy();
        GenWordPolynomial<RingElem<Object>> genWordPolynomial6 = ((GenWordPolynomial)this.ring.getZERO()).copy();
        GenWordPolynomial<GenWordPolynomial<Element>> genWordPolynomial7 = ((GenWordPolynomial)this.ring.getONE()).copy();
        while (!genWordPolynomial3.isZERO()) {
            GenWordPolynomial<C>[] genWordPolynomialArray2 = genWordPolynomial2.quotientRemainder(genWordPolynomial3);
            genWordPolynomial2 = genWordPolynomialArray2[0];
            GenWordPolynomial<GenWordPolynomial<Element>> genWordPolynomial8 = genWordPolynomial4.subtract((RingElem<Object>)genWordPolynomial2.multiply((C)genWordPolynomial5));
            GenWordPolynomial<GenWordPolynomial<Element>> genWordPolynomial9 = genWordPolynomial6.subtract((RingElem<Object>)genWordPolynomial2.multiply((C)genWordPolynomial7));
            genWordPolynomial4 = genWordPolynomial5;
            genWordPolynomial6 = genWordPolynomial7;
            genWordPolynomial5 = genWordPolynomial8;
            genWordPolynomial7 = genWordPolynomial9;
            genWordPolynomial2 = genWordPolynomial3;
            genWordPolynomial3 = genWordPolynomialArray2[1];
        }
        C c = genWordPolynomial2.leadingBaseCoefficient();
        if (c.isUnit()) {
            RingElem ringElem = (RingElem)c.inverse();
            genWordPolynomial2 = genWordPolynomial2.multiply((C)ringElem);
            genWordPolynomial4 = genWordPolynomial4.multiply(ringElem);
            genWordPolynomial6 = genWordPolynomial6.multiply(ringElem);
        }
        genWordPolynomialArray[0] = genWordPolynomial2;
        genWordPolynomialArray[1] = genWordPolynomial4;
        genWordPolynomialArray[2] = genWordPolynomial6;
        return genWordPolynomialArray;
    }

    public GenWordPolynomial<C>[] hegcd(GenWordPolynomial<C> genWordPolynomial) {
        GenWordPolynomial[] genWordPolynomialArray = new GenWordPolynomial[]{null, null};
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            genWordPolynomialArray[0] = this;
            genWordPolynomialArray[1] = this.ring.getONE();
            return genWordPolynomialArray;
        }
        if (this.isZERO()) {
            genWordPolynomialArray[0] = genWordPolynomial;
            return genWordPolynomialArray;
        }
        if (this.ring.alphabet.length() != 1) {
            throw new IllegalArgumentException("no univariate polynomial " + this.ring);
        }
        GenWordPolynomial<RingElem> genWordPolynomial2 = this;
        GenWordPolynomial<C> genWordPolynomial3 = genWordPolynomial;
        GenWordPolynomial<RingElem> genWordPolynomial4 = ((GenWordPolynomial)this.ring.getONE()).copy();
        GenWordPolynomial<GenWordPolynomial<Element>> genWordPolynomial5 = ((GenWordPolynomial)this.ring.getZERO()).copy();
        while (!genWordPolynomial3.isZERO()) {
            GenWordPolynomial<C>[] genWordPolynomialArray2 = genWordPolynomial2.quotientRemainder(genWordPolynomial3);
            genWordPolynomial2 = genWordPolynomialArray2[0];
            GenWordPolynomial<GenWordPolynomial<Element>> genWordPolynomial6 = genWordPolynomial4.subtract(genWordPolynomial2.multiply(genWordPolynomial5));
            genWordPolynomial4 = genWordPolynomial5;
            genWordPolynomial5 = genWordPolynomial6;
            genWordPolynomial2 = genWordPolynomial3;
            genWordPolynomial3 = genWordPolynomialArray2[1];
        }
        C c = genWordPolynomial2.leadingBaseCoefficient();
        if (c.isUnit()) {
            RingElem ringElem = (RingElem)c.inverse();
            genWordPolynomial2 = genWordPolynomial2.multiply(ringElem);
            genWordPolynomial4 = genWordPolynomial4.multiply(ringElem);
        }
        genWordPolynomialArray[0] = genWordPolynomial2;
        genWordPolynomialArray[1] = genWordPolynomial4;
        return genWordPolynomialArray;
    }

    @Override
    public GenWordPolynomial<C> inverse() {
        if (this.isUnit()) {
            RingElem ringElem = (RingElem)this.leadingBaseCoefficient().inverse();
            return ((GenWordPolynomial)this.ring.getONE()).multiply((C)ringElem);
        }
        throw new NotInvertibleException("element not invertible " + this + " :: " + this.ring);
    }

    public GenWordPolynomial<C> modInverse(GenWordPolynomial<C> genWordPolynomial) {
        if (this.isZERO()) {
            throw new NotInvertibleException("zero is not invertible");
        }
        GenWordPolynomial<C>[] genWordPolynomialArray = this.hegcd(genWordPolynomial);
        GenWordPolynomial<C> genWordPolynomial2 = genWordPolynomialArray[0];
        if (!genWordPolynomial2.isUnit()) {
            throw new NotInvertibleException("element not invertible, gcd != 1");
        }
        GenWordPolynomial<C> genWordPolynomial3 = genWordPolynomialArray[1];
        if (genWordPolynomial3.isZERO()) {
            throw new NotInvertibleException("element not invertible, divisible by modul");
        }
        return genWordPolynomial3;
    }

    public Iterator<C> coefficientIterator() {
        return this.val.values().iterator();
    }

    public Iterator<Word> wordIterator() {
        return this.val.keySet().iterator();
    }

    @Override
    public Iterator<WordMonomial<C>> iterator() {
        return new WordPolyIterator<C>(this.val);
    }

    public GenWordPolynomial<C> map(UnaryFunctor<? super C, C> unaryFunctor) {
        Element element = ((GenWordPolynomial)this.ring.getZERO()).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        for (WordMonomial<C> wordMonomial : this) {
            RingElem ringElem = (RingElem)unaryFunctor.eval(wordMonomial.c);
            if (ringElem == null || ringElem.isZERO()) continue;
            sortedMap.put(wordMonomial.e, ringElem);
        }
        return element;
    }

    public GenWordPolynomial<C> contract(GenWordPolynomialRing<C> genWordPolynomialRing) {
        if (genWordPolynomialRing == null) {
            throw new IllegalArgumentException("fac ring may not be null");
        }
        Element element = genWordPolynomialRing.getZERO();
        if (this.isZERO()) {
            return element;
        }
        WordFactory wordFactory = genWordPolynomialRing.alphabet;
        element = ((GenWordPolynomial)element).copy();
        SortedMap<Word, C> sortedMap = ((GenWordPolynomial)element).val;
        SortedMap<Word, C> sortedMap2 = this.val;
        for (Map.Entry<Word, C> entry : sortedMap2.entrySet()) {
            Word word = entry.getKey();
            Word word2 = wordFactory.contract(word);
            if (word2 == null) {
                return genWordPolynomialRing.getZERO();
            }
            RingElem ringElem = (RingElem)entry.getValue();
            if (sortedMap.get(word2) != null) {
                throw new RuntimeException("x != null: need sum " + sortedMap.get(word2) + " + " + ringElem);
            }
            sortedMap.put(word2, ringElem);
        }
        return element;
    }
}

