/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.OptimizedModuleList;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TermOrderOptimization {
    private static final Logger logger = LogManager.getLogger(TermOrderOptimization.class);

    public static <C extends RingElem<C>> List<GenPolynomial<BigInteger>> degreeMatrix(GenPolynomial<C> genPolynomial) {
        List<GenPolynomial<BigInteger>> list = null;
        if (genPolynomial == null) {
            return list;
        }
        BigInteger bigInteger = new BigInteger();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, new String[]{"dm"});
        int n = genPolynomial.numberOfVariables();
        list = new ArrayList<GenPolynomial<BigInteger>>(n);
        for (int i = 0; i < n; ++i) {
            list.add((GenPolynomial<BigInteger>)genPolynomialRing.getZERO());
        }
        if (genPolynomial.isZERO()) {
            return list;
        }
        for (ExpVector expVector : genPolynomial.getMap().keySet()) {
            list = TermOrderOptimization.expVectorAdd(list, expVector);
        }
        return list;
    }

    public static List<GenPolynomial<BigInteger>> expVectorAdd(List<GenPolynomial<BigInteger>> list, ExpVector expVector) {
        for (int i = 0; i < list.size() && i < expVector.length(); ++i) {
            GenPolynomial<BigInteger> genPolynomial = list.get(i);
            long l = expVector.getVal(i);
            ExpVector expVector2 = ExpVector.create(1, 0, l);
            genPolynomial = genPolynomial.sum((BigInteger)genPolynomial.ring.getONECoefficient(), expVector2);
            list.set(i, genPolynomial);
        }
        return list;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<BigInteger>> degreeMatrixOfCoefficients(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException("polynomial must not be null");
        }
        return TermOrderOptimization.degreeMatrix(genPolynomial.getMap().values());
    }

    public static <C extends RingElem<C>> List<GenPolynomial<BigInteger>> degreeMatrix(Collection<GenPolynomial<C>> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("list must be non null");
        }
        GenVectorModul genVectorModul = null;
        GenVector<GenPolynomial<BigInteger>> genVector = null;
        for (GenPolynomial<C> genPolynomial : collection) {
            List<GenPolynomial<BigInteger>> list = TermOrderOptimization.degreeMatrix(genPolynomial);
            if (genVector == null) {
                genVectorModul = new GenVectorModul(list.get((int)0).ring, list.size());
                genVector = new GenVector<GenPolynomial<BigInteger>>(genVectorModul, list);
                continue;
            }
            genVector = genVector.sum(new GenVector<GenPolynomial<BigInteger>>(genVectorModul, list));
        }
        return genVector.val;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<BigInteger>> degreeMatrixOfCoefficients(Collection<GenPolynomial<GenPolynomial<C>>> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        GenVectorModul genVectorModul = null;
        GenVector<GenPolynomial<BigInteger>> genVector = null;
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : collection) {
            List<GenPolynomial<BigInteger>> list = TermOrderOptimization.degreeMatrixOfCoefficients(genPolynomial);
            if (genVector == null) {
                genVectorModul = new GenVectorModul(list.get((int)0).ring, list.size());
                genVector = new GenVector<GenPolynomial<BigInteger>>(genVectorModul, list);
                continue;
            }
            genVector = genVector.sum(new GenVector<GenPolynomial<BigInteger>>(genVectorModul, list));
        }
        return genVector.val;
    }

    public static List<Integer> optimalPermutation(List<GenPolynomial<BigInteger>> list) {
        List list2;
        if (list == null) {
            throw new IllegalArgumentException("list must be non null");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        if (list.size() == 0) {
            return arrayList;
        }
        if (list.size() == 1) {
            arrayList.add(0);
            return arrayList;
        }
        TreeMap<GenPolynomial<BigInteger>, ArrayList<Integer>> treeMap = new TreeMap<GenPolynomial<BigInteger>, ArrayList<Integer>>();
        int n = 0;
        for (GenPolynomial<BigInteger> genPolynomial : list) {
            list2 = (ArrayList<Integer>)treeMap.get(genPolynomial);
            if (list2 == null) {
                list2 = new ArrayList<Integer>(3);
            }
            list2.add(n);
            treeMap.put(genPolynomial, (ArrayList<Integer>)list2);
            ++n;
        }
        ArrayList arrayList2 = new ArrayList(treeMap.values());
        if (logger.isDebugEnabled()) {
            logger.info("V = " + (List)arrayList2);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            list2 = (List)arrayList2.get(i);
            for (Integer n2 : list2) {
                arrayList.add(n2);
            }
        }
        return arrayList;
    }

    public static List<Integer> inversePermutation(List<Integer> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.set(list.get(i), i);
        }
        return arrayList;
    }

    public static boolean isIdentityPermutation(List<Integer> list) {
        if (list == null || list.size() <= 1) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == i) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> multiplyPermutation(List<Integer> list, List<Integer> list2) {
        if (list == null || list2 == null) {
            return null;
        }
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("#P != #S: P =" + list + ", S = " + list2);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.set(i, list2.get(list.get(i)));
        }
        return arrayList;
    }

    public static <T> List<T> listPermutation(List<Integer> list, List<T> list2) {
        if (list2 == null || list2.size() <= 1) {
            return list2;
        }
        ArrayList<T> arrayList = new ArrayList<T>(list2.size());
        for (Integer n : list) {
            arrayList.add(list2.get(n));
        }
        return arrayList;
    }

    public static <T> T[] arrayPermutation(List<Integer> list, T[] TArray) {
        if (TArray == null || TArray.length <= 1) {
            return TArray;
        }
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length);
        int n = 0;
        for (Integer n2 : list) {
            TArray2[n] = TArray[n2];
            ++n;
        }
        return TArray2;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> permutation(List<Integer> list, GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return genPolynomial;
        }
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, C> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = expVector.permutation(list);
            sortedMap.put(expVector2, ringElem);
        }
        return element;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> permutation(List<Integer> list, GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list2) {
        if (list2 == null || list2.size() == 0) {
            return list2;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list2.size());
        for (GenPolynomial<C> genPolynomial : list2) {
            GenPolynomial<C> genPolynomial2 = TermOrderOptimization.permutation(list, genPolynomialRing, genPolynomial);
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> List<GenSolvablePolynomial<C>> permutation(List<Integer> list, GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list2) {
        if (list2 == null || list2.size() == 0) {
            return list2;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list2.size());
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list2) {
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)TermOrderOptimization.permutation(list, genSolvablePolynomialRing, genSolvablePolynomial);
            arrayList.add(genSolvablePolynomial2);
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> permutationOnCoefficients(List<Integer> list, GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null) {
            return genPolynomial;
        }
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        SortedMap sortedMap = ((GenPolynomial)element).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            GenPolynomial<C> genPolynomial3 = TermOrderOptimization.permutation(list, genPolynomialRing2, genPolynomial2);
            sortedMap.put(expVector, genPolynomial3);
        }
        return element;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> permutationOnCoefficients(List<Integer> list, GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, List<GenPolynomial<GenPolynomial<C>>> list2) {
        if (list2 == null || list2.size() == 0) {
            return list2;
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>(list2.size());
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : list2) {
            GenPolynomial<GenPolynomial<C>> genPolynomial2 = TermOrderOptimization.permutationOnCoefficients(list, genPolynomialRing, genPolynomial);
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public static <C extends RingElem<C>> GenPolynomialRing<C> permutation(List<Integer> list, GenPolynomialRing<C> genPolynomialRing) {
        return genPolynomialRing.permutation(list);
    }

    public static <C extends RingElem<C>> OptimizedPolynomialList<C> optimizeTermOrder(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list) {
        Iterable iterable;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list);
        if (genPolynomialRing instanceof GenSolvablePolynomialRing) {
            iterable = (GenSolvablePolynomialRing)genPolynomialRing;
            arrayList.addAll(iterable.table.relationList());
        }
        iterable = TermOrderOptimization.optimalPermutation(TermOrderOptimization.degreeMatrix(arrayList));
        GenPolynomialRing<C> genPolynomialRing2 = genPolynomialRing.permutation((List<Integer>)iterable);
        List<GenPolynomial<C>> list2 = TermOrderOptimization.permutation((List<Integer>)iterable, genPolynomialRing2, list);
        OptimizedPolynomialList<C> optimizedPolynomialList = new OptimizedPolynomialList<C>((List<Integer>)iterable, genPolynomialRing2, list2);
        return optimizedPolynomialList;
    }

    public static <C extends RingElem<C>> OptimizedPolynomialList<C> optimizeTermOrder(PolynomialList<C> polynomialList) {
        if (polynomialList == null) {
            return null;
        }
        return TermOrderOptimization.optimizeTermOrder(polynomialList.ring, polynomialList.list);
    }

    public static <C extends RingElem<C>> OptimizedPolynomialList<GenPolynomial<C>> optimizeTermOrderOnCoefficients(PolynomialList<GenPolynomial<C>> polynomialList) {
        return TermOrderOptimization.optimizeTermOrderOnCoefficients(polynomialList.ring, polynomialList.list);
    }

    public static <C extends RingElem<C>> OptimizedPolynomialList<GenPolynomial<C>> optimizeTermOrderOnCoefficients(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, List<GenPolynomial<GenPolynomial<C>>> list) {
        GenPolynomialRing<GenPolynomial<C>> genPolynomialRing2;
        List list2;
        Iterable iterable;
        if (list == null) {
            return null;
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>(list);
        if (genPolynomialRing instanceof GenSolvablePolynomialRing) {
            iterable = (GenSolvablePolynomialRing)genPolynomialRing;
            arrayList.addAll(iterable.table.relationList());
        }
        iterable = TermOrderOptimization.optimalPermutation(TermOrderOptimization.degreeMatrixOfCoefficients(arrayList));
        GenPolynomialRing genPolynomialRing3 = (GenPolynomialRing)genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing4 = genPolynomialRing3.permutation((List<Integer>)iterable);
        if (genPolynomialRing instanceof GenSolvablePolynomialRing) {
            GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)genPolynomialRing;
            GenSolvablePolynomialRing genSolvablePolynomialRing2 = new GenSolvablePolynomialRing(genPolynomialRing4, genSolvablePolynomialRing);
            list2 = PolynomialList.castToList(genSolvablePolynomialRing.table.relationList());
            list2 = TermOrderOptimization.permutationOnCoefficients((List<Integer>)iterable, genSolvablePolynomialRing2, list2);
            genSolvablePolynomialRing2.addRelations(list2);
            genPolynomialRing2 = genSolvablePolynomialRing2;
        } else {
            genPolynomialRing2 = new GenPolynomialRing<GenPolynomial<C>>(genPolynomialRing4, genPolynomialRing);
        }
        list2 = TermOrderOptimization.permutationOnCoefficients((List<Integer>)iterable, genPolynomialRing2, list);
        OptimizedPolynomialList<GenPolynomial<C>> optimizedPolynomialList = new OptimizedPolynomialList<GenPolynomial<C>>((List<Integer>)iterable, genPolynomialRing2, list2);
        return optimizedPolynomialList;
    }

    public static <C extends RingElem<C>> OptimizedModuleList<C> optimizeTermOrder(ModuleList<C> moduleList) {
        if (moduleList == null) {
            return null;
        }
        return TermOrderOptimization.optimizeTermOrderModule(moduleList.ring, moduleList.list);
    }

    public static <C extends RingElem<C>> OptimizedModuleList<C> optimizeTermOrderModule(GenPolynomialRing<C> genPolynomialRing, List<List<GenPolynomial<C>>> list) {
        List<Integer> list2;
        Iterable<GenPolynomial<C>> iterable2;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        for (Iterable<GenPolynomial<C>> iterable2 : list) {
            arrayList.addAll((Collection<GenPolynomial<C>>)iterable2);
        }
        if (genPolynomialRing instanceof GenSolvablePolynomialRing) {
            list2 = (GenSolvablePolynomialRing)genPolynomialRing;
            arrayList.addAll(((GenSolvablePolynomialRing)((Object)list2)).table.relationList());
        }
        list2 = TermOrderOptimization.optimalPermutation(TermOrderOptimization.degreeMatrix(arrayList));
        iterable2 = genPolynomialRing.permutation(list2);
        ArrayList arrayList2 = new ArrayList();
        for (List<GenPolynomial<C>> list3 : list) {
            List<GenPolynomial<GenPolynomial<C>>> list4 = TermOrderOptimization.permutation(list2, iterable2, list3);
            arrayList2.add(list4);
        }
        OptimizedModuleList<GenPolynomial<C>> optimizedModuleList = new OptimizedModuleList<GenPolynomial<C>>(list2, iterable2, arrayList2);
        return optimizedModuleList;
    }

    public static <C extends RingElem<C>> OptimizedModuleList<GenPolynomial<C>> optimizeTermOrderOnCoefficients(ModuleList<GenPolynomial<C>> moduleList) {
        GenPolynomialRing<GenPolynomial<C>> genPolynomialRing;
        List<GenPolynomial<Object>> list;
        List<Integer> list2;
        if (moduleList == null) {
            return null;
        }
        GenPolynomialRing genPolynomialRing2 = moduleList.ring;
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        for (List iterable2 : moduleList.list) {
            arrayList.addAll(iterable2);
        }
        if (genPolynomialRing2 instanceof GenSolvablePolynomialRing) {
            list2 = (GenSolvablePolynomialRing)genPolynomialRing2;
            arrayList.addAll(((GenSolvablePolynomialRing)((Object)list2)).table.relationList());
        }
        list2 = TermOrderOptimization.optimalPermutation(TermOrderOptimization.degreeMatrixOfCoefficients(arrayList));
        GenPolynomialRing genPolynomialRing3 = (GenPolynomialRing)genPolynomialRing2.coFac;
        GenPolynomialRing genPolynomialRing4 = genPolynomialRing3.permutation(list2);
        if (genPolynomialRing2 instanceof GenSolvablePolynomialRing) {
            GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)genPolynomialRing2;
            GenSolvablePolynomialRing genSolvablePolynomialRing2 = new GenSolvablePolynomialRing(genPolynomialRing4, genSolvablePolynomialRing);
            list = PolynomialList.castToList(genSolvablePolynomialRing.table.relationList());
            list = TermOrderOptimization.permutationOnCoefficients(list2, genSolvablePolynomialRing2, list);
            genSolvablePolynomialRing2.addRelations(list);
            genPolynomialRing = genSolvablePolynomialRing2;
        } else {
            genPolynomialRing = new GenPolynomialRing<GenPolynomial<C>>(genPolynomialRing4, genPolynomialRing2);
        }
        ArrayList arrayList2 = new ArrayList();
        for (List<GenPolynomial<GenPolynomial<C>>> list3 : moduleList.list) {
            list = TermOrderOptimization.permutationOnCoefficients(list2, genPolynomialRing, list3);
            arrayList2.add(list);
        }
        OptimizedModuleList optimizedModuleList = new OptimizedModuleList(list2, genPolynomialRing, arrayList2);
        return optimizedModuleList;
    }
}

