/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Serializable;

public class Interval<C extends RingElem<C> & Rational>
implements Serializable {
    public final C left;
    public final C right;

    public Interval(C c, C c2) {
        this.left = c;
        this.right = c2;
    }

    public Interval(C c) {
        this(c, c);
    }

    public String toString() {
        return "[" + this.left + ", " + this.right + "]";
    }

    public String toScript() {
        return "[ " + this.left.toScript() + ", " + this.right.toScript() + " ]";
    }

    public Interval<C> copy() {
        return new Interval<C>(this.left, this.right);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Interval)) {
            return false;
        }
        Interval interval = null;
        try {
            interval = (Interval)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.left.equals(interval.left) && this.right.equals(interval.right);
    }

    public int hashCode() {
        return 37 * this.left.hashCode() + this.right.hashCode();
    }

    public boolean contains(C c) {
        return this.left.compareTo(c) <= 0 && c.compareTo(this.right) <= 0;
    }

    public boolean contains(Interval<C> interval) {
        return this.contains(interval.left) && this.contains(interval.right);
    }

    public C length() {
        RingElem ringElem = (RingElem)this.right.subtract(this.left);
        return (C)((RingElem)ringElem.abs());
    }

    public BigRational rationalLength() {
        return ((Rational)this.length()).getRational();
    }

    public BigDecimal toDecimal() {
        BigDecimal bigDecimal = new BigDecimal(((Rational)this.left).getRational());
        BigDecimal bigDecimal2 = new BigDecimal(((Rational)this.right).getRational());
        BigDecimal bigDecimal3 = new BigDecimal(2L);
        BigDecimal bigDecimal4 = bigDecimal.sum(bigDecimal2).divide(bigDecimal3);
        return bigDecimal4;
    }

    public BigRational rationalMiddle() {
        BigRational bigRational = ((Rational)this.left).getRational().sum(((Rational)this.right).getRational());
        BigRational bigRational2 = new BigRational(1L, 2L);
        bigRational = bigRational.multiply(bigRational2);
        return bigRational;
    }

    public C middle() {
        RingElem ringElem = (RingElem)this.left.sum(this.right);
        RingElem ringElem2 = (RingElem)this.left.factory().parse("1/2");
        ringElem = ringElem.multiply(ringElem2);
        return (C)ringElem;
    }

    public C randomPoint() {
        RingElem ringElem = (RingElem)this.right.subtract(this.left);
        RingFactory ringFactory = (RingFactory)ringElem.factory();
        RingElem ringElem2 = (RingElem)ringFactory.random(13);
        if (!(ringElem2 = (RingElem)ringElem2.abs()).isZERO() && ringElem2.compareTo((RingElem)ringFactory.getONE()) > 0) {
            ringElem2 = (RingElem)ringElem2.inverse();
        }
        ringElem = ringElem.multiply(ringElem2);
        RingElem ringElem3 = this.left.sum((RingElem)ringElem);
        return (C)ringElem3;
    }
}

