/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDProxyTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 5;
    int ll = 7;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GCDProxyTest.suite());
    }

    public GCDProxyTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDProxyTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
        ComputerThreads.terminate();
    }

    public void testBigInteger() {
        BigInteger bigInteger = new BigInteger();
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getProxy(bigInteger);
        GCDProxyTest.assertTrue((String)("ufd_par != null " + greatestCommonDivisorAbstract), (greatestCommonDivisorAbstract != null ? 1 : 0) != 0);
        GreatestCommonDivisorSubres<BigInteger> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<BigInteger>();
        GCDProxyTest.assertTrue((String)("ufd != null " + greatestCommonDivisorSubres), (greatestCommonDivisorSubres != null ? 1 : 0) != 0);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger, 4, this.to);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl + i * 10, this.ll + i, this.el, this.q);
            this.b = this.dfac.random(this.kl + i * 10, this.ll + i, this.el, this.q);
            this.c = this.dfac.random(this.kl + 2, this.ll, this.el, this.q);
            this.c = greatestCommonDivisorSubres.primitivePart(this.c).abs();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDProxyTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigInteger)((Object)this.c));
            this.b = this.b.multiply((BigInteger)((Object)this.c));
            long l = System.currentTimeMillis();
            this.d = greatestCommonDivisorAbstract.gcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            this.e = PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
            GCDProxyTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
        }
        ComputerThreads.terminate();
    }

    public void testModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GreatestCommonDivisorAbstract<ModInteger> greatestCommonDivisorAbstract = GCDFactory.getProxy(modIntegerRing);
        GCDProxyTest.assertTrue((String)("ufd_par != null " + greatestCommonDivisorAbstract), (greatestCommonDivisorAbstract != null ? 1 : 0) != 0);
        GreatestCommonDivisorSubres<ModInteger> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<ModInteger>();
        GCDProxyTest.assertTrue((String)("ufd != null " + greatestCommonDivisorSubres), (greatestCommonDivisorSubres != null ? 1 : 0) != 0);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 4, this.to);
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<AbelianGroupElem<ModInteger>> genPolynomial = genPolynomialRing.random(this.kl + i * 2, this.ll + i, this.el, this.q);
            GenPolynomial<AbelianGroupElem<ModInteger>> genPolynomial2 = genPolynomialRing.random(this.kl + i * 2, this.ll + i, this.el, this.q);
            AbelianGroupElem abelianGroupElem = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
            abelianGroupElem = greatestCommonDivisorSubres.primitivePart((GenPolynomial<ModInteger>)abelianGroupElem).abs();
            if (genPolynomial.isZERO() || genPolynomial2.isZERO() || ((GenPolynomial)abelianGroupElem).isZERO()) continue;
            GCDProxyTest.assertTrue((String)("length( c" + i + " ) <> 0"), (((GenPolynomial)abelianGroupElem).length() > 0 ? 1 : 0) != 0);
            genPolynomial = genPolynomial.multiply((ModInteger)abelianGroupElem);
            genPolynomial2 = genPolynomial2.multiply((ModInteger)abelianGroupElem);
            long l = System.currentTimeMillis();
            GenPolynomial<ModInteger> genPolynomial3 = greatestCommonDivisorAbstract.gcd(genPolynomial, genPolynomial2);
            l = System.currentTimeMillis() - l;
            GenPolynomial genPolynomial4 = PolyUtil.baseSparsePseudoRemainder(genPolynomial3, abelianGroupElem);
            GCDProxyTest.assertTrue((String)("c | gcd(ac,bc) " + genPolynomial4), (boolean)genPolynomial4.isZERO());
        }
        ComputerThreads.terminate();
    }

    public void testBigRational() {
        BigRational bigRational = new BigRational();
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigRational);
        GCDProxyTest.assertTrue((String)("ufd = Primitive " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorPrimitive));
    }

    public void testBigComplex() {
        BigComplex bigComplex = new BigComplex();
        GreatestCommonDivisorAbstract<BigComplex> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigComplex);
        GCDProxyTest.assertTrue((String)("ufd != Simple " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSimple));
    }

    public void xtestAlgebraicNumberBigRational() {
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isConstant() || genPolynomial.isZERO()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial);
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = GCDFactory.getImplementation(algebraicNumberRing);
        GCDProxyTest.assertTrue((String)("ufd = Subres " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSubres));
        genPolynomial = genPolynomialRing.univariate(0).subtract((BigRational)genPolynomialRing.getONE());
        algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial, true);
        greatestCommonDivisorAbstract = GCDFactory.getImplementation(algebraicNumberRing);
        GCDProxyTest.assertTrue((String)("ufd = Simple " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSimple));
    }

    public void testAlgebraicNumberModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isConstant() || genPolynomial.isZERO()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial);
        MonoidElem monoidElem = algebraicNumberRing.getONE();
        GCDProxyTest.assertTrue((String)("a == 1 " + (AlgebraicNumber)monoidElem), (boolean)((AlgebraicNumber)monoidElem).isONE());
        GreatestCommonDivisorAbstract<ModInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(algebraicNumberRing);
        GCDProxyTest.assertTrue((String)("ufd = Subres " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSubres));
    }
}

