/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.Combinatoric;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GreatestCommonDivisorModular<MOD extends GcdRingElem<MOD> & Modular>
extends GreatestCommonDivisorAbstract<BigInteger> {
    private static final Logger logger = LogManager.getLogger(GreatestCommonDivisorModular.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<MOD> mufd;
    protected final GreatestCommonDivisorAbstract<BigInteger> iufd = new GreatestCommonDivisorSubres<BigInteger>();

    public GreatestCommonDivisorModular() {
        this(false);
    }

    public GreatestCommonDivisorModular(boolean bl) {
        this.mufd = bl ? new GreatestCommonDivisorSimple<MOD>() : new GreatestCommonDivisorModEval();
    }

    @Override
    public GenPolynomial<BigInteger> baseGcd(GenPolynomial<BigInteger> genPolynomial, GenPolynomial<BigInteger> genPolynomial2) {
        return this.iufd.baseGcd(genPolynomial, genPolynomial2);
    }

    @Override
    public GenPolynomial<GenPolynomial<BigInteger>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<BigInteger>> genPolynomial, GenPolynomial<GenPolynomial<BigInteger>> genPolynomial2) {
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        RingFactory ringFactory = genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)ringFactory;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.getVars());
        GenPolynomial<BigInteger> genPolynomial3 = PolyUtil.distribute(genPolynomialRing3, genPolynomial);
        GenPolynomial<BigInteger> genPolynomial4 = PolyUtil.distribute(genPolynomialRing3, genPolynomial2);
        GenPolynomial<BigInteger> genPolynomial5 = this.gcd(genPolynomial3, genPolynomial4);
        GenPolynomial<GenPolynomial<BigInteger>> genPolynomial6 = PolyUtil.recursive(genPolynomialRing, genPolynomial5);
        return genPolynomial6;
    }

    @Override
    public GenPolynomial<BigInteger> gcd(GenPolynomial<BigInteger> genPolynomial, GenPolynomial<BigInteger> genPolynomial2) {
        BigInteger bigInteger;
        AbelianGroupElem<GenPolynomial<BigInteger>> abelianGroupElem;
        AbelianGroupElem<GenPolynomial<BigInteger>> abelianGroupElem2;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            GenPolynomial<BigInteger> genPolynomial3 = this.baseGcd(genPolynomial, genPolynomial2);
            return genPolynomial3;
        }
        long l = genPolynomial.degree(0);
        long l2 = genPolynomial2.degree(0);
        if (l2 > l) {
            abelianGroupElem2 = genPolynomial;
            abelianGroupElem = genPolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else {
            abelianGroupElem = genPolynomial;
            abelianGroupElem2 = genPolynomial2;
        }
        if (debug) {
            logger.debug("degrees: e = " + l + ", f = " + l2);
        }
        abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).abs();
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs();
        BigInteger bigInteger2 = this.baseContent(abelianGroupElem2);
        BigInteger bigInteger3 = this.baseContent(abelianGroupElem);
        BigInteger bigInteger4 = this.gcd(bigInteger2, bigInteger3);
        abelianGroupElem2 = this.divide(abelianGroupElem2, bigInteger2);
        abelianGroupElem = this.divide(abelianGroupElem, bigInteger3);
        if (((GenPolynomial)abelianGroupElem2).isONE()) {
            return ((GenPolynomial)abelianGroupElem2).multiply((GenPolynomial<BigInteger>)((Object)bigInteger4));
        }
        if (((GenPolynomial)abelianGroupElem).isONE()) {
            return ((GenPolynomial)abelianGroupElem).multiply((GenPolynomial<BigInteger>)((Object)bigInteger4));
        }
        BigInteger bigInteger5 = (BigInteger)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient();
        BigInteger bigInteger6 = (BigInteger)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient();
        BigInteger bigInteger7 = this.gcd(bigInteger5, bigInteger6);
        BigInteger bigInteger8 = (BigInteger)((GenPolynomial)abelianGroupElem2).maxNorm();
        BigInteger bigInteger9 = bigInteger8.compareTo(bigInteger = (BigInteger)((GenPolynomial)abelianGroupElem).maxNorm()) < 0 ? bigInteger : bigInteger8;
        bigInteger9 = bigInteger9.multiply(bigInteger7).multiply(bigInteger9.fromInteger(2L));
        ExpVector expVector = ((GenPolynomial)abelianGroupElem2).degreeVector();
        ExpVector expVector2 = ((GenPolynomial)abelianGroupElem).degreeVector();
        BigInteger bigInteger10 = bigInteger8.multiply(PolyUtil.factorBound(expVector));
        BigInteger bigInteger11 = bigInteger.multiply(PolyUtil.factorBound(expVector2));
        BigInteger bigInteger12 = bigInteger10.compareTo(bigInteger11) < 0 ? bigInteger11 : bigInteger10;
        bigInteger12 = bigInteger12.multiply(bigInteger7.multiply(bigInteger7.fromInteger(8L)));
        PrimeList primeList = new PrimeList();
        int n = 10;
        ExpVector expVector3 = expVector.subst(0, expVector.getVal(0) + 1L);
        Iterable<ModLong> iterable = null;
        GenPolynomialRing<ModLong> genPolynomialRing2 = null;
        int n2 = 0;
        BigInteger bigInteger13 = null;
        BigInteger bigInteger14 = null;
        GenPolynomial<ModLong> genPolynomial4 = null;
        GenPolynomial<ModLong> genPolynomial5 = null;
        GenPolynomial<BigInteger> genPolynomial6 = null;
        if (debug) {
            logger.debug("c = " + bigInteger4);
            logger.debug("cc = " + bigInteger7);
            logger.debug("n  = " + bigInteger9);
            logger.debug("cf = " + bigInteger12);
            logger.info("wdegv = " + expVector3 + ", in " + genPolynomialRing.toScript());
        }
        for (java.math.BigInteger bigInteger15 : primeList) {
            RingElem<Object> ringElem;
            int n3;
            GenPolynomial<ModLong> genPolynomial7;
            GenPolynomialRing<ModLong> genPolynomialRing3;
            GenPolynomial<ModLong> genPolynomial8;
            if (bigInteger15.longValue() == 2L) continue;
            if (++n2 >= n) {
                logger.warn("prime list exhausted, pn = " + n);
                return this.iufd.gcd(genPolynomial, genPolynomial2);
            }
            Iterable<ModLong> iterable2 = ModLongRing.MAX_LONG.compareTo(bigInteger15) > 0 ? new ModLongRing(bigInteger15, true) : new ModIntegerRing(bigInteger15, true);
            GcdRingElem gcdRingElem = (GcdRingElem)iterable2.fromInteger(bigInteger7.getVal());
            if (gcdRingElem.isZERO() || (genPolynomial8 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars()), abelianGroupElem)).isZERO() || !genPolynomial8.degreeVector().equals(expVector2) || (genPolynomial7 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, abelianGroupElem2)).isZERO() || !genPolynomial7.degreeVector().equals(expVector)) continue;
            if (debug) {
                logger.info("cofac = " + iterable2.getIntegerModul());
            }
            if ((genPolynomial5 = this.mufd.gcd(genPolynomial7, genPolynomial8)).isConstant()) {
                logger.debug("cm, constant = " + genPolynomial5);
                return ((GenPolynomial)genPolynomialRing.getONE()).multiply(bigInteger4);
            }
            ExpVector expVector4 = genPolynomial5.degreeVector();
            if (expVector3.equals(expVector4)) {
                if (bigInteger13 != null && bigInteger13.compareTo(bigInteger14) > 0) {
                    System.out.println("M > cfe: " + bigInteger13 + " > " + bigInteger14);
                }
            } else {
                n3 = 0;
                if (expVector3.multipleOf(expVector4)) {
                    bigInteger13 = null;
                    n3 = 1;
                }
                if (expVector4.multipleOf(expVector3)) continue;
                if (n3 == 0) {
                    bigInteger13 = null;
                    continue;
                }
            }
            genPolynomial5 = genPolynomial5.multiply((ModLong)gcdRingElem);
            if (bigInteger13 == null) {
                bigInteger13 = new BigInteger(bigInteger15);
                iterable = iterable2;
                genPolynomialRing2 = genPolynomialRing3;
                genPolynomial4 = genPolynomial5;
                expVector3 = expVector3.gcd(expVector4);
                bigInteger14 = bigInteger12;
                for (n3 = 0; n3 < expVector3.length(); ++n3) {
                    bigInteger14 = bigInteger14.multiply(new BigInteger(expVector3.getVal(n3) + 1L));
                }
            } else {
                Serializable serializable;
                BigInteger bigInteger16 = bigInteger13;
                ringElem = (GcdRingElem)iterable2.fromInteger(bigInteger16.getVal());
                ringElem = (GcdRingElem)ringElem.inverse();
                iterable = ModLongRing.MAX_LONG.compareTo((bigInteger13 = bigInteger13.multiply(new BigInteger(bigInteger15))).getVal()) > 0 ? new ModLongRing(bigInteger13.getVal()) : new ModIntegerRing(bigInteger13.getVal());
                genPolynomialRing2 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable), genPolynomialRing);
                if (!iterable2.getClass().equals(iterable.getClass())) {
                    logger.info("adjusting coefficents: cofacM = " + iterable.getClass() + ", cofacP = " + iterable2.getClass());
                    iterable2 = new ModIntegerRing(bigInteger15);
                    genPolynomialRing3 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), genPolynomialRing);
                    serializable = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial5);
                    genPolynomial5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, serializable);
                    ringElem = (GcdRingElem)iterable2.fromInteger(bigInteger16.getVal());
                    ringElem = (GcdRingElem)ringElem.inverse();
                }
                if (!genPolynomial4.ring.coFac.getClass().equals(iterable.getClass())) {
                    logger.info("adjusting coefficents: cofacM = " + iterable.getClass() + ", cofacM' = " + genPolynomial4.ring.coFac.getClass());
                    serializable = (ModularRingFactory)genPolynomial4.ring.coFac;
                    iterable2 = new ModIntegerRing(serializable.getIntegerModul().getVal());
                    genPolynomialRing3 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), genPolynomialRing);
                    GenPolynomial<BigInteger> genPolynomial9 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial4);
                    genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial9);
                }
                genPolynomial4 = PolyUtil.chineseRemainder(genPolynomialRing2, genPolynomial4, ringElem, genPolynomial5);
            }
            if (bigInteger9.compareTo(bigInteger13) <= 0) break;
            genPolynomial6 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial4);
            BigInteger bigInteger17 = genPolynomial6.sumNorm();
            bigInteger17 = bigInteger17.multiply(bigInteger17.fromInteger(4L));
            if (n2 % 2 == 0 || genPolynomial4.isZERO()) continue;
            ringElem = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial4);
            if (!PolyUtil.baseSparsePseudoRemainder(abelianGroupElem, ringElem = this.basePrimitivePart(ringElem)).isZERO() || !PolyUtil.baseSparsePseudoRemainder(abelianGroupElem2, ringElem).isZERO()) continue;
            logger.info("done on exact division, #primes = " + n2);
            break;
        }
        if (debug) {
            logger.info("done on M = " + bigInteger13 + ", #primes = " + n2);
        }
        abelianGroupElem = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial4);
        abelianGroupElem = this.basePrimitivePart(abelianGroupElem);
        return ((GenPolynomial)((GenPolynomial)abelianGroupElem).abs()).multiply(bigInteger4);
    }

    @Override
    public GenPolynomial<BigInteger> baseResultant(GenPolynomial<BigInteger> genPolynomial, GenPolynomial<BigInteger> genPolynomial2) {
        return this.resultant(genPolynomial, genPolynomial2);
    }

    @Override
    public GenPolynomial<GenPolynomial<BigInteger>> recursiveUnivariateResultant(GenPolynomial<GenPolynomial<BigInteger>> genPolynomial, GenPolynomial<GenPolynomial<BigInteger>> genPolynomial2) {
        return this.recursiveResultant(genPolynomial, genPolynomial2);
    }

    @Override
    public GenPolynomial<BigInteger> resultant(GenPolynomial<BigInteger> genPolynomial, GenPolynomial<BigInteger> genPolynomial2) {
        GenPolynomial<BigInteger> genPolynomial3;
        GenPolynomial<BigInteger> genPolynomial4;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = genPolynomial.ring;
        long l = genPolynomial.degree(0);
        long l2 = genPolynomial2.degree(0);
        if (l2 > l) {
            genPolynomial4 = genPolynomial;
            genPolynomial3 = genPolynomial2;
            long l3 = l2;
            l2 = l;
            l = l3;
        } else {
            genPolynomial3 = genPolynomial;
            genPolynomial4 = genPolynomial2;
        }
        BigInteger bigInteger = genPolynomial4.maxNorm();
        BigInteger bigInteger2 = genPolynomial3.maxNorm();
        bigInteger = (BigInteger)bigInteger.power(l2);
        bigInteger2 = (BigInteger)bigInteger2.power(l);
        BigInteger bigInteger3 = Combinatoric.factorial(l + l2);
        BigInteger bigInteger4 = bigInteger3.multiply(bigInteger).multiply(bigInteger2);
        ExpVector expVector = genPolynomial4.leadingExpVector();
        ExpVector expVector2 = genPolynomial3.leadingExpVector();
        PrimeList primeList = new PrimeList();
        int n = 30;
        Iterable<ModLong> iterable = null;
        GenPolynomialRing<ModLong> genPolynomialRing2 = null;
        int n2 = 0;
        BigInteger bigInteger5 = null;
        GenPolynomial<ModLong> genPolynomial5 = null;
        GenPolynomial<ModLong> genPolynomial6 = null;
        if (debug) {
            logger.debug("an  = " + bigInteger);
            logger.debug("bn  = " + bigInteger2);
            logger.debug("e+f = " + (l + l2));
            logger.debug("cn  = " + bigInteger3);
            logger.info("n     = " + bigInteger4);
        }
        for (java.math.BigInteger bigInteger6 : primeList) {
            if (bigInteger6.longValue() == 2L) continue;
            if (++n2 >= n) {
                logger.warn("prime list exhausted, pn = " + n);
                return this.iufd.resultant(genPolynomial, genPolynomial2);
            }
            Iterable<ModLong> iterable2 = ModLongRing.MAX_LONG.compareTo(bigInteger6) > 0 ? new ModLongRing(bigInteger6, true) : new ModIntegerRing(bigInteger6, true);
            GenPolynomialRing<ModLong> genPolynomialRing3 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), genPolynomialRing);
            GenPolynomial<ModLong> genPolynomial7 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial3);
            if (genPolynomial7.isZERO() || !genPolynomial7.leadingExpVector().equals(expVector2)) {
                if (!debug) continue;
                logger.info("unlucky prime = " + iterable2.getIntegerModul() + ", degv = " + genPolynomial7.leadingExpVector());
                continue;
            }
            GenPolynomial<ModLong> genPolynomial8 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial4);
            if (genPolynomial8.isZERO() || !genPolynomial8.leadingExpVector().equals(expVector)) {
                if (!debug) continue;
                logger.info("unlucky prime = " + iterable2.getIntegerModul() + ", degv = " + genPolynomial8.leadingExpVector());
                continue;
            }
            logger.info("lucky prime = " + iterable2.getIntegerModul());
            genPolynomial6 = this.mufd.resultant(genPolynomial7, genPolynomial8);
            if (debug) {
                logger.info("res_p = " + genPolynomial6);
            }
            if (bigInteger5 == null) {
                bigInteger5 = new BigInteger(bigInteger6);
                iterable = iterable2;
                genPolynomial5 = genPolynomial6;
            } else {
                Serializable serializable;
                BigInteger bigInteger7 = bigInteger5;
                GcdRingElem gcdRingElem = (GcdRingElem)iterable2.fromInteger(bigInteger7.getVal());
                gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
                iterable = ModLongRing.MAX_LONG.compareTo((bigInteger5 = bigInteger5.multiply(new BigInteger(bigInteger6))).getVal()) > 0 ? new ModLongRing(bigInteger5.getVal()) : new ModIntegerRing(bigInteger5.getVal());
                genPolynomialRing2 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable), genPolynomialRing);
                if (!iterable2.getClass().equals(iterable.getClass())) {
                    logger.info("adjusting coefficents: cofacM = " + iterable.getClass() + ", cofacP = " + iterable2.getClass());
                    iterable2 = new ModIntegerRing(bigInteger6);
                    genPolynomialRing3 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), genPolynomialRing);
                    serializable = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial6);
                    genPolynomial6 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, serializable);
                    gcdRingElem = (GcdRingElem)iterable2.fromInteger(bigInteger7.getVal());
                    gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
                }
                if (!genPolynomial5.ring.coFac.getClass().equals(iterable.getClass())) {
                    logger.info("adjusting coefficents: cofacM = " + iterable.getClass() + ", cofacM' = " + genPolynomial5.ring.coFac.getClass());
                    serializable = (ModularRingFactory)genPolynomial5.ring.coFac;
                    iterable2 = new ModIntegerRing(serializable.getIntegerModul().getVal());
                    genPolynomialRing3 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), genPolynomialRing);
                    GenPolynomial<BigInteger> genPolynomial9 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial5);
                    genPolynomial5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial9);
                }
                genPolynomial5 = PolyUtil.chineseRemainder(genPolynomialRing2, genPolynomial5, gcdRingElem, genPolynomial6);
            }
            if (bigInteger4.compareTo(bigInteger5) > 0) continue;
            break;
        }
        if (debug) {
            logger.info("done on M = " + bigInteger5 + ", #primes = " + n2);
        }
        genPolynomial3 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial5);
        return genPolynomial3;
    }
}

