/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SocketChannelTest
extends TestCase {
    private ChannelFactory cf;
    private SocketChannel sc1;
    private SocketChannel sc2;
    private String host;
    private int port;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SocketChannelTest.suite());
    }

    public SocketChannelTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SocketChannelTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.host = "localhost";
        this.port = 4711;
        this.cf = new ChannelFactory(this.port);
        this.cf.init();
        try {
            this.sc1 = this.cf.getChannel(this.host, this.port);
            this.sc2 = this.cf.getChannel();
        }
        catch (IOException iOException) {
            SocketChannelTest.fail((String)("IOException" + iOException));
        }
        catch (InterruptedException interruptedException) {
            SocketChannelTest.fail((String)("InterruptedException" + interruptedException));
        }
    }

    protected void tearDown() {
        this.cf.terminate();
        this.sc1.close();
        this.sc2.close();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            SocketChannelTest.fail((String)("InterruptedException" + interruptedException));
        }
    }

    public void testSocketChannel0() {
    }

    public void testSocketChannel1() {
        Integer n = 0;
        try {
            this.sc1.send(n);
            SocketChannelTest.assertEquals((Object)n, (Object)this.sc2.receive());
        }
        catch (IOException iOException) {
            SocketChannelTest.fail((String)("Exception" + iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            SocketChannelTest.fail((String)("Exception" + classNotFoundException));
        }
    }

    public void testSocketChannel2() {
        Integer n = 0;
        try {
            this.sc1.send(n);
            this.sc2.send(n);
            SocketChannelTest.assertEquals((Object)n, (Object)this.sc1.receive());
            SocketChannelTest.assertEquals((Object)n, (Object)this.sc2.receive());
        }
        catch (IOException iOException) {
            SocketChannelTest.fail((String)("Exception" + iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            SocketChannelTest.fail((String)("Exception" + classNotFoundException));
        }
    }

    public void testSocketChannel3() {
        int n = 10;
        try {
            Integer n2;
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                n2 = n3;
                this.sc1.send(n2);
            }
            for (n3 = 0; n3 < n; ++n3) {
                n2 = n3;
                SocketChannelTest.assertEquals((Object)n2, (Object)this.sc2.receive());
            }
        }
        catch (IOException iOException) {
            SocketChannelTest.fail((String)("Exception" + iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            SocketChannelTest.fail((String)("Exception" + classNotFoundException));
        }
    }
}

