/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.SocketChannel;
import edu.jas.util.TaggedSocketChannel;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TaggedSocketChannelTest
extends TestCase {
    private ChannelFactory cf;
    private SocketChannel sc1;
    private SocketChannel sc2;
    private TaggedSocketChannel tsc1;
    private TaggedSocketChannel tsc2;
    private String host;
    private int port;
    final Integer tag1 = 1;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TaggedSocketChannelTest.suite());
    }

    public TaggedSocketChannelTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(TaggedSocketChannelTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.host = "localhost";
        this.port = 4711;
        this.cf = new ChannelFactory(this.port);
        this.cf.init();
        try {
            this.sc1 = this.cf.getChannel(this.host, this.port);
            this.sc2 = this.cf.getChannel();
            this.tsc1 = new TaggedSocketChannel(this.sc1);
            this.tsc1.init();
            this.tsc2 = new TaggedSocketChannel(this.sc2);
            this.tsc2.init();
        }
        catch (IOException iOException) {
            TaggedSocketChannelTest.fail((String)("IOException" + iOException));
        }
        catch (InterruptedException interruptedException) {
            TaggedSocketChannelTest.fail((String)("InterruptedException" + interruptedException));
        }
    }

    protected void tearDown() {
        this.cf.terminate();
        this.tsc1.close();
        this.tsc2.close();
        this.sc1.close();
        this.sc2.close();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            TaggedSocketChannelTest.fail((String)("InterruptedException" + interruptedException));
        }
    }

    public void testTaggedSocketChannel0() {
    }

    public void testTaggedSocketChannel1() {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("leer");
        Integer n = -1;
        try {
            this.tsc1.send(n, illegalArgumentException);
            TaggedSocketChannelTest.fail((String)"no Exception thrown");
        }
        catch (IOException iOException) {
            TaggedSocketChannelTest.fail((String)("Exception" + iOException));
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            // empty catch block
        }
        n = null;
        try {
            this.tsc1.send(n, illegalArgumentException);
            TaggedSocketChannelTest.fail((String)"no Exception thrown");
        }
        catch (IOException iOException) {
            TaggedSocketChannelTest.fail((String)("Exception" + iOException));
        }
        catch (IllegalArgumentException illegalArgumentException3) {
            // empty catch block
        }
    }

    public void testTaggedSocketChannel2() {
        Integer n = 0;
        try {
            this.tsc1.send(this.tag1, n);
            TaggedSocketChannelTest.assertEquals((Object)n, (Object)this.tsc2.receive(this.tag1));
        }
        catch (IOException iOException) {
            TaggedSocketChannelTest.fail((String)("Exception" + iOException));
        }
        catch (InterruptedException interruptedException) {
            TaggedSocketChannelTest.fail((String)("Exception" + interruptedException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            TaggedSocketChannelTest.fail((String)("Exception" + classNotFoundException));
        }
    }

    public void testTaggedSocketChannel3() {
        Integer n = 0;
        try {
            this.tsc1.send(this.tag1, n);
            this.tsc2.send(this.tag1, n);
            TaggedSocketChannelTest.assertEquals((Object)n, (Object)this.tsc1.receive(this.tag1));
            TaggedSocketChannelTest.assertEquals((Object)n, (Object)this.tsc2.receive(this.tag1));
        }
        catch (IOException iOException) {
            TaggedSocketChannelTest.fail((String)("Exception" + iOException));
        }
        catch (InterruptedException interruptedException) {
            TaggedSocketChannelTest.fail((String)("Exception" + interruptedException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            TaggedSocketChannelTest.fail((String)("Exception" + classNotFoundException));
        }
    }

    public void testTaggedSocketChannel4() {
        int n = 10;
        try {
            Integer n2;
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                n2 = n3;
                this.tsc1.send(this.tag1, n2);
            }
            TaggedSocketChannelTest.assertEquals((String)"#tags == 0 ", (int)0, (int)this.tsc1.tagSize());
            for (n3 = 0; n3 < n; ++n3) {
                n2 = n3;
                TaggedSocketChannelTest.assertEquals((Object)n2, (Object)this.tsc2.receive(this.tag1));
            }
            TaggedSocketChannelTest.assertTrue((String)"#tags == 1 ", (this.tsc2.tagSize() == 1 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages == 0 ", (this.tsc1.messages() == 0 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages == 0 ", (this.tsc2.messages() == 0 ? 1 : 0) != 0);
        }
        catch (IOException iOException) {
            TaggedSocketChannelTest.fail((String)("Exception" + iOException));
        }
        catch (InterruptedException interruptedException) {
            TaggedSocketChannelTest.fail((String)("Exception" + interruptedException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            TaggedSocketChannelTest.fail((String)("Exception" + classNotFoundException));
        }
    }

    public void testTaggedSocketChannel5() {
        int n = 10;
        String string = "Hello_";
        try {
            Integer n2;
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                n2 = n3;
                this.tsc1.send(n2, string + n3);
            }
            TaggedSocketChannelTest.assertTrue((String)"#tags == 0 ", (this.tsc1.tagSize() == 0 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages == 0 ", (this.tsc1.messages() == 0 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages >= 0 ", (this.tsc2.messages() >= 0 ? 1 : 0) != 0);
            for (n3 = 0; n3 < n; ++n3) {
                n2 = n3;
                TaggedSocketChannelTest.assertEquals((Object)(string + n3), (Object)this.tsc2.receive(n2));
            }
            TaggedSocketChannelTest.assertTrue((String)"#tags == 10 ", (this.tsc2.tagSize() == 10 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages == 0 ", (this.tsc2.messages() <= 1 ? 1 : 0) != 0);
        }
        catch (IOException iOException) {
            TaggedSocketChannelTest.fail((String)("Exception" + iOException));
        }
        catch (InterruptedException interruptedException) {
            TaggedSocketChannelTest.fail((String)("Exception" + interruptedException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            TaggedSocketChannelTest.fail((String)("Exception" + classNotFoundException));
        }
    }
}

