/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.CoeffConvertAlg;
import edu.jas.application.CoeffRecConvertAlg;
import edu.jas.application.CoeffToComplexReal;
import edu.jas.application.ColoredSystem;
import edu.jas.application.EvaluateToComplexReal;
import edu.jas.application.GroebnerSystem;
import edu.jas.application.Ideal;
import edu.jas.application.IdealWithComplexAlgebraicRoots;
import edu.jas.application.IdealWithComplexRoots;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.IdealWithRealRoots;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PrimitiveElement;
import edu.jas.application.ReAlgFromRealCoeff;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.application.RealFromReAlgCoeff;
import edu.jas.application.Residue;
import edu.jas.application.ResidueRing;
import edu.jas.application.RootFactoryApp;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.Interval;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.RealRootTuple;
import edu.jas.root.RealRootsSturm;
import edu.jas.root.Rectangle;
import edu.jas.root.RootFactory;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.util.ListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolyUtilApp<C extends RingElem<C>> {
    private static final Logger logger = LogManager.getLogger(PolyUtilApp.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Product<Residue<C>>>> toProductRes(GenPolynomialRing<Product<Residue<C>>> genPolynomialRing, List<GenPolynomial<GenPolynomial<C>>> list) {
        ArrayList<GenPolynomial<Product<Residue<C>>>> arrayList = new ArrayList<GenPolynomial<Product<Residue<C>>>>();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : list) {
            GenPolynomial<Product<Residue<C>>> genPolynomial2 = PolyUtilApp.toProductRes(genPolynomialRing, genPolynomial);
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Product<Residue<C>>> toProductRes(GenPolynomialRing<Product<Residue<C>>> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return element;
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        ProductRing productRing = (ProductRing)ringFactory;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            Product<Residue<C>> product = PolyUtilApp.toProductRes(productRing, genPolynomial2);
            if (product.isZERO()) continue;
            ((GenPolynomial)element).doPutToMap(expVector, product);
        }
        return element;
    }

    public static <C extends GcdRingElem<C>> Product<Residue<C>> toProductRes(ProductRing<Residue<C>> productRing, GenPolynomial<C> genPolynomial) {
        TreeMap<Integer, Residue<C>> treeMap = new TreeMap<Integer, Residue<C>>();
        for (int i = 0; i < productRing.length(); ++i) {
            RingFactory<Residue<C>> ringFactory = productRing.getFactory(i);
            ResidueRing residueRing = (ResidueRing)ringFactory;
            Residue<C> residue = new Residue<C>(residueRing, genPolynomial);
            if (residue.isZERO()) continue;
            treeMap.put(i, residue);
        }
        return new Product<Residue<C>>(productRing, treeMap);
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Product<Residue<C>>>> toProductRes(List<ColoredSystem<C>> list) {
        ResidueRing residueRing;
        Ideal ideal;
        List<GenPolynomial<Product<Residue<C>>>> list2 = new ArrayList<GenPolynomial<Product<Residue<C>>>>();
        if (list == null || list.isEmpty()) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = null;
        ArrayList arrayList = new ArrayList(list.size());
        for (ColoredSystem<C> object2 : list) {
            ideal = object2.condition.zero;
            residueRing = new ResidueRing(ideal);
            if (!arrayList.contains(residueRing)) {
                arrayList.add(residueRing);
            }
            if (genPolynomialRing != null || object2.list.size() <= 0) continue;
            genPolynomialRing = object2.list.get((int)0).green.ring;
        }
        if (genPolynomialRing == null) {
            throw new IllegalArgumentException("no polynomial ring found");
        }
        ProductRing productRing = new ProductRing(arrayList);
        GenPolynomialRing<Product<Residue<C>>> genPolynomialRing2 = new GenPolynomialRing<Product<Residue<C>>>(productRing, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        ideal = new GroebnerSystem<C>(list);
        residueRing = ((GroebnerSystem)((Object)ideal)).getCGB();
        list2 = PolyUtilApp.toProductRes(genPolynomialRing2, residueRing);
        return list2;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Residue<C>>> toResidue(GenPolynomialRing<Residue<C>> genPolynomialRing, List<GenPolynomial<GenPolynomial<C>>> list) {
        ArrayList<GenPolynomial<Residue<C>>> arrayList = new ArrayList<GenPolynomial<Residue<C>>>();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : list) {
            GenPolynomial<Residue<C>> genPolynomial2 = PolyUtilApp.toResidue(genPolynomialRing, genPolynomial);
            if (genPolynomial2.isZERO()) continue;
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Residue<C>> toResidue(GenPolynomialRing<Residue<C>> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return element;
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        ResidueRing residueRing = (ResidueRing)ringFactory;
        for (Map.Entry<ExpVector, GenPolynomial<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial2 = entry.getValue();
            Residue<C> residue = new Residue<C>(residueRing, genPolynomial2);
            if (residue.isZERO()) continue;
            ((GenPolynomial)element).doPutToMap(expVector, residue);
        }
        return element;
    }

    public static <C extends GcdRingElem<C>> Map<Ideal<C>, PolynomialList<GenPolynomial<C>>> productSlice(PolynomialList<Product<Residue<C>>> polynomialList) {
        RingFactory ringFactory = polynomialList.ring.coFac;
        ProductRing productRing = (ProductRing)ringFactory;
        int n = productRing.length();
        TreeMap<Ideal<C>, PolynomialList<GenPolynomial<C>>> treeMap = new TreeMap<Ideal<C>, PolynomialList<GenPolynomial<C>>>();
        List<GenPolynomial<Product<Residue<C>>>> list = polynomialList.list;
        for (int i = 0; i < n; ++i) {
            RingFactory ringFactory2 = productRing.getFactory(i);
            ResidueRing residueRing = (ResidueRing)ringFactory2;
            Ideal ideal = residueRing.ideal;
            GenPolynomialRing genPolynomialRing = residueRing.ring;
            GenPolynomialRing<GenPolynomial<C>> genPolynomialRing2 = new GenPolynomialRing<GenPolynomial<C>>(genPolynomialRing, polynomialList.ring);
            List list2 = PolyUtilApp.fromProduct(genPolynomialRing2, list, i);
            PolynomialList<GenPolynomial<C>> polynomialList2 = new PolynomialList<GenPolynomial<C>>(genPolynomialRing2, list2);
            PolynomialList polynomialList3 = (PolynomialList)treeMap.get(ideal);
            if (polynomialList3 != null) {
                throw new RuntimeException("ideal exists twice " + ideal);
            }
            treeMap.put(ideal, polynomialList2);
        }
        return treeMap;
    }

    public static <C extends GcdRingElem<C>> PolynomialList<GenPolynomial<C>> productSlice(PolynomialList<Product<Residue<C>>> polynomialList, int n) {
        RingFactory ringFactory = polynomialList.ring.coFac;
        ProductRing productRing = (ProductRing)ringFactory;
        List<GenPolynomial<Product<Residue<C>>>> list = polynomialList.list;
        RingFactory ringFactory2 = productRing.getFactory(n);
        ResidueRing residueRing = (ResidueRing)ringFactory2;
        GenPolynomialRing genPolynomialRing = residueRing.ring;
        GenPolynomialRing<GenPolynomial<C>> genPolynomialRing2 = new GenPolynomialRing<GenPolynomial<C>>(genPolynomialRing, polynomialList.ring);
        List list2 = PolyUtilApp.fromProduct(genPolynomialRing2, list, n);
        PolynomialList<GenPolynomial<C>> polynomialList2 = new PolynomialList<GenPolynomial<C>>(genPolynomialRing2, list2);
        return polynomialList2;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<GenPolynomial<C>>> fromProduct(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, List<GenPolynomial<Product<Residue<C>>>> list, int n) {
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        for (GenPolynomial<Product<Residue<C>>> genPolynomial : list) {
            AbelianGroupElem<GenPolynomial<C>> abelianGroupElem = PolyUtilApp.fromProduct(genPolynomialRing, genPolynomial, n);
            if (abelianGroupElem.isZERO() || arrayList.contains(abelianGroupElem = abelianGroupElem.abs())) continue;
            arrayList.add((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> fromProduct(GenPolynomialRing<GenPolynomial<C>> genPolynomialRing, GenPolynomial<Product<Residue<C>>> genPolynomial, int n) {
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return element;
        }
        for (Map.Entry<ExpVector, Product<Residue<C>>> entry : genPolynomial.getMap().entrySet()) {
            GenPolynomial genPolynomial2;
            ExpVector expVector = entry.getKey();
            Product<Residue<C>> product = entry.getValue();
            Residue<C> residue = product.get(n);
            if (residue == null || residue.isZERO() || (genPolynomial2 = residue.val).isZERO()) continue;
            ((GenPolynomial)element).doPutToMap(expVector, genPolynomial2);
        }
        return element;
    }

    public static <C extends GcdRingElem<C>> String productSliceToString(Map<Ideal<C>, PolynomialList<GenPolynomial<C>>> map) {
        PolynomialList<GenPolynomial<C>> polynomialList = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<Ideal<C>, PolynomialList<GenPolynomial<C>>> entry : map.entrySet()) {
            stringBuffer.append("\n\ncondition == 0:\n");
            stringBuffer.append(entry.getKey().list.toScript());
            polynomialList = entry.getValue();
            stringBuffer.append("\ncorresponding ideal:\n");
            stringBuffer.append(polynomialList.toScript());
        }
        return stringBuffer.toString();
    }

    public static <C extends GcdRingElem<C>> String productToString(PolynomialList<Product<Residue<C>>> polynomialList) {
        Map<Ideal<C>, PolynomialList<GenPolynomial<C>>> map = PolyUtilApp.productSlice(polynomialList);
        String string = PolyUtilApp.productSliceToString(map);
        return string;
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<Complex<BigDecimal>>> complexRootTuples(Ideal<D> ideal, BigRational bigRational) {
        List<GenPolynomial<D>> list = ideal.constructUnivariate();
        if (logger.isInfoEnabled()) {
            logger.info("univs = " + list);
        }
        return PolyUtilApp.complexRoots(ideal, list, bigRational);
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<Complex<BigDecimal>>> complexRoots(Ideal<D> ideal, List<GenPolynomial<D>> list, BigRational bigRational) {
        ArrayList<List<Complex<BigDecimal>>> arrayList = new ArrayList();
        RingFactory ringFactory = ideal.list.ring.coFac;
        ComplexRing complexRing = new ComplexRing(ringFactory);
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(complexRing);
        ArrayList arrayList2 = new ArrayList();
        for (Iterable<Monomial<Object>> iterable : list) {
            GenPolynomialRing genPolynomialRing = new GenPolynomialRing(complexRing, iterable.ring);
            GenPolynomial genPolynomial = PolyUtil.toComplex(genPolynomialRing, iterable);
            arrayList2.add(genPolynomial);
        }
        for (int i = 0; i < ideal.list.ring.nvar; ++i) {
            Iterable<Monomial<Object>> iterable;
            iterable = complexRootsSturm.approximateRoots((GenPolynomial)arrayList2.get(i), bigRational);
            arrayList.add((List<Complex<BigDecimal>>)iterable);
        }
        arrayList = ListUtil.tupleFromList(arrayList);
        return arrayList;
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<Complex<BigDecimal>>> complexRootTuples(List<IdealWithUniv<D>> list, BigRational bigRational) {
        ArrayList<List<Complex<BigDecimal>>> arrayList = new ArrayList<List<Complex<BigDecimal>>>();
        for (IdealWithUniv<D> idealWithUniv : list) {
            List<List<Complex<BigDecimal>>> list2 = PolyUtilApp.complexRoots(idealWithUniv.ideal, idealWithUniv.upolys, bigRational);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithComplexRoots<D>> complexRoots(List<IdealWithUniv<D>> list, BigRational bigRational) {
        ArrayList<IdealWithComplexRoots<D>> arrayList = new ArrayList<IdealWithComplexRoots<D>>(list.size());
        for (IdealWithUniv<D> idealWithUniv : list) {
            List<List<Complex<BigDecimal>>> list2 = PolyUtilApp.complexRoots(idealWithUniv.ideal, idealWithUniv.upolys, bigRational);
            IdealWithComplexRoots<D> idealWithComplexRoots = new IdealWithComplexRoots<D>(idealWithUniv, list2);
            arrayList.add(idealWithComplexRoots);
        }
        return arrayList;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithComplexRoots<D>> complexRoots(Ideal<D> ideal, BigRational bigRational) {
        List<IdealWithUniv<D>> list = ideal.zeroDimDecomposition();
        return PolyUtilApp.complexRoots(list, bigRational);
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<BigDecimal>> realRootTuples(Ideal<D> ideal, BigRational bigRational) {
        List<GenPolynomial<D>> list = ideal.constructUnivariate();
        if (logger.isInfoEnabled()) {
            logger.info("univs = " + list);
        }
        return PolyUtilApp.realRoots(ideal, list, bigRational);
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<BigDecimal>> realRoots(Ideal<D> ideal, List<GenPolynomial<D>> list, BigRational bigRational) {
        ArrayList<List<BigDecimal>> arrayList = new ArrayList();
        RealRootsSturm<D> realRootsSturm = new RealRootsSturm<D>();
        for (int i = 0; i < ideal.list.ring.nvar; ++i) {
            List<BigDecimal> list2 = realRootsSturm.approximateRoots(list.get(i), bigRational);
            arrayList.add(list2);
        }
        arrayList = ListUtil.tupleFromList(arrayList);
        return arrayList;
    }

    public static <D extends GcdRingElem<D> & Rational> List<List<BigDecimal>> realRootTuples(List<IdealWithUniv<D>> list, BigRational bigRational) {
        ArrayList<List<BigDecimal>> arrayList = new ArrayList<List<BigDecimal>>();
        for (IdealWithUniv<D> idealWithUniv : list) {
            List<List<BigDecimal>> list2 = PolyUtilApp.realRoots(idealWithUniv.ideal, idealWithUniv.upolys, bigRational);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithRealRoots<D>> realRoots(List<IdealWithUniv<D>> list, BigRational bigRational) {
        ArrayList<IdealWithRealRoots<D>> arrayList = new ArrayList<IdealWithRealRoots<D>>(list.size());
        for (IdealWithUniv<D> idealWithUniv : list) {
            List<List<BigDecimal>> list2 = PolyUtilApp.realRoots(idealWithUniv.ideal, idealWithUniv.upolys, bigRational);
            IdealWithRealRoots<D> idealWithRealRoots = new IdealWithRealRoots<D>(idealWithUniv, list2);
            arrayList.add(idealWithRealRoots);
        }
        return arrayList;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithRealRoots<D>> realRoots(Ideal<D> ideal, BigRational bigRational) {
        List<IdealWithUniv<D>> list = ideal.zeroDimDecomposition();
        return PolyUtilApp.realRoots(list, bigRational);
    }

    public static boolean isRealRoots(List<GenPolynomial<BigDecimal>> list, List<List<BigDecimal>> list2, BigDecimal bigDecimal) {
        if (list == null || list.size() == 0) {
            return true;
        }
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        for (GenPolynomial<BigDecimal> genPolynomial : list) {
            for (List<BigDecimal> list3 : list2) {
                BigDecimal bigDecimal3 = PolyUtil.evaluateAll(bigDecimal2, genPolynomial, list3);
                if (bigDecimal3.abs().compareTo(bigDecimal) <= 0) continue;
                System.out.println("ev = " + bigDecimal3);
                return false;
            }
        }
        return true;
    }

    public static boolean isComplexRoots(List<GenPolynomial<Complex<BigDecimal>>> list, List<List<Complex<BigDecimal>>> list2, BigDecimal bigDecimal) {
        if (list == null || list.size() == 0) {
            return true;
        }
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(bigDecimal2);
        for (GenPolynomial<Complex<BigDecimal>> genPolynomial : list) {
            for (List<Complex<BigDecimal>> list3 : list2) {
                Complex<BigDecimal> complex = PolyUtil.evaluateAll(complexRing, genPolynomial, list3);
                if (((BigDecimal)((Complex)complex.norm()).getRe()).compareTo(bigDecimal) <= 0) continue;
                System.out.println("ev = " + complex);
                return false;
            }
        }
        return true;
    }

    public static <D extends GcdRingElem<D> & Rational> IdealWithRealAlgebraicRoots<D> realAlgebraicRoots(IdealWithUniv<D> idealWithUniv) {
        int[] nArray;
        ArrayList<List<edu.jas.root.RealAlgebraicNumber<Object>>> list = new ArrayList();
        if (idealWithUniv == null) {
            throw new IllegalArgumentException("null ideal not permitted");
        }
        if (idealWithUniv.ideal == null || idealWithUniv.upolys == null) {
            throw new IllegalArgumentException("null ideal components not permitted " + idealWithUniv);
        }
        if (idealWithUniv.ideal.isZERO() || idealWithUniv.upolys.size() == 0) {
            return new IdealWithRealAlgebraicRoots<D>(idealWithUniv, list);
        }
        GenPolynomialRing genPolynomialRing = idealWithUniv.ideal.list.ring;
        GenPolynomial genPolynomial = idealWithUniv.upolys.get(0);
        GenPolynomial genPolynomial2 = PolyUtil.selectWithVariable(idealWithUniv.ideal.list.list, genPolynomialRing.nvar - 1);
        if (genPolynomial2 == null) {
            throw new RuntimeException("no polynomial found in " + (genPolynomialRing.nvar - 1) + " of  " + idealWithUniv.ideal);
        }
        if (logger.isInfoEnabled()) {
            logger.info("p0p = " + genPolynomial2);
        }
        if ((nArray = genPolynomial2.degreeVector().dependencyOnVariables()).length != 1) {
            throw new RuntimeException("wrong number of variables " + Arrays.toString(nArray));
        }
        List list2 = RootFactory.realAlgebraicNumbersIrred(genPolynomial);
        if (logger.isInfoEnabled()) {
            ArrayList arrayList = new ArrayList();
            for (edu.jas.root.RealAlgebraicNumber realAlgebraicNumber : list2) {
                arrayList.add(realAlgebraicNumber.ring.getRoot());
            }
            logger.info("roots(p0) = " + (List)arrayList);
        }
        for (edu.jas.root.RealAlgebraicNumber realAlgebraicNumber : list2) {
            ArrayList<edu.jas.root.RealAlgebraicNumber> arrayList = new ArrayList<edu.jas.root.RealAlgebraicNumber>();
            arrayList.add(realAlgebraicNumber);
            list.add(arrayList);
        }
        for (int i = 1; i < idealWithUniv.upolys.size(); ++i) {
            Iterable<Object> iterable;
            GenPolynomial genPolynomial3;
            int[] nArray2;
            ArrayList<Iterable<Object>> arrayList = new ArrayList<Iterable<Object>>();
            GenPolynomial genPolynomial4 = idealWithUniv.upolys.get(i);
            GenPolynomial genPolynomial5 = PolyUtil.selectWithVariable(idealWithUniv.ideal.list.list, genPolynomialRing.nvar - 1 - i);
            if (genPolynomial5 == null) {
                throw new RuntimeException("no polynomial found in " + (genPolynomialRing.nvar - 1 - i) + " of  " + idealWithUniv.ideal);
            }
            if (logger.isInfoEnabled()) {
                logger.info("pi  = " + genPolynomial4);
                logger.info("pip = " + genPolynomial5);
            }
            if ((nArray2 = genPolynomial5.degreeVector().dependencyOnVariables()).length < 1 || nArray2.length > 2) {
                throw new RuntimeException("wrong number of variables " + Arrays.toString(nArray2));
            }
            list2 = RootFactory.realAlgebraicNumbersIrred(genPolynomial4);
            if (logger.isInfoEnabled()) {
                genPolynomial3 = new ArrayList();
                for (edu.jas.root.RealAlgebraicNumber realAlgebraicNumber : list2) {
                    genPolynomial3.add(realAlgebraicNumber.ring.getRoot());
                }
                logger.info("roots(pi) = " + genPolynomial3);
            }
            if (nArray2.length == 1) {
                for (edu.jas.root.RealAlgebraicNumber realAlgebraicNumber : list2) {
                    for (List list3 : list) {
                        iterable = new ArrayList();
                        iterable.addAll(list3);
                        iterable.add((edu.jas.root.RealAlgebraicNumber)realAlgebraicNumber);
                        arrayList.add(iterable);
                    }
                }
            } else {
                genPolynomial3 = PolyUtil.removeUnusedUpperVariables(genPolynomial5);
                GenPolynomialRing genPolynomialRing2 = genPolynomial3.ring.contract(1);
                TermOrder termOrder = new TermOrder(2);
                GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2, 1, termOrder);
                iterable = PolyUtil.recursive(genPolynomialRing3, genPolynomial3);
                int n = genPolynomialRing.nvar - 1 - nArray2[nArray2.length - 1];
                for (edu.jas.root.RealAlgebraicNumber realAlgebraicNumber : list2) {
                    Interval interval = realAlgebraicNumber.ring.getRoot();
                    GenPolynomial<GcdRingElem> genPolynomial6 = PolyUtil.evaluateMainRecursive(genPolynomialRing2, iterable, (GcdRingElem)interval.left);
                    GenPolynomial<GcdRingElem> genPolynomial7 = PolyUtil.evaluateMainRecursive(genPolynomialRing2, iterable, (GcdRingElem)interval.right);
                    GenPolynomialRing genPolynomialRing4 = idealWithUniv.upolys.get((int)n).ring;
                    GenPolynomial<GcdRingElem> genPolynomial8 = PolyUtilApp.convert(genPolynomialRing4, genPolynomial6);
                    GenPolynomial<GcdRingElem> genPolynomial9 = PolyUtilApp.convert(genPolynomialRing4, genPolynomial7);
                    for (List list4 : list) {
                        int n2;
                        edu.jas.root.RealAlgebraicRing realAlgebraicRing = ((edu.jas.root.RealAlgebraicNumber)list4.get((int)n)).ring;
                        edu.jas.root.RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber2 = new edu.jas.root.RealAlgebraicNumber<GcdRingElem>(realAlgebraicRing, genPolynomial8);
                        edu.jas.root.RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber3 = new edu.jas.root.RealAlgebraicNumber<GcdRingElem>(realAlgebraicRing, genPolynomial9);
                        int n3 = realAlgebraicNumber2.signum();
                        if (n3 * (n2 = realAlgebraicNumber3.signum()) > 0) continue;
                        ArrayList arrayList2 = new ArrayList();
                        arrayList2.addAll(list4);
                        arrayList2.add(realAlgebraicNumber);
                        arrayList.add(arrayList2);
                    }
                }
            }
            list = arrayList;
        }
        if (logger.isInfoEnabled()) {
            for (List list5 : list) {
                ArrayList arrayList = new ArrayList();
                for (edu.jas.root.RealAlgebraicNumber realAlgebraicNumber : list5) {
                    arrayList.add(realAlgebraicNumber.ring.getRoot());
                }
                logger.info("root-tuple = " + arrayList);
            }
        }
        IdealWithRealAlgebraicRoots<D> idealWithRealAlgebraicRoots = new IdealWithRealAlgebraicRoots<D>(idealWithUniv, list);
        return idealWithRealAlgebraicRoots;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithRealAlgebraicRoots<D>> realAlgebraicRoots(List<IdealWithUniv<D>> list) {
        ArrayList<IdealWithRealAlgebraicRoots<D>> arrayList = new ArrayList<IdealWithRealAlgebraicRoots<D>>(list.size());
        for (IdealWithUniv<D> idealWithUniv : list) {
            IdealWithRealAlgebraicRoots<D> idealWithRealAlgebraicRoots = PolyUtilApp.realAlgebraicRoots(idealWithUniv);
            arrayList.add(idealWithRealAlgebraicRoots);
        }
        return arrayList;
    }

    public static <D extends GcdRingElem<D> & Rational> IdealWithComplexAlgebraicRoots<D> complexAlgebraicRootsWrong(IdealWithUniv<D> idealWithUniv) {
        Iterable iterable;
        boolean bl;
        int[] nArray;
        ArrayList<List<Complex<RealAlgebraicNumber<Object>>>> serializable = new ArrayList();
        if (idealWithUniv == null) {
            throw new IllegalArgumentException("null ideal not permitted");
        }
        if (idealWithUniv.ideal == null || idealWithUniv.upolys == null) {
            throw new IllegalArgumentException("null ideal components not permitted " + idealWithUniv);
        }
        if (idealWithUniv.ideal.isZERO() || idealWithUniv.upolys.size() == 0) {
            return new IdealWithComplexAlgebraicRoots<D>(idealWithUniv, serializable);
        }
        GenPolynomialRing genPolynomialRing = idealWithUniv.ideal.list.ring;
        if (genPolynomialRing.nvar == 0) {
            return new IdealWithComplexAlgebraicRoots<D>(idealWithUniv, serializable);
        }
        if (genPolynomialRing.nvar != idealWithUniv.upolys.size()) {
            throw new IllegalArgumentException("ideal not zero dimnsional: " + idealWithUniv);
        }
        GenPolynomial genPolynomial = idealWithUniv.upolys.get(0);
        GenPolynomial genPolynomial2 = PolyUtil.selectWithVariable(idealWithUniv.ideal.list.list, genPolynomialRing.nvar - 1);
        if (genPolynomial2 == null) {
            throw new RuntimeException("no polynomial found in " + (genPolynomialRing.nvar - 1) + " of  " + idealWithUniv.ideal);
        }
        if (logger.isInfoEnabled()) {
            logger.info("p0  = " + genPolynomial);
            logger.info("p0p = " + genPolynomial2);
        }
        if ((nArray = genPolynomial2.degreeVector().dependencyOnVariables()).length != 1) {
            throw new RuntimeException("wrong number of variables " + Arrays.toString(nArray));
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        ComplexRing complexRing = new ComplexRing(ringFactory);
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(complexRing, genPolynomial.ring);
        GenPolynomial genPolynomial3 = PolyUtil.complexFromAny(genPolynomialRing2, genPolynomial);
        List list = RootFactoryApp.complexAlgebraicNumbersSquarefree(genPolynomial3);
        logger.info("#roots(p0c) = " + list.size());
        if (debug && !(bl = RootFactoryApp.isRoot(genPolynomial3, list))) {
            throw new RuntimeException("no roots of " + genPolynomial3);
        }
        for (Complex serializable2 : list) {
            iterable = new ArrayList();
            iterable.add(serializable2);
            serializable.add((List<Complex<RealAlgebraicNumber<Object>>>)iterable);
        }
        if (genPolynomialRing.nvar == 1) {
            return new IdealWithComplexAlgebraicRoots<D>(idealWithUniv, serializable);
        }
        for (int i = 1; i < idealWithUniv.upolys.size(); ++i) {
            Iterable<Object> iterable2;
            boolean bl2;
            ArrayList<Iterable<Object>> arrayList = new ArrayList<Iterable<Object>>();
            iterable = idealWithUniv.upolys.get(i);
            GenPolynomial genPolynomial4 = PolyUtil.selectWithVariable(idealWithUniv.ideal.list.list, genPolynomialRing.nvar - 1 - i);
            if (genPolynomial4 == null) {
                throw new RuntimeException("no polynomial found in " + (genPolynomialRing.nvar - 1 - i) + " of  " + idealWithUniv.ideal);
            }
            if (logger.isInfoEnabled()) {
                logger.info("pi(" + i + ") = " + iterable);
                logger.info("pip  = " + genPolynomial4);
            }
            genPolynomialRing2 = new GenPolynomialRing(complexRing, ((GenPolynomial)iterable).ring);
            GenPolynomial genPolynomial5 = PolyUtil.complexFromAny(genPolynomialRing2, iterable);
            int[] nArray2 = genPolynomial4.degreeVector().dependencyOnVariables();
            if (nArray2.length < 1 || nArray2.length > 2) {
                throw new RuntimeException("wrong number of variables " + Arrays.toString(nArray2) + " for " + genPolynomial4);
            }
            list = RootFactoryApp.complexAlgebraicNumbersSquarefree(genPolynomial5);
            logger.info("#roots(pic) = " + list.size());
            if (debug && !(bl2 = RootFactoryApp.isRoot(genPolynomial5, list))) {
                throw new RuntimeException("no roots of " + genPolynomial5);
            }
            if (nArray2.length == 1) {
                for (Complex complex : list) {
                    for (Iterable iterable3 : serializable) {
                        iterable2 = new ArrayList();
                        iterable2.addAll(iterable3);
                        iterable2.add(complex);
                        arrayList.add(iterable2);
                    }
                }
            } else {
                Iterable iterable3;
                GenPolynomial genPolynomial6 = PolyUtil.removeUnusedUpperVariables(genPolynomial4);
                GenPolynomialRing genPolynomialRing3 = genPolynomial6.ring.recursive(1);
                GenPolynomialRing genPolynomialRing4 = genPolynomial6.ring.contract(1);
                iterable3 = new GenPolynomialRing(complexRing, genPolynomialRing4);
                iterable2 = new GenPolynomialRing(complexRing, genPolynomial6.ring);
                GenPolynomial genPolynomial7 = PolyUtil.complexFromAny(iterable2, genPolynomial6);
                GenPolynomialRing genPolynomialRing5 = new GenPolynomialRing(iterable3, genPolynomialRing3);
                GenPolynomial genPolynomial8 = PolyUtil.recursive(genPolynomialRing5, genPolynomial7);
                int n = genPolynomialRing.nvar - 1 - nArray2[nArray2.length - 1];
                for (Complex<RealAlgebraicNumber<D>> complex : list) {
                    Complex<GcdRingElem> complex2;
                    Complex<GcdRingElem> complex3;
                    System.out.println("cr = " + PolyUtilApp.toString(complex));
                    RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)complex.ring.ring;
                    RealRootTuple realRootTuple = realAlgebraicRing.getRoot();
                    List list2 = realRootTuple.tuple;
                    Interval<Object> interval = list2.get((int)0).ring.getRoot();
                    Interval<Object> interval2 = list2.get((int)1).ring.getRoot();
                    logger.info("vr = " + interval + ", vi = " + interval2);
                    if (((GcdRingElem)interval.length()).isZERO()) {
                        complex3 = (Complex<GcdRingElem>)((GcdRingElem)interval.left).factory().parse("1/2");
                        complex2 = (Complex<GcdRingElem>)interval.left;
                        interval = new Interval<GcdRingElem>(complex2.subtract((GcdRingElem)complex3), complex2.sum((GcdRingElem)complex3));
                        logger.info("|vr| == 0: " + interval);
                    }
                    if (((GcdRingElem)interval2.length()).isZERO()) {
                        complex3 = (GcdRingElem)((GcdRingElem)interval2.left).factory().parse("1/2");
                        complex2 = (GcdRingElem)interval2.left;
                        interval2 = new Interval<GcdRingElem>(complex2.subtract((GcdRingElem)complex3), complex2.sum((GcdRingElem)complex3));
                        logger.info("|vi| == 0: " + interval2);
                    }
                    complex3 = new Complex<GcdRingElem>(complexRing, (GcdRingElem)interval.left, (GcdRingElem)interval2.left);
                    complex2 = new Complex<GcdRingElem>(complexRing, (GcdRingElem)interval.right, (GcdRingElem)interval2.right);
                    logger.info("sw   = " + PolyUtilApp.toString1(complex3) + ", ne   = " + PolyUtilApp.toString1(complex2));
                    GenPolynomial genPolynomial9 = PolyUtil.evaluateMainRecursive(iterable3, genPolynomial8, complex3);
                    GenPolynomial genPolynomial10 = PolyUtil.evaluateMainRecursive(iterable3, genPolynomial8, complex2);
                    GenPolynomialRing genPolynomialRing6 = idealWithUniv.upolys.get((int)n).ring;
                    GenPolynomialRing genPolynomialRing7 = new GenPolynomialRing(complexRing, genPolynomialRing6);
                    GenPolynomial genPolynomial11 = PolyUtilApp.convertComplexComplex(genPolynomialRing7, genPolynomial9);
                    GenPolynomial genPolynomial12 = PolyUtilApp.convertComplexComplex(genPolynomialRing7, genPolynomial10);
                    for (List list3 : serializable) {
                        Complex complex4 = (Complex)list3.get(n);
                        ComplexRing complexRing2 = complex4.ring;
                        RealAlgebraicRing realAlgebraicRing2 = (RealAlgebraicRing)complexRing2.ring;
                        TermOrder termOrder = new TermOrder(2);
                        String string = realAlgebraicRing2.algebraic.ring.getVars()[0];
                        String string2 = realAlgebraicRing2.algebraic.ring.getVars()[1];
                        String[] stringArray = new String[]{string, string2};
                        GenPolynomialRing genPolynomialRing8 = new GenPolynomialRing(complexRing, termOrder, stringArray);
                        GenPolynomial genPolynomial13 = genPolynomialRing8.univariate(1, 1L).sum(genPolynomialRing8.univariate(0, 1L).multiply(complexRing.getIMAG()));
                        GenPolynomialRing genPolynomialRing9 = new GenPolynomialRing(ringFactory, genPolynomialRing8);
                        GenPolynomial genPolynomial14 = PolyUtil.substituteUnivariate(genPolynomial11, genPolynomial13);
                        GenPolynomial genPolynomial15 = PolyUtil.realPartFromComplex(genPolynomialRing9, genPolynomial14);
                        GenPolynomial genPolynomial16 = PolyUtil.imaginaryPartFromComplex(genPolynomialRing9, genPolynomial14);
                        RealAlgebraicNumber realAlgebraicNumber = new RealAlgebraicNumber(realAlgebraicRing2, genPolynomial15);
                        int n2 = realAlgebraicNumber.signum();
                        RealAlgebraicNumber realAlgebraicNumber2 = new RealAlgebraicNumber(realAlgebraicRing2, genPolynomial16);
                        int n3 = realAlgebraicNumber2.signum();
                        genPolynomial14 = PolyUtil.substituteUnivariate(genPolynomial12, genPolynomial13);
                        genPolynomial15 = PolyUtil.realPartFromComplex(genPolynomialRing9, genPolynomial14);
                        genPolynomial16 = PolyUtil.imaginaryPartFromComplex(genPolynomialRing9, genPolynomial14);
                        RealAlgebraicNumber realAlgebraicNumber3 = new RealAlgebraicNumber(realAlgebraicRing2, genPolynomial15);
                        int n4 = realAlgebraicNumber3.signum();
                        RealAlgebraicNumber realAlgebraicNumber4 = new RealAlgebraicNumber(realAlgebraicRing2, genPolynomial16);
                        int n5 = realAlgebraicNumber4.signum();
                        if (n2 * n4 <= 0 && n3 * n5 <= 0) {
                            logger.info("   hit, cxi = " + PolyUtilApp.toString((Complex)list3.get(n)) + ", cr = " + PolyUtilApp.toString(complex));
                            ArrayList<Complex<RealAlgebraicNumber<D>>> arrayList2 = new ArrayList<Complex<RealAlgebraicNumber<D>>>();
                            arrayList2.addAll(list3);
                            arrayList2.add(complex);
                            arrayList.add(arrayList2);
                            continue;
                        }
                        logger.info("no hit, cxi = " + PolyUtilApp.toString((Complex)list3.get(n)) + ", cr = " + PolyUtilApp.toString(complex));
                    }
                }
            }
            serializable = arrayList;
        }
        IdealWithComplexAlgebraicRoots<D> idealWithComplexAlgebraicRoots = new IdealWithComplexAlgebraicRoots<D>(idealWithUniv, serializable);
        return idealWithComplexAlgebraicRoots;
    }

    public static <D extends GcdRingElem<D> & Rational> IdealWithComplexAlgebraicRoots<D> complexAlgebraicRoots(IdealWithUniv<D> idealWithUniv) {
        Iterable iterable;
        int[] nArray;
        ArrayList<List<Complex<RealAlgebraicNumber<Object>>>> serializable = new ArrayList();
        if (idealWithUniv == null) {
            throw new IllegalArgumentException("null ideal not permitted");
        }
        if (idealWithUniv.ideal == null || idealWithUniv.upolys == null) {
            throw new IllegalArgumentException("null ideal components not permitted " + idealWithUniv);
        }
        if (idealWithUniv.ideal.isZERO() || idealWithUniv.upolys.size() == 0) {
            return new IdealWithComplexAlgebraicRoots<D>(idealWithUniv, serializable);
        }
        GenPolynomialRing genPolynomialRing = idealWithUniv.ideal.list.ring;
        if (genPolynomialRing.nvar == 0) {
            return new IdealWithComplexAlgebraicRoots<D>(idealWithUniv, serializable);
        }
        if (genPolynomialRing.nvar != idealWithUniv.upolys.size()) {
            throw new IllegalArgumentException("ideal not zero dimnsional: " + idealWithUniv);
        }
        GenPolynomial genPolynomial = idealWithUniv.upolys.get(0);
        GenPolynomial genPolynomial2 = PolyUtil.selectWithVariable(idealWithUniv.ideal.list.list, genPolynomialRing.nvar - 1);
        if (genPolynomial2 == null) {
            throw new RuntimeException("no polynomial found in " + (genPolynomialRing.nvar - 1) + " of  " + idealWithUniv.ideal);
        }
        if (logger.isInfoEnabled()) {
            logger.info("p0  = " + genPolynomial);
            logger.info("p0p = " + genPolynomial2);
        }
        if ((nArray = genPolynomial2.degreeVector().dependencyOnVariables()).length != 1) {
            throw new RuntimeException("wrong number of variables " + Arrays.toString(nArray));
        }
        RingFactory ringFactory = genPolynomial.ring.coFac;
        ComplexRing complexRing = new ComplexRing(ringFactory);
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(complexRing, genPolynomial.ring);
        GenPolynomial genPolynomial3 = PolyUtil.complexFromAny(genPolynomialRing2, genPolynomial);
        List list = RootFactoryApp.complexAlgebraicNumbersSquarefree(genPolynomial3);
        logger.info("#roots(p0c) = " + list.size());
        for (Complex serializable2 : list) {
            iterable = new ArrayList();
            iterable.add(serializable2);
            serializable.add((List<Complex<RealAlgebraicNumber<Object>>>)iterable);
        }
        if (genPolynomialRing.nvar == 1) {
            return new IdealWithComplexAlgebraicRoots<D>(idealWithUniv, serializable);
        }
        for (int i = 1; i < idealWithUniv.upolys.size(); ++i) {
            Iterable iterable2;
            ArrayList arrayList = new ArrayList();
            iterable = idealWithUniv.upolys.get(i);
            GenPolynomial genPolynomial4 = PolyUtil.selectWithVariable(idealWithUniv.ideal.list.list, genPolynomialRing.nvar - 1 - i);
            if (genPolynomial4 == null) {
                throw new RuntimeException("no polynomial found in " + (genPolynomialRing.nvar - 1 - i) + " of  " + idealWithUniv.ideal);
            }
            if (logger.isInfoEnabled()) {
                logger.info("pi(" + i + ") = " + iterable);
                logger.info("pip  = " + genPolynomial4);
            }
            genPolynomialRing2 = new GenPolynomialRing(complexRing, ((GenPolynomial)iterable).ring);
            GenPolynomial genPolynomial5 = PolyUtil.complexFromAny(genPolynomialRing2, iterable);
            int[] nArray2 = genPolynomial4.degreeVector().dependencyOnVariables();
            if (nArray2.length < 1 || nArray2.length > 2) {
                throw new RuntimeException("wrong number of variables " + Arrays.toString(nArray2) + " for " + genPolynomial4);
            }
            list = RootFactoryApp.complexAlgebraicNumbersSquarefree(genPolynomial5);
            logger.info("#roots(pic) = " + list.size());
            if (nArray2.length == 1) {
                for (Complex complex : list) {
                    for (Iterable<Object> iterable3 : serializable) {
                        iterable2 = new ArrayList<Complex>();
                        iterable2.addAll(iterable3);
                        iterable2.add(complex);
                        arrayList.add(iterable2);
                    }
                }
            } else {
                Iterable<Object> iterable3;
                GenPolynomial genPolynomial6 = PolyUtil.removeUnusedUpperVariables(genPolynomial4);
                genPolynomial6 = PolyUtil.removeUnusedLowerVariables(genPolynomial6);
                genPolynomial6 = PolyUtil.removeUnusedMiddleVariables(genPolynomial6);
                GenPolynomialRing genPolynomialRing3 = genPolynomial6.ring.recursive(1);
                GenPolynomialRing genPolynomialRing4 = genPolynomial6.ring.contract(1);
                iterable3 = new GenPolynomialRing(complexRing, genPolynomialRing4);
                iterable2 = new GenPolynomialRing(complexRing, genPolynomial6.ring);
                GenPolynomial genPolynomial7 = PolyUtil.complexFromAny(iterable2, genPolynomial6);
                GenPolynomialRing genPolynomialRing5 = new GenPolynomialRing(iterable3, genPolynomialRing3);
                GenPolynomial genPolynomial8 = PolyUtil.recursive(genPolynomialRing5, genPolynomial7);
                int n = genPolynomialRing.nvar - 1 - nArray2[nArray2.length - 1];
                for (Complex<RealAlgebraicNumber<D>> complex : list) {
                    RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)complex.ring.ring;
                    RealRootTuple realRootTuple = realAlgebraicRing.getRoot();
                    List list2 = realRootTuple.tuple;
                    Interval interval = list2.get((int)0).ring.getRoot();
                    Interval interval2 = list2.get((int)1).ring.getRoot();
                    RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber = new RealAlgebraicNumber<GcdRingElem>(realAlgebraicRing, (GcdRingElem)interval.left);
                    RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber2 = new RealAlgebraicNumber<GcdRingElem>(realAlgebraicRing, (GcdRingElem)interval2.left);
                    RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber3 = new RealAlgebraicNumber<GcdRingElem>(realAlgebraicRing, (GcdRingElem)interval.right);
                    RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber4 = new RealAlgebraicNumber<GcdRingElem>(realAlgebraicRing, (GcdRingElem)interval2.right);
                    ComplexRing complexRing2 = new ComplexRing(realAlgebraicRing);
                    Complex<RealAlgebraicNumber<GcdRingElem>> complex2 = new Complex<RealAlgebraicNumber<GcdRingElem>>(complexRing2, realAlgebraicNumber, realAlgebraicNumber2);
                    Complex<RealAlgebraicNumber<GcdRingElem>> complex3 = new Complex<RealAlgebraicNumber<GcdRingElem>>(complexRing2, realAlgebraicNumber3, realAlgebraicNumber4);
                    Rectangle<RealAlgebraicNumber<GcdRingElem>> rectangle = new Rectangle<RealAlgebraicNumber<GcdRingElem>>(complex2, complex3);
                    for (List list3 : serializable) {
                        Complex complex4 = (Complex)list3.get(n);
                        ComplexRing complexRing3 = complex4.ring;
                        GenPolynomialRing genPolynomialRing6 = new GenPolynomialRing(complexRing3, genPolynomialRing5);
                        GenPolynomial genPolynomial9 = PolyUtilApp.evaluateToComplexRealCoefficients(genPolynomialRing6, genPolynomial8, complex4);
                        ComplexRootsSturm<RealAlgebraicNumber<GcdRingElem>> complexRootsSturm = new ComplexRootsSturm<RealAlgebraicNumber<GcdRingElem>>(complexRing3);
                        long l = 0L;
                        try {
                            l = complexRootsSturm.complexRootCount(rectangle, genPolynomial9);
                        }
                        catch (InvalidBoundaryException invalidBoundaryException) {
                            invalidBoundaryException.printStackTrace();
                        }
                        if (l == 1L) {
                            logger.info("   hit, cxi = " + PolyUtilApp.toString((Complex)list3.get(n)) + ", cr = " + PolyUtilApp.toString(complex));
                            ArrayList<Complex<RealAlgebraicNumber<D>>> arrayList2 = new ArrayList<Complex<RealAlgebraicNumber<D>>>();
                            arrayList2.addAll(list3);
                            arrayList2.add(complex);
                            arrayList.add(arrayList2);
                            continue;
                        }
                        if (l > 1L) {
                            logger.error("to many roots, cxi = " + PolyUtilApp.toString((Complex)list3.get(n)) + ", cr = " + PolyUtilApp.toString(complex));
                            continue;
                        }
                        logger.info("no hit, cxi = " + PolyUtilApp.toString((Complex)list3.get(n)) + ", cr = " + PolyUtilApp.toString(complex));
                    }
                }
            }
            serializable = arrayList;
        }
        IdealWithComplexAlgebraicRoots<D> idealWithComplexAlgebraicRoots = new IdealWithComplexAlgebraicRoots<D>(idealWithUniv, serializable);
        return idealWithComplexAlgebraicRoots;
    }

    public static <D extends GcdRingElem<D> & Rational> String toString(Complex<RealAlgebraicNumber<D>> complex) {
        RealAlgebraicNumber<D> realAlgebraicNumber = complex.getRe();
        RealAlgebraicNumber<D> realAlgebraicNumber2 = complex.getIm();
        Object object = realAlgebraicNumber.decimalMagnitude().toString();
        if (!realAlgebraicNumber2.isZERO()) {
            object = (String)object + "i" + realAlgebraicNumber2.decimalMagnitude();
        }
        return object;
    }

    public static <D extends GcdRingElem<D> & Rational> String toString1(Complex<D> complex) {
        GcdRingElem gcdRingElem = (GcdRingElem)complex.getRe();
        GcdRingElem gcdRingElem2 = (GcdRingElem)complex.getIm();
        Object object = new BigDecimal(((Rational)((Object)gcdRingElem)).getRational()).toString();
        if (!gcdRingElem2.isZERO()) {
            object = (String)object + "i" + new BigDecimal(((Rational)((Object)gcdRingElem2)).getRational());
        }
        return object;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithComplexAlgebraicRoots<D>> complexAlgebraicRoots(List<IdealWithUniv<D>> list) {
        ArrayList<IdealWithComplexAlgebraicRoots<D>> arrayList = new ArrayList<IdealWithComplexAlgebraicRoots<D>>();
        for (IdealWithUniv<D> idealWithUniv : list) {
            IdealWithComplexAlgebraicRoots<D> idealWithComplexAlgebraicRoots = PolyUtilApp.complexAlgebraicRoots(idealWithUniv);
            arrayList.add(idealWithComplexAlgebraicRoots);
        }
        return arrayList;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithComplexAlgebraicRoots<D>> complexAlgebraicRoots(Ideal<D> ideal) {
        List<IdealWithUniv<D>> list = ideal.zeroDimRootDecomposition();
        List<IdealWithComplexAlgebraicRoots<D>> list2 = PolyUtilApp.complexAlgebraicRoots(list);
        return list2;
    }

    static <C extends RingElem<C>> GenPolynomial<C> convert(GenPolynomialRing<C> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        if (genPolynomialRing.equals(genPolynomial.factory())) {
            return genPolynomial;
        }
        Element element = genPolynomialRing.parse(genPolynomial.toString());
        if (!((GenPolynomial)element).toString().equals(genPolynomial.toString())) {
            throw new RuntimeException("convert(" + genPolynomial + ") = " + (GenPolynomial)element);
        }
        return element;
    }

    static <C extends RingElem<C>> GenPolynomial<Complex<C>> convertComplex(GenPolynomialRing<Complex<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        Element element = genPolynomialRing.parse(genPolynomial.toString());
        if (!((GenPolynomial)element).toString().equals(genPolynomial.toString())) {
            throw new RuntimeException("convert(" + genPolynomial + ") = " + (GenPolynomial)element);
        }
        return element;
    }

    static <C extends RingElem<C>> GenPolynomial<Complex<C>> convertComplexComplex(GenPolynomialRing<Complex<C>> genPolynomialRing, GenPolynomial<Complex<C>> genPolynomial) {
        if (genPolynomialRing.equals(genPolynomial.factory())) {
            return genPolynomial;
        }
        Element element = genPolynomialRing.parse(genPolynomial.toString());
        if (!((GenPolynomial)element).toString().equals(genPolynomial.toString())) {
            throw new RuntimeException("convert(" + genPolynomial + ") = " + (GenPolynomial)element);
        }
        return element;
    }

    public static <D extends GcdRingElem<D> & Rational> List<IdealWithRealAlgebraicRoots<D>> realAlgebraicRoots(Ideal<D> ideal) {
        List<IdealWithUniv<D>> list = ideal.zeroDimRootDecomposition();
        List<IdealWithRealAlgebraicRoots<D>> list2 = PolyUtilApp.realAlgebraicRoots(list);
        return list2;
    }

    public static <C extends GcdRingElem<C>> PrimitiveElement<C> primitiveElement(AlgebraicNumberRing<C> algebraicNumberRing, AlgebraicNumberRing<C> algebraicNumberRing2) {
        GenPolynomial genPolynomial = algebraicNumberRing.modul;
        GenPolynomial genPolynomial2 = algebraicNumberRing2.modul;
        String[] stringArray = new String[]{genPolynomial.ring.getVars()[0], genPolynomial2.ring.getVars()[0]};
        TermOrder termOrder = new TermOrder(2);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(genPolynomial.ring.coFac, 2, termOrder, stringArray);
        AbelianGroupElem abelianGroupElem = genPolynomial.extendUnivariate(genPolynomialRing, 0);
        AbelianGroupElem abelianGroupElem2 = genPolynomial2.extendUnivariate(genPolynomialRing, 1);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(abelianGroupElem);
        arrayList.add(abelianGroupElem2);
        ArrayList arrayList2 = new ArrayList();
        Ideal ideal = new Ideal(genPolynomialRing, arrayList);
        IdealWithUniv idealWithUniv = ideal.normalPositionFor(0, 1, arrayList2);
        List list = idealWithUniv.ideal.getList();
        abelianGroupElem = PolyUtil.selectWithVariable(list, 1);
        abelianGroupElem2 = PolyUtil.selectWithVariable(list, 0);
        GenPolynomial genPolynomial3 = PolyUtil.selectWithVariable(list, 2);
        String[] stringArray2 = new String[]{genPolynomial3.ring.getVars()[0]};
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomial.ring.coFac, 1, termOrder, stringArray2);
        genPolynomial3 = genPolynomial3.contractCoeff(genPolynomialRing2);
        abelianGroupElem = abelianGroupElem.reductum().contractCoeff(genPolynomialRing2);
        abelianGroupElem = abelianGroupElem.negate();
        abelianGroupElem2 = abelianGroupElem2.reductum().contractCoeff(genPolynomialRing2);
        abelianGroupElem2 = abelianGroupElem2.negate();
        AlgebraicNumberRing algebraicNumberRing3 = new AlgebraicNumberRing(genPolynomial3);
        AlgebraicNumber algebraicNumber = new AlgebraicNumber(algebraicNumberRing3, abelianGroupElem);
        AlgebraicNumber algebraicNumber2 = new AlgebraicNumber(algebraicNumberRing3, abelianGroupElem2);
        PrimitiveElement primitiveElement = new PrimitiveElement(algebraicNumberRing3, algebraicNumber, algebraicNumber2, algebraicNumberRing, algebraicNumberRing2);
        if (logger.isInfoEnabled()) {
            logger.info("primitive element = " + algebraicNumberRing3);
        }
        return primitiveElement;
    }

    public static <C extends GcdRingElem<C>> AlgebraicNumber<C> convertToPrimitiveElem(AlgebraicNumberRing<C> algebraicNumberRing, AlgebraicNumber<C> algebraicNumber, AlgebraicNumber<C> algebraicNumber2) {
        GenPolynomialRing genPolynomialRing = algebraicNumber2.ring.ring;
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(algebraicNumberRing, genPolynomialRing);
        GenPolynomial genPolynomial = PolyUtil.convertToAlgebraicCoefficients(genPolynomialRing2, algebraicNumber2.val);
        AlgebraicNumber<C> algebraicNumber3 = PolyUtil.evaluateMain(algebraicNumberRing, genPolynomial, algebraicNumber);
        return algebraicNumber3;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToPrimitiveElem(AlgebraicNumberRing<C> algebraicNumberRing, AlgebraicNumber<C> algebraicNumber, GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        GenPolynomialRing<C> genPolynomialRing = new GenPolynomialRing<C>(algebraicNumberRing, genPolynomial.ring);
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffConvertAlg<C>(algebraicNumberRing, algebraicNumber));
    }

    public static <C extends GcdRingElem<C>> AlgebraicNumber<C> convertToPrimitiveElem(AlgebraicNumberRing<C> algebraicNumberRing, AlgebraicNumber<C> algebraicNumber, AlgebraicNumber<C> algebraicNumber2, AlgebraicNumber<AlgebraicNumber<C>> algebraicNumber3) {
        GenPolynomial<AlgebraicNumber<C>> genPolynomial = PolyUtilApp.convertToPrimitiveElem(algebraicNumberRing, algebraicNumber, algebraicNumber3.val);
        AlgebraicNumber<C> algebraicNumber4 = PolyUtil.evaluateMain(algebraicNumberRing, genPolynomial, algebraicNumber2);
        return algebraicNumber4;
    }

    public static <C extends GcdRingElem<C>> PrimitiveElement<C> primitiveElement(AlgebraicNumberRing<AlgebraicNumber<C>> algebraicNumberRing) {
        GenPolynomial genPolynomial = algebraicNumberRing.modul;
        AlgebraicNumberRing algebraicNumberRing2 = (AlgebraicNumberRing)algebraicNumberRing.ring.coFac;
        GenPolynomial genPolynomial2 = algebraicNumberRing2.modul;
        String[] stringArray = new String[]{genPolynomial2.ring.getVars()[0], genPolynomial.ring.getVars()[0]};
        TermOrder termOrder = new TermOrder(2);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(genPolynomial2.ring.coFac, 2, termOrder, stringArray);
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(algebraicNumberRing2.ring, 1, genPolynomial.ring.getVars());
        AbelianGroupElem abelianGroupElem = genPolynomial2.extendUnivariate(genPolynomialRing, 0);
        GenPolynomial genPolynomial3 = PolyUtil.fromAlgebraicCoefficients(genPolynomialRing2, genPolynomial);
        AbelianGroupElem abelianGroupElem2 = PolyUtil.distribute(genPolynomialRing, genPolynomial3);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(abelianGroupElem);
        arrayList.add(abelianGroupElem2);
        ArrayList arrayList2 = new ArrayList();
        Ideal ideal = new Ideal(genPolynomialRing, arrayList);
        IdealWithUniv idealWithUniv = ideal.normalPositionFor(0, 1, arrayList2);
        List list = idealWithUniv.ideal.getList();
        abelianGroupElem = PolyUtil.selectWithVariable(list, 1);
        abelianGroupElem2 = PolyUtil.selectWithVariable(list, 0);
        GenPolynomial genPolynomial4 = PolyUtil.selectWithVariable(list, 2);
        String[] stringArray2 = new String[]{genPolynomial4.ring.getVars()[0]};
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomial2.ring.coFac, 1, termOrder, stringArray2);
        genPolynomial4 = genPolynomial4.contractCoeff(genPolynomialRing3);
        abelianGroupElem = abelianGroupElem.reductum().contractCoeff(genPolynomialRing3);
        abelianGroupElem = abelianGroupElem.negate();
        abelianGroupElem2 = abelianGroupElem2.reductum().contractCoeff(genPolynomialRing3);
        abelianGroupElem2 = abelianGroupElem2.negate();
        AlgebraicNumberRing algebraicNumberRing3 = new AlgebraicNumberRing(genPolynomial4);
        AlgebraicNumber algebraicNumber = new AlgebraicNumber(algebraicNumberRing3, abelianGroupElem);
        AlgebraicNumber algebraicNumber2 = new AlgebraicNumber(algebraicNumberRing3, abelianGroupElem2);
        PrimitiveElement primitiveElement = new PrimitiveElement(algebraicNumberRing3, algebraicNumber, algebraicNumber2);
        if (logger.isInfoEnabled()) {
            logger.info("primitive element = " + primitiveElement);
        }
        return primitiveElement;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToPrimitiveElem(AlgebraicNumberRing<C> algebraicNumberRing, AlgebraicNumber<C> algebraicNumber, AlgebraicNumber<C> algebraicNumber2, GenPolynomial<AlgebraicNumber<AlgebraicNumber<C>>> genPolynomial) {
        GenPolynomialRing<C> genPolynomialRing = new GenPolynomialRing<C>(algebraicNumberRing, genPolynomial.ring);
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffRecConvertAlg<C>(algebraicNumberRing, algebraicNumber, algebraicNumber2));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<edu.jas.root.RealAlgebraicNumber<C>> realAlgFromRealCoefficients(GenPolynomialRing<edu.jas.root.RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<RealAlgebraicNumber<C>> genPolynomial) {
        edu.jas.root.RealAlgebraicRing realAlgebraicRing = (edu.jas.root.RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ReAlgFromRealCoeff(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> realFromRealAlgCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<edu.jas.root.RealAlgebraicNumber<C>> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RealFromReAlgCoeff(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<Complex<RealAlgebraicNumber<C>>> convertToComplexRealCoefficients(GenPolynomialRing<Complex<RealAlgebraicNumber<C>>> genPolynomialRing, GenPolynomial<Complex<C>> genPolynomial) {
        ComplexRing complexRing = (ComplexRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToComplexReal(complexRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<Complex<RealAlgebraicNumber<C>>> evaluateToComplexRealCoefficients(GenPolynomialRing<Complex<RealAlgebraicNumber<C>>> genPolynomialRing, GenPolynomial<GenPolynomial<Complex<C>>> genPolynomial, Complex<RealAlgebraicNumber<C>> complex) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new EvaluateToComplexReal<C>(genPolynomialRing, complex));
    }
}

